/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.deps.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.javacard.project.deps.ui.ArchiveFileFilter;
import org.netbeans.modules.javacard.project.deps.ui.InitialDepKind;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class ChooseOriginPanelVisual
extends JPanel
implements DocumentListener {
    private InitialDepKind kind;
    private final ChangeSupport supp = new ChangeSupport((Object)this);
    private final WizardDescriptor wiz;
    private JButton browseOriginButton;
    private JButton browseSourcesButton;
    private JTextField originField;
    private JLabel originLbl;
    private JTextField sourcesField;
    private JLabel sourcesLabel;

    public void removeChangeListener(ChangeListener listener) {
        this.supp.removeChangeListener(listener);
    }

    public void fireChange() {
        this.supp.fireChange();
    }

    public void addChangeListener(ChangeListener listener) {
        this.supp.addChangeListener(listener);
    }

    ChooseOriginPanelVisual(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.initComponents();
        this.originField.getDocument().addDocumentListener(this);
        this.sourcesField.getDocument().addDocumentListener(this);
        HelpCtx.setHelpIDString((JComponent)this, (String)"org.netbeans.modules.javacard.DependenciesPanel");
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ChooseOriginPanelVisual.class, (String)"WIZARD_STEP_CHOOSE_ORIGIN");
    }

    private void initComponents() {
        this.originLbl = new JLabel();
        this.originField = new JTextField();
        this.browseOriginButton = new JButton();
        this.sourcesLabel = new JLabel();
        this.sourcesField = new JTextField();
        this.browseSourcesButton = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.originLbl, (String)NbBundle.getMessage(ChooseOriginPanelVisual.class, (String)"ChooseOriginPanelVisual.originLbl.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 12, 0);
        this.add((Component)this.originLbl, gridBagConstraints);
        this.originField.setText(NbBundle.getMessage(ChooseOriginPanelVisual.class, (String)"ChooseOriginPanelVisual.originField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 140;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 5, 12, 5);
        this.add((Component)this.originField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseOriginButton, (String)NbBundle.getMessage(ChooseOriginPanelVisual.class, (String)"ChooseOriginPanelVisual.browseOriginButton.text"));
        this.browseOriginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseOriginPanelVisual.this.onBrowseOrigin(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 12, 0);
        this.add((Component)this.browseOriginButton, gridBagConstraints);
        this.sourcesLabel.setLabelFor(this.sourcesField);
        Mnemonics.setLocalizedText((JLabel)this.sourcesLabel, (String)NbBundle.getMessage(ChooseOriginPanelVisual.class, (String)"ChooseOriginPanelVisual.sourcesLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 0, 12, 0);
        this.add((Component)this.sourcesLabel, gridBagConstraints);
        this.sourcesField.setText(NbBundle.getMessage(ChooseOriginPanelVisual.class, (String)"ChooseOriginPanelVisual.sourcesField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 140;
        gridBagConstraints.insets = new Insets(3, 5, 12, 5);
        this.add((Component)this.sourcesField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseSourcesButton, (String)NbBundle.getMessage(ChooseOriginPanelVisual.class, (String)"ChooseOriginPanelVisual.browseSourcesButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 0, 12, 0);
        this.add((Component)this.browseSourcesButton, gridBagConstraints);
    }

    private void onBrowseOrigin(ActionEvent evt) {
        if (this.kind == InitialDepKind.PROJECT) {
            JFileChooser chooser = ProjectChooser.projectChooser();
            if (chooser.showOpenDialog(this) == 0) {
                File f = chooser.getSelectedFile();
                this.originField.setText(f.getAbsolutePath());
            }
        } else {
            File f = new FileChooserBuilder(ChooseOriginPanelVisual.class).setFileFilter((FileFilter)new ArchiveFileFilter()).setTitle(this.kind.toString()).setFilesOnly(true).showOpenDialog();
            if (f != null) {
                this.originField.setText(f.getAbsolutePath());
            }
        }
    }

    boolean valid() {
        boolean result;
        if (this.kind == null) {
            return false;
        }
        if (this.originField.getText().trim().length() == 0) {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ChooseOriginPanelVisual.class, (String)"ERR_ORIGIN_NOT_SET"));
            return false;
        }
        File f = new File(this.originField.getText().trim());
        boolean e = f.exists();
        boolean bl = result = e && this.kind == InitialDepKind.PROJECT ? f.isDirectory() : f.isFile();
        if (!result) {
            String key = e ? (this.kind == InitialDepKind.PROJECT ? "ERR_EXPECTING_DIR" : "ERR_EXPECTING_FILE") : "ERR_NON_EXISTENT_FILE";
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ChooseOriginPanelVisual.class, (String)key, (Object)f.getName()));
            return result;
        }
        String s = this.sourcesField.getText();
        if (s.trim().length() > 0 && !(f = new File(s)).exists()) {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ChooseOriginPanelVisual.class, (String)"ERR_SOURCE_FILE_DOES_NOT_EXIST", (Object)f.getName()));
            return false;
        }
        if (result) {
            this.wiz.putProperty("WizardPanel_errorMessage", null);
        }
        return result;
    }

    File getOriginFile() {
        return this.valid() ? new File(this.originField.getText().trim()) : null;
    }

    File getSourceFile() {
        return !this.sourcesField.isVisible() ? null : (this.valid() ? (this.sourcesField.getText().trim().length() == 0 ? null : new File(this.sourcesField.getText().trim())) : null);
    }

    void setDepKind(InitialDepKind kind) {
        if (kind != null) {
            switch (kind) {
                case PROJECT: {
                    this.originLbl.setText(NbBundle.getMessage(ChooseOriginPanelVisual.class, (String)"LBL_PROJECT"));
                    break;
                }
                default: {
                    this.originLbl.setText(NbBundle.getMessage(ChooseOriginPanelVisual.class, (String)"LBL_FILE"));
                }
            }
        }
        this.kind = kind;
        this.sourcesField.setVisible(kind != InitialDepKind.PROJECT);
        this.sourcesLabel.setVisible(kind != InitialDepKind.PROJECT);
        this.browseSourcesButton.setVisible(kind != InitialDepKind.PROJECT);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.insertUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.insertUpdate(e);
    }
}

