/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.api;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.refactoring.api.CsmContext;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public final class IntroduceMethodRefactoring
extends AbstractRefactoring {
    public static final int PARAM_BY_REF = 0;
    public static final int PARAM_NAME = 1;
    public static final int PARAM_TYPE = 2;
    private ParameterInfo[] paramTable;
    private String functionName;
    private IntroduceMethodContext introduceMethodContext;
    private String methodDeclaration;
    private String methodDefinition;
    private String methodCall;
    private int declarationInsetOffset;

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public int getDeclarationInsetOffset() {
        return this.declarationInsetOffset;
    }

    public void setDeclarationInsetOffset(int declarationInsetOffset) {
        this.declarationInsetOffset = declarationInsetOffset;
    }

    public String getMethodDeclaration() {
        return this.methodDeclaration;
    }

    public void setMethodDeclaration(String methodDeclaration) {
        this.methodDeclaration = methodDeclaration;
    }

    public String getMethodDefinition() {
        return this.methodDefinition;
    }

    public void setMethodDefinition(String methodDefinition) {
        this.methodDefinition = methodDefinition;
    }

    public String getMethodCall() {
        return this.methodCall;
    }

    public void setMethodCall(String methodCall) {
        this.methodCall = methodCall;
    }

    public IntroduceMethodRefactoring(CsmObject method, CsmContext editorContext) {
        super(IntroduceMethodRefactoring.createLookup(method, editorContext));
    }

    private static Lookup createLookup(CsmObject method, CsmContext editorContext) {
        assert (method != null || editorContext != null) : "must be non null object to refactor";
        if (editorContext == null) {
            return Lookups.fixed((Object[])new Object[]{method});
        }
        if (method == null) {
            return Lookups.fixed((Object[])new Object[]{editorContext});
        }
        return Lookups.fixed((Object[])new Object[]{method, editorContext});
    }

    public ParameterInfo[] getParameterInfo() {
        return this.paramTable;
    }

    public void setParameterInfo(ParameterInfo[] paramTable) {
        this.paramTable = paramTable;
    }

    public IntroduceMethodContext getIntroduceMethodContext() {
        return this.introduceMethodContext;
    }

    public void setIntroduceMethodContext(IntroduceMethodContext introduceMethodContext) {
        this.introduceMethodContext = introduceMethodContext;
    }

    public static interface VariableContext {
        public List<CsmReference> getReferences();

        public CsmVariable getVariable();

        public boolean isAccessAfter();

        public boolean isAccessBefore();

        public boolean isAccessInside();

        public boolean isTopLevelDeclaration();

        public boolean isWriteAccessInside();
    }

    public static interface IntroduceMethodContext {
        public Document getDocument();

        public CsmClass getEnclosingClass();

        public CsmFunctionDefinition getFunction();

        public CsmFunction getFunctionDeclaration();

        public FunctionKind getFunctionKind();

        public List<VariableContext> getImportantVariables();

        public CsmScope getInsertScope();

        public int getInsetionOffset();

        public int getSelectionFrom();

        public int getSelectionTo();

        public boolean isApplicable(AtomicBoolean var1);

        public boolean isC();

        public static enum FunctionKind {
            Function,
            MethodDefinition,
            MethodDeclarationDefinition;

        }
    }

    public static final class ParameterInfo {
        private final boolean byRef;
        private final CharSequence name;
        private final CharSequence type;

        public ParameterInfo(boolean byRef, CharSequence name, CharSequence type) {
            this.byRef = byRef;
            this.name = this.trim(name);
            this.type = this.trim(type);
        }

        private CharSequence trim(CharSequence cs) {
            CharSequence out = cs;
            if (cs != null && (out = cs.toString().trim()).length() == cs.length()) {
                out = cs;
            }
            return out;
        }

        public boolean isByRef() {
            return this.byRef;
        }

        public CharSequence getName() {
            return this.name;
        }

        public CharSequence getType() {
            return this.type;
        }
    }
}

