/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.completion.delegate;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.net.URL;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Utilities;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class PopupDelegateCompletionItem
implements CompletionItem {
    private static final int PRIORITY = 10;
    private final int substitutionOffset;
    private final Action action;
    private final String rightText;

    private PopupDelegateCompletionItem(int substitutionOffset, Action action, String rightText) {
        this.substitutionOffset = substitutionOffset;
        this.action = action;
        this.rightText = rightText;
    }

    public static PopupDelegateCompletionItem createImplementItem(int substitutionOffset, JTextComponent component) {
        Action action = (Action)FileUtil.getConfigObject((String)"Editors/Actions/generate-code.instance", Action.class);
        if (action != null) {
            String rightText = "";
            BaseKit kit = Utilities.getKit((JTextComponent)component);
            if (kit != null) {
                KeyStroke[] keys;
                Action a = kit.getActionByName((String)action.getValue("Name"));
                MultiKeymap keymap = kit.getKeymap();
                if (keymap != null && (keys = keymap.getKeyStrokesForAction(a)) != null && keys.length > 0) {
                    KeyStroke ks = keys[0];
                    String keyModifiersText = KeyEvent.getKeyModifiersText(ks.getModifiers());
                    rightText = keyModifiersText.length() > 0 ? keyModifiersText + "+" + KeyEvent.getKeyText(ks.getKeyCode()) : KeyEvent.getKeyText(ks.getKeyCode());
                }
            }
            return new PopupDelegateCompletionItem(substitutionOffset, action, rightText);
        }
        return null;
    }

    public String getItemText() {
        return NbBundle.getMessage(PopupDelegateCompletionItem.class, (String)"GENERATE");
    }

    public void defaultAction(JTextComponent component) {
        if (component != null) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            int caretOffset = component.getSelectionEnd();
            this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset);
        }
    }

    public void processKeyEvent(KeyEvent evt) {
        JTextComponent component;
        int caretOffset;
        int len;
        if (evt.getID() == 400 && (len = (caretOffset = (component = (JTextComponent)evt.getSource()).getSelectionEnd()) - this.substitutionOffset) < 0) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
        }
    }

    public boolean instantSubstitution(JTextComponent component) {
        return false;
    }

    public CompletionTask createDocumentationTask() {
        return new CompletionTask(){

            public void query(CompletionResultSet resultSet) {
                resultSet.setDocumentation((CompletionDocumentation)new CompletionDocumentationImpl());
                resultSet.finish();
            }

            public void refresh(CompletionResultSet resultSet) {
                this.query(resultSet);
            }

            public void cancel() {
            }
        };
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(true), (String)this.getRightHtmlText(true), (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(true), (String)this.getRightHtmlText(true), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.getLeftHtmlText(false));
        out.append(this.getRightHtmlText(false));
        return out.toString();
    }

    public int getSortPriority() {
        return 10;
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    protected ImageIcon getIcon() {
        return new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/refactoring/resources/delegate_generate.png"));
    }

    protected String getLeftHtmlText(boolean html) {
        return this.getItemText();
    }

    protected String getRightHtmlText(boolean html) {
        return this.rightText;
    }

    protected void substituteText(JTextComponent c, int offset, int origLen) {
        this.action.actionPerformed(null);
    }

    private static final class CompletionDocumentationImpl
    implements CompletionDocumentation {
        public String getText() {
            return NbBundle.getMessage(PopupDelegateCompletionItem.class, (String)"GENERATE_HINT");
        }

        public URL getURL() {
            return null;
        }

        public CompletionDocumentation resolveLink(String link) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }
}

