/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.completion.overridemethod;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.modules.cnd.spi.model.services.CsmDocProvider;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CsmOverrideMethodCompletionItem
implements CompletionItem {
    private final int substitutionOffset;
    private final int priority;
    private final String sortItemText;
    private final boolean supportInstantSubst;
    private static final int PRIORITY = 15;
    private final String appendItemText;
    private final String htmlItemText;
    private final CsmMember item;
    private final ImageIcon icon;
    private final String right;

    private CsmOverrideMethodCompletionItem(CsmMember item, int substitutionOffset, int priority, String sortItemText, String appendItemText, String htmlItemText, boolean supportInstantSubst, String right) {
        this.substitutionOffset = substitutionOffset;
        this.priority = priority;
        this.supportInstantSubst = supportInstantSubst;
        this.sortItemText = sortItemText;
        this.appendItemText = appendItemText;
        this.htmlItemText = htmlItemText;
        this.item = item;
        ImageIcon anIicon = item != null ? CsmImageLoader.getIcon((CsmObject)item) : CsmImageLoader.getIcon((CsmDeclaration.Kind)CsmDeclaration.Kind.FUNCTION, (int)131072);
        this.icon = (ImageIcon)ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)ImageUtilities.icon2Image((Icon)anIicon), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/refactoring/resources/generate.png"), (int)0, (int)7));
        this.right = right;
    }

    public static CsmOverrideMethodCompletionItem createImplementItem(int substitutionOffset, int caretOffset, CsmClass cls, CsmMember item) {
        String sortItemText = item == null || CsmKindUtilities.isDestructor((CsmObject)item) ? "~" + cls.getName() : item.getName().toString();
        String appendItemText = CsmOverrideMethodCompletionItem.createAppendText(item, cls);
        String rightText = CsmOverrideMethodCompletionItem.createRightName(item);
        String coloredItemText = item == null || CsmKindUtilities.isDestructor((CsmObject)item) ? CsmOverrideMethodCompletionItem.createDisplayName(item, cls, NbBundle.getMessage(CsmOverrideMethodCompletionItem.class, (String)"destructor.txt")) : CsmOverrideMethodCompletionItem.createDisplayName(item, cls, NbBundle.getMessage(CsmOverrideMethodCompletionItem.class, (String)"override.txt"));
        return new CsmOverrideMethodCompletionItem(item, substitutionOffset, 15, sortItemText, appendItemText, coloredItemText, true, rightText);
    }

    private static String createDisplayName(CsmMember item, CsmClass parent, String operation) {
        StringBuilder displayName = new StringBuilder();
        displayName.append("<b>");
        if (item == null || CsmKindUtilities.isDestructor((CsmObject)item)) {
            displayName.append('~');
            displayName.append(CsmDisplayUtilities.htmlize((CharSequence)parent.getName()));
            displayName.append("()");
        } else {
            displayName.append(CsmDisplayUtilities.htmlize((CharSequence)((CsmFunction)item).getSignature()));
        }
        displayName.append("</b>");
        if (operation != null) {
            displayName.append(" - ");
            displayName.append(CsmDisplayUtilities.htmlize((CharSequence)operation));
        }
        return displayName.toString();
    }

    private static String createRightName(CsmMember item) {
        if (item == null || CsmKindUtilities.isDestructor((CsmObject)item)) {
            return "";
        }
        if (CsmKindUtilities.isConstructor((CsmObject)item)) {
            return "";
        }
        return ((CsmFunction)item).getReturnType().getText().toString();
    }

    private static String createAppendText(CsmMember item, CsmClass parent) {
        CsmClassifier classifier;
        CsmType returnType;
        boolean isCpp11 = CsmFileInfoQuery.getDefault().isCpp11OrLater(parent.getContainingFile());
        StringBuilder appendItemText = new StringBuilder();
        String type = "";
        if (item != null && !CsmKindUtilities.isConstructor((CsmObject)item) && !CsmKindUtilities.isDestructor((CsmObject)item) && (type = (returnType = ((CsmFunction)item).getReturnType()).getText().toString() + " ").indexOf("::") < 0 && (classifier = returnType.getClassifier()) != null) {
            CsmScope scope;
            String toReplace = classifier.getName().toString();
            if (type.indexOf(toReplace) == 0) {
                CsmScope scope2 = classifier.getScope();
                if (CsmKindUtilities.isClass((CsmObject)scope2)) {
                    type = ((CsmClass)scope2).getName() + "::" + type;
                }
            } else if (type.startsWith("const " + toReplace) && CsmKindUtilities.isClass((CsmObject)(scope = classifier.getScope()))) {
                type = "const " + ((CsmClass)scope).getName() + "::" + type.substring(6);
            }
        }
        if (!isCpp11) {
            appendItemText.append("\nvirtual ");
        } else if (item == null || CsmKindUtilities.isDestructor((CsmObject)item)) {
            appendItemText.append("\nvirtual ");
        }
        appendItemText.append(type);
        CsmOverrideMethodCompletionItem.addSignature(item, parent, appendItemText);
        if (isCpp11 && item != null && !CsmKindUtilities.isConstructor((CsmObject)item) && !CsmKindUtilities.isDestructor((CsmObject)item)) {
            appendItemText.append(" override");
        }
        if (item == null || CsmKindUtilities.isDestructor((CsmObject)item)) {
            appendItemText.append(" {\n\n}\n");
        } else {
            appendItemText.append(";\n");
        }
        return appendItemText.toString();
    }

    private static void addSignature(CsmMember item, CsmClass parent, StringBuilder sb) {
        if (item == null || CsmKindUtilities.isDestructor((CsmObject)item)) {
            sb.append('~');
            sb.append(parent.getName());
            sb.append("()");
        } else {
            sb.append(item.getName());
            if (CsmKindUtilities.isTemplate((CsmObject)item)) {
                List templateParameters = ((CsmTemplate)item).getTemplateParameters();
            }
            sb.append('(');
            boolean first = true;
            for (CsmParameter param : ((CsmFunction)item).getParameterList().getParameters()) {
                if (!first) {
                    sb.append(',');
                    sb.append(' ');
                }
                first = false;
                if (param.isVarArgs()) {
                    sb.append("...");
                    continue;
                }
                CsmType type = param.getType();
                if (type == null) continue;
                sb.append(type.getText());
                sb.append(' ');
                sb.append(param.getName());
            }
            sb.append(')');
            if (CsmKindUtilities.isMethod((CsmObject)item) && ((CsmMethod)item).isConst()) {
                sb.append(" const");
            }
        }
    }

    public String getItemText() {
        return this.appendItemText;
    }

    public void defaultAction(JTextComponent component) {
        if (component != null) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            int caretOffset = component.getSelectionEnd();
            this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset);
        }
    }

    public void processKeyEvent(KeyEvent evt) {
        JTextComponent component;
        int caretOffset;
        int len;
        if (evt.getID() == 400 && (len = (caretOffset = (component = (JTextComponent)evt.getSource()).getSelectionEnd()) - this.substitutionOffset) < 0) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
        }
    }

    public boolean instantSubstitution(JTextComponent component) {
        if (this.supportInstantSubst) {
            this.defaultAction(component);
            return true;
        }
        return false;
    }

    public CompletionTask createDocumentationTask() {
        CsmDocProvider p = (CsmDocProvider)Lookup.getDefault().lookup(CsmDocProvider.class);
        if (p != null) {
            return p.createDocumentationTask((CsmObject)this.item);
        }
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(true), (String)this.getRightHtmlText(true), (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(true), (String)this.getRightHtmlText(true), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.getLeftHtmlText(false));
        out.append(this.getRightHtmlText(false));
        return out.toString();
    }

    public int getSortPriority() {
        return this.priority;
    }

    public CharSequence getSortText() {
        return this.sortItemText;
    }

    public CharSequence getInsertPrefix() {
        return this.sortItemText;
    }

    protected ImageIcon getIcon() {
        return this.icon;
    }

    protected String getLeftHtmlText(boolean html) {
        return html ? this.htmlItemText : this.getItemText();
    }

    protected String getRightHtmlText(boolean html) {
        return this.right;
    }

    protected void substituteText(final JTextComponent c, final int offset, final int origLen) {
        final BaseDocument doc = (BaseDocument)c.getDocument();
        doc.runAtomicAsUser(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block6: {
                    try {
                        if (origLen > 0) {
                            doc.remove(offset, origLen);
                        }
                        String itemText = CsmOverrideMethodCompletionItem.this.getItemText();
                        doc.insertString(offset, itemText, null);
                        if (c == null) break block6;
                        int setDot = CsmOverrideMethodCompletionItem.this.item == null || CsmKindUtilities.isDestructor((CsmObject)CsmOverrideMethodCompletionItem.this.item) ? offset + itemText.length() - 3 : offset + itemText.length() - 1;
                        c.setCaretPosition(setDot);
                        Reformat reformat = Reformat.get((Document)doc);
                        reformat.lock();
                        try {
                            reformat.reformat(offset, offset + itemText.length() - 1);
                        }
                        finally {
                            reformat.unlock();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
    }
}

