/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.completion.overridemethod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.completion.overridemethod.CsmOverrideMethodCompletionItem;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public class CsmOverrideMethodCompletionProvider
implements CompletionProvider {
    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if ((queryType & 1) != 0) {
            int dot = component.getCaret().getDot();
            return new AsyncCompletionTask((AsyncCompletionQuery)new Query(dot), component);
        }
        return null;
    }

    static Collection<CsmOverrideMethodCompletionItem> getFilteredData(BaseDocument doc, int caretOffset, int queryType) {
        Query query = new Query(caretOffset);
        Collection items = query.getItems(doc, caretOffset);
        return items;
    }

    private static final class AntiLoopElement {
        private final int offset;
        private final CsmFile file;

        AntiLoopElement(CsmOffsetable object) {
            this.offset = object.getStartOffset();
            this.file = object.getContainingFile();
        }

        public boolean equals(Object obj) {
            if (obj instanceof AntiLoopElement) {
                return this.offset == ((AntiLoopElement)obj).offset && this.file.equals(((AntiLoopElement)obj).file);
            }
            return false;
        }

        public int hashCode() {
            return this.offset * 31 + this.file.hashCode() * 37;
        }
    }

    private static final class Query
    extends AsyncCompletionQuery {
        private Collection<CsmOverrideMethodCompletionItem> results;
        private final int creationCaretOffset;
        private int queryAnchorOffset;
        private String filterPrefix;

        Query(int caretOffset) {
            this.creationCaretOffset = caretOffset;
            this.queryAnchorOffset = -1;
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            Collection<CsmOverrideMethodCompletionItem> items = this.getItems((BaseDocument)doc, caretOffset);
            if (this.queryAnchorOffset >= 0) {
                if (items != null && items.size() > 0) {
                    this.results = items;
                    items = this.getFilteredData(items, this.filterPrefix);
                    resultSet.estimateItems(items.size(), -1);
                    resultSet.addAllItems(items);
                    resultSet.setAnchorOffset(this.queryAnchorOffset);
                }
                resultSet.setHasAdditionalItems(false);
            }
            resultSet.finish();
        }

        protected boolean canFilter(JTextComponent component) {
            int caretOffset = component.getCaretPosition();
            this.filterPrefix = null;
            if (this.queryAnchorOffset > -1 && caretOffset >= this.queryAnchorOffset) {
                Document doc = component.getDocument();
                try {
                    this.filterPrefix = doc.getText(this.queryAnchorOffset, caretOffset - this.queryAnchorOffset);
                }
                catch (BadLocationException ex) {
                    Completion.get().hideCompletion();
                }
            } else {
                Completion.get().hideCompletion();
            }
            return this.filterPrefix != null;
        }

        protected void filter(CompletionResultSet resultSet) {
            if (this.filterPrefix != null && this.results != null) {
                resultSet.setAnchorOffset(this.queryAnchorOffset);
                Collection<CsmOverrideMethodCompletionItem> items = this.getFilteredData(this.results, this.filterPrefix);
                resultSet.estimateItems(items.size(), -1);
                resultSet.addAllItems(items);
            }
            resultSet.setHasAdditionalItems(false);
            resultSet.finish();
        }

        private CsmClass visitDeclarations(Collection<CsmOffsetableDeclaration> decls, int caretOffset) {
            for (CsmOffsetableDeclaration decl : decls) {
                if (CsmKindUtilities.isNamespaceDefinition((CsmObject)decl)) {
                    if (decl.getStartOffset() > caretOffset || caretOffset > decl.getEndOffset()) continue;
                    return this.visitDeclarations(((CsmNamespaceDefinition)decl).getDeclarations(), caretOffset);
                }
                if (CsmKindUtilities.isClass((CsmObject)decl)) {
                    block1: while (decl.getStartOffset() <= caretOffset && caretOffset <= decl.getEndOffset()) {
                        CsmClass cls = (CsmClass)decl;
                        int leftBracketOffset = cls.getLeftBracketOffset();
                        if (leftBracketOffset >= caretOffset) {
                            return null;
                        }
                        ArrayList members = new ArrayList(cls.getMembers());
                        for (int i = 0; i < members.size(); ++i) {
                            CsmMember member = (CsmMember)members.get(i);
                            if (member.getStartOffset() > caretOffset || caretOffset > member.getEndOffset()) continue;
                            if (CsmKindUtilities.isClass((CsmObject)member)) {
                                decl = member;
                                continue block1;
                            }
                            return null;
                        }
                        return cls;
                    }
                    continue;
                }
                if (decl.getStartOffset() > caretOffset || caretOffset > decl.getEndOffset()) continue;
                return null;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection<CsmOverrideMethodCompletionItem> getItems(BaseDocument doc, int caretOffset) {
            ArrayList<CsmOverrideMethodCompletionItem> items = new ArrayList<CsmOverrideMethodCompletionItem>();
            CsmCacheManager.enter();
            try {
                CsmClass cls;
                CsmFile csmFile;
                if (this.init(doc, caretOffset) && (csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false)) != null && (cls = this.visitDeclarations(csmFile.getDeclarations(), caretOffset)) != null) {
                    HashSet<CsmMethod> virtual = new HashSet<CsmMethod>();
                    this.getVirtualMethods(virtual, cls, new HashSet<AntiLoopElement>());
                    boolean hasDestructor = false;
                    for (CsmMember member : cls.getMembers()) {
                        if (!CsmKindUtilities.isMethod((CsmObject)member)) continue;
                        if (CsmKindUtilities.isDestructor((CsmObject)member)) {
                            hasDestructor = true;
                        }
                        for (CsmMethod m : CsmVirtualInfoQuery.getDefault().getAllBaseDeclarations((CsmMethod)member)) {
                            virtual.remove(m);
                        }
                    }
                    boolean addDestructor = !hasDestructor;
                    for (CsmMethod m : virtual) {
                        if (CsmKindUtilities.isDestructor((CsmObject)m)) {
                            if (hasDestructor || !addDestructor) continue;
                            items.add(CsmOverrideMethodCompletionItem.createImplementItem(this.queryAnchorOffset, caretOffset, cls, (CsmMember)m));
                            addDestructor = false;
                            continue;
                        }
                        items.add(CsmOverrideMethodCompletionItem.createImplementItem(this.queryAnchorOffset, caretOffset, cls, (CsmMember)m));
                    }
                    if (addDestructor) {
                        items.add(CsmOverrideMethodCompletionItem.createImplementItem(this.queryAnchorOffset, caretOffset, cls, null));
                    }
                }
            }
            catch (BadLocationException ex) {
            }
            finally {
                CsmCacheManager.leave();
            }
            return items;
        }

        private void getVirtualMethods(Set<CsmMethod> res, CsmClass cls, Set<AntiLoopElement> antiLoop) {
            AntiLoopElement element = new AntiLoopElement((CsmOffsetable)cls);
            if (antiLoop.contains(element)) {
                return;
            }
            antiLoop.add(element);
            Collection baseClasses = cls.getBaseClasses();
            for (CsmInheritance inh : baseClasses) {
                element = new AntiLoopElement((CsmOffsetable)inh);
                if (antiLoop.contains(element)) continue;
                antiLoop.add(element);
                CsmClassifier classifier = inh.getClassifier();
                if (!CsmKindUtilities.isClass((CsmObject)classifier)) continue;
                CsmClass c = (CsmClass)classifier;
                this.getVirtualMethods(res, c, antiLoop);
                for (CsmMember member : c.getMembers()) {
                    if (!CsmKindUtilities.isMethod((CsmObject)member) || !CsmVirtualInfoQuery.getDefault().isVirtual((CsmMethod)member)) continue;
                    res.add((CsmMethod)member);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean init(BaseDocument doc, int caretOffset) throws BadLocationException {
            this.filterPrefix = "";
            this.queryAnchorOffset = caretOffset;
            if (doc != null) {
                doc.readLock();
                try {
                    TokenId id;
                    TokenItem tok = CndTokenUtilities.getTokenCheckPrev((Document)doc, (int)caretOffset);
                    if (tok != null && (id = tok.id()) instanceof CppTokenId && !"whitespace".equals(id.primaryCategory())) {
                        this.queryAnchorOffset = tok.offset();
                        this.filterPrefix = doc.getText(this.queryAnchorOffset, caretOffset - this.queryAnchorOffset);
                    }
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    doc.readUnlock();
                }
            }
            return this.queryAnchorOffset >= 0;
        }

        private Collection<CsmOverrideMethodCompletionItem> getFilteredData(Collection<CsmOverrideMethodCompletionItem> data, String prefix) {
            Collection<CsmOverrideMethodCompletionItem> out;
            if (prefix == null) {
                out = data;
            } else {
                ArrayList<CsmOverrideMethodCompletionItem> ret = new ArrayList<CsmOverrideMethodCompletionItem>(data.size());
                for (CsmOverrideMethodCompletionItem itm : data) {
                    if (!this.matchPrefix(itm, prefix)) continue;
                    ret.add(itm);
                }
                out = ret;
            }
            return out;
        }

        private boolean matchPrefix(CsmOverrideMethodCompletionItem itm, String prefix) {
            return CharSequenceUtils.startsWith((CharSequence)itm.getSortText(), (CharSequence)prefix);
        }
    }
}

