/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.ui;

import java.util.Collection;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.refactoring.api.WhereUsedQueryConstants;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.ui.WhereUsedPanel;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class WhereUsedQueryUI
implements RefactoringUI {
    private WhereUsedQuery query;
    private WhereUsedPanel panel;
    private final CsmObject origObject;
    private final String name;

    public WhereUsedQueryUI(CsmObject csmObject) {
        this.query = new WhereUsedQuery(Lookups.singleton((Object)csmObject));
        this.origObject = csmObject;
        this.name = this.getSearchElementName(this.origObject);
    }

    public boolean isQuery() {
        return true;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new WhereUsedPanel(this.name, this.origObject, parent);
        }
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem setParameters() {
        try {
            assert (this.panel != null);
            this.query.putValue((Object)"SEARCH_IN_COMMENTS", (Object)this.panel.isSearchInComments());
            Collection<CsmProject> prjs = CsmRefactoringUtils.getRelatedCsmProjects(this.origObject, this.panel.getScopeProject());
            CsmProject[] ar = prjs.toArray(new CsmProject[prjs.size()]);
            this.query.getContext().add((Object)ar);
            CsmObject refObj = this.panel.getReferencedObject();
            if (refObj == null) {
                this.query.setRefactoringSource(Lookup.EMPTY);
            } else {
                this.query.setRefactoringSource(Lookups.singleton(CsmRefactoringUtils.getHandler(refObj)));
            }
            if (this.panel.isVirtualMethod()) {
                this.setForMethod();
                Problem problem = this.query.checkParameters();
                return problem;
            }
            if (this.panel.isClass()) {
                this.setForClass();
                Problem problem = this.query.checkParameters();
                return problem;
            }
            Problem problem = null;
            return problem;
        }
        finally {
            this.panel.uninitialize();
        }
    }

    private void setForMethod() {
        assert (this.panel != null);
        CsmObject refObj = this.panel.getReferencedObject();
        if (refObj == null) {
            this.query.setRefactoringSource(Lookup.EMPTY);
        } else {
            this.query.setRefactoringSource(Lookups.singleton(CsmRefactoringUtils.getHandler(refObj)));
        }
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS, (Object)this.panel.isMethodOverriders());
        this.query.putValue((Object)WhereUsedQueryConstants.SEARCH_FROM_BASECLASS, (Object)this.panel.isMethodFromBaseClass());
        this.query.putValue((Object)"FIND_REFERENCES", (Object)this.panel.isMethodFindUsages());
    }

    private void setForClass() {
        assert (this.panel != null);
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES, (Object)this.panel.isClassSubTypes());
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES, (Object)this.panel.isClassSubTypesDirectOnly());
        this.query.putValue((Object)"FIND_REFERENCES", (Object)this.panel.isClassFindUsages());
    }

    public Problem checkParameters() {
        assert (this.panel != null);
        if (this.panel.isVirtualMethod()) {
            this.setForMethod();
            return this.query.fastCheckParameters();
        }
        if (this.panel.isClass()) {
            this.setForClass();
            return this.query.fastCheckParameters();
        }
        return null;
    }

    public AbstractRefactoring getRefactoring() {
        return this.query;
    }

    public String getDescription() {
        if (this.panel != null) {
            String description = this.panel.getDescription();
            String key = "DSC_WhereUsed";
            if (this.panel.isClass()) {
                if (!this.panel.isClassFindUsages()) {
                    key = this.panel.isClassSubTypesDirectOnly() ? "DSC_WhereUsedFindDirectSubTypes" : "DSC_WhereUsedFindAllSubTypes";
                }
            } else if (this.panel.isVirtualMethod()) {
                if (this.panel.isMethodFromBaseClass()) {
                    description = this.panel.getBaseMethodDescription();
                }
                if (this.panel.isMethodOverriders()) {
                    key = this.panel.isMethodFindUsages() ? "DSC_WhereUsedUsagesAndMethodOverriders" : "DSC_WhereUsedMethodOverriders";
                }
            }
            description = description.replace("<html>", "").replace("</html>", "");
            return this.getString(key, description);
        }
        return this.getString("DSC_WhereUsed", this.name);
    }

    private String getString(String key, String value) {
        return NbBundle.getMessage(WhereUsedQueryUI.class, (String)key, (Object)value);
    }

    public String getName() {
        return this.getString("LBL_UsagesOf", this.name);
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WhereUsedQueryUI.class);
    }

    private String getSearchElementName(CsmObject csmObj) {
        String objName;
        if (csmObj instanceof CsmReference) {
            objName = ((CsmReference)csmObj).getText().toString();
        } else if (CsmKindUtilities.isNamedElement((CsmObject)csmObj)) {
            objName = ((CsmNamedElement)csmObj).getName().toString();
        } else if (CsmKindUtilities.isInclude((CsmObject)csmObj)) {
            objName = ((CsmInclude)csmObj).getIncludeName().toString();
        } else if (csmObj != null) {
            objName = "<UNNAMED ELEMENT>";
        } else {
            CndUtils.assertUnconditional((String)"Null parameter");
            objName = "<UNRESOLVED ELEMENT>";
        }
        return objName;
    }
}

