/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.projectui.wizard.ide;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.modules.cnd.remote.projectui.wizard.ide.OpenProjectListSettings;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.ListView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class TemplatesPanelGUI
extends JPanel
implements PropertyChangeListener {
    public static final String TEMPLATES_FOLDER = "templatesFolder";
    public static final String TARGET_TEMPLATE = "targetTemplate";
    private static final String ATTR_INSTANTIATING_DESC = "instantiatingWizardURL";
    private static final Image PLEASE_WAIT_ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/project/ui/resources/wait.gif");
    private Builder firer;
    private String presetTemplateName = null;
    private Node pleaseWait;
    private JPanel categoriesPanel;
    private JEditorPane description;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JPanel projectsPanel;

    public TemplatesPanelGUI(Builder firer) {
        assert (firer != null) : "Builder can not be null";
        this.firer = firer;
        this.initComponents();
        this.postInitComponents();
        this.setName(NbBundle.getMessage(TemplatesPanelGUI.class, (String)"TXT_SelectTemplate"));
    }

    public void setTemplatesFolder(FileObject folder) {
        DataFolder dobj = DataFolder.findFolder((FileObject)folder);
        dobj.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TemplatesPanelGUI.this.setSelectedCategoryByName(OpenProjectListSettings.getInstance().getLastSelectedProjectCategory());
                    }
                });
            }
        });
        ((ExplorerProviderPanel)this.categoriesPanel).setRootNode((Node)new FilterNode(dobj.getNodeDelegate(), this.firer.createCategoriesChildren(dobj)));
    }

    public void setSelectedCategoryByName(String categoryName) {
        if (categoryName != null) {
            try {
                ((ExplorerProviderPanel)this.categoriesPanel).setSelectedNode(categoryName);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Node[] sel = ((ExplorerProviderPanel)TemplatesPanelGUI.this.categoriesPanel).getSelectedNodes();
                        if (sel.length == 1) {
                            ((CategoriesPanel)TemplatesPanelGUI.this.categoriesPanel).btv.expandNode(sel[0]);
                        }
                    }
                });
            }
            catch (NodeNotFoundException ex) {
                ((CategoriesPanel)this.categoriesPanel).selectFirstCategory();
            }
        } else {
            ((CategoriesPanel)this.categoriesPanel).selectFirstCategory();
        }
    }

    public String getSelectedCategoryName() {
        return ((ExplorerProviderPanel)this.categoriesPanel).getSelectionPath();
    }

    public void setSelectedTemplateByName(final String templateName) {
        this.presetTemplateName = templateName;
        final TemplatesPanel tempExplorer = (TemplatesPanel)this.projectsPanel;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (templateName != null) {
                    try {
                        tempExplorer.setSelectedNode(templateName);
                    }
                    catch (NodeNotFoundException nodeNotFoundException) {
                        // empty catch block
                    }
                    if (tempExplorer.getSelectionPath() == null) {
                        TemplatesPanelGUI.this.presetTemplateName = null;
                        tempExplorer.selectFirstTemplate();
                    }
                } else {
                    tempExplorer.selectFirstTemplate();
                }
            }
        });
    }

    public String getSelectedTemplateName() {
        return ((TemplatesPanel)this.projectsPanel).getSelectionPath();
    }

    public FileObject getSelectedTemplate() {
        DataObject dobj;
        Node[] nodes = ((ExplorerProviderPanel)this.projectsPanel).getSelectedNodes();
        if (nodes != null && nodes.length == 1 && (dobj = (DataObject)nodes[0].getCookie(DataObject.class)) != null) {
            while (dobj instanceof DataShadow) {
                dobj = ((DataShadow)dobj).getOriginal();
            }
            return dobj.getPrimaryFile();
        }
        return null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.jScrollPane1.setViewportView(this.description);
        this.jLabel3.setLabelFor(this.description);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.jScrollPane1.setViewportView(null);
        this.jLabel3.setLabelFor(null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.categoriesPanel) {
            Node[] selectedNodes;
            if ("selectedNodes".equals(event.getPropertyName()) && (selectedNodes = (Node[])event.getNewValue()) != null && selectedNodes.length == 1) {
                assert (this.pleaseWait == null || !this.pleaseWait.equals((Object)selectedNodes[0])) : "Cannot be fired a propertyChange with PleaseWaitNode, but was " + selectedNodes[0];
                try {
                    ((ExplorerProviderPanel)this.projectsPanel).setSelectedNodes(new Node[0]);
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
                DataObject template = (DataObject)selectedNodes[0].getCookie(DataFolder.class);
                if (template != null) {
                    if (!template.isValid()) {
                        FileObject fo = template.getPrimaryFile();
                        if ((fo = FileUtil.getConfigFile((String)fo.getPath())) != null) {
                            try {
                                template = DataObject.find((FileObject)fo);
                            }
                            catch (DataObjectNotFoundException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                    ((ExplorerProviderPanel)this.projectsPanel).setRootNode((Node)new FilterNode(selectedNodes[0], this.firer.createTemplatesChildren((DataFolder)template)));
                    this.setSelectedTemplateByName(this.presetTemplateName);
                }
            }
        } else if (event.getSource() == this.projectsPanel && "selectedNodes".equals(event.getPropertyName())) {
            Node[] selectedNodes = (Node[])event.getNewValue();
            if (selectedNodes != null && selectedNodes.length == 1) {
                DataObject template = (DataObject)selectedNodes[0].getCookie(DataObject.class);
                if (template != null) {
                    URL descURL = this.getDescription(template);
                    if (descURL != null) {
                        try {
                            String charset = TemplatesPanelGUI.findEncodingFromURL(descURL.openStream());
                            ErrorManager.getDefault().log(1, "Url " + descURL + " has charset " + charset);
                            if (charset != null) {
                                this.description.putClientProperty("charset", charset);
                            }
                            this.description.read(descURL.openStream(), (Object)descURL);
                        }
                        catch (ChangedCharSetException x) {
                            Document doc = this.description.getEditorKit().createDefaultDocument();
                            doc.putProperty("IgnoreCharsetDirective", true);
                            try {
                                this.description.read(descURL.openStream(), (Object)doc);
                            }
                            catch (IOException ioe) {
                                ErrorManager.getDefault().notify(1, (Throwable)ioe);
                                this.description.setText(NbBundle.getBundle(TemplatesPanelGUI.class).getString("TXT_NoDescription"));
                            }
                        }
                        catch (IOException e) {
                            ErrorManager.getDefault().notify(1, (Throwable)e);
                            this.description.setText(NbBundle.getBundle(TemplatesPanelGUI.class).getString("TXT_NoDescription"));
                        }
                    } else {
                        this.description.setText(NbBundle.getBundle(TemplatesPanelGUI.class).getString("TXT_NoDescription"));
                    }
                }
            } else {
                this.description.setText(NbBundle.getBundle(TemplatesPanelGUI.class).getString("TXT_NoDescription"));
            }
            this.firer.fireChange();
        }
    }

    private void postInitComponents() {
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)this.firer.getCategoriesName());
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)this.firer.getTemplatesName());
        this.description.setEditorKit(new HTMLEditorKit());
        this.pleaseWait = new AbstractNode(Children.LEAF){

            public Image getIcon(int ignore) {
                return PLEASE_WAIT_ICON;
            }
        };
        this.pleaseWait.setName(NbBundle.getBundle(TemplatesPanelGUI.class).getString("LBL_TemplatesPanel_PleaseWait"));
        Children.Array ch = new Children.Array();
        ch.add(new Node[]{this.pleaseWait});
        AbstractNode root = new AbstractNode((Children)ch);
        SwingUtilities.invokeLater(new Runnable((Node)root){
            final /* synthetic */ Node val$root;
            {
                this.val$root = node;
            }

            @Override
            public void run() {
                ((ExplorerProviderPanel)TemplatesPanelGUI.this.categoriesPanel).setRootNode(this.val$root);
            }
        });
        ((ExplorerProviderPanel)this.projectsPanel).addDefaultActionListener(this.firer);
        this.description.addHyperlinkListener(new ClickHyperlinks());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.categoriesPanel = new CategoriesPanel();
        this.projectsPanel = new TemplatesPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.description = new JEditorPane();
        this.setPreferredSize(new Dimension(500, 230));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.categoriesPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(TemplatesPanelGUI.class).getString("CTL_Categories"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.projectsPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getBundle(TemplatesPanelGUI.class).getString("CTL_Templates"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.insets = new Insets(2, 0, 6, 6);
        this.add((Component)this.categoriesPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.insets = new Insets(2, 6, 6, 0);
        this.add((Component)this.projectsPanel, gridBagConstraints);
        this.jLabel3.setLabelFor(this.description);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getBundle(TemplatesPanelGUI.class).getString("CTL_Description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.description.setEditable(false);
        this.description.setText(NbBundle.getBundle(TemplatesPanelGUI.class).getString("TXT_NoDescription"));
        this.description.setPreferredSize(new Dimension(100, 66));
        this.jScrollPane1.setViewportView(this.description);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private URL getDescription(DataObject dobj) {
        FileObject fo = dobj.getPrimaryFile();
        URL desc = (URL)fo.getAttribute(ATTR_INSTANTIATING_DESC);
        if (desc != null) {
            return desc;
        }
        desc = TemplateWizard.getDescription((DataObject)dobj);
        return desc;
    }

    void warmUp(FileObject templatesFolder) {
        DataFolder df;
        if (templatesFolder != null && (df = DataFolder.findFolder((FileObject)templatesFolder)) != null) {
            df.getChildren();
        }
    }

    void doFinished(FileObject temlatesFolder, String category, String template) {
        assert (temlatesFolder != null);
        this.categoriesPanel.addPropertyChangeListener(this);
        this.projectsPanel.addPropertyChangeListener(this);
        this.setTemplatesFolder(temlatesFolder);
        this.setSelectedCategoryByName(category);
        this.setSelectedTemplateByName(template);
        this.categoriesPanel.requestFocus();
        if (this.description.getEditorKit() instanceof HTMLEditorKit) {
            HTMLEditorKit htmlkit = (HTMLEditorKit)this.description.getEditorKit();
            StyleSheet css = htmlkit.getStyleSheet();
            if (css.getStyleSheets() != null) {
                return;
            }
            StyleSheet css2 = new StyleSheet();
            Font f = this.jLabel1.getFont();
            css2.addRule(new StringBuffer("body { font-size: ").append(f.getSize()).append("; font-family: ").append(f.getName()).append("; }").toString());
            css2.addStyleSheet(css);
            htmlkit.setStyleSheet(css2);
        }
    }

    private static String findEncodingFromURL(InputStream stream) {
        try {
            byte[] arr = new byte[4096];
            int len = stream.read(arr, 0, arr.length);
            String txt = new String(arr, 0, len >= 0 ? len : 0).toUpperCase();
            return TemplatesPanelGUI.findEncoding(txt);
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    private static String findEncoding(String txt) {
        int content;
        int headLen = txt.indexOf("</HEAD>");
        if (headLen == -1) {
            headLen = txt.length();
        }
        if ((content = txt.indexOf("CONTENT-TYPE")) == -1 || content > headLen) {
            return null;
        }
        int charset = txt.indexOf("CHARSET=", content);
        if (charset == -1) {
            return null;
        }
        int charend = txt.indexOf(34, charset);
        int charend2 = txt.indexOf(39, charset);
        if (charend == -1 && charend2 == -1) {
            return null;
        }
        if (charend2 != -1 && (charend == -1 || charend > charend2)) {
            charend = charend2;
        }
        return txt.substring(charset + "CHARSET=".length(), charend);
    }

    private static final class TemplatesPanel
    extends ExplorerProviderPanel {
        private ListView list;

        private TemplatesPanel() {
        }

        @Override
        protected synchronized JComponent createComponent() {
            if (this.list == null) {
                this.list = new TemplatesListView();
                this.list.setPopupAllowed(false);
                this.list.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TemplatesPanelGUI.class, (String)"ACSN_TemplatesPanel"));
                this.list.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanelGUI.class, (String)"ACSD_TemplatesPanel"));
                Border b = (Border)UIManager.get("Nb.ScrollPane.border");
                if (b != null) {
                    this.list.setBorder(b);
                }
            }
            return this.list;
        }

        public void selectFirstTemplate() {
            try {
                Children ch = this.getExplorerManager().getRootContext().getChildren();
                if (ch.getNodesCount() > 0) {
                    this.getExplorerManager().setSelectedNodes(new Node[]{ch.getNodes()[0]});
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        @Override
        void addDefaultActionListener(ActionListener al) {
            this.createComponent();
            ((TemplatesListView)this.list).setDefaultProcessor(al);
        }
    }

    private static class TemplatesListView
    extends ListView
    implements ActionListener {
        public TemplatesListView() {
            this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
            this.setDefaultProcessor(this);
            ToolTipManager.sharedInstance().unregisterComponent(this.list);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private static final class CategoriesPanel
    extends ExplorerProviderPanel {
        private CategoriesBeanTreeView btv;

        private CategoriesPanel() {
        }

        @Override
        protected synchronized JComponent createComponent() {
            if (this.btv == null) {
                this.btv = new CategoriesBeanTreeView();
                this.btv.setRootVisible(false);
                this.btv.setPopupAllowed(false);
                this.btv.setFocusable(false);
                this.btv.setDefaultActionAllowed(false);
                this.btv.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TemplatesPanelGUI.class, (String)"ACSN_CategoriesPanel"));
                this.btv.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanelGUI.class, (String)"ACSD_CategoriesPanel"));
                Border b = (Border)UIManager.get("Nb.ScrollPane.border");
                if (b != null) {
                    this.btv.setBorder(b);
                }
            }
            return this.btv;
        }

        public void selectFirstCategory() {
            this.btv.selectFirstCategory();
        }
    }

    private static class CategoriesBeanTreeView
    extends BeanTreeView {
        public CategoriesBeanTreeView() {
            this.tree.setEditable(false);
        }

        public void selectFirstCategory() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CategoriesBeanTreeView.this.tree.setSelectionRow(0);
                }
            });
        }
    }

    private static abstract class ExplorerProviderPanel
    extends JPanel
    implements ExplorerManager.Provider,
    PropertyChangeListener,
    VetoableChangeListener {
        private ExplorerManager manager = new ExplorerManager();

        protected ExplorerProviderPanel() {
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            this.manager.addVetoableChangeListener((VetoableChangeListener)this);
            this.initGUI();
        }

        public void setRootNode(Node node) {
            this.manager.setRootContext(node);
        }

        public Node getRootNode() {
            return this.manager.getRootContext();
        }

        public Node[] getSelectedNodes() {
            return this.manager.getSelectedNodes();
        }

        public void setSelectedNodes(Node[] nodes) throws PropertyVetoException {
            this.manager.setSelectedNodes(nodes);
        }

        public void setSelectedNode(String path) throws NodeNotFoundException {
            if (path == null) {
                return;
            }
            StringTokenizer tk = new StringTokenizer(path, "/");
            String[] names = new String[tk.countTokens()];
            int i = 0;
            while (tk.hasMoreTokens()) {
                names[i] = tk.nextToken();
                ++i;
            }
            try {
                Node node = NodeOp.findPath((Node)this.manager.getRootContext(), (String[])names);
                if (node != null) {
                    this.manager.setSelectedNodes(new Node[]{node});
                }
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }

        public String getSelectionPath() {
            Node[] selectedNodes = this.manager.getSelectedNodes();
            if (selectedNodes == null || selectedNodes.length != 1) {
                return null;
            }
            Node rootNode = this.manager.getRootContext();
            String[] path = NodeOp.createPath((Node)selectedNodes[0], (Node)rootNode);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < path.length; ++i) {
                builder.append('/');
                builder.append(path[i]);
            }
            return builder.substring(1);
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        @Override
        public void propertyChange(final PropertyChangeEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExplorerProviderPanel.this.firePropertyChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
                }
            });
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            Node[] newValue;
            if ("selectedNodes".equals(evt.getPropertyName()) && ((newValue = (Node[])evt.getNewValue()) == null || newValue.length != 1 && newValue.length != 0)) {
                throw new PropertyVetoException("Invalid length", evt);
            }
        }

        @Override
        public void requestFocus() {
            this.createComponent().requestFocus();
        }

        protected abstract JComponent createComponent();

        private void initGUI() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 0;
            c.gridheight = 0;
            c.fill = 1;
            c.anchor = 18;
            c.weightx = 1.0;
            c.weighty = 1.0;
            JComponent component = this.createComponent();
            ((GridBagLayout)this.getLayout()).setConstraints(component, c);
            this.add(component);
        }

        void addDefaultActionListener(ActionListener al) {
        }
    }

    private static final class ClickHyperlinks
    implements HyperlinkListener {
        private ClickHyperlinks() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent evt) {
            if (HyperlinkEvent.EventType.ACTIVATED == evt.getEventType() && evt.getURL() != null) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(evt.getURL());
            }
        }
    }

    public static interface Builder
    extends ActionListener {
        public Children createCategoriesChildren(DataFolder var1);

        public Children createTemplatesChildren(DataFolder var1);

        public String getCategoriesName();

        public String getTemplatesName();

        public void fireChange();
    }
}

