/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.netbeans.modules.glassfish.tooling.GlassFishIdeException;
import org.netbeans.modules.glassfish.tooling.logging.Logger;
import org.netbeans.modules.glassfish.tooling.utils.ServerUtils;

public class NetUtils {
    private static final Logger LOGGER = new Logger(ServerUtils.class);
    public static final int PORT_CHECK_TIMEOUT = 2000;
    private static byte[] TEST_QUERY = new byte[]{22, 3, 0, 0, 83, 1, 0, 0, 79, 3, 0, 63, 71, -41, -9, -70, 44, -18, -22, -78, 96, 126, -13, 0, -3, -126, 123, -71, -43, -106, -56, 119, -101, -26, -60, -37, 60, 61, -37, 111, -17, 16, 110, 0, 0, 40, 0, 22, 0, 19, 0, 10, 0, 102, 0, 5, 0, 4, 0, 101, 0, 100, 0, 99, 0, 98, 0, 97, 0, 96, 0, 21, 0, 18, 0, 9, 0, 20, 0, 17, 0, 8, 0, 6, 0, 3, 1, 0, 71, 69, 84, 32, 47, 99, 111, 109, 95, 115, 117, 110, 95, 119, 101, 98, 95, 117, 105, 32, 72, 84, 84, 80, 47, 49, 46, 48, 10, 10};
    private static final InetAddressComparator INET_ADDRESS_COMPARATOR = new InetAddressComparator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortListeningRemote(String host, int port, int timeout) {
        String METHOD = "isPortListeningRemote";
        if (null == host) {
            return false;
        }
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), timeout);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.INFO, "isPortListeningRemote", "closeError", ioe.getLocalizedMessage());
                }
            }
        }
    }

    public static boolean isPortListeningRemote(String host, int port) {
        return NetUtils.isPortListeningRemote(host, port, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortListeningLocal(String host, int port) {
        String METHOD = "isPortListeningLocal";
        ServerSocket socket = null;
        try {
            InetAddress ia = InetAddress.getByName(host);
            socket = new ServerSocket(port, 1, ia);
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.INFO, "isPortListeningLocal", "closeError", ioe.getLocalizedMessage());
                }
            }
        }
    }

    public static boolean isSecurePort(String hostname, int port) throws IOException, ConnectException, SocketTimeoutException {
        return NetUtils.isSecurePort(hostname, port, 0);
    }

    private static boolean isSecurePort(String hostname, int port, int depth) throws IOException, ConnectException, SocketTimeoutException {
        OutputStream ostream;
        String METHOD = "isSecurePort";
        try (Socket socket = new Socket();){
            block31: {
                try {
                    LOGGER.log(Level.FINE, "isSecurePort", "socket");
                    socket.connect(new InetSocketAddress(hostname, port), 2000);
                    socket.setSoTimeout(2000);
                }
                catch (SocketException ex) {
                    String socksNonProxyHosts = System.getProperty("socksNonProxyHosts");
                    if (socksNonProxyHosts == null || socksNonProxyHosts.indexOf("localhost") >= 0) break block31;
                    String localhost = socksNonProxyHosts.length() > 0 ? "|localhost" : "localhost";
                    System.setProperty("socksNonProxyHosts", socksNonProxyHosts + localhost);
                    if (depth < 1) {
                        socket.close();
                        boolean bl = NetUtils.isSecurePort(hostname, port, 1);
                        if (socket != null) {
                            if (var6_5 != null) {
                                try {
                                    socket.close();
                                }
                                catch (Throwable x2) {
                                    var6_5.addSuppressed(x2);
                                }
                            } else {
                                socket.close();
                            }
                        }
                        return bl;
                    }
                    socket.close();
                    ConnectException ce = new ConnectException();
                    ce.initCause(ex);
                    throw ce;
                }
            }
            ostream = socket.getOutputStream();
        }
        ostream.write(TEST_QUERY);
        InputStream istream = socket.getInputStream();
        byte[] input = new byte[8192];
        istream.read(input);
        String response = new String(input).toLowerCase(Locale.ENGLISH);
        boolean isSecure = true;
        if (response.length() == 0) {
            socket.close();
            throw new ConnectException();
        }
        if (response.startsWith("http/1.1 302 moved temporarily")) {
            isSecure = true;
        } else if (response.startsWith("http/1.")) {
            isSecure = false;
        } else if (response.indexOf("<html") != -1) {
            isSecure = false;
        } else if (response.indexOf("</html") != -1) {
            isSecure = false;
        } else if (response.indexOf("connection: ") != -1) {
            isSecure = false;
        }
        return isSecure;
    }

    public static Set<InetAddress> getHostIPs() {
        String METHOD = "getHostIPs";
        TreeSet<InetAddress> addrs = new TreeSet<InetAddress>(INET_ADDRESS_COMPARATOR);
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> e = iface.getInetAddresses();
                while (e.hasMoreElements()) {
                    InetAddress a = e.nextElement();
                    addrs.add(a);
                }
            }
        }
        catch (SocketException se) {
            addrs = null;
            throw new GlassFishIdeException(LOGGER.excMsg("getHostIPs", "exception"));
        }
        return addrs;
    }

    public static Set<Inet4Address> getHostIP4s() {
        TreeSet<InetAddress> addrs = new TreeSet<InetAddress>(INET_ADDRESS_COMPARATOR);
        for (InetAddress a : NetUtils.getHostIPs()) {
            if (!(a instanceof Inet4Address)) continue;
            addrs.add((Inet4Address)a);
        }
        return addrs;
    }

    public static Set<Inet6Address> getHostIP6s() {
        TreeSet<InetAddress> addrs = new TreeSet<InetAddress>(INET_ADDRESS_COMPARATOR);
        for (InetAddress a : NetUtils.getHostIPs()) {
            if (!(a instanceof Inet6Address)) continue;
            addrs.add((Inet6Address)a);
        }
        return addrs;
    }

    public static class InetAddressComparator
    implements Comparator<InetAddress> {
        @Override
        public int compare(InetAddress ip1, InetAddress ip2) {
            byte[] addr1 = ip1.getAddress();
            byte[] addr2 = ip2.getAddress();
            int result = addr2.length - addr1.length;
            if (result == 0) {
                for (int i = 0; result == 0 && i < addr1.length; ++i) {
                    result = addr1[i] - addr2[i];
                }
            }
            return result;
        }
    }
}

