/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sendto.api;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.dlight.sendto.api.Configuration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.Exceptions;

public final class ScriptsRegistry {
    private static final Object lock = new Object();
    private static final HashMap<Integer, HashMap<String, HashMap<ExecutionEnvironment, String>>> cfgToMap = new HashMap();
    private static final AtomicReference<File> localTmpDir = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidate(Configuration cfg) {
        Object object = lock;
        synchronized (object) {
            if (cfgToMap.containsKey(cfg.getID())) {
                HashMap<String, HashMap<ExecutionEnvironment, String>> map = cfgToMap.remove(cfg.getID());
                for (Map.Entry<String, HashMap<ExecutionEnvironment, String>> map1 : map.entrySet()) {
                    HashMap<ExecutionEnvironment, String> map2 = map1.getValue();
                    for (ExecutionEnvironment env : map2.keySet()) {
                        if (env.isLocal()) {
                            ScriptsRegistry.removeLocalFiles(cfg);
                            continue;
                        }
                        ScriptsRegistry.removeRemoteFiles(env, cfg);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getScriptFile(Configuration config, ExecutionEnvironment env, String script) {
        String result;
        if (env == null) {
            env = ExecutionEnvironmentFactory.getLocal();
        }
        Object object = lock;
        synchronized (object) {
            HashMap map2;
            HashMap<Object, Object> map;
            Integer configID = config.getID();
            if (!cfgToMap.containsKey(configID)) {
                map = new HashMap();
                cfgToMap.put(configID, map);
            } else {
                map = cfgToMap.get(configID);
            }
            if (!map.containsKey(script)) {
                map2 = new HashMap();
                map.put(script, map2);
            } else {
                map2 = (HashMap)map.get(script);
            }
            result = (String)map2.get(env);
            if (result == null && (result = env.isLocal() ? ScriptsRegistry.createLocalFile(config, script) : ScriptsRegistry.createRemoteFile(env, config, script)) != null) {
                map2.put(env, result);
            }
        }
        return result;
    }

    private static void removeLocalFiles(Configuration cfg) {
        File tmpDir = ScriptsRegistry.getLocalTmpDir();
        if (tmpDir == null) {
            return;
        }
        try {
            File[] files;
            final String cfgPrefix = ScriptsRegistry.getFilePrefix(cfg);
            for (File file : files = tmpDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(cfgPrefix);
                }
            })) {
                file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void removeRemoteFiles(ExecutionEnvironment env, Configuration cfg) {
        try {
            if (!ConnectionManager.getInstance().isConnectedTo(env)) {
                return;
            }
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)env);
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
            if (hostInfo == null) {
                return;
            }
            npb.setExecutable("/bin/sh");
            npb.setArguments(new String[]{"-c", "/bin/rm " + hostInfo.getTempDir() + "/" + ScriptsRegistry.getFilePrefix(cfg) + "*"});
            npb.call().waitFor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getFilePrefix(Configuration cfg) {
        return "sendto." + Math.abs((long)cfg.getName().hashCode()) + '.';
    }

    private static String createLocalFile(Configuration config, String script) {
        File tmpDir = ScriptsRegistry.getLocalTmpDir();
        if (tmpDir == null) {
            return null;
        }
        try {
            File file = File.createTempFile(ScriptsRegistry.getFilePrefix(config), "", tmpDir);
            file.deleteOnExit();
            BufferedWriter w = new BufferedWriter(new FileWriter(file));
            w.write(script);
            w.flush();
            w.close();
            return file.getAbsolutePath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String createRemoteFile(ExecutionEnvironment env, Configuration config, String script) {
        try {
            String tmpDir = ScriptsRegistry.getRemoteTmpDir(env);
            if (tmpDir == null) {
                return null;
            }
            String fname = tmpDir + '/' + ScriptsRegistry.getFilePrefix(config) + Math.abs((long)script.hashCode());
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)env);
            npb.setExecutable("/bin/sh");
            npb.setArguments(new String[]{"-c", "/bin/cat > " + fname});
            NativeProcess process = npb.call();
            PrintWriter w = ProcessUtils.getWriter((OutputStream)process.getOutputStream(), (boolean)true);
            w.write(script);
            w.flush();
            w.close();
            return fname;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private static File getLocalTmpDir() {
        File tmpDir = localTmpDir.get();
        if (tmpDir == null) {
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
                if (hostInfo == null) {
                    return null;
                }
                tmpDir = hostInfo.getTempDirFile();
                localTmpDir.compareAndSet(null, tmpDir);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tmpDir;
    }

    private static String getRemoteTmpDir(ExecutionEnvironment env) {
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
            if (hostInfo != null) {
                return hostInfo.getTempDir();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

