/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.jade.editor.lexer;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.javascript2.jade.editor.lexer.JadeLexer;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public enum JadeTokenId implements TokenId
{
    DOCTYPE("doctype", "sgml-declaration"),
    DOCTYPE_TEMPLATE(null, "sgml-declaration"),
    DOCTYPE_ATTRIBUTE(null, "sgml-declaration"),
    DOCTYPE_STRING(null, "sgml-declaration"),
    DOCTYPE_STRING_START(null, "sgml-declaration"),
    DOCTYPE_STRING_END(null, "sgml-declaration"),
    EOL(null, "whitespace"),
    WHITESPACE(null, "whitespace"),
    KEYWORD_IF("if", "keyword"),
    KEYWORD_ELSE("else", "keyword"),
    KEYWORD_UNLESS("unless", "keyword"),
    KEYWORD_CASE("case", "keyword"),
    KEYWORD_WHEN("when", "keyword"),
    KEYWORD_DEFAULT("default", "keyword"),
    KEYWORD_EACH("each", "keyword"),
    KEYWORD_IN("in", "keyword"),
    KEYWORD_FOR("for", "keyword"),
    KEYWORD_WHILE("while", "keyword"),
    KEYWORD_MIXIN("mixin", "keyword"),
    KEYWORD_TRUE("true", "keyword"),
    KEYWORD_FALSE("false", "keyword"),
    KEYWORD_BLOCK("block", "keyword"),
    KEYWORD_EXTENDS("extends", "keyword"),
    KEYWORD_INCLUDE("include", "keyword"),
    MIXIN_NAME(null, "mixin-name"),
    IDENTIFIER(null, "identifier"),
    OPERATOR_COLON(":", "separator"),
    OPERATOR_DIVISION("/", "operator"),
    OPERATOR_ASSIGNMENT("=", "operator"),
    OPERATOR_NOT_EQUALS("!=", "operator"),
    OPERATOR_COMMA(",", "separator"),
    OPERATOR_REST_ARGUMENTS("...", "operator"),
    OPERATOR_PLUS("+", "operator"),
    COMMENT_DELIMITER(null, "comment"),
    UNBUFFERED_COMMENT_DELIMITER(null, "unbuffered-comment"),
    COMMENT(null, "comment"),
    UNBUFFERED_COMMENT(null, "unbuffered-comment"),
    CODE_DELIMITER(null, "code-delimiter"),
    PLAIN_TEXT_DELIMITER(null, "plain-text-delimiter"),
    PLAIN_TEXT(null, "plain-text"),
    EXPRESSION_DELIMITER_OPEN(null, "expression-delimiter"),
    EXPRESSION_DELIMITER_CLOSE(null, "expression-delimiter"),
    CSS_ID(null, "css-id"),
    CSS_CLASS(null, "css-class"),
    FILE_PATH(null, "file-path"),
    FILTER(null, "filter"),
    FILTER_TEXT(null, "filter-text"),
    BLOCK_NAME(null, "block-name"),
    TAG(null, "html-tag"),
    ATTRIBUTE(null, "html-attribute"),
    TEXT(null, "text"),
    JAVASCRIPT(null, "javascript-embedded"),
    CSS(null, "css-embedded"),
    BRACKET_LEFT_PAREN("(", "separator"),
    BRACKET_RIGHT_PAREN(")", "separator"),
    UNKNOWN(null, "error");

    public static final String JADE_MIME_TYPE = "text/jade";
    private final String text;
    private final String primaryCategory;
    private static final Language<JadeTokenId> JADE_LANGUAGE;

    private JadeTokenId(String text, String primaryCategory) {
        this.text = text;
        this.primaryCategory = primaryCategory;
    }

    public String getText() {
        return this.text;
    }

    public boolean isKeyword() {
        return "keyword".equals(this.primaryCategory);
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public static Language<JadeTokenId> jadeLanguage() {
        return JADE_LANGUAGE;
    }

    static {
        JADE_LANGUAGE = new LanguageHierarchy<JadeTokenId>(){

            protected String mimeType() {
                return JadeTokenId.JADE_MIME_TYPE;
            }

            protected Collection<JadeTokenId> createTokenIds() {
                return EnumSet.allOf(JadeTokenId.class);
            }

            protected Map<String, Collection<JadeTokenId>> createTokenCategories() {
                HashMap<String, Collection<JadeTokenId>> cats = new HashMap<String, Collection<JadeTokenId>>();
                return cats;
            }

            protected Lexer<JadeTokenId> createLexer(LexerRestartInfo<JadeTokenId> info) {
                return JadeLexer.create(info);
            }

            protected LanguageEmbedding<?> embedding(Token<JadeTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                JadeTokenId id = (JadeTokenId)token.id();
                switch (id) {
                    case JAVASCRIPT: {
                        return LanguageEmbedding.create((Language)JsTokenId.javascriptLanguage(), (int)0, (int)0, (boolean)true);
                    }
                    case CSS: {
                        return LanguageEmbedding.create((Language)CssTokenId.language(), (int)0, (int)0, (boolean)true);
                    }
                    case PLAIN_TEXT: 
                    case TEXT: {
                        return LanguageEmbedding.create((Language)HTMLTokenId.language(), (int)0, (int)0, (boolean)true);
                    }
                }
                return null;
            }
        }.language();
    }
}

