/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.libs.common;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.openide.filesystems.FileSystem;

public class FileStatistics {
    private static final ConcurrentHashMap<FileSystem, FileStatistics> instances = new ConcurrentHashMap();
    private static final boolean REPORT_FIRST = Boolean.getBoolean("dlight.file.read.statistics.report.first");
    private static final String PREFIX = "### FRS ";
    private static final Set<String> extensionsToInclude = new TreeSet<String>();
    private static final Set<String> namesToExclude;
    private final PrintStream out = System.err;
    private final FileSystem fileSystem;
    private final Map<String, StatEntry> stacks = new HashMap<String, StatEntry>();
    private final Map<String, StatEntry> files = new HashMap<String, StatEntry>();
    private final Object lock = new Object();

    public static FileStatistics getInstance(FileSystem fs) {
        FileStatistics oldInstance;
        FileStatistics instance = instances.get(fs);
        if (instance == null && (oldInstance = instances.putIfAbsent(fs, instance = new FileStatistics(fs))) != null) {
            instance = oldInstance;
        }
        return instance;
    }

    private FileStatistics(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    private List<StackTraceElement> filter(StackTraceElement[] stack) {
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>();
        String thisClassName = this.getClass().getName();
        for (int i = 0; i < stack.length; ++i) {
            StackTraceElement st = stack[i];
            if (st.getClassName().startsWith(thisClassName) || st.getClassName().startsWith("java.util.logging") || st.getClassName().startsWith("java.lang.Thread")) continue;
            result.add(st);
        }
        return result;
    }

    private static <T> List<T> removeCycles(List<T> stack) {
        ArrayList<T> result = new ArrayList<T>();
        block0: for (int curr = 0; curr < stack.size(); ++curr) {
            T currElement = stack.get(curr);
            for (int prev = 0; prev < curr; ++prev) {
                int distance;
                if (!currElement.equals(stack.get(prev)) || curr + (distance = curr - prev) > stack.size()) continue;
                boolean cycle = true;
                for (int i = 1; i < distance; ++i) {
                    if (stack.get(curr + i).equals(stack.get(prev + i))) continue;
                    cycle = false;
                    break;
                }
                if (!cycle) continue;
                curr += distance - 1;
                continue block0;
            }
            result.add(currElement);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.files.clear();
            this.stacks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logPath(String path) {
        StatEntry stackEntry;
        StatEntry pathEntry;
        String ext;
        String fileName = PathUtilities.getBaseName(path);
        if (namesToExclude.contains(fileName)) {
            return;
        }
        int dotIndex = fileName.lastIndexOf(46);
        String string = ext = dotIndex > 0 ? fileName.substring(dotIndex + 1) : "";
        if (!extensionsToInclude.contains(ext)) {
            return;
        }
        List<StackTraceElement> stack = this.filter(Thread.currentThread().getStackTrace());
        stack = FileStatistics.removeCycles(stack);
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement st : stack) {
            sb.append(st.getClassName()).append('.').append(st.getMethodName());
            sb.append('(').append(st.getFileName()).append(':').append(st.getLineNumber()).append(')');
            sb.append('\n');
        }
        String stackKey = sb.toString();
        boolean report = false;
        Object object = this.lock;
        synchronized (object) {
            pathEntry = this.files.get(path);
            if (pathEntry == null) {
                pathEntry = new StatEntry(path, stackKey);
                this.files.put(path, pathEntry);
            }
            if ((stackEntry = this.stacks.get(stackKey)) == null) {
                stackEntry = new StatEntry(path, stackKey);
                this.stacks.put(stackKey, stackEntry);
                if (REPORT_FIRST) {
                    report = true;
                }
            }
        }
        pathEntry.increment();
        stackEntry.increment();
        if (report) {
            this.report(stackEntry);
            this.out.flush();
        }
    }

    private void printf(String pattern, Object ... args) {
        String formattedString = String.format(pattern, args);
        String[] lines = formattedString.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            this.out.printf("%s%s\n", PREFIX, lines[i]);
        }
        this.out.flush();
    }

    private void report(StatEntry entry) {
        String stack = entry.getStack();
        this.printf("%6d @%d  1-st path: %s\n", entry.getCount(), stack.hashCode(), entry.getPath());
        this.printf("    %s\n", stack);
    }

    public void report() {
        StatEntry statEntry;
        int readCount = 0;
        for (StatEntry statEntry2 : this.stacks.values()) {
            readCount += statEntry2.getCount();
        }
        this.out.printf("\n\n\n", new Object[0]);
        this.printf("\nFile Read Statistics by Path [%s]\n", this.fileSystem.getDisplayName());
        this.printf("Files count: %d reads count: %d\n", this.files.size(), readCount);
        this.printf("\t   Cnt  File\n", new Object[0]);
        for (Map.Entry entry : FileStatistics.sortByCount(this.files)) {
            statEntry = (StatEntry)entry.getValue();
            this.printf("\t%6d  %s\n", statEntry.getCount(), entry.getKey());
        }
        this.out.flush();
        this.printf("\n\nFile Read Statistics by Stack [%s]\n", this.fileSystem.getDisplayName());
        this.printf("Stacks count: %d reads count: %d\n", this.stacks.size(), readCount);
        for (Map.Entry entry : FileStatistics.sortByCount(this.stacks)) {
            statEntry = (StatEntry)entry.getValue();
            assert (statEntry.getStack().equals(entry.getKey()));
            this.report(statEntry);
        }
        this.out.flush();
    }

    private static List<Map.Entry<String, StatEntry>> sortByCount(Map<String, StatEntry> map) {
        ArrayList<Map.Entry<String, StatEntry>> sorted = new ArrayList<Map.Entry<String, StatEntry>>(map.entrySet());
        Collections.sort(sorted, new Comparator<Map.Entry<String, StatEntry>>(){

            @Override
            public int compare(Map.Entry<String, StatEntry> o1, Map.Entry<String, StatEntry> o2) {
                int cnt2;
                int cnt1 = o1.getValue().getCount();
                return cnt1 == (cnt2 = o2.getValue().getCount()) ? o1.getKey().compareTo(o2.getKey()) : cnt2 - cnt1;
            }
        });
        return sorted;
    }

    static {
        String extList = System.getProperty("dlight.file.read.statistics.include.extensions");
        if (extList != null) {
            String[] splitExt = extList.split(",");
            extensionsToInclude.addAll(Arrays.asList(splitExt));
        }
        namesToExclude = new TreeSet<String>();
        String nameList = System.getProperty("dlight.file.read.statistics.exclude.names");
        if (nameList != null) {
            String[] splitNam = nameList.split(",");
            namesToExclude.addAll(Arrays.asList(splitNam));
        }
    }

    private static class StatEntry {
        private int count;
        private final String path;
        private final String stack;

        public StatEntry(String path, String stack) {
            this.path = path;
            this.stack = stack;
        }

        public synchronized int getCount() {
            return this.count;
        }

        public synchronized void increment() {
            ++this.count;
        }

        public String getPath() {
            return this.path;
        }

        public String getStack() {
            return this.stack;
        }
    }

    public static class Reporter
    implements Runnable {
        @Override
        public void run() {
            if (!extensionsToInclude.isEmpty()) {
                for (FileStatistics fileStatistics : instances.values()) {
                    fileStatistics.report();
                }
            }
        }
    }
}

