/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.internal.UploadImpl;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferStateUpdatingCallable
implements Callable<UploadResult> {
    private final Callable<UploadResult> callable;
    private final UploadImpl transfer;

    public TransferStateUpdatingCallable(Callable<UploadResult> callable, UploadImpl transfer) {
        this.callable = callable;
        this.transfer = transfer;
    }

    @Override
    public UploadResult call() throws Exception {
        this.transfer.setState(Transfer.TransferState.InProgress);
        try {
            UploadResult result = this.callable.call();
            this.transfer.setState(Transfer.TransferState.Completed);
            return result;
        }
        catch (Exception e) {
            this.transfer.setState(Transfer.TransferState.Failed);
            throw e;
        }
    }
}

