/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.annotations;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.annotations.Bundle;
import org.netbeans.modules.php.project.annotations.UserAnnotationTag;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class UserAnnotationPanel
extends JPanel
implements HelpCtx.Provider {
    private static final long serialVersionUID = -135764354564L;
    private static final String HTML_CONTENT_TYPE = "text/html";
    private final EnumMap<UserAnnotationTag.Type, JCheckBox> typeCheckBoxes;
    private DialogDescriptor descriptor = null;
    private NotificationLineSupport notificationLineSupport = null;
    private JLabel docLabel;
    private JTabbedPane docTabbedPane;
    private JCheckBox fieldCheckBox;
    private JLabel forLabel;
    private JCheckBox functionCheckBox;
    private JCheckBox methodCheckBox;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JScrollPane previewScrollPane;
    private JTextPane previewTextPane;
    private JEditorPane sourceEditorPane;
    private JScrollPane sourceScrollPane;
    private JLabel templateLabel;
    private JTextField templateTextField;
    private JCheckBox typeCheckBox;

    public UserAnnotationPanel(UserAnnotationTag annotation) {
        assert (EventQueue.isDispatchThread());
        assert (annotation != null);
        this.initComponents();
        this.typeCheckBoxes = this.createTypeCheckBoxes();
        this.initSourceEditor();
        this.init(annotation);
    }

    private void initSourceEditor() {
        this.sourceEditorPane.setEditorKit(CloneableEditorSupport.getEditorKit((String)HTML_CONTENT_TYPE));
        Font font = new JLabel().getFont();
        this.sourceEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.sourceEditorPane.setFont(font);
        this.previewTextPane.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.previewTextPane.setFont(font);
    }

    private void init(UserAnnotationTag annotation) {
        assert (EventQueue.isDispatchThread());
        this.nameTextField.setText(annotation.getName());
        this.selectTypes(annotation.getTypes());
        this.templateTextField.setText(annotation.getInsertTemplate());
        this.setDocumentation(annotation.getDocumentation());
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        DefaultItemListener defaultItemListener = new DefaultItemListener();
        this.nameTextField.getDocument().addDocumentListener(defaultDocumentListener);
        for (JCheckBox checkBox : this.typeCheckBoxes.values()) {
            checkBox.addItemListener(defaultItemListener);
        }
        this.templateTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.sourceEditorPane.getDocument().addDocumentListener(defaultDocumentListener);
        this.docTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UserAnnotationPanel.this.refreshPreview();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        boolean okPressed;
        assert (EventQueue.isDispatchThread());
        this.descriptor = new DialogDescriptor((Object)this, Bundle.UserAnnotationPanel_title(), true, 2, NotifyDescriptor.OK_OPTION, null);
        this.notificationLineSupport = this.descriptor.createNotificationLineSupport();
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        this.validateAnnotation();
        try {
            dialog.setVisible(true);
            okPressed = this.descriptor.getValue() == NotifyDescriptor.OK_OPTION;
        }
        finally {
            dialog.dispose();
        }
        return okPressed;
    }

    public UserAnnotationTag getAnnotation() {
        return new UserAnnotationTag(this.getSelectedTypes(), this.nameTextField.getText(), this.templateTextField.getText(), this.sourceEditorPane.getText());
    }

    void validateAnnotation() {
        if (!StringUtils.hasText((String)this.nameTextField.getText())) {
            this.setError(Bundle.UserAnnotationPanel_error_noName());
            return;
        }
        if (!this.anyTypeSelected()) {
            this.setError(Bundle.UserAnnotationPanel_error_noFor());
            return;
        }
        if (!StringUtils.hasText((String)this.templateTextField.getText())) {
            this.setError(Bundle.UserAnnotationPanel_error_noTemplate());
            return;
        }
        this.clearError();
    }

    void setError(String error) {
        assert (EventQueue.isDispatchThread());
        this.notificationLineSupport.setErrorMessage(error);
        this.descriptor.setValid(false);
    }

    void clearError() {
        assert (EventQueue.isDispatchThread());
        this.notificationLineSupport.clearMessages();
        this.descriptor.setValid(true);
    }

    void refreshPreview() {
        if (this.docTabbedPane.getSelectedIndex() == 1) {
            this.previewTextPane.setText(this.sourceEditorPane.getText());
            this.previewTextPane.setCaretPosition(0);
        }
    }

    private EnumMap<UserAnnotationTag.Type, JCheckBox> createTypeCheckBoxes() {
        EnumMap<UserAnnotationTag.Type, JCheckBox> map = new EnumMap<UserAnnotationTag.Type, JCheckBox>(UserAnnotationTag.Type.class);
        for (UserAnnotationTag.Type type : UserAnnotationTag.Type.values()) {
            JCheckBox checkBox;
            switch (type) {
                case FUNCTION: {
                    checkBox = this.functionCheckBox;
                    break;
                }
                case TYPE: {
                    checkBox = this.typeCheckBox;
                    break;
                }
                case METHOD: {
                    checkBox = this.methodCheckBox;
                    break;
                }
                case FIELD: {
                    checkBox = this.fieldCheckBox;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown type: " + (Object)((Object)type));
                }
            }
            map.put(type, checkBox);
        }
        return map;
    }

    private void selectTypes(EnumSet<UserAnnotationTag.Type> types) {
        assert (EventQueue.isDispatchThread());
        for (UserAnnotationTag.Type type : types) {
            this.typeCheckBoxes.get((Object)type).setSelected(true);
        }
    }

    private void setDocumentation(String documentation) {
        block2: {
            try {
                this.sourceEditorPane.getDocument().insertString(0, documentation, null);
            }
            catch (BadLocationException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)ex);
            }
        }
        this.sourceEditorPane.setCaretPosition(0);
    }

    private boolean anyTypeSelected() {
        assert (EventQueue.isDispatchThread());
        for (JCheckBox checkBox : this.typeCheckBoxes.values()) {
            if (!checkBox.isSelected()) continue;
            return true;
        }
        return false;
    }

    private EnumSet<UserAnnotationTag.Type> getSelectedTypes() {
        assert (EventQueue.isDispatchThread());
        EnumSet<UserAnnotationTag.Type> types = EnumSet.noneOf(UserAnnotationTag.Type.class);
        for (Map.Entry<UserAnnotationTag.Type, JCheckBox> entry : this.typeCheckBoxes.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            types.add(entry.getKey());
        }
        return types;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.project.annotations.UserAnnotationPanel");
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.forLabel = new JLabel();
        this.functionCheckBox = new JCheckBox();
        this.typeCheckBox = new JCheckBox();
        this.fieldCheckBox = new JCheckBox();
        this.methodCheckBox = new JCheckBox();
        this.templateLabel = new JLabel();
        this.templateTextField = new JTextField();
        this.docLabel = new JLabel();
        this.docTabbedPane = new JTabbedPane();
        this.sourceScrollPane = new JScrollPane();
        this.sourceEditorPane = new JEditorPane();
        this.previewScrollPane = new JScrollPane();
        this.previewTextPane = new JTextPane();
        this.setPreferredSize(new Dimension(400, 350));
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(UserAnnotationPanel.class, (String)"UserAnnotationPanel.nameLabel.text"));
        this.forLabel.setLabelFor(this.functionCheckBox);
        Mnemonics.setLocalizedText((JLabel)this.forLabel, (String)NbBundle.getMessage(UserAnnotationPanel.class, (String)"UserAnnotationPanel.forLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.functionCheckBox, (String)NbBundle.getMessage(UserAnnotationPanel.class, (String)"UserAnnotationPanel.functionCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.typeCheckBox, (String)NbBundle.getMessage(UserAnnotationPanel.class, (String)"UserAnnotationPanel.typeCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.fieldCheckBox, (String)NbBundle.getMessage(UserAnnotationPanel.class, (String)"UserAnnotationPanel.fieldCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.methodCheckBox, (String)NbBundle.getMessage(UserAnnotationPanel.class, (String)"UserAnnotationPanel.methodCheckBox.text"));
        this.templateLabel.setLabelFor(this.templateTextField);
        Mnemonics.setLocalizedText((JLabel)this.templateLabel, (String)NbBundle.getMessage(UserAnnotationPanel.class, (String)"UserAnnotationPanel.templateLabel.text"));
        this.docLabel.setLabelFor(this.docTabbedPane);
        Mnemonics.setLocalizedText((JLabel)this.docLabel, (String)NbBundle.getMessage(UserAnnotationPanel.class, (String)"UserAnnotationPanel.docLabel.text"));
        this.sourceScrollPane.setViewportView(this.sourceEditorPane);
        this.docTabbedPane.addTab(NbBundle.getMessage(UserAnnotationPanel.class, (String)"UserAnnotationPanel.sourceScrollPane.TabConstraints.tabTitle"), this.sourceScrollPane);
        this.previewTextPane.setContentType(HTML_CONTENT_TYPE);
        this.previewTextPane.setEditable(false);
        this.previewScrollPane.setViewportView(this.previewTextPane);
        this.docTabbedPane.addTab(NbBundle.getMessage(UserAnnotationPanel.class, (String)"UserAnnotationPanel.previewScrollPane.TabConstraints.tabTitle"), this.previewScrollPane);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.forLabel).addComponent(this.nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameTextField).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.functionCheckBox).addComponent(this.fieldCheckBox)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.methodCheckBox).addComponent(this.typeCheckBox)).addGap(0, 0, Short.MAX_VALUE)))).addComponent(this.templateTextField).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.templateLabel).addComponent(this.docLabel)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.docTabbedPane, -1, 458, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.forLabel).addComponent(this.functionCheckBox).addComponent(this.typeCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fieldCheckBox).addComponent(this.methodCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.templateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.templateTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.docLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.docTabbedPane, -1, 225, Short.MAX_VALUE)));
    }

    private final class DefaultItemListener
    implements ItemListener {
        private DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            UserAnnotationPanel.this.validateAnnotation();
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            UserAnnotationPanel.this.validateAnnotation();
        }
    }
}

