/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.spi.RemoteConfigurationPanel;
import org.netbeans.modules.php.project.connections.ui.Bundle;
import org.netbeans.modules.php.project.connections.ui.NewRemoteConnectionPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

@SuppressWarnings(value={"SE_BAD_FIELD_STORE"})
public final class RemoteConnectionsPanel
extends JPanel
implements ChangeListener,
HelpCtx.Provider {
    private static final long serialVersionUID = -6457687532146576878L;
    private static final RequestProcessor RP = new RequestProcessor(RemoteConnectionsPanel.class);
    private static final int VALIDATION_DELAY = 300;
    private final ConfigListModel configListModel = new ConfigListModel();
    private final RemoteConnections remoteConnections;
    private final ConfigManager configManager;
    private final Map<ConfigManager.Configuration, RemoteConfigurationPanel> configPanels = new HashMap<ConfigManager.Configuration, RemoteConfigurationPanel>();
    private final RequestProcessor.Task validationTask;
    private RemoteConfigurationPanel configurationPanel = new EmptyConfigurationPanel();
    private DialogDescriptor descriptor = null;
    private NotificationLineSupport notificationLineSupport = null;
    private RequestProcessor.Task testConnectionTask = null;
    private JButton addButton;
    private JList<ConfigManager.Configuration> configList;
    private JScrollPane configScrollPane;
    private JPanel configurationPanelHolder;
    private JScrollPane configurationPanelScrollPane;
    private JButton configureProxyButton;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JButton removeButton;
    private JSeparator separator;
    private JButton testConnectionButton;

    public RemoteConnectionsPanel(RemoteConnections remoteConnections, ConfigManager configManager) {
        this.remoteConnections = remoteConnections;
        this.configManager = configManager;
        this.validationTask = RP.create(new Runnable(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RemoteConnectionsPanel.this.validateActiveConfig();
                    }
                });
            }
        });
        this.initComponents();
        this.configList.setModel(this.configListModel);
        this.configList.setCellRenderer(new ConfigListRenderer(remoteConnections));
        this.setEnabledRemoveButton();
        this.registerListeners();
    }

    public void setConfigurations(List<ConfigManager.Configuration> configurations) {
        this.configListModel.setElements(configurations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(final RemoteConfiguration remoteConfiguration) {
        this.testConnectionTask = RP.create(new Runnable(){

            @Override
            public void run() {
                RemoteConnectionsPanel.this.testConnection();
            }
        }, true);
        this.descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_ManageRemoteConnections"), true, 2, NotifyDescriptor.OK_OPTION, null);
        this.notificationLineSupport = this.descriptor.createNotificationLineSupport();
        this.testConnectionTask.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                RemoteConnectionsPanel.this.enableTestConnection();
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (RemoteConnectionsPanel.this.getConfigurations().isEmpty()) {
                        RemoteConnectionsPanel.this.addConfig();
                    } else if (remoteConfiguration != null) {
                        RemoteConnectionsPanel.this.selectConfiguration(remoteConfiguration.getName());
                    } else {
                        RemoteConnectionsPanel.this.selectConfiguration(0);
                    }
                }
            });
            dialog.setVisible(true);
        }
        finally {
            dialog.dispose();
        }
        return this.descriptor.getValue() == NotifyDescriptor.OK_OPTION;
    }

    private void registerListeners() {
        this.configList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RemoteConnectionsPanel.this.setEnabledRemoveButton();
                RemoteConnectionsPanel.this.selectCurrentConfig();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteConnectionsPanel.this.addConfig();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteConnectionsPanel.this.removeConfig();
            }
        });
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processChange();
            }

            private void processChange() {
                RemoteConnectionsPanel.this.displayNameChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testConnection() {
        this.testConnectionButton.setEnabled(false);
        ConfigManager.Configuration selectedConfiguration = this.getSelectedConfiguration();
        assert (selectedConfiguration != null);
        RemoteConfiguration remoteConfiguration = this.remoteConnections.getRemoteConfiguration(selectedConfiguration);
        assert (remoteConfiguration != null) : "Cannot find remote configuration for config manager configuration " + selectedConfiguration.getName();
        String configName = selectedConfiguration.getDisplayName();
        String progressTitle = NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"MSG_TestingConnection", (Object)configName);
        ProgressHandle progressHandle = ProgressHandle.createHandle((String)progressTitle);
        RemoteClient client = new RemoteClient(remoteConfiguration);
        RemoteException exception = null;
        try {
            progressHandle.start();
            client.connect();
        }
        catch (RemoteException ex) {
            exception = ex;
        }
        finally {
            try {
                client.disconnect(true);
            }
            catch (RemoteException ex) {}
            progressHandle.finish();
        }
        String msg = null;
        int msgType = 0;
        if (exception != null) {
            msg = exception.getRemoteServerAnswer() != null ? NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"MSG_TestConnectionFailedServerAnswer", (Object)exception.getMessage(), (Object)exception.getRemoteServerAnswer()) : (exception.getCause() != null ? NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"MSG_TestConnectionFailedCause", (Object)exception.getMessage(), (Object)exception.getCause().getMessage()) : exception.getMessage());
            msgType = 0;
        } else {
            msg = NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"MSG_TestConnectionSucceeded");
            msgType = 1;
        }
        DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)msg, configName, 2, msgType, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION));
    }

    void enableTestConnection() {
        assert (this.testConnectionTask != null);
        ConfigManager.Configuration cfg = this.getSelectedConfiguration();
        this.testConnectionButton.setEnabled(this.testConnectionTask.isFinished() && cfg != null && cfg.isValid());
    }

    private void addConfiguration(ConfigManager.Configuration configuration) {
        this.addConfiguration(configuration, true);
    }

    private void addConfiguration(ConfigManager.Configuration configuration, boolean select) {
        assert (this.configListModel.indexOf(configuration) == -1) : "Configuration already in the list: " + configuration;
        this.configListModel.addElement(configuration);
        if (select) {
            this.descriptor.setValid(false);
            this.configList.setSelectedValue(configuration, true);
        }
    }

    private void selectConfiguration(int index) {
        this.configList.setSelectedIndex(index);
    }

    private void selectConfiguration(String configName) {
        this.configList.setSelectedValue(this.configListModel.getElement(configName), true);
    }

    private void readActiveConfig(ConfigManager.Configuration cfg) {
        assert (EventQueue.isDispatchThread());
        this.configurationPanel.read(cfg);
    }

    private void storeActiveConfig(ConfigManager.Configuration cfg) {
        assert (EventQueue.isDispatchThread());
        cfg.setDisplayName(this.nameTextField.getText());
        this.configurationPanel.store(cfg);
    }

    private void switchConfigurationPanel() {
        assert (EventQueue.isDispatchThread());
        this.configurationPanel.removeChangeListener(this);
        String name = null;
        ConfigManager.Configuration configuration = this.configList.getSelectedValue();
        if (configuration != null) {
            name = configuration.getDisplayName();
            this.configurationPanel = this.getConfigurationPanel(configuration);
            assert (this.configurationPanel != null) : "Panel must be provided for configuration " + configuration.getName();
            this.readActiveConfig(configuration);
            this.configManager.markAsCurrentConfiguration(configuration.getName());
        } else {
            this.configurationPanel = new EmptyConfigurationPanel();
        }
        this.configurationPanel.addChangeListener(this);
        this.resetFields();
        if (configuration != null) {
            assert (name != null) : "Name must be found for config " + configuration.getDisplayName();
            this.setConfigurationName(name);
        }
        JComponent innerPanel = this.configurationPanel.getComponent();
        this.configurationPanelHolder.setPreferredSize(((Component)innerPanel).getPreferredSize());
        this.configurationPanelHolder.add((Component)innerPanel, "Center");
        this.configurationPanelHolder.revalidate();
        this.configurationPanelHolder.repaint();
    }

    private void setConfigurationName(String name) {
        this.nameTextField.setText(name);
        this.nameTextField.setEditable(name != null);
    }

    private RemoteConfigurationPanel getConfigurationPanel(ConfigManager.Configuration configuration) {
        RemoteConfigurationPanel panel = this.configPanels.get(configuration);
        if (panel == null) {
            panel = this.remoteConnections.getConfigurationPanel(configuration);
            this.configPanels.put(configuration, panel);
        }
        return panel;
    }

    private ConfigManager.Configuration getSelectedConfiguration() {
        return this.configList.getSelectedValue();
    }

    private List<ConfigManager.Configuration> getConfigurations() {
        return this.configListModel.getElements();
    }

    private void removeConfiguration(ConfigManager.Configuration configuration) {
        assert (this.configListModel.indexOf(configuration) != -1) : "Configuration not in the list: " + configuration;
        int toSelect = -1;
        int idx = this.configListModel.indexOf(configuration);
        if (idx + 1 < this.configListModel.getSize()) {
            toSelect = idx;
        } else if (this.configListModel.getSize() > 1) {
            toSelect = idx - 1;
        }
        this.configListModel.removeElement(configuration);
        if (toSelect != -1) {
            this.configList.setSelectedIndex(toSelect);
        }
    }

    private void resetFields() {
        this.setConfigurationName(null);
        this.configurationPanelHolder.removeAll();
        this.configurationPanelHolder.revalidate();
        this.configurationPanelHolder.repaint();
        this.setError(null);
        this.setWarning(null);
    }

    private String getError() {
        assert (EventQueue.isDispatchThread());
        return this.configurationPanel.getError();
    }

    private String getWarning() {
        assert (EventQueue.isDispatchThread());
        return this.configurationPanel.getWarning();
    }

    private void setError(String msg) {
        assert (this.descriptor != null);
        assert (this.notificationLineSupport != null);
        if (StringUtils.hasText((String)msg)) {
            this.notificationLineSupport.setErrorMessage(msg);
            this.descriptor.setValid(false);
        } else {
            this.notificationLineSupport.clearMessages();
            this.descriptor.setValid(true);
        }
        this.enableTestConnection();
    }

    private void setWarning(String msg) {
        assert (this.descriptor != null);
        assert (this.notificationLineSupport != null);
        if (StringUtils.hasText((String)msg)) {
            this.notificationLineSupport.setWarningMessage(msg);
        }
    }

    private void refreshConfigList() {
        this.configList.repaint();
    }

    void setEnabledRemoveButton() {
        this.setEnabledRemoveButton(this.configList.getSelectedIndex() != -1);
    }

    private void setEnabledRemoveButton(boolean enabled) {
        this.removeButton.setEnabled(enabled);
    }

    void validateActiveConfig() {
        assert (EventQueue.isDispatchThread());
        boolean valid = this.configurationPanel.isValidConfiguration();
        String error = this.getError();
        ConfigManager.Configuration cfg = this.getSelectedConfiguration();
        cfg.setErrorMessage(error);
        this.setError(error);
        if (!valid) {
            return;
        }
        String warning = this.getWarning();
        if (warning != null) {
            this.setWarning(warning);
        } else if (!StringUtils.hasText((String)this.nameTextField.getText())) {
            this.setWarning(Bundle.RemoteConnectionsPanel_warning_name_empty());
        }
        this.checkAllConfigs();
    }

    private void checkAllConfigs() {
        for (ConfigManager.Configuration cfg : this.getConfigurations()) {
            assert (cfg != null);
            if (cfg.isValid()) continue;
            this.setError(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"MSG_InvalidConfiguration", (Object)cfg.getDisplayName()));
            assert (this.descriptor != null);
            this.descriptor.setValid(false);
            return;
        }
    }

    void addConfig() {
        NewRemoteConnectionPanel panel = new NewRemoteConnectionPanel(this.configManager);
        if (panel.open()) {
            String config = panel.getConfigName();
            String name = panel.getConnectionName();
            String type = panel.getConnectionType();
            assert (config != null);
            assert (name != null);
            assert (type != null);
            ConfigManager.Configuration cfg = this.configManager.createNew(config, name);
            RemoteConfiguration remoteConfiguration = this.remoteConnections.createRemoteConfiguration(type, cfg);
            assert (remoteConfiguration != null) : "No remote configuration created for type: " + type;
            this.addConfiguration(cfg);
            this.configManager.markAsCurrentConfiguration(config);
        }
    }

    void removeConfig() {
        ConfigManager.Configuration cfg = this.getSelectedConfiguration();
        assert (cfg != null);
        this.configManager.configurationFor(cfg.getName()).delete();
        this.removeConfiguration(cfg);
    }

    void selectCurrentConfig() {
        ConfigManager.Configuration cfg = this.getSelectedConfiguration();
        if (cfg != null) {
            this.switchConfigurationPanel();
            this.validationTask.schedule(300);
        } else {
            this.resetFields();
            this.checkAllConfigs();
        }
    }

    private void initComponents() {
        this.configScrollPane = new JScrollPane();
        this.configList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.separator = new JSeparator();
        this.configurationPanelScrollPane = new JScrollPane();
        this.configurationPanelHolder = new JPanel();
        this.testConnectionButton = new JButton();
        this.configureProxyButton = new JButton();
        this.configList.setSelectionMode(0);
        this.configScrollPane.setViewportView(this.configList);
        this.configList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.configList.AccessibleContext.accessibleName"));
        this.configList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.configList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_Remove"));
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_Name"));
        this.nameTextField.setEditable(false);
        this.nameTextField.setColumns(30);
        this.configurationPanelScrollPane.setBorder(null);
        this.configurationPanelHolder.setLayout(new BorderLayout());
        this.configurationPanelScrollPane.setViewportView(this.configurationPanelHolder);
        this.configurationPanelHolder.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.detailsPanel.AccessibleContext.accessibleName"));
        this.configurationPanelHolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.detailsPanel.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.testConnectionButton, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"LBL_TestConnection"));
        this.testConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoteConnectionsPanel.this.testConnectionButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.configureProxyButton, (String)NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.configureProxyButton.text"));
        this.configureProxyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoteConnectionsPanel.this.configureProxyButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton)).addComponent(this.configScrollPane, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.separator, -1, 506, Short.MAX_VALUE).addComponent(this.configurationPanelScrollPane, -1, 506, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.testConnectionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configureProxyButton).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.nameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameTextField))).addContainerGap()));
        layout.linkSize(0, this.addButton, this.removeButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.configScrollPane, -1, 362, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configurationPanelScrollPane, -1, 330, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addButton).addComponent(this.removeButton).addComponent(this.testConnectionButton).addComponent(this.configureProxyButton)).addContainerGap()));
        this.configScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.configScrollPane.AccessibleContext.accessibleName"));
        this.configScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.configScrollPane.AccessibleContext.accessibleDescription"));
        this.addButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.addButton.AccessibleContext.accessibleName"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.addButton.AccessibleContext.accessibleDescription"));
        this.removeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.removeButton.AccessibleContext.accessibleName"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.removeButton.AccessibleContext.accessibleDescription"));
        this.nameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.nameLabel.AccessibleContext.accessibleName"));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.nameLabel.AccessibleContext.accessibleDescription"));
        this.nameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.nameTextField.AccessibleContext.accessibleName"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.nameTextField.AccessibleContext.accessibleDescription"));
        this.separator.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.separator.AccessibleContext.accessibleName"));
        this.separator.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.separator.AccessibleContext.accessibleDescription"));
        this.configurationPanelScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.configurationPanelScrollPane.AccessibleContext.accessibleName"));
        this.configurationPanelScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.configurationPanelScrollPane.AccessibleContext.accessibleDescription"));
        this.testConnectionButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.testConnectionButton.AccessibleContext.accessibleName"));
        this.testConnectionButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.testConnectionButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConnectionsPanel.class, (String)"RemoteConnectionsPanel.AccessibleContext.accessibleDescription"));
    }

    private void testConnectionButtonActionPerformed(ActionEvent evt) {
        this.testConnectionTask.schedule(0);
    }

    private void configureProxyButtonActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("General");
    }

    void displayNameChanged() {
        this.stateChanged(null);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        ConfigManager.Configuration cfg = this.getSelectedConfiguration();
        if (cfg != null) {
            this.validationTask.schedule(300);
            this.storeActiveConfig(cfg);
        }
        this.refreshConfigList();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.project.connections.ui.RemoteConnectionsPanel");
    }

    private static final class EmptyConfigurationPanel
    implements RemoteConfigurationPanel {
        private static final JPanel PANEL = new JPanel();

        private EmptyConfigurationPanel() {
        }

        @Override
        public void addChangeListener(ChangeListener listener) {
        }

        @Override
        public void removeChangeListener(ChangeListener listener) {
        }

        @Override
        public JComponent getComponent() {
            return PANEL;
        }

        @Override
        public boolean isValidConfiguration() {
            return true;
        }

        @Override
        public String getError() {
            return null;
        }

        @Override
        public String getWarning() {
            return null;
        }

        @Override
        public void read(ConfigManager.Configuration configuration) {
        }

        @Override
        public void store(ConfigManager.Configuration configuration) {
        }
    }

    public static final class ConfigListModel
    extends AbstractListModel<ConfigManager.Configuration> {
        private static final long serialVersionUID = -546879865427974L;
        private final List<ConfigManager.Configuration> data = new ArrayList<ConfigManager.Configuration>();

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public ConfigManager.Configuration getElementAt(int index) {
            return this.data.get(index);
        }

        public boolean addElement(ConfigManager.Configuration configuration) {
            assert (configuration != null);
            if (!this.data.add(configuration)) {
                return false;
            }
            Collections.sort(this.data, ConfigManager.getConfigurationComparator());
            int idx = this.indexOf(configuration);
            this.fireIntervalAdded(this, idx, idx);
            return true;
        }

        public int indexOf(ConfigManager.Configuration configuration) {
            return this.data.indexOf(configuration);
        }

        public boolean removeElement(ConfigManager.Configuration configuration) {
            int idx = this.indexOf(configuration);
            if (idx == -1) {
                return false;
            }
            boolean result = this.data.remove(configuration);
            assert (result);
            this.fireIntervalRemoved(this, idx, idx);
            return true;
        }

        public List<ConfigManager.Configuration> getElements() {
            return Collections.unmodifiableList(this.data);
        }

        public void setElements(List<ConfigManager.Configuration> configurations) {
            int size = this.data.size();
            this.data.clear();
            if (size > 0) {
                this.fireIntervalRemoved(this, 0, size - 1);
            }
            if (configurations.size() > 0) {
                this.data.addAll(configurations);
                Collections.sort(this.data, ConfigManager.getConfigurationComparator());
                this.fireIntervalAdded(this, 0, this.data.size() - 1);
            }
        }

        public ConfigManager.Configuration getElement(String configName) {
            assert (configName != null);
            for (ConfigManager.Configuration configuration : this.data) {
                if (!configName.equals(configuration.getName())) continue;
                return configuration;
            }
            return null;
        }
    }

    public static class ConfigListRenderer
    extends JLabel
    implements ListCellRenderer<ConfigManager.Configuration>,
    UIResource {
        private static final long serialVersionUID = 468768321568787L;
        private final RemoteConnections remoteConnections;

        private ConfigListRenderer(RemoteConnections remoteConnections) {
            assert (remoteConnections != null);
            this.remoteConnections = remoteConnections;
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ConfigManager.Configuration> list, ConfigManager.Configuration value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            Color errorColor = UIManager.getColor("nb.errorForeground");
            boolean cfgValid = true;
            if (value != null) {
                ConfigManager.Configuration cfg = value;
                cfgValid = cfg.isValid();
                this.setText(Bundle.ConfigListRenderer_item_label(cfg.getDisplayName(), this.remoteConnections.getConfigurationType(cfg)));
            }
            this.setIcon(null);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(cfgValid ? list.getSelectionForeground() : errorColor);
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(cfgValid ? list.getForeground() : errorColor);
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }
}

