/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.common.RemoteValidator;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.LocalPathCell;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public class RunAsWebAdvanced
extends JPanel
implements HelpCtx.Provider {
    private static final long serialVersionUID = 7842376554376847L;
    static final String DEFAULT_LOCAL_PATH = "";
    static final int COLUMN_REMOTE_PATH = 0;
    static final int COLUMN_LOCAL_PATH = 1;
    final PhpProject project;
    private final PathMappingTableModel pathMappingTableModel;
    private DialogDescriptor descriptor = null;
    private NotificationLineSupport notificationLineSupport;
    private JRadioButton askUrlRadioButton;
    private ButtonGroup debugUrlButtonGroup;
    private JLabel debugUrlLabel;
    private JLabel defaultUrlPreviewLabel;
    private JRadioButton defaultUrlRadioButton;
    private JRadioButton doNotOpenBrowserRadioButton;
    private JButton newPathMappingButton;
    private JLabel pathMappingInfoLabel;
    private JLabel pathMappingLabel;
    private JScrollPane pathMappingScrollPane;
    private JTable pathMappingTable;
    private JLabel proxyHostLabel;
    private JTextField proxyHostTextField;
    private JLabel proxyLabel;
    private JLabel proxyPortLabel;
    private JTextField proxyPortTextField;
    private JButton removePathMappingButton;

    RunAsWebAdvanced(PhpProject project, Properties properties) {
        assert (project != null);
        assert (properties != null);
        this.project = project;
        this.initComponents();
        this.setDebugUrl(properties);
        this.setDebugProxy(properties);
        String[] columnNames = new String[]{NbBundle.getMessage(RunAsWebAdvanced.class, (String)"LBL_ServerPath"), NbBundle.getMessage(RunAsWebAdvanced.class, (String)"LBL_LocalPath")};
        this.pathMappingTableModel = new PathMappingTableModel(columnNames, this.getPathMappings(properties.remotePaths, properties.localPaths));
        this.pathMappingTable.setModel(this.pathMappingTableModel);
        this.pathMappingTable.setDefaultRenderer(LocalPathCell.class, new LocalPathCellRenderer());
        this.pathMappingTable.addMouseListener(new LocalPathCellMouseListener(this.pathMappingTable));
        ActionListener debugUrlListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunAsWebAdvanced.this.validateFields();
            }
        };
        this.defaultUrlRadioButton.addActionListener(debugUrlListener);
        this.askUrlRadioButton.addActionListener(debugUrlListener);
        this.doNotOpenBrowserRadioButton.addActionListener(debugUrlListener);
        this.pathMappingTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                RunAsWebAdvanced.this.handleButtonStates();
                RunAsWebAdvanced.this.validateFields();
            }
        });
        this.pathMappingTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RunAsWebAdvanced.this.handleButtonStates();
            }
        });
        DocumentListener defaultDocumentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            private void processUpdate() {
                RunAsWebAdvanced.this.validateFields();
            }
        };
        this.proxyHostTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.proxyPortTextField.getDocument().addDocumentListener(defaultDocumentListener);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.project.ui.customizer.RunAsWebAdvanced");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        this.descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(RunAsWebAdvanced.class, (String)"LBL_AdvancedWebConfiguration"), true, null);
        this.notificationLineSupport = this.descriptor.createNotificationLineSupport();
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        try {
            this.validateFields();
            dialog.setVisible(true);
        }
        finally {
            dialog.dispose();
        }
        return this.descriptor.getValue() == NotifyDescriptor.OK_OPTION;
    }

    public PhpProjectProperties.DebugUrl getDebugUrl() {
        PhpProjectProperties.DebugUrl debugUrl = null;
        if (this.defaultUrlRadioButton.isSelected()) {
            debugUrl = PhpProjectProperties.DebugUrl.DEFAULT_URL;
        } else if (this.askUrlRadioButton.isSelected()) {
            debugUrl = PhpProjectProperties.DebugUrl.ASK_FOR_URL;
        } else if (this.doNotOpenBrowserRadioButton.isSelected()) {
            debugUrl = PhpProjectProperties.DebugUrl.DO_NOT_OPEN_BROWSER;
        }
        assert (debugUrl != null);
        return debugUrl;
    }

    public Pair<String, String> getPathMapping() {
        FileObject sources = ProjectPropertiesSupport.getSourcesDirectory(this.project);
        int rowCount = this.pathMappingTableModel.getRowCount();
        ArrayList<String> remotes = new ArrayList<String>(rowCount);
        ArrayList<String> locals = new ArrayList<String>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            String remotePath = (String)this.pathMappingTableModel.getValueAt(i, 0);
            if (!StringUtils.hasText((String)remotePath)) continue;
            String localPath = null;
            localPath = ((LocalPathCell)this.pathMappingTableModel.getValueAt(i, 1)).getPath();
            File local = new File(localPath);
            assert (local.isDirectory()) : localPath + " must be a directory!";
            FileObject localFileObject = FileUtil.toFileObject((File)local);
            String relativePath = FileUtil.getRelativePath((FileObject)sources, (FileObject)localFileObject);
            if (relativePath != null) {
                localPath = relativePath;
            }
            remotes.add(remotePath);
            locals.add(localPath);
        }
        return Pair.of((Object)StringUtils.implode(remotes, (String)"||NB||"), (Object)StringUtils.implode(locals, (String)"||NB||"));
    }

    public Pair<String, String> getDebugProxy() {
        String proxyHost = this.proxyHostTextField.getText();
        String proxyPort = null;
        if (StringUtils.hasText((String)proxyHost)) {
            proxyPort = this.proxyPortTextField.getText();
        }
        return Pair.of((Object)proxyHost, proxyPort);
    }

    void validateFields() {
        String err;
        assert (this.notificationLineSupport != null);
        for (int i = 0; i < this.pathMappingTableModel.getRowCount(); ++i) {
            String remotePath = (String)this.pathMappingTableModel.getValueAt(i, 0);
            String localPath = ((LocalPathCell)this.pathMappingTableModel.getValueAt(i, 1)).getPath();
            if (!StringUtils.hasText((String)remotePath) && !StringUtils.hasText((String)localPath)) continue;
            if (!StringUtils.hasText((String)remotePath) && StringUtils.hasText((String)localPath)) {
                this.notificationLineSupport.setErrorMessage(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"MSG_RemotePathEmpty"));
                this.descriptor.setValid(false);
                return;
            }
            if (StringUtils.hasText((String)remotePath) && !StringUtils.hasText((String)localPath)) {
                this.notificationLineSupport.setErrorMessage(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"MSG_LocalPathEmpty"));
                this.descriptor.setValid(false);
                return;
            }
            if (this.isLocalPathValid(localPath)) continue;
            this.notificationLineSupport.setErrorMessage(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"MSG_LocalPathNotValid", (Object)localPath));
            this.descriptor.setValid(false);
            return;
        }
        String proxyHost = this.proxyHostTextField.getText();
        if (StringUtils.hasText((String)proxyHost) && (err = RemoteValidator.validatePort(this.proxyPortTextField.getText())) != null) {
            this.notificationLineSupport.setErrorMessage(err);
            this.descriptor.setValid(false);
            return;
        }
        String warning = null;
        if ((this.doNotOpenBrowserRadioButton.isSelected() || this.askUrlRadioButton.isSelected()) && !this.isAnyRemotePathDefined()) {
            warning = NbBundle.getMessage(RunAsWebAdvanced.class, (String)"MSG_WarningNoPathMapping");
        }
        if (warning != null) {
            this.notificationLineSupport.setWarningMessage(warning);
        } else {
            this.notificationLineSupport.clearMessages();
        }
        this.descriptor.setValid(true);
    }

    private boolean isAnyRemotePathDefined() {
        for (int i = 0; i < this.pathMappingTableModel.getRowCount(); ++i) {
            String remotePath = (String)this.pathMappingTableModel.getValueAt(i, 0);
            if (!StringUtils.hasText((String)remotePath)) continue;
            return true;
        }
        return false;
    }

    void handleButtonStates() {
        this.removePathMappingButton.setEnabled(this.isTableRowSelected());
        this.newPathMappingButton.setEnabled(this.pathMappingTableModel.isLastServerPathFilled());
    }

    private Object[][] getPathMappings(String remotePaths, String localPaths) {
        List remotes = StringUtils.explode((String)remotePaths, (String)"||NB||");
        List locals = StringUtils.explode((String)localPaths, (String)"||NB||");
        int remotesSize = remotes.size();
        int localsSize = locals.size();
        Object[][] paths = new Object[remotesSize + 1][2];
        for (int i = 0; i < remotesSize; ++i) {
            String local = DEFAULT_LOCAL_PATH;
            if (i < localsSize) {
                local = (String)locals.get(i);
            }
            Pair<String, String> pathMapping = this.getPathMapping((String)remotes.get(i), local);
            paths[i][0] = pathMapping.first();
            paths[i][1] = new LocalPathCell((String)pathMapping.second());
        }
        paths[remotesSize][0] = null;
        paths[remotesSize][1] = new LocalPathCell(DEFAULT_LOCAL_PATH);
        return paths;
    }

    private Pair<String, String> getPathMapping(String remotePath, String localPath) {
        if (StringUtils.hasText((String)remotePath)) {
            FileObject sources = ProjectPropertiesSupport.getSourcesDirectory(this.project);
            if (RunAsWebAdvanced.isSources(localPath)) {
                localPath = FileUtil.toFile((FileObject)sources).getAbsolutePath();
            } else {
                FileObject resolved = sources.getFileObject(localPath);
                if (resolved != null) {
                    localPath = FileUtil.toFile((FileObject)resolved).getAbsolutePath();
                }
            }
        } else {
            localPath = DEFAULT_LOCAL_PATH;
        }
        return Pair.of((Object)remotePath, (Object)localPath);
    }

    private int getTableSelectedRow() {
        return this.pathMappingTable.getSelectedRow();
    }

    private boolean isTableRowSelected() {
        return this.getTableSelectedRow() != -1;
    }

    private void setDebugUrl(Properties properties) {
        String debugUrl = properties.debugUrl;
        if (debugUrl == null) {
            debugUrl = PhpProjectProperties.DebugUrl.DEFAULT_URL.name();
        }
        switch (PhpProjectProperties.DebugUrl.valueOf(debugUrl)) {
            case DEFAULT_URL: {
                this.defaultUrlRadioButton.setSelected(true);
                break;
            }
            case ASK_FOR_URL: {
                this.askUrlRadioButton.setSelected(true);
                break;
            }
            case DO_NOT_OPEN_BROWSER: {
                this.doNotOpenBrowserRadioButton.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown debug url type: " + debugUrl);
            }
        }
        this.defaultUrlPreviewLabel.setText(properties.urlPreview);
    }

    private void setDebugProxy(Properties properties) {
        this.proxyHostTextField.setText(properties.proxyHost);
        String port = properties.proxyPort;
        if (RemoteValidator.validatePort(port) != null) {
            port = String.valueOf(9001);
        }
        this.proxyPortTextField.setText(port);
    }

    private void initComponents() {
        this.debugUrlButtonGroup = new ButtonGroup();
        this.debugUrlLabel = new JLabel();
        this.defaultUrlRadioButton = new JRadioButton();
        this.defaultUrlPreviewLabel = new JLabel();
        this.askUrlRadioButton = new JRadioButton();
        this.doNotOpenBrowserRadioButton = new JRadioButton();
        this.pathMappingLabel = new JLabel();
        this.pathMappingScrollPane = new JScrollPane();
        this.pathMappingTable = new JTable();
        this.newPathMappingButton = new JButton();
        this.removePathMappingButton = new JButton();
        this.pathMappingInfoLabel = new JLabel();
        this.proxyLabel = new JLabel();
        this.proxyHostLabel = new JLabel();
        this.proxyHostTextField = new JTextField();
        this.proxyPortLabel = new JLabel();
        this.proxyPortTextField = new JTextField();
        this.debugUrlLabel.setLabelFor(this.defaultUrlRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.debugUrlLabel, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.debugUrlLabel.text"));
        this.debugUrlButtonGroup.add(this.defaultUrlRadioButton);
        this.defaultUrlRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.defaultUrlRadioButton, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.defaultUrlRadioButton.text"));
        this.defaultUrlPreviewLabel.setLabelFor(this.defaultUrlRadioButton);
        Mnemonics.setLocalizedText((JLabel)this.defaultUrlPreviewLabel, (String)"dummy");
        this.debugUrlButtonGroup.add(this.askUrlRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.askUrlRadioButton, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.askUrlRadioButton.text"));
        this.debugUrlButtonGroup.add(this.doNotOpenBrowserRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.doNotOpenBrowserRadioButton, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.doNotOpenBrowserRadioButton.text"));
        this.pathMappingLabel.setLabelFor(this.pathMappingTable);
        Mnemonics.setLocalizedText((JLabel)this.pathMappingLabel, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.pathMappingLabel.text"));
        this.pathMappingTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.pathMappingScrollPane.setViewportView(this.pathMappingTable);
        this.pathMappingTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.pathMappingTable.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.newPathMappingButton, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.newPathMappingButton.text"));
        this.newPathMappingButton.setEnabled(false);
        this.newPathMappingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAsWebAdvanced.this.newPathMappingButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removePathMappingButton, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.removePathMappingButton.text"));
        this.removePathMappingButton.setEnabled(false);
        this.removePathMappingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAsWebAdvanced.this.removePathMappingButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.pathMappingInfoLabel, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.pathMappingInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.proxyLabel, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyLabel.text"));
        this.proxyHostLabel.setLabelFor(this.proxyHostTextField);
        Mnemonics.setLocalizedText((JLabel)this.proxyHostLabel, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyHostLabel.text"));
        this.proxyPortLabel.setLabelFor(this.proxyPortTextField);
        Mnemonics.setLocalizedText((JLabel)this.proxyPortLabel, (String)NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyPortLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.pathMappingScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.removePathMappingButton).addComponent(this.newPathMappingButton))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.debugUrlLabel).addGroup(layout.createSequentialGroup().addComponent(this.defaultUrlRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.defaultUrlPreviewLabel)).addComponent(this.askUrlRadioButton).addComponent(this.doNotOpenBrowserRadioButton).addComponent(this.pathMappingLabel).addComponent(this.pathMappingInfoLabel).addComponent(this.proxyLabel).addGroup(layout.createSequentialGroup().addComponent(this.proxyHostLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.proxyHostTextField, -2, 207, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.proxyPortLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.proxyPortTextField, -2, 40, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.newPathMappingButton, this.removePathMappingButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.debugUrlLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.defaultUrlRadioButton).addComponent(this.defaultUrlPreviewLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.askUrlRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.doNotOpenBrowserRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pathMappingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.newPathMappingButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removePathMappingButton)).addComponent(this.pathMappingScrollPane, -1, 127, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pathMappingInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.proxyLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proxyHostTextField, -2, -1, -2).addComponent(this.proxyHostLabel).addComponent(this.proxyPortLabel).addComponent(this.proxyPortTextField, -2, -1, -2)).addContainerGap()));
        this.debugUrlLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.debugUrlLabel.AccessibleContext.accessibleName"));
        this.debugUrlLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.debugUrlLabel.AccessibleContext.accessibleDescription"));
        this.defaultUrlRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.defaultUrlRadioButton.AccessibleContext.accessibleName"));
        this.defaultUrlRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.defaultUrlRadioButton.AccessibleContext.accessibleDescription"));
        this.defaultUrlPreviewLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.defaultUrlPreviewLabel.AccessibleContext.accessibleName"));
        this.defaultUrlPreviewLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.defaultUrlPreviewLabel.AccessibleContext.accessibleDescription"));
        this.askUrlRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.askUrlRadioButton.AccessibleContext.accessibleName"));
        this.askUrlRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.askUrlRadioButton.AccessibleContext.accessibleDescription"));
        this.doNotOpenBrowserRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.doNotOpenBrowserRadioButton.AccessibleContext.accessibleName"));
        this.doNotOpenBrowserRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.doNotOpenBrowserRadioButton.AccessibleContext.accessibleDescription"));
        this.pathMappingLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.pathMappingLabel.AccessibleContext.accessibleName"));
        this.pathMappingLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.pathMappingLabel.AccessibleContext.accessibleDescription"));
        this.pathMappingScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.pathMappingScrollPane.AccessibleContext.accessibleName"));
        this.pathMappingScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.pathMappingScrollPane.AccessibleContext.accessibleDescription"));
        this.newPathMappingButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.newPathMappingButton.AccessibleContext.accessibleName"));
        this.newPathMappingButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.newPathMappingButton.AccessibleContext.accessibleDescription"));
        this.removePathMappingButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.removePathMappingButton.AccessibleContext.accessibleName"));
        this.removePathMappingButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.removePathMappingButton.AccessibleContext.accessibleDescription"));
        this.pathMappingInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.pathMappingInfoLabel.AccessibleContext.accessibleName"));
        this.pathMappingInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.pathMappingInfoLabel.AccessibleContext.accessibleDescription"));
        this.proxyLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyLabel.AccessibleContext.accessibleName"));
        this.proxyLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyLabel.AccessibleContext.accessibleDescription"));
        this.proxyHostLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyHostLabel.AccessibleContext.accessibleName"));
        this.proxyHostLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyHostLabel.AccessibleContext.accessibleDescription"));
        this.proxyHostTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyHostTextField.AccessibleContext.accessibleName"));
        this.proxyHostTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyHostTextField.AccessibleContext.accessibleDescription"));
        this.proxyPortLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyPortLabel.AccessibleContext.accessibleName"));
        this.proxyPortLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyPortLabel.AccessibleContext.accessibleDescription"));
        this.proxyPortTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.proxyPortTextField.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsWebAdvanced.class, (String)"RunAsWebAdvanced.AccessibleContext.accessibleDescription"));
    }

    private void newPathMappingButtonActionPerformed(ActionEvent evt) {
        this.pathMappingTableModel.addRow(new Object[]{null, new LocalPathCell(DEFAULT_LOCAL_PATH)});
    }

    private void removePathMappingButtonActionPerformed(ActionEvent evt) {
        assert (this.getTableSelectedRow() != -1) : "A table row must be selected";
        while (this.getTableSelectedRow() != -1) {
            this.pathMappingTableModel.removeRow(this.getTableSelectedRow());
        }
        if (this.pathMappingTableModel.getRowCount() == 0) {
            this.newPathMappingButtonActionPerformed(null);
        }
    }

    static boolean isSources(String path) {
        return path == null || DEFAULT_LOCAL_PATH.equals(path);
    }

    private boolean isLocalPathValid(String localPath) {
        assert (StringUtils.hasText((String)localPath));
        File directory = new File(localPath);
        return directory.isDirectory() && directory.isAbsolute();
    }

    public static final class Properties {
        public final String debugUrl;
        public final String urlPreview;
        public final String remotePaths;
        public final String localPaths;
        public final String proxyHost;
        public final String proxyPort;

        public Properties(String debugUrl, String urlPreview, String remotePaths, String localPaths, String proxyHost, String proxyPort) {
            this.debugUrl = debugUrl;
            this.urlPreview = urlPreview;
            this.remotePaths = remotePaths;
            this.localPaths = localPaths;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
        }
    }

    private final class LocalPathCellMouseListener
    extends MouseAdapter {
        private final JTable table;

        public LocalPathCellMouseListener(JTable table) {
            this.table = table;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int col;
            Point p = new Point(e.getX(), e.getY());
            int row = this.table.rowAtPoint(p);
            Object value = this.table.getValueAt(row, col = this.table.columnAtPoint(p));
            if (value instanceof LocalPathCell) {
                Rectangle cellRect = this.table.getCellRect(row, col, false);
                LocalPathCell localPathCell = (LocalPathCell)value;
                JButton button = localPathCell.getButton();
                if (e.getX() > cellRect.x + cellRect.width - button.getWidth()) {
                    File newLocation = Utils.browseLocationAction("nb.php.debugger.pathMapping", NbBundle.getMessage(RunAsWebAdvanced.class, (String)"LBL_SelectProjectFolder"), FileUtil.toFile((FileObject)ProjectPropertiesSupport.getSourcesDirectory(RunAsWebAdvanced.this.project)));
                    if (newLocation != null) {
                        localPathCell.setPath(newLocation.getAbsolutePath());
                    }
                    RunAsWebAdvanced.this.validateFields();
                }
            }
        }
    }

    private static final class LocalPathCellRenderer
    implements TableCellRenderer {
        private LocalPathCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            LocalPathCell localPathCell = (LocalPathCell)value;
            if (localPathCell == null) {
                localPathCell = new LocalPathCell(RunAsWebAdvanced.DEFAULT_LOCAL_PATH);
            }
            if (isSelected) {
                localPathCell.setBgColor(table.getSelectionBackground());
                localPathCell.setFgColor(table.getSelectionForeground());
            } else {
                localPathCell.setBgColor(table.getBackground());
                localPathCell.setFgColor(table.getForeground());
            }
            return localPathCell;
        }
    }

    private static final class PathMappingTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 169356031075115831L;

        public PathMappingTableModel(String[] columnNames, Object[][] data) {
            super(data, columnNames);
        }

        public boolean isLastServerPathFilled() {
            int rowCount = this.getRowCount();
            if (rowCount == 0) {
                return true;
            }
            return StringUtils.hasText((String)((String)this.getValueAt(rowCount - 1, 0)));
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 1) {
                return LocalPathCell.class;
            }
            if (columnIndex == 0) {
                return String.class;
            }
            throw new IllegalStateException("Unhandled column index: " + columnIndex);
        }
    }
}

