/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.logicalview;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.logicalview.PhpSourcesFilter;
import org.netbeans.modules.php.project.ui.logicalview.SrcNode;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public class SourcesNodeFactory
implements NodeFactory {
    private static final Logger LOGGER = Logger.getLogger(SourcesNodeFactory.class.getName());

    public NodeList<SourceGroup> createNodes(Project p) {
        PhpProject prj = (PhpProject)p.getLookup().lookup(PhpProject.class);
        return new SourceChildrenList(prj);
    }

    private static final class SourceChildrenList
    implements NodeList<SourceGroup>,
    ChangeListener {
        private final PhpProject project;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final Sources projectSources;
        private final ChangeListener changeListener;

        private SourceChildrenList(PhpProject project) {
            this.project = project;
            this.projectSources = ProjectUtils.getSources((Project)project);
            this.changeListener = WeakListeners.change((ChangeListener)this, (Object)this.projectSources);
        }

        public void addNotify() {
            this.projectSources.addChangeListener(this.changeListener);
        }

        public void removeNotify() {
            this.projectSources.removeChangeListener(this.changeListener);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SourceChildrenList.this.fireChange();
                }
            });
        }

        private void fireChange() {
            this.changeSupport.fireChange();
        }

        private DataFolder getFolder(FileObject fileObject) {
            if (fileObject != null && fileObject.isValid()) {
                try {
                    DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                    return dataFolder;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
            }
            return null;
        }

        public List<SourceGroup> keys() {
            SourceGroup[] sourceGroups = PhpProjectUtils.getSourceGroups(this.project);
            SourceGroup[] groups = new SourceGroup[sourceGroups.length];
            System.arraycopy(sourceGroups, 0, groups, 0, sourceGroups.length);
            ArrayList<SourceGroup> keysList = new ArrayList<SourceGroup>(groups.length);
            for (int i = 0; i < groups.length; ++i) {
                FileObject fileObject = groups[i].getRootFolder();
                DataFolder srcDir = this.getFolder(fileObject);
                if (srcDir == null) continue;
                keysList.add(groups[i]);
            }
            return keysList;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        public Node node(SourceGroup key) {
            FileObject rootFolder;
            DataFolder folder;
            SrcNode node = null;
            if (key != null && (folder = this.getFolder(rootFolder = key.getRootFolder())) != null) {
                boolean isTest = !folder.getPrimaryFile().equals(ProjectPropertiesSupport.getSourcesDirectory(this.project));
                node = new SrcNode(this.project, folder, (DataFilter)new PhpSourcesFilter(this.project, rootFolder), key.getDisplayName(), isTest);
            }
            return node;
        }
    }
}

