/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdnjs;

import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.javascript.cdnjs.Library;
import org.netbeans.modules.javascript.cdnjs.LibraryListener;
import org.netbeans.modules.web.common.api.UsageLogger;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class LibraryPersistence {
    private static final String NAMESPACE_URI = "http://www.netbeans.org/ns/cdnjs-libraries/1";
    private static final String ELEMENT_LIBRARIES = "libraries";
    private static final String ELEMENT_LIBRARY = "library";
    private static final String ELEMENT_FILE = "file";
    private static final String ATTR_LIBRARY_NAME = "name";
    private static final String ATTR_VERSION_NAME = "version";
    private static final String ATTR_FILE_LOCAL_PATH = "localPath";
    private static final String ATTR_FILE_PATH = "path";
    private static final LibraryPersistence DEFAULT = new LibraryPersistence();
    private final LibraryListener.Support libraryListenerSupport = new LibraryListener.Support();
    private static final UsageLogger USAGE_LOGGER = new UsageLogger.Builder("org.netbeans.ui.metrics.javascript.cdnjs").firstMessageOnly(false).create();

    LibraryPersistence() {
    }

    public static LibraryPersistence getDefault() {
        return DEFAULT;
    }

    public void addLibraryListener(@NullAllowed LibraryListener listener) {
        this.libraryListenerSupport.addLibraryListener(listener);
    }

    public void removeLibraryListener(@NullAllowed LibraryListener listener) {
        this.libraryListenerSupport.removeLibraryListener(listener);
    }

    public Library.Version[] loadLibraries(Project project) {
        Library.Version[] libraries;
        AuxiliaryConfiguration config = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        Element element = config.getConfigurationFragment(ELEMENT_LIBRARIES, NAMESPACE_URI, true);
        if (element == null) {
            libraries = new Library.Version[]{};
        } else {
            NodeList libraryList = element.getElementsByTagNameNS(NAMESPACE_URI, ELEMENT_LIBRARY);
            libraries = new Library.Version[libraryList.getLength()];
            for (int i = 0; i < libraryList.getLength(); ++i) {
                Element libraryElement = (Element)libraryList.item(i);
                libraries[i] = this.loadLibrary(libraryElement);
            }
        }
        return libraries;
    }

    private Library.Version loadLibrary(Element libraryElement) {
        String libraryName = libraryElement.getAttribute(ATTR_LIBRARY_NAME);
        String versionName = libraryElement.getAttribute(ATTR_VERSION_NAME);
        Library library = new Library();
        library.setName(libraryName);
        Library.Version version = new Library.Version(library);
        version.setName(versionName);
        library.setVersions(new Library.Version[]{version});
        NodeList fileList = libraryElement.getElementsByTagNameNS(NAMESPACE_URI, ELEMENT_FILE);
        String[] files = new String[fileList.getLength()];
        String[] localFiles = new String[fileList.getLength()];
        for (int i = 0; i < fileList.getLength(); ++i) {
            Element fileElement = (Element)fileList.item(i);
            String path = fileElement.getAttribute(ATTR_FILE_PATH);
            String localPath = fileElement.getAttribute(ATTR_FILE_LOCAL_PATH);
            files[i] = path;
            localFiles[i] = localPath == null ? path : localPath;
        }
        version.setFileInfo(files, localFiles);
        return version;
    }

    void storeLibraries(Project project, Library.Version[] libraries) {
        Arrays.sort(libraries, new LibraryVersionComparator());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element librariesElement = document.createElementNS(NAMESPACE_URI, ELEMENT_LIBRARIES);
            for (Library.Version library : libraries) {
                Element libraryElement = document.createElementNS(NAMESPACE_URI, ELEMENT_LIBRARY);
                String libraryName = library.getLibrary().getName();
                libraryElement.setAttribute(ATTR_LIBRARY_NAME, libraryName);
                String versionName = library.getName();
                libraryElement.setAttribute(ATTR_VERSION_NAME, versionName);
                String[] files = library.getFiles();
                String[] localFiles = library.getLocalFiles();
                for (int i = 0; i < files.length; ++i) {
                    Element fileElement = document.createElementNS(NAMESPACE_URI, ELEMENT_FILE);
                    String path = files[i];
                    String localPath = localFiles[i];
                    fileElement.setAttribute(ATTR_FILE_PATH, path);
                    fileElement.setAttribute(ATTR_FILE_LOCAL_PATH, localPath);
                    libraryElement.appendChild(fileElement);
                }
                librariesElement.appendChild(libraryElement);
            }
            AuxiliaryConfiguration config = ProjectUtils.getAuxiliaryConfiguration((Project)project);
            config.putConfigurationFragment(librariesElement, true);
            LibraryPersistence.logLibraryUsage(libraries);
            this.libraryListenerSupport.fireLibrariesChanged(project);
        }
        catch (ParserConfigurationException pcex) {
            Logger.getLogger(LibraryPersistence.class.getName()).log(Level.SEVERE, "Unable to store library information!", pcex);
        }
    }

    private static void logLibraryUsage(Library.Version[] libraries) {
        USAGE_LOGGER.log(LibraryPersistence.class, "USG_CDNJS_LIBRARY_EDIT", new Object[0]);
        for (Library.Version library : libraries) {
            String version = library.getName();
            String name = library.getLibrary().getName();
            USAGE_LOGGER.log(LibraryPersistence.class, "USG_CDNJS_LIBRARY", new Object[]{name, version});
        }
    }

    static class LibraryVersionComparator
    implements Comparator<Library.Version> {
        LibraryVersionComparator() {
        }

        @Override
        public int compare(Library.Version o1, Library.Version o2) {
            String name1 = o1.getLibrary().getName();
            String name2 = o2.getLibrary().getName();
            return name1.compareTo(name2);
        }
    }
}

