/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdnjs;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.netbeans.modules.javascript.cdnjs.Library;
import org.netbeans.modules.javascript.cdnjs.Version;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

public final class LibraryProvider {
    private static final LibraryProvider INSTANCE = new LibraryProvider();
    private static final RequestProcessor RP = new RequestProcessor(LibraryProvider.class.getName(), 3);
    private final Map<String, WeakReference<Library[]>> cache = Collections.synchronizedMap(new HashMap());
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private static final String LIBRARY_FILE_URL_PATTERN = System.getProperty("netbeans.cdnjs.downloadurl", "http://cdnjs.cloudflare.com/ajax/libs/{0}/{1}/{2}");
    static final String SEARCH_URL_PREFIX = System.getProperty("netbeans.cdnjs.searchurl", "http://api.cdnjs.com/libraries?fields=description,homepage,assets&search=");
    static final Comparator<Pair<Library.Version, Version>> VERSION_COMPARATOR = new Comparator<Pair<Library.Version, Version>>(){

        @Override
        public int compare(Pair<Library.Version, Version> pair1, Pair<Library.Version, Version> pair2) {
            return Version.Comparator.getInstance(false).compare((Version)pair1.second(), (Version)pair2.second());
        }
    };

    private LibraryProvider() {
    }

    public static LibraryProvider getInstance() {
        return INSTANCE;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public Library[] findLibraries(String searchTerm, int priority) {
        WeakReference<Library[]> reference = this.cache.get(searchTerm);
        Library[] result = null;
        if (reference != null) {
            result = (Library[])reference.get();
        }
        if (result == null) {
            SearchTask task = new SearchTask(searchTerm);
            RP.post((Runnable)task, 0, priority);
        }
        return result;
    }

    void updateCache(String searchTerm, Library[] libraries) {
        if (libraries != null) {
            WeakReference<Library[]> reference = new WeakReference<Library[]>(libraries);
            this.cache.put(searchTerm, reference);
        }
        this.propertyChangeSupport.firePropertyChange(searchTerm, null, libraries);
    }

    /*
     * Exception decompiling
     */
    public File downloadLibraryFile(Library.Version version, int fileIndex) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    final class SearchTask
    implements Runnable {
        private static final String PROPERTY_RESULT = "results";
        private final String searchTerm;
        private static final String PROPERTY_NAME = "name";
        private static final String PROPERTY_DESCRIPTION = "description";
        private static final String PROPERTY_HOMEPAGE = "homepage";
        private static final String PROPERTY_VERSIONS = "assets";
        private static final String PROPERTY_VERSION_NAME = "version";
        private static final String PROPERTY_FILES = "files";
        private static final String PROPERTY_FILE_NAME = "name";

        SearchTask(String searchTerm) {
            this.searchTerm = searchTerm;
        }

        String getSearchURL() {
            String encodedSearchTerm;
            try {
                encodedSearchTerm = URLEncoder.encode(this.searchTerm, "UTF-8");
            }
            catch (UnsupportedEncodingException ueex) {
                Logger.getLogger(LibraryProvider.class.getName()).log(Level.SEVERE, null, ueex);
                encodedSearchTerm = this.searchTerm;
            }
            return SEARCH_URL_PREFIX + encodedSearchTerm;
        }

        @Override
        public void run() {
            String searchURL = this.getSearchURL();
            String urlContent = this.readUrl(searchURL);
            Library[] libraries = null;
            if (urlContent != null) {
                libraries = this.parse(urlContent);
            }
            LibraryProvider.this.updateCache(this.searchTerm, libraries);
        }

        String readUrl(String url) {
            String urlContent = null;
            try {
                URL urlObject = new URL(url);
                URLConnection urlConnection = urlObject.openConnection();
                StringBuilder content = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        content.append(line).append('\n');
                    }
                }
                urlContent = content.toString();
            }
            catch (MalformedURLException muex) {
                Logger.getLogger(SearchTask.class.getName()).log(Level.INFO, null, muex);
            }
            catch (IOException ioex) {
                Logger.getLogger(SearchTask.class.getName()).log(Level.INFO, null, ioex);
            }
            return urlContent;
        }

        Library[] parse(String data) {
            Library[] libraries = null;
            try {
                JSONParser parser = new JSONParser();
                JSONObject searchResult = (JSONObject)parser.parse(data);
                JSONArray libraryArray = (JSONArray)searchResult.get((Object)PROPERTY_RESULT);
                libraries = new Library[libraryArray.size()];
                for (int i = 0; i < libraries.length; ++i) {
                    JSONObject libraryData = (JSONObject)libraryArray.get(i);
                    libraries[i] = this.createLibrary(libraryData);
                }
            }
            catch (ParseException pex) {
                Logger.getLogger(SearchTask.class.getName()).log(Level.INFO, null, pex);
            }
            return libraries;
        }

        Library createLibrary(JSONObject data) {
            Library library = new Library();
            String name = (String)data.get((Object)"name");
            library.setName(name);
            String description = (String)data.get((Object)PROPERTY_DESCRIPTION);
            library.setDescription(description);
            String homepage = (String)data.get((Object)PROPERTY_HOMEPAGE);
            library.setHomePage(homepage);
            JSONArray versionsData = (JSONArray)data.get((Object)PROPERTY_VERSIONS);
            Library.Version[] versions = new Library.Version[versionsData.size()];
            for (int i = 0; i < versions.length; ++i) {
                JSONObject versionData = (JSONObject)versionsData.get(i);
                versions[i] = this.createVersion(library, versionData);
            }
            this.sort(versions);
            library.setVersions(versions);
            return library;
        }

        private void sort(Library.Version[] versions) {
            int i;
            Pair[] pairs = new Pair[versions.length];
            for (i = 0; i < versions.length; ++i) {
                Library.Version libraryVersion = versions[i];
                Version version = Version.parse(libraryVersion.getName());
                pairs[i] = Pair.of((Object)libraryVersion, (Object)version);
            }
            Arrays.sort(pairs, VERSION_COMPARATOR);
            for (i = 0; i < versions.length; ++i) {
                versions[i] = (Library.Version)pairs[i].first();
            }
        }

        private Library.Version createVersion(Library library, JSONObject data) {
            Library.Version version = new Library.Version(library);
            String versionName = (String)data.get((Object)PROPERTY_VERSION_NAME);
            version.setName(versionName);
            JSONArray filesData = (JSONArray)data.get((Object)PROPERTY_FILES);
            String[] files = new String[filesData.size()];
            for (int i = 0; i < files.length; ++i) {
                String fileName;
                Object fileInfo = filesData.get(i);
                if (fileInfo instanceof JSONObject) {
                    JSONObject fileData = (JSONObject)fileInfo;
                    fileName = (String)fileData.get((Object)"name");
                } else {
                    fileName = fileInfo.toString();
                }
                files[i] = fileName;
            }
            version.setFileInfo(files, null);
            return version;
        }
    }
}

