/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.pm;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Name;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreeScanner;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.spiimpl.Utilities;
import org.netbeans.modules.java.hints.spiimpl.pm.BulkSearch;
import org.netbeans.modules.java.hints.spiimpl.pm.NFA;
import org.openide.util.Exceptions;

public class NFABasedBulkSearch
extends BulkSearch {
    private static final Set<Tree.Kind> TO_IGNORE = EnumSet.of(Tree.Kind.BLOCK, Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT);
    private static final Map<Tree.Kind, byte[]> kind2Encoded = new EnumMap<Tree.Kind, byte[]>(Tree.Kind.class);
    private static final Map<Tree.Kind, String> kind2EncodedString = new EnumMap<Tree.Kind, String>(Tree.Kind.class);
    private static final Map<Integer, Tree.Kind> encoded2Kind = new HashMap<Integer, Tree.Kind>();
    private static final Input UP;

    public NFABasedBulkSearch() {
        super(false);
    }

    @Override
    public Map<String, Collection<TreePath>> match(CompilationInfo info, final AtomicBoolean cancel, TreePath tree, BulkSearch.BulkPattern patternIn, Map<String, Long> timeLog) {
        BulkPatternImpl pattern = (BulkPatternImpl)patternIn;
        final HashMap occurringPatterns = new HashMap();
        final NFA<Input, Res> nfa = pattern.toNFA();
        final HashSet identifiers = new HashSet();
        new CollectIdentifiers<Void, TreePath>(identifiers, cancel){
            private NFA.State active;
            {
                super(x0, x1);
                this.active = nfa.getStartingState();
            }

            public Void scan(Tree node, TreePath p) {
                if (node == null) {
                    return null;
                }
                TreePath currentPath = new TreePath(p, node);
                boolean[] goDeeper = new boolean[1];
                NFA.State newActiveAfterVariable = nfa.transition(this.active, new Input(Tree.Kind.IDENTIFIER, "$", false));
                Input normalizedInput = NFABasedBulkSearch.normalizeInput(node, goDeeper, null);
                boolean ignoreKind = normalizedInput.kind == Tree.Kind.IDENTIFIER || normalizedInput.kind == Tree.Kind.MEMBER_SELECT;
                NFA.State newActiveBefore = nfa.transition(this.active, normalizedInput);
                if (normalizedInput.name != null && !ignoreKind) {
                    newActiveBefore = nfa.join(newActiveBefore, nfa.transition(this.active, new Input(normalizedInput.kind, "$", false)));
                }
                this.active = newActiveBefore;
                if (goDeeper[0]) {
                    super.scan(node, (Object)currentPath);
                } else {
                    new CollectIdentifiers(identifiers, cancel).scan(node, null);
                }
                if (cancel.get()) {
                    return null;
                }
                NFA.State newActiveAfter = nfa.transition(this.active, UP);
                this.active = nfa.join(newActiveAfter, nfa.transition(newActiveAfterVariable, UP));
                for (Res r : nfa.getResults(this.active)) {
                    this.addOccurrence(r, currentPath);
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void scan(Iterable<? extends Tree> nodes, TreePath p) {
                this.active = nfa.transition(this.active, new Input(Tree.Kind.IDENTIFIER, "(", false));
                try {
                    Void void_ = (Void)super.scan(nodes, (Object)p);
                    return void_;
                }
                finally {
                    this.active = nfa.transition(this.active, UP);
                }
            }

            private void addOccurrence(Res r, TreePath currentPath) {
                LinkedList<TreePath> occurrences = (LinkedList<TreePath>)occurringPatterns.get(r);
                if (occurrences == null) {
                    occurrences = new LinkedList<TreePath>();
                    occurringPatterns.put(r, occurrences);
                }
                occurrences.add(currentPath);
            }
        }.scan(tree, tree.getParentPath());
        if (cancel.get()) {
            return null;
        }
        HashMap<String, Collection<TreePath>> result = new HashMap<String, Collection<TreePath>>();
        for (Map.Entry e : occurringPatterns.entrySet()) {
            if (cancel.get()) {
                return null;
            }
            if (!identifiers.containsAll((Collection)pattern.getIdentifiers().get(((Res)e.getKey()).patternIndex))) continue;
            result.put(((Res)e.getKey()).pattern, (Collection<TreePath>)e.getValue());
        }
        return result;
    }

    @Override
    public BulkSearch.BulkPattern create(Collection<? extends String> code, Collection<? extends Tree> patterns, Collection<? extends HintDescription.AdditionalQueryConstraints> additionalConstraints, final AtomicBoolean cancel) {
        int startState = 0;
        final int[] nextState = new int[]{1};
        final LinkedHashMap transitionTable = new LinkedHashMap();
        HashMap<Integer, Res> finalStates = new HashMap<Integer, Res>();
        LinkedList identifiers = new LinkedList();
        ArrayList requiredContent = new ArrayList();
        Iterator<? extends String> codeIt = code.iterator();
        int patternIndex = 0;
        for (final Tree tree : patterns) {
            final int[] currentState = new int[]{startState};
            final HashSet patternIdentifiers = new HashSet();
            final ArrayList content = new ArrayList();
            identifiers.add(patternIdentifiers);
            requiredContent.add(content);
            class Scanner
            extends CollectIdentifiers<Void, Void> {
                private boolean auxPath;
                private List<String> currentContent;

                public Scanner() {
                    super(set, atomicBoolean);
                    this.currentContent = new ArrayList<String>();
                    content.add(this.currentContent);
                }

                public Void scan(Tree t, Void v) {
                    if (t == null) {
                        return null;
                    }
                    if (Utilities.isMultistatementWildcardTree(t) || NFABasedBulkSearch.this.multiModifiers(t)) {
                        int n = nextState[0];
                        nextState[0] = n + 1;
                        int target = n;
                        NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(currentState[0], new Input(Tree.Kind.IDENTIFIER, "$", false)), target);
                        NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(target, UP), currentState[0]);
                        this.currentContent = new ArrayList<String>();
                        content.add(this.currentContent);
                        return null;
                    }
                    if (t.getKind() == Tree.Kind.BLOCK) {
                        StatementTree singletonStatement = null;
                        BlockTree bt = (BlockTree)t;
                        if (!bt.isStatic()) {
                            switch (bt.getStatements().size()) {
                                case 1: {
                                    singletonStatement = bt.getStatements().get(0);
                                    break;
                                }
                                case 2: {
                                    if (Utilities.isMultistatementWildcardTree(bt.getStatements().get(0))) {
                                        singletonStatement = bt.getStatements().get(1);
                                        break;
                                    }
                                    if (!Utilities.isMultistatementWildcardTree(bt.getStatements().get(1))) break;
                                    singletonStatement = bt.getStatements().get(0);
                                    break;
                                }
                                case 3: {
                                    if (!Utilities.isMultistatementWildcardTree(bt.getStatements().get(0)) || !Utilities.isMultistatementWildcardTree(bt.getStatements().get(2))) break;
                                    singletonStatement = bt.getStatements().get(1);
                                }
                            }
                        }
                        if (singletonStatement != null) {
                            int backup = currentState[0];
                            boolean oldAuxPath = this.auxPath;
                            this.auxPath = true;
                            this.scan((Tree)singletonStatement, null);
                            this.auxPath = oldAuxPath;
                            int target = currentState[0];
                            nextState[0] = nextState[0] + 1;
                            NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(backup, new Input(Tree.Kind.BLOCK, null, false)), currentState[0]);
                            nextState[0] = nextState[0] + 1;
                            NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(currentState[0], new Input(Tree.Kind.IDENTIFIER, "(", false)), currentState[0]);
                            for (StatementTree statementTree : bt.getStatements()) {
                                this.scan((Tree)statementTree, null);
                            }
                            nextState[0] = nextState[0] + 1;
                            NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(currentState[0], UP), currentState[0]);
                            NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(currentState[0], UP), target);
                            currentState[0] = target;
                            return null;
                        }
                    }
                    boolean[] goDeeper = new boolean[1];
                    Input[] bypass = new Input[1];
                    Input i = NFABasedBulkSearch.normalizeInput(t, goDeeper, bypass);
                    if (!TO_IGNORE.contains((Object)i.kind) && !this.auxPath) {
                        this.currentContent.add((String)kind2EncodedString.get((Object)i.kind));
                    }
                    if (i.name != null && !this.auxPath) {
                        if (!"$".equals(i.name)) {
                            if (NFABasedBulkSearch.isIdentifierAcceptable(i.name)) {
                                this.currentContent.add(i.name);
                            }
                            if (Utilities.isPureMemberSelect(t, false)) {
                                this.currentContent = new ArrayList<String>();
                                content.add(this.currentContent);
                            }
                        } else {
                            this.currentContent = new ArrayList<String>();
                            content.add(this.currentContent);
                        }
                    }
                    int backup = currentState[0];
                    this.handleTree(i, goDeeper, t, bypass);
                    boolean oldAuxPath = this.auxPath;
                    this.auxPath = true;
                    if (StatementTree.class.isAssignableFrom(t.getKind().asInterface()) && t != tree) {
                        int target = currentState[0];
                        nextState[0] = nextState[0] + 1;
                        NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(backup, new Input(Tree.Kind.BLOCK, null, false)), currentState[0]);
                        nextState[0] = nextState[0] + 1;
                        NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(currentState[0], new Input(Tree.Kind.IDENTIFIER, "(", false)), currentState[0]);
                        this.handleTree(i, goDeeper, t, bypass);
                        nextState[0] = nextState[0] + 1;
                        NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(currentState[0], UP), currentState[0]);
                        NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(currentState[0], UP), target);
                        currentState[0] = target;
                    }
                    this.auxPath = oldAuxPath;
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void scan(Iterable<? extends Tree> nodes, Void p) {
                    nextState[0] = nextState[0] + 1;
                    NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(currentState[0], new Input(Tree.Kind.IDENTIFIER, "(", false)), currentState[0]);
                    try {
                        Void void_ = (Void)super.scan(nodes, (Object)p);
                        return void_;
                    }
                    finally {
                        nextState[0] = nextState[0] + 1;
                        NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(currentState[0], UP), currentState[0]);
                    }
                }

                private void handleTree(Input i, boolean[] goDeeper, Tree t, Input[] bypass) {
                    int backup = currentState[0];
                    int n = nextState[0];
                    nextState[0] = n + 1;
                    int target = n;
                    nextState[0] = nextState[0] + 1;
                    NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(backup, i), currentState[0]);
                    if (goDeeper[0]) {
                        super.scan(t, null);
                    } else {
                        new CollectIdentifiers(patternIdentifiers, cancel).scan(t, null);
                        int n2 = nextState[0];
                        nextState[0] = n2 + 1;
                        int aux = n2;
                        NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(backup, new Input(Tree.Kind.MEMBER_SELECT, i.name, false)), aux);
                        NFA.Key<Input> key = NFA.Key.create(aux, new Input(Tree.Kind.IDENTIFIER, "$", false));
                        int n3 = nextState[0];
                        nextState[0] = n3 + 1;
                        aux = n3;
                        NFABasedBulkSearch.setBit(transitionTable, key, n3);
                        NFA.Key<Input> key2 = NFA.Key.create(aux, UP);
                        int n4 = nextState[0];
                        nextState[0] = n4 + 1;
                        aux = n4;
                        NFABasedBulkSearch.setBit(transitionTable, key2, n4);
                        NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(aux, UP), target);
                    }
                    NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(currentState[0], UP), target);
                    if (bypass[0] != null) {
                        int n5 = nextState[0];
                        nextState[0] = n5 + 1;
                        int intermediate = n5;
                        NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(backup, bypass[0]), intermediate);
                        NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(intermediate, UP), target);
                    }
                    currentState[0] = target;
                }
            }
            Scanner s = new Scanner();
            s.scan(tree, null);
            finalStates.put(currentState[0], new Res(codeIt.next(), patternIndex++));
        }
        if (cancel.get()) {
            return null;
        }
        NFA nfa = NFA.create(startState, nextState[0], null, transitionTable, finalStates);
        return new BulkPatternImpl(new LinkedList<String>(code), identifiers, requiredContent, new LinkedList<HintDescription.AdditionalQueryConstraints>(additionalConstraints), nfa);
    }

    private static void setBit(Map<NFA.Key<Input>, NFA.State> transitionTable, NFA.Key<Input> input, int state) {
        NFA.State target = transitionTable.get(input);
        if (target == null) {
            target = NFA.State.create();
            transitionTable.put(input, target);
        }
        target.mutableOr(state);
    }

    private static Input normalizeInput(Tree t, boolean[] goDeeper, Input[] bypass) {
        String name;
        if (t.getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)t).getName().toString().startsWith("$")) {
            goDeeper[0] = false;
            return new Input(Tree.Kind.IDENTIFIER, "$", false);
        }
        if (Utilities.getWildcardTreeName(t) != null) {
            goDeeper[0] = false;
            return new Input(Tree.Kind.IDENTIFIER, "$", false);
        }
        if (t.getKind() == Tree.Kind.IDENTIFIER) {
            goDeeper[0] = false;
            String name2 = ((IdentifierTree)t).getName().toString();
            return new Input(Tree.Kind.IDENTIFIER, name2, false);
        }
        if (t.getKind() == Tree.Kind.MEMBER_SELECT) {
            String name3 = ((MemberSelectTree)t).getIdentifier().toString();
            if (name3.startsWith("$")) {
                goDeeper[0] = false;
                return new Input(Tree.Kind.IDENTIFIER, "$", false);
            }
            if (bypass != null && Utilities.isPureMemberSelect(t, true)) {
                bypass[0] = new Input(Tree.Kind.IDENTIFIER, name3, false);
            }
            goDeeper[0] = true;
            return new Input(Tree.Kind.MEMBER_SELECT, name3, false);
        }
        goDeeper[0] = true;
        switch (t.getKind()) {
            case CLASS: {
                name = ((ClassTree)t).getSimpleName().toString();
                break;
            }
            case VARIABLE: {
                name = ((VariableTree)t).getName().toString();
                break;
            }
            case METHOD: {
                name = ((MethodTree)t).getName().toString();
                break;
            }
            case BOOLEAN_LITERAL: {
                name = ((LiteralTree)t).getValue().toString();
                break;
            }
            default: {
                name = null;
            }
        }
        if (name != null && !name.isEmpty() && name.charAt(0) == '$') {
            name = "$";
        }
        return new Input(t.getKind(), name, false);
    }

    private boolean multiModifiers(Tree t) {
        if (t.getKind() != Tree.Kind.MODIFIERS) {
            return false;
        }
        ArrayList<? extends AnnotationTree> annotations = new ArrayList<AnnotationTree>(((ModifiersTree)t).getAnnotations());
        return !annotations.isEmpty() && ((AnnotationTree)annotations.get(0)).getAnnotationType().getKind() == Tree.Kind.IDENTIFIER;
    }

    @Override
    public boolean matches(CompilationInfo info, AtomicBoolean cancel, TreePath tree, BulkSearch.BulkPattern pattern) {
        return !this.match(info, cancel, tree, pattern).isEmpty();
    }

    @Override
    public void encode(Tree tree, final BulkSearch.EncodingContext ctx, AtomicBoolean cancel) {
        HashSet<String> identifiers = new HashSet<String>();
        final ArrayList<String> content = new ArrayList<String>();
        if (!ctx.isForDuplicates()) {
            new CollectIdentifiers(identifiers, cancel).scan(tree, null);
            try {
                int size = identifiers.size();
                ctx.getOut().write(size >> 24 & 0xFF);
                ctx.getOut().write(size >> 16 & 0xFF);
                ctx.getOut().write(size >> 8 & 0xFF);
                ctx.getOut().write(size >> 0 & 0xFF);
                for (String ident : identifiers) {
                    ctx.getOut().write(ident.getBytes("UTF-8"));
                    ctx.getOut().write(59);
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        if (cancel.get()) {
            // empty if block
        }
        new CollectIdentifiers<Void, Void>(new HashSet(), cancel){
            private boolean encode;
            {
                super(x0, x1);
                this.encode = true;
            }

            public Void scan(Tree t, Void v) {
                if (t == null) {
                    return null;
                }
                if (t instanceof StatementTree && Utilities.isMultistatementWildcardTree((StatementTree)t)) {
                    return null;
                }
                boolean[] goDeeper = new boolean[1];
                Input i = NFABasedBulkSearch.normalizeInput(t, goDeeper, null);
                try {
                    ctx.getOut().write(40);
                    ctx.getOut().write((byte[])kind2Encoded.get((Object)i.kind));
                    if (!TO_IGNORE.contains((Object)i.kind)) {
                        content.add(kind2EncodedString.get((Object)i.kind));
                    }
                    if (i.name != null) {
                        if (this.encode) {
                            ctx.getOut().write(36);
                            ctx.getOut().write(i.name.getBytes("UTF-8"));
                            ctx.getOut().write(59);
                        }
                        if (NFABasedBulkSearch.isIdentifierAcceptable(i.name)) {
                            content.add(i.name);
                        }
                    }
                    boolean oldEncode = this.encode;
                    this.encode &= goDeeper[0];
                    super.scan(t, (Object)v);
                    this.encode = oldEncode;
                    ctx.getOut().write(41);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return null;
            }

            public Void scan(Iterable<? extends Tree> nodes, Void p) {
                try {
                    ctx.getOut().write(40);
                    ctx.getOut().write((byte[])kind2Encoded.get((Object)Tree.Kind.IDENTIFIER));
                    ctx.getOut().write(36);
                    ctx.getOut().write(40);
                    ctx.getOut().write(59);
                    super.scan(nodes, (Object)p);
                    ctx.getOut().write(41);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return null;
            }
        }.scan(tree, null);
        ctx.setIdentifiers(identifiers);
        ctx.setContent(content);
        if (cancel.get()) {
            // empty if block
        }
    }

    @Override
    public boolean matches(InputStream encoded, AtomicBoolean cancel, BulkSearch.BulkPattern patternIn) {
        try {
            return !this.matchesImpl(encoded, cancel, patternIn, false).isEmpty();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    @Override
    public Map<String, Integer> matchesWithFrequencies(InputStream encoded, BulkSearch.BulkPattern patternIn, AtomicBoolean cancel) {
        try {
            return this.matchesImpl(encoded, cancel, patternIn, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyMap();
        }
    }

    public Map<String, Integer> matchesImpl(InputStream encoded, AtomicBoolean cancel, BulkSearch.BulkPattern patternIn, boolean withFrequencies) throws IOException {
        BulkPatternImpl pattern = (BulkPatternImpl)patternIn;
        NFA<Input, Res> nfa = pattern.toNFA();
        Stack<NFA.State> skips = new Stack<NFA.State>();
        NFA.State active = nfa.getStartingState();
        int identSize = 0;
        identSize = encoded.read();
        identSize = (identSize << 8) + encoded.read();
        identSize = (identSize << 8) + encoded.read();
        identSize = (identSize << 8) + encoded.read();
        HashSet<String> identifiers = new HashSet<String>(2 * identSize);
        while (identSize-- > 0) {
            if (cancel.get()) {
                return null;
            }
            int read = encoded.read();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while (read != 59) {
                baos.write(read);
                read = encoded.read();
            }
            identifiers.add(new String(baos.toByteArray(), "UTF-8"));
        }
        HashMap<String, Integer> patternsAndFrequencies = new HashMap<String, Integer>();
        int read = encoded.read();
        while (read != -1) {
            if (cancel.get()) {
                return null;
            }
            if (read == 40) {
                String name;
                read = encoded.read();
                Tree.Kind k = encoded2Kind.get((read << 8) + encoded.read());
                read = encoded.read();
                if (read == 36) {
                    read = encoded.read();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while (read != 59) {
                        baos.write(read);
                        read = encoded.read();
                    }
                    read = encoded.read();
                    name = new String(baos.toByteArray(), "UTF-8");
                } else {
                    name = null;
                }
                NFA.State newActiveAfterVariable = nfa.transition(active, new Input(Tree.Kind.IDENTIFIER, "$", false));
                Input normalizedInput = new Input(k, name, false);
                boolean ignoreKind = normalizedInput.kind == Tree.Kind.IDENTIFIER || normalizedInput.kind == Tree.Kind.MEMBER_SELECT;
                NFA.State newActive = nfa.transition(active, normalizedInput);
                if (normalizedInput.name != null && !ignoreKind) {
                    newActive = nfa.join(newActive, nfa.transition(active, new Input(k, "$", false)));
                }
                active = newActive;
                skips.push(newActiveAfterVariable);
                continue;
            }
            NFA.State newActiveAfterVariable = (NFA.State)skips.pop();
            NFA.State newActive = nfa.transition(active, UP);
            NFA.State s2 = nfa.transition(newActiveAfterVariable, UP);
            active = nfa.join(newActive, s2);
            for (Res res : nfa.getResults(active)) {
                if (!identifiers.containsAll((Collection)pattern.getIdentifiers().get(res.patternIndex))) continue;
                if (!withFrequencies) {
                    patternsAndFrequencies.put(res.pattern, 1);
                    return patternsAndFrequencies;
                }
                Integer freqs = (Integer)patternsAndFrequencies.get(res.pattern);
                if (freqs == null) {
                    freqs = 0;
                }
                patternsAndFrequencies.put(res.pattern, freqs + 1);
            }
            read = encoded.read();
        }
        return patternsAndFrequencies;
    }

    private static boolean isIdentifierAcceptable(CharSequence content) {
        if (content.length() == 0) {
            return false;
        }
        if (content.charAt(0) == '$' || content.charAt(0) == '<') {
            return false;
        }
        String stringValue = content.toString();
        return !stringValue.contentEquals("java") && !"lang".equals(stringValue);
    }

    static {
        for (Tree.Kind k : Tree.Kind.values()) {
            String enc = Integer.toHexString(k.ordinal());
            if (enc.length() < 2) {
                enc = "0" + enc;
            }
            try {
                byte[] bytes = enc.getBytes("UTF-8");
                assert (bytes.length == 2);
                kind2Encoded.put(k, bytes);
                kind2EncodedString.put(k, enc);
                encoded2Kind.put((bytes[0] << 8) + bytes[1], k);
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException(ex);
            }
        }
        UP = new Input(null, null, true);
    }

    private static class CollectIdentifiers<R, P>
    extends CancellableTreeScanner<R, P> {
        private final Set<String> identifiers;

        public CollectIdentifiers(Set<String> identifiers, AtomicBoolean cancel) {
            super(cancel);
            this.identifiers = identifiers;
        }

        private void addIdentifier(Name ident) {
            if (!NFABasedBulkSearch.isIdentifierAcceptable(ident)) {
                return;
            }
            this.identifiers.add(ident.toString());
        }

        public R visitMemberSelect(MemberSelectTree node, P p) {
            this.addIdentifier(node.getIdentifier());
            return (R)super.visitMemberSelect(node, p);
        }

        public R visitIdentifier(IdentifierTree node, P p) {
            this.addIdentifier(node.getName());
            return (R)super.visitIdentifier(node, p);
        }

        public R visitClass(ClassTree node, P p) {
            if (node.getSimpleName().length() == 0) {
                return (R)this.scan(Utilities.filterHidden(null, node.getMembers()), p);
            }
            this.addIdentifier(node.getSimpleName());
            return (R)super.visitClass(node, p);
        }

        public R visitMethod(MethodTree node, P p) {
            this.addIdentifier(node.getName());
            return (R)super.visitMethod(node, p);
        }

        public R visitVariable(VariableTree node, P p) {
            this.addIdentifier(node.getName());
            return (R)super.visitVariable(node, p);
        }
    }

    private static final class Input {
        private final Tree.Kind kind;
        private final String name;
        private final boolean end;

        private Input(Tree.Kind kind, String name, boolean end) {
            this.kind = kind;
            this.name = name;
            this.end = end;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Input other = (Input)obj;
            if (this.kind != other.kind) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.end == other.end;
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + (this.kind != null ? this.kind.hashCode() : 17);
            hash = 47 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 47 * hash + (this.end ? 1 : 0);
            return hash;
        }

        public String toString() {
            return (Object)((Object)this.kind) + ", " + this.name + ", " + this.end;
        }
    }

    private static final class Res {
        private final String pattern;
        private final int patternIndex;

        public Res(String pattern, int patternIndex) {
            this.pattern = pattern;
            this.patternIndex = patternIndex;
        }
    }

    public static class BulkPatternImpl
    extends BulkSearch.BulkPattern {
        private final NFA<Input, Res> nfa;

        private BulkPatternImpl(List<? extends String> patterns, List<? extends Set<? extends String>> identifiers, List<List<List<String>>> requiredContent, List<HintDescription.AdditionalQueryConstraints> additionalConstraints, NFA<Input, Res> nfa) {
            super(patterns, identifiers, requiredContent, additionalConstraints);
            this.nfa = nfa;
        }

        NFA<Input, Res> toNFA() {
            return this.nfa;
        }
    }
}

