/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.debug;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.groovy.support.debug.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class GroovyLineBreakpointFactory {
    private static final Logger LOGGER = Logger.getLogger(GroovyLineBreakpointFactory.class.getName());

    private GroovyLineBreakpointFactory() {
    }

    public static LineBreakpoint create(String url, int lineNumber) {
        String pt = Bundle.CTL_Default_Print_Text();
        String printText = pt.replace("{groovyName}", GroovyLineBreakpointFactory.getGroovyName(url));
        LineBreakpoint groovyBreakpoint = LineBreakpoint.create((String)url, (int)lineNumber);
        groovyBreakpoint.setStratum("Groovy");
        groovyBreakpoint.setSourceName(GroovyLineBreakpointFactory.getGroovyName(url));
        groovyBreakpoint.setSourcePath(GroovyLineBreakpointFactory.getGroovyPath(url));
        groovyBreakpoint.setPreferredClassName(GroovyLineBreakpointFactory.getClassFilter(url));
        groovyBreakpoint.setPrintText(printText);
        groovyBreakpoint.setHidden(false);
        return groovyBreakpoint;
    }

    private static FileObject getFileObjectFromUrl(String url) {
        FileObject fo = null;
        try {
            fo = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return fo;
    }

    private static String getClassFilter(String url) {
        String relativePath = GroovyLineBreakpointFactory.getGroovyPath(url);
        if (relativePath == null) {
            return "";
        }
        if (relativePath.endsWith(".groovy")) {
            relativePath = relativePath.substring(0, relativePath.length() - 7);
        }
        return relativePath.replace('/', '.') + "*";
    }

    private static String getGroovyName(String url) {
        FileObject fo = GroovyLineBreakpointFactory.getFileObjectFromUrl(url);
        if (fo != null) {
            return fo.getNameExt();
        }
        return url == null ? null : url.toString();
    }

    private static String getGroovyPath(String url) {
        FileObject fo = GroovyLineBreakpointFactory.getFileObjectFromUrl(url);
        String relativePath = url;
        if (fo != null) {
            ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
            if (cp == null) {
                LOGGER.log(Level.FINE, "No classpath for {0}", url);
                return null;
            }
            FileObject root = cp.findOwnerRoot(fo);
            if (root == null) {
                return null;
            }
            relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
        }
        return relativePath;
    }
}

