/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.APIntOps;
import org.llvm.adt.FoldingSetNodeID;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.support.impl.APIntStatics;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class APInt<T extends APInt>
implements Destructors.ClassWithDestructor,
Native.NativePOD<T> {
    private int BitWidth;
    public long VAL;
    public uint.ptr pVal;
    public static final int APINT_BITS_PER_WORD = NativeType.sizeof(Long.TYPE) * 8;
    public static final int APINT_WORD_SIZE = NativeType.sizeof(Long.TYPE);
    private static final char.ptr Digits = NativePointer.$((String)"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    private static final byte[] results = new byte[]{0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6};

    private APInt(uint.ptr val, int bits) {
        this.BitWidth = bits;
        this.pVal = val;
    }

    protected boolean isSingleWord() {
        return this.BitWidth <= APINT_BITS_PER_WORD;
    }

    private static int whichWord(int bitPosition) {
        assert (bitPosition >= 0) : "must be non negative " + bitPosition;
        return bitPosition / APINT_BITS_PER_WORD;
    }

    private static int whichBit(int bitPosition) {
        assert (bitPosition >= 0) : "must be non negative " + bitPosition;
        return bitPosition % APINT_BITS_PER_WORD;
    }

    private static long maskBit(int bitPosition) {
        assert (bitPosition >= 0) : "must be non negative " + bitPosition;
        return 1L << APInt.whichBit(bitPosition);
    }

    private APInt clearUnusedBits() {
        int wordBits = this.BitWidth % APINT_BITS_PER_WORD;
        if (wordBits == 0) {
            return this;
        }
        long mask = -1L >>> APINT_BITS_PER_WORD - wordBits;
        if (this.isSingleWord()) {
            this.VAL &= mask;
        } else {
            this.pVal.$set$andassign(this.getNumWords() - 1, mask);
        }
        return this;
    }

    private long getWord(int bitPosition) {
        assert (bitPosition >= 0) : "must be non negative " + bitPosition;
        return this.isSingleWord() ? this.VAL : this.pVal.$at(APInt.whichWord(bitPosition));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fromString(int numbits, StringRef str, int radix) {
        assert (numbits >= 0) : "must be non negative " + numbits;
        assert (radix >= 0) : "must be non negative " + radix;
        APInt<T> apdigit = null;
        APInt<T> apradix = null;
        try {
            boolean isNeg;
            assert (!str.empty()) : "Invalid string length";
            assert (radix == 10 || radix == 8 || radix == 16 || radix == 2 || radix == 36) : "Radix should be 2, 8, 10, 16, or 36!";
            char.ptr p = Native.$tryClone((char.ptr)str.begin());
            int slen = str.size();
            boolean bl = isNeg = p.$star() == NativePointer.$((char)'-');
            if (p.$star() == NativePointer.$((char)'-') || p.$star() == NativePointer.$((char)'+')) {
                p.$preInc();
                assert (--slen != 0) : "String is only a sign, needs a value.";
            }
            assert (slen <= numbits || radix != 2) : "Insufficient bit width";
            assert ((slen - 1) * 3 <= numbits || radix != 8) : "Insufficient bit width";
            assert ((slen - 1) * 4 <= numbits || radix != 16) : "Insufficient bit width";
            assert ((slen - 1) * 64 / 22 <= numbits || radix != 10) : "Insufficient bit width";
            if (!this.isSingleWord()) {
                this.pVal = (uint.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getClearedMemory(this.getNumWords()));
            }
            int shift = radix == 16 ? 4 : (radix == 8 ? 3 : (radix == 2 ? 1 : 0));
            apdigit = new APInt<T>(this.getBitWidth(), 0L);
            apradix = new APInt<T>(this.getBitWidth(), (long)radix);
            char.ptr e = Native.$tryClone((char.ptr)str.end());
            while (p.$noteq((Object)e)) {
                int digit = APIntStatics.getDigit(p.$star(), radix);
                assert (digit < radix) : "Invalid character in digit string";
                if (slen > 1) {
                    if (shift != 0) {
                        this.$lshiftassign(shift);
                    } else {
                        this.$starassign(apradix);
                    }
                }
                if (apdigit.isSingleWord()) {
                    apdigit.VAL = digit;
                } else {
                    apdigit.pVal.$set(0, (long)digit);
                }
                this.$addassign(apdigit);
                p.$preInc();
            }
            if (isNeg) {
                this.$preDec();
                this.flipAllBits();
            }
        }
        finally {
            if (apradix != null) {
                apradix.$destroy();
            }
            if (apdigit != null) {
                apdigit.$destroy();
            }
        }
    }

    private static void divide(APInt LHS, int lhsWords, APInt RHS, int rhsWords, APInt Quotient, APInt Remainder) {
        long tmp;
        int i;
        assert (lhsWords >= 0) : "must be non negative " + lhsWords;
        assert (rhsWords >= 0) : "must be non negative " + rhsWords;
        assert (lhsWords >= rhsWords) : "Fractional result";
        long mask = -1L >> NativeType.sizeof(Long.TYPE) * 8;
        int n = rhsWords * 2;
        int m = lhsWords * 2 - n;
        uint.ptr SPACE = NativePointer.create_uint$ptr((long[])NativePointer.new$uint((int)128));
        uint.ptr U = null;
        uint.ptr V = null;
        uint.ptr Q = null;
        uint.ptr R = null;
        if ((Remainder != null ? 4 : 3) * n + 2 * m + 1 <= 128) {
            U = (uint.ptr)SPACE.$add(0);
            V = (uint.ptr)SPACE.$add(m + n + 1);
            Q = (uint.ptr)SPACE.$add(m + n + 1 + n);
            if (Remainder != null) {
                R = (uint.ptr)SPACE.$add(m + n + 1 + n + (m + n));
            }
        } else {
            U = NativePointer.create_uint$ptr((long[])NativePointer.new$uint((int)(m + n + 1)));
            V = NativePointer.create_uint$ptr((long[])NativePointer.new$uint((int)n));
            Q = NativePointer.create_uint$ptr((long[])NativePointer.new$uint((int)(m + n)));
            if (Remainder != null) {
                R = NativePointer.create_uint$ptr((long[])NativePointer.new$uint((int)n));
            }
        }
        std.memset((uint.ptr)U, (long)0L, (int)((m + n + 1) * NativeType.sizeof(Long.TYPE)));
        for (i = 0; i < lhsWords; ++i) {
            tmp = LHS.getNumWords() == 1 ? LHS.VAL : LHS.pVal.$at(i);
            U.$set(i * 2, tmp & mask);
            U.$set(i * 2 + 1, tmp >> NativeType.sizeof(Long.TYPE) * 8);
        }
        U.$set(m + n, 0L);
        std.memset((uint.ptr)V, (long)0L, (int)(n * NativeType.sizeof(Long.TYPE)));
        for (i = 0; i < rhsWords; ++i) {
            tmp = RHS.getNumWords() == 1 ? RHS.VAL : RHS.pVal.$at(i);
            V.$set(i * 2, tmp & mask);
            V.$set(i * 2 + 1, tmp >> NativeType.sizeof(Long.TYPE) * 8);
        }
        std.memset((uint.ptr)Q, (long)0L, (int)((m + n) * NativeType.sizeof(Long.TYPE)));
        if (Remainder != null) {
            std.memset((uint.ptr)R, (long)0L, (int)(n * NativeType.sizeof(Long.TYPE)));
        }
        for (i = n; i > 0 && V.$at(i - 1) == 0L; --i) {
            --n;
            ++m;
        }
        for (i = m + n; i > 0 && U.$at(i - 1) == 0L; --i) {
            --m;
        }
        assert (n != 0) : "Divide by zero?";
        if (n == 1) {
            long divisor = V.$at(0);
            long remainder = 0L;
            for (int i2 = m + n - 1; i2 >= 0; --i2) {
                long partial_dividend = remainder << 32 | U.$at(i2);
                if (partial_dividend == 0L) {
                    Q.$set(i2, 0L);
                    remainder = 0L;
                    continue;
                }
                if (partial_dividend < divisor) {
                    Q.$set(i2, 0L);
                    remainder = partial_dividend;
                    continue;
                }
                if (partial_dividend == divisor) {
                    Q.$set(i2, 1L);
                    remainder = 0L;
                    continue;
                }
                Q.$set(i2, partial_dividend / divisor);
                remainder = partial_dividend - Q.$at(i2) * divisor;
            }
            if (R != null) {
                R.$set(0, remainder);
            }
        } else {
            APIntStatics.KnuthDiv(U, V, Q, R, m, n);
        }
        if (Quotient != null) {
            if (Quotient.BitWidth != LHS.BitWidth) {
                if (Quotient.isSingleWord()) {
                    Quotient.VAL = 0L;
                } else {
                    Destructors.$destroyArray((Object)Quotient.pVal);
                }
                Quotient.BitWidth = LHS.BitWidth;
                if (!Quotient.isSingleWord()) {
                    Quotient.pVal = (uint.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getClearedMemory(Quotient.getNumWords()));
                }
            } else {
                Quotient.clearAllBits();
            }
            if (lhsWords == 1) {
                long tmp2 = Q.$at(0) | Q.$at(1) << APINT_BITS_PER_WORD / 2;
                if (Quotient.isSingleWord()) {
                    Quotient.VAL = tmp2;
                } else {
                    Quotient.pVal.$set(0, tmp2);
                }
            } else {
                assert (!Quotient.isSingleWord()) : "Quotient APInt not large enough";
                for (int i3 = 0; i3 < lhsWords; ++i3) {
                    Quotient.pVal.$set(i3, Q.$at(i3 * 2) | Q.$at(i3 * 2 + 1) << APINT_BITS_PER_WORD / 2);
                }
            }
        }
        if (Remainder != null) {
            if (Remainder.BitWidth != RHS.BitWidth) {
                if (Remainder.isSingleWord()) {
                    Remainder.VAL = 0L;
                } else {
                    Destructors.$destroyArray((Object)Remainder.pVal);
                }
                Remainder.BitWidth = RHS.BitWidth;
                if (!Remainder.isSingleWord()) {
                    Remainder.pVal = (uint.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getClearedMemory(Remainder.getNumWords()));
                }
            } else {
                Remainder.clearAllBits();
            }
            if (rhsWords == 1) {
                long tmp3 = R.$at(0) | R.$at(1) << APINT_BITS_PER_WORD / 2;
                if (Remainder.isSingleWord()) {
                    Remainder.VAL = tmp3;
                } else {
                    Remainder.pVal.$set(0, tmp3);
                }
            } else {
                assert (!Remainder.isSingleWord()) : "Remainder APInt not large enough";
                for (int i4 = 0; i4 < rhsWords; ++i4) {
                    Remainder.pVal.$set(i4, R.$at(i4 * 2) | R.$at(i4 * 2 + 1) << APINT_BITS_PER_WORD / 2);
                }
            }
        }
        if (U.$noteq((Object)SPACE.$at(0))) {
            Destructors.$destroyArray((Object)U);
            Destructors.$destroyArray((Object)V);
            Destructors.$destroyArray((Object)Q);
            Destructors.$destroyArray((Object)R);
        }
    }

    private void initSlowCase(int numBits, long val, boolean isSigned) {
        assert (numBits >= 0) : "must be non negative " + numBits;
        this.pVal = (uint.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getClearedMemory(APInt.getNumWords(numBits)));
        this.pVal.$set(0, val);
        if (isSigned && val < 0L) {
            for (int i = 1; i < APInt.getNumWords(numBits); ++i) {
                this.pVal.$set(i, -1L);
            }
        }
    }

    private void initFromArray(ArrayRefUInt bigVal) {
        assert (this.BitWidth != 0) : "Bitwidth too small";
        assert (bigVal.data() != null) : "Null pointer detected!";
        if (this.isSingleWord()) {
            this.VAL = bigVal.$at(0);
        } else {
            this.pVal = (uint.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getClearedMemory(this.getNumWords()));
            int words = std.min((int)bigVal.size(), (int)this.getNumWords());
            std.memcpy((uint.ptr)this.pVal, (uint.ptr)bigVal.data(), (int)(words * APINT_WORD_SIZE));
        }
        this.clearUnusedBits();
    }

    private void initSlowCase(APInt that) {
        this.pVal = (uint.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getMemory(this.getNumWords()));
        std.memcpy((uint.ptr)this.pVal, (uint.ptr)that.pVal, (int)(this.getNumWords() * APINT_WORD_SIZE));
    }

    private APInt shlSlowCase(int shiftAmt) {
        int i;
        assert (shiftAmt >= 0) : "must be non negative " + shiftAmt;
        if (shiftAmt == this.BitWidth) {
            return new APInt<T>(this.BitWidth, 0L);
        }
        if (shiftAmt == 0) {
            return this;
        }
        uint.ptr val = NativePointer.create_uint$ptr((long[])NativePointer.new$uint((int)this.getNumWords()));
        if (shiftAmt < APINT_BITS_PER_WORD) {
            long carry = 0L;
            for (int i2 = 0; i2 < this.getNumWords(); ++i2) {
                val.$set(i2, this.pVal.$at(i2) << shiftAmt | carry);
                carry = this.pVal.$at(i2) >>> APINT_BITS_PER_WORD - shiftAmt;
            }
            APInt<T> Result = new APInt<T>(val, this.BitWidth);
            super.clearUnusedBits();
            return Result;
        }
        int wordShift = shiftAmt % APINT_BITS_PER_WORD;
        int offset = shiftAmt / APINT_BITS_PER_WORD;
        if (wordShift == 0) {
            int i3;
            for (i3 = 0; i3 < offset; ++i3) {
                val.$set(i3, 0L);
            }
            for (i3 = offset; i3 < this.getNumWords(); ++i3) {
                val.$set(i3, this.pVal.$at(i3 - offset));
            }
            APInt<T> Result = new APInt<T>(val, this.BitWidth);
            super.clearUnusedBits();
            return Result;
        }
        for (i = this.getNumWords() - 1; i > offset; --i) {
            val.$set(i, this.pVal.$at(i - offset) << wordShift | this.pVal.$at(i - offset - 1) >>> APINT_BITS_PER_WORD - wordShift);
        }
        val.$set(offset, this.pVal.$at(0) << wordShift);
        for (i = 0; i < offset; ++i) {
            val.$set(i, 0L);
        }
        APInt<T> Result = new APInt<T>(val, this.BitWidth);
        super.clearUnusedBits();
        return Result;
    }

    private APInt AndSlowCase(APInt RHS) {
        int numWords = this.getNumWords();
        uint.ptr val = (uint.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getMemory(numWords));
        for (int i = 0; i < numWords; ++i) {
            val.$set(i, this.pVal.$at(i) & RHS.pVal.$at(i));
        }
        return new APInt<T>(val, this.getBitWidth());
    }

    private APInt OrSlowCase(APInt RHS) {
        int numWords = this.getNumWords();
        uint.ptr val = (uint.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getMemory(numWords));
        for (int i = 0; i < numWords; ++i) {
            val.$set(i, this.pVal.$at(i) | RHS.pVal.$at(i));
        }
        return new APInt<T>(val, this.getBitWidth());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APInt XorSlowCase(APInt RHS) {
        APInt<T> Result = null;
        try {
            int numWords = this.getNumWords();
            uint.ptr val = (uint.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getMemory(numWords));
            for (int i = 0; i < numWords; ++i) {
                val.$set(i, this.pVal.$at(i) ^ RHS.pVal.$at(i));
            }
            Result = new APInt<T>(val, this.getBitWidth());
            super.clearUnusedBits();
            APInt<T> aPInt = new APInt<T>(Result);
            return aPInt;
        }
        finally {
            if (Result != null) {
                Result.$destroy();
            }
        }
    }

    private APInt AssignSlowCase(APInt RHS) {
        if (this == RHS) {
            return this;
        }
        if (this.BitWidth == RHS.getBitWidth()) {
            assert (!this.isSingleWord());
            std.memcpy((uint.ptr)this.pVal, (uint.ptr)RHS.pVal, (int)(this.getNumWords() * APINT_WORD_SIZE));
            return this;
        }
        if (this.isSingleWord()) {
            assert (!RHS.isSingleWord());
            this.VAL = 0L;
            this.pVal = (uint.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getMemory(RHS.getNumWords()));
            std.memcpy((uint.ptr)this.pVal, (uint.ptr)RHS.pVal, (int)(RHS.getNumWords() * APINT_WORD_SIZE));
        } else if (this.getNumWords() == RHS.getNumWords()) {
            std.memcpy((uint.ptr)this.pVal, (uint.ptr)RHS.pVal, (int)(RHS.getNumWords() * APINT_WORD_SIZE));
        } else if (RHS.isSingleWord()) {
            Destructors.$destroyArray((Object)this.pVal);
            this.VAL = RHS.VAL;
        } else {
            Destructors.$destroyArray((Object)this.pVal);
            this.pVal = (uint.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getMemory(RHS.getNumWords()));
            std.memcpy((uint.ptr)this.pVal, (uint.ptr)RHS.pVal, (int)(RHS.getNumWords() * APINT_WORD_SIZE));
        }
        this.BitWidth = RHS.BitWidth;
        return this.clearUnusedBits();
    }

    private boolean EqualSlowCase(APInt RHS) {
        int n2;
        int n1 = this.getActiveBits();
        if (n1 != (n2 = RHS.getActiveBits())) {
            return false;
        }
        if (n1 <= APINT_BITS_PER_WORD) {
            return this.pVal.$at(0) == RHS.pVal.$at(0);
        }
        for (int i = APInt.whichWord(n1 - 1); i >= 0; --i) {
            if (this.pVal.$at(i) == RHS.pVal.$at(i)) continue;
            return false;
        }
        return true;
    }

    private boolean EqualSlowCase(long Val) {
        int n = this.getActiveBits();
        if (n <= APINT_BITS_PER_WORD) {
            return this.pVal.$at(0) == Val;
        }
        return false;
    }

    private int countLeadingZerosSlowCase() {
        int Count;
        long MSWMask;
        int BitsInMSW = this.BitWidth % APINT_BITS_PER_WORD;
        if (BitsInMSW != 0) {
            MSWMask = (1L << BitsInMSW) - 1L;
        } else {
            MSWMask = -1L;
            BitsInMSW = APINT_BITS_PER_WORD;
        }
        int i = this.getNumWords();
        long MSW = this.pVal.$at(i - 1) & MSWMask;
        if (MSW != 0L) {
            Count = llvm.countLeadingZeros(MSW) - (APINT_BITS_PER_WORD - BitsInMSW);
        } else {
            Count = BitsInMSW;
            --i;
            while ((long)i > 0L) {
                if (this.pVal.$at(i - 1) == 0L) {
                    Count += APINT_BITS_PER_WORD;
                } else {
                    Count += llvm.countLeadingZeros(this.pVal.$at(i - 1));
                    break;
                }
                --i;
            }
        }
        assert (Count >= 0) : "must be non negative " + Count;
        return Count;
    }

    private int countTrailingOnesSlowCase() {
        int i;
        int Count = 0;
        for (i = 0; i < this.getNumWords() && this.pVal.$at(i) == -1L; ++i) {
            Count += APINT_BITS_PER_WORD;
        }
        if (i < this.getNumWords()) {
            Count += llvm.CountTrailingOnes_64(this.pVal.$at(i));
        }
        Count = std.min((int)Count, (int)this.BitWidth);
        assert (Count >= 0) : "must be non negative " + Count;
        return Count;
    }

    private int countPopulationSlowCase() {
        int Count = 0;
        for (int i = 0; i < this.getNumWords(); ++i) {
            Count += llvm.CountPopulation_64(this.pVal.$at(i));
        }
        assert (Count >= 0) : "must be non negative " + Count;
        return Count;
    }

    public APInt(JavaDifferentiators.Uint_uint64_t _dparam, int numBits, long val) {
        this(_dparam, numBits, val, false);
    }

    public APInt(JavaDifferentiators.Uint_uint64_t _dparam, int numBits, long val, boolean isSigned) {
        assert (numBits >= 0) : "must be non negative " + numBits;
        this.BitWidth = numBits;
        this.VAL = 0L;
        assert (this.BitWidth != 0) : "bitwidth too small";
        if (this.isSingleWord()) {
            this.VAL = val;
        } else {
            this.initSlowCase(numBits, val, isSigned);
        }
        this.clearUnusedBits();
    }

    public APInt(int numBits, long val) {
        this(JavaDifferentiators.Uint_uint64_t.INSTANCE, numBits, val);
    }

    public APInt(int numBits, long val, boolean isSigned) {
        this(JavaDifferentiators.Uint_uint64_t.INSTANCE, numBits, val, isSigned);
    }

    public APInt(int numBits, ArrayRefUInt bigVal) {
        this.BitWidth = numBits;
        this.VAL = 0L;
        this.initFromArray(bigVal);
    }

    public APInt(JavaDifferentiators.Uint_uint _dparam, int numBits, int numWords, long[] bigVal) {
        assert (numBits >= 0) : "must be non negative " + numBits;
        assert (numWords >= 0) : "must be non negative " + numWords;
        this.BitWidth = numBits;
        this.VAL = 0L;
        this.initFromArray(llvm.makeArrayRef(bigVal, numWords));
    }

    public APInt(int numBits, int numWords, long[] bigVal) {
        this(JavaDifferentiators.Uint_uint.INSTANCE, numBits, numWords, bigVal);
    }

    public APInt(int numbits, StringRef Str, int radix) {
        assert (numbits >= 0) : "must be non negative " + numbits;
        assert (radix >= 0) : "must be non negative " + radix;
        this.BitWidth = numbits;
        this.VAL = 0L;
        assert (this.BitWidth != 0) : "Bitwidth too small";
        this.fromString(numbits, Str, radix);
    }

    public APInt(int numbits, CharSequence Str, int radix) {
        this(numbits, new StringRef(Str), radix);
    }

    public APInt(APInt that) {
        this.BitWidth = that.BitWidth;
        this.VAL = 0L;
        if (this.isSingleWord()) {
            this.VAL = that.VAL;
        } else {
            this.initSlowCase(that);
        }
    }

    public void $destroy() {
        if (this.needsCleanup()) {
            Destructors.$destroyArray((Object)this.pVal);
        }
    }

    public APInt() {
        this.BitWidth = 1;
    }

    public boolean needsCleanup() {
        return !this.isSingleWord();
    }

    public void Profile(FoldingSetNodeID ID) {
        ID.AddInteger(this.BitWidth);
        if (this.isSingleWord()) {
            ID.AddInteger(this.VAL);
            return;
        }
        int NumWords = this.getNumWords();
        for (int i = 0; i < NumWords; ++i) {
            ID.AddInteger(this.pVal.$at(i));
        }
    }

    public boolean isNegative() {
        return this.$at(this.BitWidth - 1);
    }

    public boolean isNonNegative() {
        return !this.isNegative();
    }

    public boolean isStrictlyPositive() {
        return this.isNonNegative() && !this.$not();
    }

    public boolean isAllOnesValue() {
        if (this.isSingleWord()) {
            return this.VAL == -1L >> APINT_BITS_PER_WORD - this.BitWidth;
        }
        return this.countPopulationSlowCase() == this.BitWidth;
    }

    public boolean isMaxValue() {
        return this.isAllOnesValue();
    }

    public boolean isMaxSignedValue() {
        return this.BitWidth == 1 ? this.VAL == 0L : !this.isNegative() && this.countPopulation() == this.BitWidth - 1;
    }

    public boolean isMinValue() {
        return this.$not();
    }

    public boolean isMinSignedValue() {
        return this.BitWidth == 1 ? this.VAL == 1L : this.isNegative() && this.isPowerOf2();
    }

    public boolean isIntN(int N) {
        assert (N >= 0) : "must be non negative " + N;
        assert (N != 0) : "N == 0 ???";
        return this.getActiveBits() <= N;
    }

    public boolean isSignedIntN(int N) {
        assert (N >= 0) : "must be non negative " + N;
        assert (N != 0) : "N == 0 ???";
        return this.getMinSignedBits() <= N;
    }

    public boolean isPowerOf2() {
        if (this.isSingleWord()) {
            return llvm.isPowerOf2_64(this.VAL);
        }
        return this.countPopulationSlowCase() == 1;
    }

    public boolean isSignBit() {
        return this.isMinSignedValue();
    }

    public boolean getBoolValue() {
        return !this.$not();
    }

    public long getLimitedValue() {
        return this.getLimitedValue(-1L);
    }

    public long getLimitedValue(long Limit) {
        return this.getActiveBits() > 64 || Unsigned.compare((long)this.getZExtValue(), (long)Limit) > 0L ? Limit : this.getZExtValue();
    }

    public static APInt getMaxValue(int numBits) {
        assert (numBits >= 0) : "must be non negative " + numBits;
        return APInt.getAllOnesValue(numBits);
    }

    public static APInt getSignedMaxValue(int numBits) {
        assert (numBits >= 0) : "must be non negative " + numBits;
        APInt API = APInt.getAllOnesValue(numBits);
        API.clearBit(numBits - 1);
        return API;
    }

    public static APInt getMinValue(int numBits) {
        assert (numBits >= 0) : "must be non negative " + numBits;
        return new APInt(numBits, 0L);
    }

    public static APInt getSignedMinValue(int numBits) {
        assert (numBits >= 0) : "must be non negative " + numBits;
        APInt API = null;
        try {
            API = new APInt(numBits, 0L);
            API.setBit(numBits - 1);
            APInt aPInt = API;
            return aPInt;
        }
        finally {
            if (API != null) {
                API.$destroy();
            }
        }
    }

    public static APInt getSignBit(int BitWidth) {
        assert (BitWidth >= 0) : "must be non negative " + BitWidth;
        return APInt.getSignedMinValue(BitWidth);
    }

    public static APInt getAllOnesValue(int numBits) {
        assert (numBits >= 0) : "must be non negative " + numBits;
        return new APInt(numBits, -1L, true);
    }

    public static APInt getNullValue(int numBits) {
        assert (numBits >= 0) : "must be non negative " + numBits;
        return new APInt(numBits, 0L);
    }

    public APInt getHiBits(int numBits) {
        assert (numBits >= 0) : "must be non negative " + numBits;
        return APIntOps.lshr(this, this.BitWidth - numBits);
    }

    public APInt getLoBits(int numBits) {
        assert (numBits >= 0) : "must be non negative " + numBits;
        return APIntOps.lshr(APIntOps.shl(this, this.BitWidth - numBits), this.BitWidth - numBits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static APInt getOneBitSet(int numBits, int BitNo) {
        assert (numBits >= 0) : "must be non negative " + numBits;
        assert (BitNo >= 0) : "must be non negative " + BitNo;
        APInt Res = null;
        try {
            Res = new APInt(numBits, 0L);
            Res.setBit(BitNo);
            APInt aPInt = Res;
            return aPInt;
        }
        finally {
            if (Res != null) {
                Res.$destroy();
            }
        }
    }

    public static APInt getBitsSet(int numBits, int loBit, int hiBit) {
        assert (numBits >= 0) : "must be non negative " + numBits;
        assert (loBit >= 0) : "must be non negative " + loBit;
        assert (hiBit >= 0) : "must be non negative " + hiBit;
        assert (hiBit <= numBits) : "hiBit out of range";
        assert (loBit < numBits) : "loBit out of range";
        if (hiBit < loBit) {
            return APInt.getLowBitsSet(numBits, hiBit).$bitor(APInt.getHighBitsSet(numBits, numBits - loBit));
        }
        return APInt.getLowBitsSet(numBits, hiBit - loBit).shl(loBit);
    }

    public static APInt getHighBitsSet(int numBits, int hiBitsSet) {
        assert (numBits >= 0) : "must be non negative " + numBits;
        assert (hiBitsSet >= 0) : "must be non negative " + hiBitsSet;
        assert (hiBitsSet <= numBits) : "Too many bits to set!";
        if (hiBitsSet == 0) {
            return new APInt(numBits, 0L);
        }
        int shiftAmt = numBits - hiBitsSet;
        if (numBits <= APINT_BITS_PER_WORD) {
            return new APInt(numBits, -1L << shiftAmt);
        }
        return APInt.getAllOnesValue(numBits).shl(shiftAmt);
    }

    public static APInt getLowBitsSet(int numBits, int loBitsSet) {
        assert (numBits >= 0) : "must be non negative " + numBits;
        assert (loBitsSet >= 0) : "must be non negative " + loBitsSet;
        assert (loBitsSet <= numBits) : "Too many bits to set!";
        if (loBitsSet == 0) {
            return new APInt(numBits, 0L);
        }
        if (loBitsSet == APINT_BITS_PER_WORD) {
            return new APInt(numBits, -1L);
        }
        if (loBitsSet <= APINT_BITS_PER_WORD) {
            return new APInt(numBits, -1L >> APINT_BITS_PER_WORD - loBitsSet);
        }
        return APInt.getAllOnesValue(numBits).lshr(numBits - loBitsSet);
    }

    public static APInt getSplat(int NewLen, APInt V) {
        assert (NewLen >= 0) : "must be non negative " + NewLen;
        assert (NewLen >= V.getBitWidth()) : "Can't splat to smaller bit width!";
        APInt Val = V.zextOrSelf(NewLen);
        for (int I = V.getBitWidth(); I < NewLen; I <<= 1) {
            Val.$orassign(Val.$out(I));
        }
        return Val;
    }

    public static boolean isSameValue(APInt I1, APInt I2) {
        if (I1.getBitWidth() == I2.getBitWidth()) {
            return I1.$eq(I2);
        }
        if (I1.getBitWidth() > I2.getBitWidth()) {
            return I1.$eq(I2.zext(I1.getBitWidth()));
        }
        return I1.zext(I2.getBitWidth()).$eq(I2);
    }

    public uint.ptr getRawData() {
        if (this.isSingleWord()) {
            return NativePointer.create_uint$ptr((long)this.VAL);
        }
        return (uint.ptr)this.pVal.$add(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APInt $postInc(int $Prm0) {
        APInt<T> API = null;
        try {
            API = new APInt<T>(this);
            this.$preInc();
            APInt<T> aPInt = API;
            return aPInt;
        }
        finally {
            if (API != null) {
                API.$destroy();
            }
        }
    }

    public APInt $preInc() {
        if (this.isSingleWord()) {
            ++this.VAL;
        } else {
            APIntStatics.add_1(this.pVal, this.pVal, this.getNumWords(), 1L);
        }
        return this.clearUnusedBits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APInt $postDec(int $Prm0) {
        APInt<T> API = null;
        try {
            API = new APInt<T>(this);
            this.$preDec();
            APInt<T> aPInt = API;
            return aPInt;
        }
        finally {
            if (API != null) {
                API.$destroy();
            }
        }
    }

    public APInt $preDec() {
        if (this.isSingleWord()) {
            --this.VAL;
        } else {
            APIntStatics.sub_1(this.pVal, this.getNumWords(), 1L);
        }
        return this.clearUnusedBits();
    }

    public APInt $bitnot() {
        APInt<T> Result = null;
        try {
            Result = new APInt<T>(this);
            Result.flipAllBits();
            APInt<T> aPInt = Result;
            return aPInt;
        }
        finally {
            if (Result != null) {
                Result.$destroy();
            }
        }
    }

    public APInt $minus() {
        return new APInt<T>(this.BitWidth, 0L).$minus(this);
    }

    public boolean $not() {
        if (this.isSingleWord()) {
            return this.VAL == 0L;
        }
        for (int i = 0; i != this.getNumWords(); ++i) {
            if (this.pVal.$at(i) == 0L) continue;
            return false;
        }
        return true;
    }

    public APInt $assign(APInt RHS) {
        if (this.isSingleWord() && RHS.isSingleWord()) {
            this.VAL = RHS.VAL;
            this.BitWidth = RHS.BitWidth;
            return this.clearUnusedBits();
        }
        return this.AssignSlowCase(RHS);
    }

    public APInt $assignMove(APInt that) {
        if (!this.isSingleWord()) {
            if (this == that) {
                return this;
            }
            Destructors.$destroyArray((Object)this.pVal);
        }
        this.VAL = that.VAL;
        this.pVal = that.pVal;
        int ThatBitWidth = that.BitWidth;
        that.BitWidth = 0;
        this.BitWidth = ThatBitWidth;
        return this;
    }

    public APInt $assign(long RHS) {
        if (this.isSingleWord()) {
            this.VAL = RHS;
        } else {
            this.pVal.$set(0, RHS);
            std.memset((uint.ptr)((uint.ptr)this.pVal.$add(1)), (long)0L, (int)((this.getNumWords() - 1) * APINT_WORD_SIZE));
        }
        return this.clearUnusedBits();
    }

    public APInt $assign(boolean RHS) {
        return this.$assign(RHS ? 1L : 0L);
    }

    public APInt $andassign(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            this.VAL &= RHS.VAL;
            return this;
        }
        int numWords = this.getNumWords();
        for (int i = 0; i < numWords; ++i) {
            this.pVal.$set$andassign(i, RHS.pVal.$at(i));
        }
        return this;
    }

    public APInt $orassign(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            this.VAL |= RHS.VAL;
            return this;
        }
        int numWords = this.getNumWords();
        for (int i = 0; i < numWords; ++i) {
            this.pVal.$set$orassign(i, RHS.pVal.$at(i));
        }
        return this;
    }

    public APInt $orassign(long RHS) {
        if (this.isSingleWord()) {
            this.VAL |= RHS;
            this.clearUnusedBits();
        } else {
            this.pVal.$set$orassign(0, RHS);
        }
        return this;
    }

    public APInt $xorassign(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            this.VAL ^= RHS.VAL;
            this.clearUnusedBits();
            return this;
        }
        int numWords = this.getNumWords();
        for (int i = 0; i < numWords; ++i) {
            this.pVal.$set$xorassign(i, RHS.pVal.$at(i));
        }
        return this.clearUnusedBits();
    }

    public APInt $starassign(APInt RHS) {
        int rhsWords;
        int lhsWords;
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            this.VAL *= RHS.VAL;
            this.clearUnusedBits();
            return this;
        }
        int lhsBits = this.getActiveBits();
        int n = lhsWords = lhsBits == 0 ? 0 : APInt.whichWord(lhsBits - 1) + 1;
        if (lhsWords == 0) {
            return this;
        }
        int rhsBits = RHS.getActiveBits();
        int n2 = rhsWords = rhsBits == 0 ? 0 : APInt.whichWord(rhsBits - 1) + 1;
        if (rhsWords == 0) {
            this.clearAllBits();
            return this;
        }
        int destWords = rhsWords + lhsWords;
        uint.ptr dest = (uint.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getMemory(destWords));
        APIntStatics.mul(dest, this.pVal, lhsWords, RHS.pVal, rhsWords);
        this.clearAllBits();
        int wordsToCopy = destWords >= this.getNumWords() ? this.getNumWords() : destWords;
        std.memcpy((uint.ptr)this.pVal, (uint.ptr)dest, (int)(wordsToCopy * APINT_WORD_SIZE));
        this.clearUnusedBits();
        Destructors.$destroyArray((Object)dest);
        return this;
    }

    public APInt $addassign(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            this.VAL += RHS.VAL;
        } else {
            APIntStatics.add(this.pVal, this.pVal, RHS.pVal, this.getNumWords());
        }
        return this.clearUnusedBits();
    }

    public APInt $minusassign(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            this.VAL -= RHS.VAL;
        } else {
            APIntStatics.sub(this.pVal, this.pVal, RHS.pVal, this.getNumWords());
        }
        return this.clearUnusedBits();
    }

    public APInt $lshiftassign(int shiftAmt) {
        assert (shiftAmt >= 0) : "must be non negative " + shiftAmt;
        this.$assign(this.shl(shiftAmt));
        return this;
    }

    public APInt $bitand(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            return new APInt<T>(this.getBitWidth(), this.VAL & RHS.VAL);
        }
        return this.AndSlowCase(RHS);
    }

    public APInt And(APInt RHS) {
        return this.$bitand(RHS);
    }

    public APInt $bitor(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            return new APInt<T>(this.getBitWidth(), this.VAL | RHS.VAL);
        }
        return this.OrSlowCase(RHS);
    }

    public APInt Or(APInt RHS) {
        return this.$bitor(RHS);
    }

    public APInt $bitxor(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            return new APInt<T>(this.BitWidth, this.VAL ^ RHS.VAL);
        }
        return this.XorSlowCase(RHS);
    }

    public APInt Xor(APInt RHS) {
        return this.$bitxor(RHS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APInt $star(APInt RHS) {
        APInt<T> Result = null;
        try {
            assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
            if (this.isSingleWord()) {
                APInt<T> aPInt = new APInt<T>(this.BitWidth, this.VAL * RHS.VAL);
                return aPInt;
            }
            Result = new APInt<T>(this);
            Result.$starassign(RHS);
            APInt<T> aPInt = Result;
            return aPInt;
        }
        finally {
            if (Result != null) {
                Result.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APInt $plus(APInt RHS) {
        APInt<T> Result = null;
        try {
            assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
            if (this.isSingleWord()) {
                APInt<T> aPInt = new APInt<T>(this.BitWidth, this.VAL + RHS.VAL);
                return aPInt;
            }
            Result = new APInt<T>(this.BitWidth, 0L);
            APIntStatics.add(Result.pVal, this.pVal, RHS.pVal, this.getNumWords());
            super.clearUnusedBits();
            APInt<T> aPInt = new APInt<T>(Result);
            return aPInt;
        }
        finally {
            if (Result != null) {
                Result.$destroy();
            }
        }
    }

    public APInt $plus(long RHS) {
        return this.$plus(new APInt<T>(this.BitWidth, RHS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APInt $minus(APInt RHS) {
        APInt<T> Result = null;
        try {
            assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
            if (this.isSingleWord()) {
                APInt<T> aPInt = new APInt<T>(this.BitWidth, this.VAL - RHS.VAL);
                return aPInt;
            }
            Result = new APInt<T>(this.BitWidth, 0L);
            APIntStatics.sub(Result.pVal, this.pVal, RHS.pVal, this.getNumWords());
            super.clearUnusedBits();
            APInt<T> aPInt = new APInt<T>(Result);
            return aPInt;
        }
        finally {
            if (Result != null) {
                Result.$destroy();
            }
        }
    }

    public APInt $minus(long RHS) {
        return this.$minus(new APInt<T>(this.BitWidth, RHS));
    }

    public APInt $out(int Bits) {
        return this.shl(Bits);
    }

    public APInt $out(APInt Bits) {
        return this.shl(Bits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APInt ashr(int shiftAmt) {
        assert (shiftAmt >= 0) : "must be non negative " + shiftAmt;
        APInt<T> Result = null;
        try {
            int i;
            assert (shiftAmt <= this.BitWidth) : "Invalid shift amount";
            if (shiftAmt == 0) {
                APInt aPInt = this;
                return aPInt;
            }
            if (this.isSingleWord()) {
                if (shiftAmt == this.BitWidth) {
                    APInt<T> aPInt = new APInt<T>(this.BitWidth, 0L);
                    return aPInt;
                }
                int SignBit = APINT_BITS_PER_WORD - this.BitWidth;
                APInt<T> aPInt = new APInt<T>(this.BitWidth, this.VAL << SignBit >> SignBit >> shiftAmt);
                return aPInt;
            }
            if (shiftAmt == this.BitWidth) {
                if (this.isNegative()) {
                    APInt<T> SignBit = new APInt<T>(this.BitWidth, -1L, true);
                    return SignBit;
                }
                APInt<T> SignBit = new APInt<T>(this.BitWidth, 0L);
                return SignBit;
            }
            uint.ptr val = NativePointer.create_uint$ptr((long[])NativePointer.new$uint((int)this.getNumWords()));
            int wordShift = shiftAmt % APINT_BITS_PER_WORD;
            int offset = shiftAmt / APINT_BITS_PER_WORD;
            int breakWord = this.getNumWords() - 1 - offset;
            int bitsInWord = APInt.whichBit(this.BitWidth);
            if (bitsInWord == 0) {
                bitsInWord = APINT_BITS_PER_WORD;
            }
            if (wordShift == 0) {
                for (i = 0; i <= breakWord; ++i) {
                    val.$set(i, this.pVal.$at(i + offset));
                }
                if (this.isNegative() && bitsInWord < APINT_BITS_PER_WORD) {
                    val.$set$orassign(breakWord, -1L << bitsInWord);
                }
            } else {
                for (i = 0; i < breakWord; ++i) {
                    val.$set(i, this.pVal.$at(i + offset) >> wordShift | this.pVal.$at(i + offset + 1) << APINT_BITS_PER_WORD - wordShift);
                }
                val.$set(breakWord, this.pVal.$at(breakWord + offset) >> wordShift);
                if (this.isNegative()) {
                    if (wordShift > bitsInWord) {
                        if (breakWord > 0) {
                            val.$set$orassign(breakWord - 1, -1L << APINT_BITS_PER_WORD - (wordShift - bitsInWord));
                        }
                        val.$set$orassign(breakWord, -1L);
                    } else {
                        val.$set$orassign(breakWord, -1L << bitsInWord - wordShift);
                    }
                }
            }
            long fillValue = this.isNegative() ? -1L : 0L;
            for (int i2 = breakWord + 1; i2 < this.getNumWords(); ++i2) {
                val.$set(i2, fillValue);
            }
            Result = new APInt<T>(val, this.BitWidth);
            super.clearUnusedBits();
            APInt<T> aPInt = new APInt<T>(Result);
            return aPInt;
        }
        finally {
            if (Result != null) {
                Result.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APInt lshr(int shiftAmt) {
        assert (shiftAmt >= 0) : "must be non negative " + shiftAmt;
        APInt<T> Result = null;
        try {
            int i;
            if (this.isSingleWord()) {
                if (shiftAmt >= this.BitWidth) {
                    APInt<T> aPInt = new APInt<T>(this.BitWidth, 0L);
                    return aPInt;
                }
                APInt<T> aPInt = new APInt<T>(this.BitWidth, this.VAL >>> shiftAmt);
                return aPInt;
            }
            if (shiftAmt >= this.BitWidth) {
                APInt<T> aPInt = new APInt<T>(this.BitWidth, 0L);
                return aPInt;
            }
            if (shiftAmt == 0) {
                APInt aPInt = this;
                return aPInt;
            }
            uint.ptr val = NativePointer.create_uint$ptr((long[])NativePointer.new$uint((int)this.getNumWords()));
            if (shiftAmt < APINT_BITS_PER_WORD) {
                APIntStatics.lshrNear(val, this.pVal, this.getNumWords(), shiftAmt);
                Result = new APInt<T>(val, this.BitWidth);
                super.clearUnusedBits();
                APInt<T> aPInt = new APInt<T>(Result);
                return aPInt;
            }
            int wordShift = shiftAmt % APINT_BITS_PER_WORD;
            int offset = shiftAmt / APINT_BITS_PER_WORD;
            if (wordShift == 0) {
                int i2;
                for (i2 = 0; i2 < this.getNumWords() - offset; ++i2) {
                    val.$set(i2, this.pVal.$at(i2 + offset));
                }
                for (i2 = this.getNumWords() - offset; i2 < this.getNumWords(); ++i2) {
                    val.$set(i2, 0L);
                }
                Result = new APInt<T>(val, this.BitWidth);
                super.clearUnusedBits();
                APInt<T> i3 = new APInt<T>(Result);
                return i3;
            }
            int breakWord = this.getNumWords() - offset - 1;
            for (i = 0; i < breakWord; ++i) {
                val.$set(i, this.pVal.$at(i + offset) >>> wordShift | this.pVal.$at(i + offset + 1) << APINT_BITS_PER_WORD - wordShift);
            }
            val.$set(breakWord, this.pVal.$at(breakWord + offset) >>> wordShift);
            for (i = breakWord + 1; i < this.getNumWords(); ++i) {
                val.$set(i, 0L);
            }
            Result = new APInt<T>(val, this.BitWidth);
            super.clearUnusedBits();
            APInt<T> aPInt = new APInt<T>(Result);
            return aPInt;
        }
        finally {
            if (Result != null) {
                Result.$destroy();
            }
        }
    }

    public APInt shl(int shiftAmt) {
        assert (shiftAmt >= 0) : "must be non negative " + shiftAmt;
        assert (shiftAmt <= this.BitWidth) : "Invalid shift amount";
        if (this.isSingleWord()) {
            if (shiftAmt >= this.BitWidth) {
                return new APInt<T>(this.BitWidth, 0L);
            }
            return new APInt<T>(this.BitWidth, this.VAL << shiftAmt);
        }
        return this.shlSlowCase(shiftAmt);
    }

    public APInt rotl(int rotateAmt) {
        assert (rotateAmt >= 0) : "must be non negative " + rotateAmt;
        if ((rotateAmt %= this.BitWidth) == 0) {
            return this;
        }
        return this.shl(rotateAmt).$bitor(this.lshr(this.BitWidth - rotateAmt));
    }

    public APInt rotr(int rotateAmt) {
        assert (rotateAmt >= 0) : "must be non negative " + rotateAmt;
        if ((rotateAmt %= this.BitWidth) == 0) {
            return this;
        }
        return this.lshr(rotateAmt).$bitor(this.shl(this.BitWidth - rotateAmt));
    }

    public APInt ashr(APInt shiftAmt) {
        return this.ashr((int)shiftAmt.getLimitedValue(this.BitWidth));
    }

    public APInt lshr(APInt shiftAmt) {
        return this.lshr((int)shiftAmt.getLimitedValue(this.BitWidth));
    }

    public APInt shl(APInt shiftAmt) {
        return this.shl((int)shiftAmt.getLimitedValue(this.BitWidth));
    }

    public APInt rotl(APInt rotateAmt) {
        return this.rotl((int)rotateAmt.getLimitedValue(this.BitWidth));
    }

    public APInt rotr(APInt rotateAmt) {
        return this.rotr((int)rotateAmt.getLimitedValue(this.BitWidth));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APInt udiv(APInt RHS) {
        APInt<T> Quotient = null;
        try {
            int lhsWords;
            int rhsWords;
            assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
            if (this.isSingleWord()) {
                assert (RHS.VAL != 0L) : "Divide by zero?";
                APInt<T> aPInt = new APInt<T>(this.BitWidth, Unsigned.divideUnsigned((long)this.VAL, (long)RHS.VAL));
                return aPInt;
            }
            int rhsBits = RHS.getActiveBits();
            int n = rhsWords = rhsBits == 0 ? 0 : APInt.whichWord(rhsBits - 1) + 1;
            assert (rhsWords != 0) : "Divided by zero???";
            int lhsBits = this.getActiveBits();
            int n2 = lhsWords = lhsBits == 0 ? 0 : APInt.whichWord(lhsBits - 1) + 1;
            if (lhsWords == 0) {
                APInt<T> aPInt = new APInt<T>(this.BitWidth, 0L);
                return aPInt;
            }
            if (lhsWords < rhsWords || this.ult(RHS)) {
                APInt<T> aPInt = new APInt<T>(this.BitWidth, 0L);
                return aPInt;
            }
            if (this.$eq(RHS)) {
                APInt<T> aPInt = new APInt<T>(this.BitWidth, 1L);
                return aPInt;
            }
            if (lhsWords == 1 && rhsWords == 1) {
                APInt<T> aPInt = new APInt<T>(this.BitWidth, this.pVal.$at(0) / RHS.pVal.$at(0));
                return aPInt;
            }
            Quotient = new APInt<T>(1, 0L);
            APInt.divide(this, lhsWords, RHS, rhsWords, Quotient, null);
            APInt<T> aPInt = Quotient;
            return aPInt;
        }
        finally {
            if (Quotient != null) {
                Quotient.$destroy();
            }
        }
    }

    public APInt sdiv(APInt RHS) {
        if (this.isNegative()) {
            if (RHS.isNegative()) {
                return this.$minus().udiv(RHS.$minus());
            }
            return this.$minus().udiv(RHS).$minus();
        }
        if (RHS.isNegative()) {
            return this.udiv(RHS.$minus()).$minus();
        }
        return this.udiv(RHS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APInt urem(APInt RHS) {
        APInt<T> Remainder = null;
        try {
            int rhsWords;
            assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
            if (this.isSingleWord()) {
                assert (RHS.VAL != 0L) : "Remainder by zero?";
                APInt<T> aPInt = new APInt<T>(this.BitWidth, Unsigned.remainderUnsigned((long)this.VAL, (long)RHS.VAL));
                return aPInt;
            }
            int lhsBits = this.getActiveBits();
            int lhsWords = lhsBits == 0 ? 0 : APInt.whichWord(lhsBits - 1) + 1;
            int rhsBits = RHS.getActiveBits();
            int n = rhsWords = rhsBits == 0 ? 0 : APInt.whichWord(rhsBits - 1) + 1;
            assert (rhsWords != 0) : "Performing remainder operation by zero ???";
            if (lhsWords == 0) {
                APInt<T> aPInt = new APInt<T>(this.BitWidth, 0L);
                return aPInt;
            }
            if (lhsWords < rhsWords || this.ult(RHS)) {
                APInt aPInt = this;
                return aPInt;
            }
            if (this.$eq(RHS)) {
                APInt<T> aPInt = new APInt<T>(this.BitWidth, 0L);
                return aPInt;
            }
            if (lhsWords == 1) {
                APInt<T> aPInt = new APInt<T>(this.BitWidth, this.pVal.$at(0) % RHS.pVal.$at(0));
                return aPInt;
            }
            Remainder = new APInt<T>(1, 0L);
            APInt.divide(this, lhsWords, RHS, rhsWords, null, Remainder);
            APInt<T> aPInt = Remainder;
            return aPInt;
        }
        finally {
            if (Remainder != null) {
                Remainder.$destroy();
            }
        }
    }

    public APInt srem(APInt RHS) {
        if (this.isNegative()) {
            if (RHS.isNegative()) {
                return this.$minus().urem(RHS.$minus()).$minus();
            }
            return this.$minus().urem(RHS).$minus();
        }
        if (RHS.isNegative()) {
            return this.urem(RHS.$minus());
        }
        return this.urem(RHS);
    }

    public static void udivrem(APInt LHS, APInt RHS, APInt Quotient, APInt Remainder) {
        int rhsWords;
        assert (LHS.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (LHS.isSingleWord()) {
            assert (RHS.VAL != 0L) : "Divide by zero?";
            long QuotVal = LHS.VAL / RHS.VAL;
            long RemVal = LHS.VAL % RHS.VAL;
            Quotient.$assign(new APInt(LHS.BitWidth, QuotVal));
            Remainder.$assign(new APInt(LHS.BitWidth, RemVal));
            return;
        }
        int lhsBits = LHS.getActiveBits();
        int lhsWords = lhsBits == 0 ? 0 : APInt.whichWord(lhsBits - 1) + 1;
        int rhsBits = RHS.getActiveBits();
        int n = rhsWords = rhsBits == 0 ? 0 : APInt.whichWord(rhsBits - 1) + 1;
        if (lhsWords == 0) {
            Quotient.$assign(0L);
            Remainder.$assign(0L);
            return;
        }
        if (lhsWords < rhsWords || LHS.ult(RHS)) {
            Remainder.$assign(LHS);
            Quotient.$assign(0L);
            return;
        }
        if (LHS.$eq(RHS)) {
            Quotient.$assign(1L);
            Remainder.$assign(0L);
            return;
        }
        if (lhsWords == 1 && rhsWords == 1) {
            long lhsValue = LHS.isSingleWord() ? LHS.VAL : LHS.pVal.$at(0);
            long rhsValue = RHS.isSingleWord() ? RHS.VAL : RHS.pVal.$at(0);
            Quotient.$assign(new APInt(LHS.getBitWidth(), lhsValue / rhsValue));
            Remainder.$assign(new APInt(LHS.getBitWidth(), lhsValue % rhsValue));
            return;
        }
        APInt.divide(LHS, lhsWords, RHS, rhsWords, Quotient, Remainder);
    }

    public APInt sshl_ov(APInt ShAmt, bool.ref Overflow) {
        Overflow.$set(ShAmt.uge(this.getBitWidth()));
        if (Overflow.$deref()) {
            return new APInt<T>(this.BitWidth, 0L);
        }
        if (this.isNonNegative()) {
            Overflow.$set(ShAmt.uge(this.countLeadingZeros()));
        } else {
            Overflow.$set(ShAmt.uge(this.countLeadingOnes()));
        }
        return this.$out(ShAmt);
    }

    public APInt ushl_ov(APInt ShAmt, bool.ref Overflow) {
        Overflow.$set(ShAmt.uge(this.getBitWidth()));
        if (Overflow.$deref()) {
            return new APInt<T>(this.BitWidth, 0L);
        }
        Overflow.$set(ShAmt.ugt(this.countLeadingZeros()));
        return this.$out(ShAmt);
    }

    public static void sdivrem(APInt LHS, APInt RHS, APInt Quotient, APInt Remainder) {
        if (LHS.isNegative()) {
            if (RHS.isNegative()) {
                APInt.udivrem(LHS.$minus(), RHS.$minus(), Quotient, Remainder);
            } else {
                APInt.udivrem(LHS.$minus(), RHS, Quotient, Remainder);
                Quotient.$assign(Quotient.$minus());
            }
            Remainder.$assign(Remainder.$minus());
        } else if (RHS.isNegative()) {
            APInt.udivrem(LHS, RHS.$minus(), Quotient, Remainder);
            Quotient.$assign(Quotient.$minus());
        } else {
            APInt.udivrem(LHS, RHS, Quotient, Remainder);
        }
    }

    public APInt sadd_ov(APInt RHS, bool.ref Overflow) {
        APInt Res = this.$plus(RHS);
        Overflow.$set(this.isNonNegative() == RHS.isNonNegative() && Res.isNonNegative() != this.isNonNegative());
        return Res;
    }

    public APInt uadd_ov(APInt RHS, bool.ref Overflow) {
        APInt Res = this.$plus(RHS);
        Overflow.$set(Res.ult(RHS));
        return Res;
    }

    public APInt ssub_ov(APInt RHS, bool.ref Overflow) {
        APInt Res = this.$minus(RHS);
        Overflow.$set(this.isNonNegative() != RHS.isNonNegative() && Res.isNonNegative() != this.isNonNegative());
        return Res;
    }

    public APInt usub_ov(APInt RHS, bool.ref Overflow) {
        APInt Res = this.$minus(RHS);
        Overflow.$set(Res.ugt(this));
        return Res;
    }

    public APInt sdiv_ov(APInt RHS, bool.ref Overflow) {
        Overflow.$set(this.isMinSignedValue() && RHS.isAllOnesValue());
        return this.sdiv(RHS);
    }

    public APInt smul_ov(APInt RHS, bool.ref Overflow) {
        APInt Res = this.$star(RHS);
        if (this.$noteq(0L) && RHS.$noteq(0L)) {
            Overflow.$set(Res.sdiv(RHS).$noteq(this) || Res.sdiv(this).$noteq(RHS));
        } else {
            Overflow.$set(false);
        }
        return Res;
    }

    public APInt umul_ov(APInt RHS, bool.ref Overflow) {
        APInt Res = this.$star(RHS);
        if (this.$noteq(0L) && RHS.$noteq(0L)) {
            Overflow.$set(Res.udiv(RHS).$noteq(this) || Res.udiv(this).$noteq(RHS));
        } else {
            Overflow.$set(false);
        }
        return Res;
    }

    public APInt sshl_ov(int ShAmt, bool.ref Overflow) {
        Overflow.$set(ShAmt >= this.getBitWidth());
        if (Overflow.$deref()) {
            ShAmt = this.getBitWidth() - 1;
        }
        if (this.isNonNegative()) {
            Overflow.$set(ShAmt >= this.countLeadingZeros());
        } else {
            Overflow.$set(ShAmt >= this.countLeadingOnes());
        }
        return this.$out(ShAmt);
    }

    public boolean $at(int bitPosition) {
        assert (bitPosition >= 0) : "must be non negative " + bitPosition;
        assert (bitPosition < this.getBitWidth()) : "Bit position out of bounds!";
        return (APInt.maskBit(bitPosition) & (this.isSingleWord() ? this.VAL : this.pVal.$at(APInt.whichWord(bitPosition)))) != 0L;
    }

    public boolean $eq(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Comparison requires equal bit widths";
        if (this.isSingleWord()) {
            return this.VAL == RHS.VAL;
        }
        return this.EqualSlowCase(RHS);
    }

    public boolean $eq(long Val) {
        if (this.isSingleWord()) {
            return this.VAL == Val;
        }
        return this.EqualSlowCase(Val);
    }

    public boolean eq(APInt RHS) {
        return this.$eq(RHS);
    }

    public boolean $noteq(APInt RHS) {
        return !this.$eq(RHS);
    }

    public boolean $noteq(long Val) {
        return !this.$eq(Val);
    }

    public boolean ne(APInt RHS) {
        return !this.$eq(RHS);
    }

    public boolean ult(APInt RHS) {
        int topWord;
        int n2;
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be same for comparison";
        if (this.isSingleWord()) {
            return Unsigned.compare((long)this.VAL, (long)RHS.VAL) < 0L;
        }
        int n1 = this.getActiveBits();
        if (n1 < (n2 = RHS.getActiveBits())) {
            return true;
        }
        if (n2 < n1) {
            return false;
        }
        if (n1 <= APINT_BITS_PER_WORD && n2 <= APINT_BITS_PER_WORD) {
            return this.pVal.$at(0) < RHS.pVal.$at(0);
        }
        for (int i = topWord = APInt.whichWord(std.max((int)n1, (int)n2) - 1); i >= 0; --i) {
            if (this.pVal.$at(i) > RHS.pVal.$at(i)) {
                return false;
            }
            if (this.pVal.$at(i) >= RHS.pVal.$at(i)) continue;
            return true;
        }
        return false;
    }

    public boolean ult(long RHS) {
        return this.ult(new APInt<T>(this.getBitWidth(), RHS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean slt(APInt RHS) {
        APInt<T> lhs = null;
        APInt<T> rhs = null;
        try {
            assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be same for comparison";
            if (this.isSingleWord()) {
                long lhsSext = this.VAL << 64 - this.BitWidth >> 64 - this.BitWidth;
                long rhsSext = RHS.VAL << 64 - this.BitWidth >> 64 - this.BitWidth;
                boolean bl = lhsSext < rhsSext;
                return bl;
            }
            lhs = new APInt<T>(this);
            rhs = new APInt<T>(RHS);
            boolean lhsNeg = this.isNegative();
            boolean rhsNeg = rhs.isNegative();
            if (lhsNeg) {
                lhs.flipAllBits();
                lhs.$preInc();
            }
            if (rhsNeg) {
                rhs.flipAllBits();
                rhs.$preInc();
            }
            if (lhsNeg) {
                if (rhsNeg) {
                    boolean bl = lhs.ugt(rhs);
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            if (rhsNeg) {
                boolean bl = false;
                return bl;
            }
            boolean bl = lhs.ult(rhs);
            return bl;
        }
        finally {
            if (rhs != null) {
                rhs.$destroy();
            }
            if (lhs != null) {
                lhs.$destroy();
            }
        }
    }

    public boolean slt(long RHS) {
        return this.slt(new APInt<T>(this.getBitWidth(), RHS));
    }

    public boolean ule(APInt RHS) {
        return this.ult(RHS) || this.eq(RHS);
    }

    public boolean ule(long RHS) {
        return this.ule(new APInt<T>(this.getBitWidth(), RHS));
    }

    public boolean sle(APInt RHS) {
        return this.slt(RHS) || this.eq(RHS);
    }

    public boolean sle(long RHS) {
        return this.sle(new APInt<T>(this.getBitWidth(), RHS));
    }

    public boolean ugt(APInt RHS) {
        return !this.ult(RHS) && !this.eq(RHS);
    }

    public boolean ugt(long RHS) {
        return this.ugt(new APInt<T>(this.getBitWidth(), RHS));
    }

    public boolean sgt(APInt RHS) {
        return !this.slt(RHS) && !this.eq(RHS);
    }

    public boolean sgt(long RHS) {
        return this.sgt(new APInt<T>(this.getBitWidth(), RHS));
    }

    public boolean uge(APInt RHS) {
        return !this.ult(RHS);
    }

    public boolean uge(long RHS) {
        return this.uge(new APInt<T>(this.getBitWidth(), RHS));
    }

    public boolean sge(APInt RHS) {
        return !this.slt(RHS);
    }

    public boolean sge(long RHS) {
        return this.sge(new APInt<T>(this.getBitWidth(), RHS));
    }

    public boolean intersects(APInt RHS) {
        return this.$bitand(RHS).$noteq(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APInt trunc(int width) {
        assert (width >= 0) : "must be non negative " + width;
        APInt<T> Result = null;
        try {
            int i;
            assert (width < this.BitWidth) : "Invalid APInt Truncate request";
            assert (width != 0) : "Can't truncate to 0 bits";
            if (width <= APINT_BITS_PER_WORD) {
                APInt<T> aPInt = new APInt<T>(width, this.getRawData().$at(0));
                return aPInt;
            }
            Result = new APInt<T>(APIntStatics.getMemory(APInt.getNumWords(width)), width);
            for (i = 0; i != width / APINT_BITS_PER_WORD; ++i) {
                Result.pVal.$set(i, this.pVal.$at(i));
            }
            int bits = (0 - width) % APINT_BITS_PER_WORD;
            if (bits != 0) {
                Result.pVal.$set(i, this.pVal.$at(i) << bits >> bits);
            }
            APInt<T> aPInt = Result;
            return aPInt;
        }
        finally {
            if (Result != null) {
                Result.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APInt sext(int width) {
        assert (width >= 0) : "must be non negative " + width;
        APInt<T> Result = null;
        try {
            int i;
            assert (width > this.BitWidth) : "Invalid APInt SignExtend request";
            if (width <= APINT_BITS_PER_WORD) {
                long val = this.VAL << APINT_BITS_PER_WORD - this.BitWidth;
                APInt<T> aPInt = new APInt<T>(width, (val >>= width - this.BitWidth) >> APINT_BITS_PER_WORD - width);
                return aPInt;
            }
            Result = new APInt<T>(APIntStatics.getMemory(APInt.getNumWords(width)), width);
            long word = 0L;
            for (i = 0; i != this.BitWidth / APINT_BITS_PER_WORD; ++i) {
                word = this.getRawData().$at(i);
                Result.pVal.$set(i, word);
            }
            int bits = (0 - this.BitWidth) % APINT_BITS_PER_WORD;
            word = bits != 0 ? this.getRawData().$at(i) << bits >> bits : (word >>= APINT_BITS_PER_WORD - 1);
            while (i != width / APINT_BITS_PER_WORD) {
                Result.pVal.$set(i, word);
                word >>= APINT_BITS_PER_WORD - 1;
                ++i;
            }
            bits = (0 - width) % APINT_BITS_PER_WORD;
            if (bits != 0) {
                Result.pVal.$set(i, word << bits >> bits);
            }
            APInt<T> aPInt = Result;
            return aPInt;
        }
        finally {
            if (Result != null) {
                Result.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APInt zext(int width) {
        assert (width >= 0) : "must be non negative " + width;
        APInt<T> Result = null;
        try {
            int i;
            assert (width > this.BitWidth) : "Invalid APInt ZeroExtend request";
            if (width <= APINT_BITS_PER_WORD) {
                APInt<T> aPInt = new APInt<T>(width, this.VAL);
                return aPInt;
            }
            Result = new APInt<T>(APIntStatics.getMemory(APInt.getNumWords(width)), width);
            for (i = 0; i != this.getNumWords(); ++i) {
                Result.pVal.$set(i, this.getRawData().$at(i));
            }
            std.memset((uint.ptr)((uint.ptr)Result.pVal.$add(i)), (long)0L, (int)((Result.getNumWords() - i) * APINT_WORD_SIZE));
            APInt<T> aPInt = Result;
            return aPInt;
        }
        finally {
            if (Result != null) {
                Result.$destroy();
            }
        }
    }

    public APInt sextOrTrunc(int width) {
        assert (width >= 0) : "must be non negative " + width;
        if (this.BitWidth < width) {
            return this.sext(width);
        }
        if (this.BitWidth > width) {
            return this.trunc(width);
        }
        return this;
    }

    public APInt zextOrTrunc(int width) {
        assert (width >= 0) : "must be non negative " + width;
        if (this.BitWidth < width) {
            return this.zext(width);
        }
        if (this.BitWidth > width) {
            return this.trunc(width);
        }
        return this;
    }

    public APInt sextOrSelf(int width) {
        assert (width >= 0) : "must be non negative " + width;
        if (this.BitWidth < width) {
            return this.sext(width);
        }
        return this;
    }

    public APInt zextOrSelf(int width) {
        assert (width >= 0) : "must be non negative " + width;
        if (this.BitWidth < width) {
            return this.zext(width);
        }
        return this;
    }

    public void setAllBits() {
        if (this.isSingleWord()) {
            this.VAL = -1L;
        } else {
            for (int i = 0; i < this.getNumWords(); ++i) {
                this.pVal.$set(i, -1L);
            }
        }
        this.clearUnusedBits();
    }

    public void setBit(int bitPosition) {
        assert (bitPosition >= 0) : "must be non negative " + bitPosition;
        if (this.isSingleWord()) {
            this.VAL |= APInt.maskBit(bitPosition);
        } else {
            this.pVal.$set$orassign(APInt.whichWord(bitPosition), APInt.maskBit(bitPosition));
        }
    }

    public void clearAllBits() {
        if (this.isSingleWord()) {
            this.VAL = 0L;
        } else {
            std.memset((uint.ptr)this.pVal, (long)0L, (int)(this.getNumWords() * APINT_WORD_SIZE));
        }
    }

    public void clearBit(int bitPosition) {
        assert (bitPosition >= 0) : "must be non negative " + bitPosition;
        if (this.isSingleWord()) {
            this.VAL &= APInt.maskBit(bitPosition) ^ 0xFFFFFFFFFFFFFFFFL;
        } else {
            this.pVal.$set$andassign(APInt.whichWord(bitPosition), APInt.maskBit(bitPosition) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void flipAllBits() {
        if (this.isSingleWord()) {
            this.VAL ^= 0xFFFFFFFFFFFFFFFFL;
        } else {
            for (int i = 0; i < this.getNumWords(); ++i) {
                this.pVal.$set$xorassign(i, -1L);
            }
        }
        this.clearUnusedBits();
    }

    public void flipBit(int bitPosition) {
        assert (bitPosition >= 0) : "must be non negative " + bitPosition;
        assert (bitPosition < this.BitWidth) : "Out of the bit-width range!";
        if (this.$at(bitPosition)) {
            this.clearBit(bitPosition);
        } else {
            this.setBit(bitPosition);
        }
    }

    public int getBitWidth() {
        return this.BitWidth;
    }

    public int getNumWords() {
        return APInt.getNumWords(this.BitWidth);
    }

    public static int getNumWords(int BitWidth) {
        assert (BitWidth >= 0) : "must be non negative " + BitWidth;
        int out = Unsigned.long2uint((long)(((long)BitWidth + (long)APINT_BITS_PER_WORD - 1L) / (long)APINT_BITS_PER_WORD));
        assert (out >= 0);
        return out;
    }

    public int getActiveBits() {
        return this.BitWidth - this.countLeadingZeros();
    }

    public int getActiveWords() {
        int numActiveBits = this.getActiveBits();
        return numActiveBits != 0 ? APInt.whichWord(numActiveBits - 1) + 1 : 1;
    }

    public int getMinSignedBits() {
        if (this.isNegative()) {
            return this.BitWidth - this.countLeadingOnes() + 1;
        }
        return this.getActiveBits() + 1;
    }

    public long getZExtValue() {
        if (this.isSingleWord()) {
            return this.VAL;
        }
        assert (this.getActiveBits() <= 64) : "Too many bits for uint64_t";
        return this.pVal.$at(0);
    }

    public long getSExtValue() {
        if (this.isSingleWord()) {
            return this.VAL << APINT_BITS_PER_WORD - this.BitWidth >> APINT_BITS_PER_WORD - this.BitWidth;
        }
        assert (this.getMinSignedBits() <= 64) : "Too many bits for int64_t";
        return this.pVal.$at(0);
    }

    public static int getBitsNeeded(StringRef str, int radix) {
        int Count = APInt.getBitsNeededImpl(str, radix);
        assert (Count >= 0) : "must be non negative " + Count;
        return Count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getBitsNeededImpl(StringRef str, int radix) {
        assert (radix >= 0) : "must be non negative " + radix;
        APInt tmp = null;
        try {
            int isNegative;
            assert (!str.empty()) : "Invalid string length";
            assert (radix == 10 || radix == 8 || radix == 16 || radix == 2 || radix == 36) : "Radix should be 2, 8, 10, 16, or 36!";
            int slen = str.size();
            char.ptr p = Native.$tryClone((char.ptr)str.begin());
            int n = isNegative = p.$star() == NativePointer.$((char)'-') ? 1 : 0;
            if (p.$star() == NativePointer.$((char)'-') || p.$star() == NativePointer.$((char)'+')) {
                p.$preInc();
                assert (--slen != 0) : "String is only a sign, needs a value.";
            }
            if (radix == 2) {
                int n2 = slen + isNegative;
                return n2;
            }
            if (radix == 8) {
                int n3 = slen * 3 + isNegative;
                return n3;
            }
            if (radix == 16) {
                int n4 = slen * 4 + isNegative;
                return n4;
            }
            int sufficient = radix == 10 ? (slen == 1 ? 4 : slen * 64 / 18) : (slen == 1 ? 7 : slen * 16 / 3);
            tmp = new APInt(sufficient, new StringRef(p, slen), radix);
            int log = tmp.logBase2();
            if (log == -1) {
                int n5 = isNegative + 1;
                return n5;
            }
            int n6 = isNegative + log + 1;
            return n6;
        }
        finally {
            if (tmp != null) {
                tmp.$destroy();
            }
        }
    }

    public static int getBitsNeeded(CharSequence str, int radix) {
        assert (radix >= 0) : "must be non negative " + radix;
        return APInt.getBitsNeeded(new StringRef(str), radix);
    }

    public int countLeadingZeros() {
        if (this.isSingleWord()) {
            int unusedBits = APINT_BITS_PER_WORD - this.BitWidth;
            return llvm.countLeadingZeros(this.VAL) - unusedBits;
        }
        return this.countLeadingZerosSlowCase();
    }

    public int countLeadingOnes() {
        int shift;
        if (this.isSingleWord()) {
            return llvm.CountLeadingOnes_64(this.VAL << APINT_BITS_PER_WORD - this.BitWidth);
        }
        int highWordBits = this.BitWidth % APINT_BITS_PER_WORD;
        if (highWordBits == 0) {
            highWordBits = APINT_BITS_PER_WORD;
            shift = 0;
        } else {
            shift = APINT_BITS_PER_WORD - highWordBits;
        }
        int i = this.getNumWords() - 1;
        int Count = llvm.CountLeadingOnes_64(this.pVal.$at(i) << shift);
        if (Count == highWordBits) {
            --i;
            while (i >= 0) {
                if (this.pVal.$at(i) == -1L) {
                    Count += APINT_BITS_PER_WORD;
                } else {
                    Count += llvm.CountLeadingOnes_64(this.pVal.$at(i));
                    break;
                }
                --i;
            }
        }
        assert (Count >= 0) : "must be non negative " + Count;
        return Count;
    }

    public int getNumSignBits() {
        return this.isNegative() ? this.countLeadingOnes() : this.countLeadingZeros();
    }

    public int countTrailingZeros() {
        int i;
        if (this.isSingleWord()) {
            return std.min((int)llvm.countTrailingZeros_uint64_t_ZeroBehavior(this.VAL), (int)this.BitWidth);
        }
        int Count = 0;
        for (i = 0; i < this.getNumWords() && this.pVal.$at(i) == 0L; ++i) {
            Count += APINT_BITS_PER_WORD;
        }
        if (i < this.getNumWords()) {
            Count += llvm.countTrailingZeros_uint64_t_ZeroBehavior(this.pVal.$at(i));
        }
        Count = std.min((int)Count, (int)this.BitWidth);
        assert (Count >= 0) : "must be non negative " + Count;
        return Count;
    }

    public int countTrailingOnes() {
        if (this.isSingleWord()) {
            return llvm.CountTrailingOnes_64(this.VAL);
        }
        return this.countTrailingOnesSlowCase();
    }

    public int countPopulation() {
        if (this.isSingleWord()) {
            return llvm.CountPopulation_64(this.VAL);
        }
        return this.countPopulationSlowCase();
    }

    public void print(raw_ostream OS, boolean isSigned) {
        SmallString S = new SmallString(40);
        this.__toString(S, 10, isSigned, false);
        OS.$out(S.str());
    }

    public void __toString(SmallString Str, int Radix, boolean Signed) {
        this.__toString(Str, Radix, Signed, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void __toString(SmallString Str, int Radix, boolean Signed, boolean formatAsCLiteral) {
        assert (Radix >= 0) : "must be non negative " + Radix;
        APInt<T> Tmp = null;
        try {
            assert (Radix == 10 || Radix == 8 || Radix == 16 || Radix == 2 || Radix == 36) : "Radix should be 2, 8, 10, 16, or 36!";
            char.ptr Prefix = Native.$tryClone((char.ptr)NativePointer.$((String)""));
            if (formatAsCLiteral) {
                switch (Radix) {
                    case 2: {
                        Prefix = Native.$tryClone((char.ptr)NativePointer.$((String)"0b"));
                        break;
                    }
                    case 8: {
                        Prefix = Native.$tryClone((char.ptr)NativePointer.$((String)"0"));
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 16: {
                        Prefix = Native.$tryClone((char.ptr)NativePointer.$((String)"0x"));
                        break;
                    }
                    default: {
                        llvm.llvm_unreachable_internal("Invalid radix!" + Radix);
                    }
                }
            }
            if (this.$eq(0L)) {
                while (Prefix.$star() != 0) {
                    Str.push_back(Prefix.$star());
                    Prefix.$preInc();
                }
                Str.push_back(NativePointer.$((char)'0'));
                return;
            }
            if (this.isSingleWord()) {
                long N;
                char.ptr Buffer = NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)65, (byte[])new byte[0]));
                char.ptr BufPtr = (char.ptr)Buffer.$add(65);
                if (!Signed) {
                    N = this.getZExtValue();
                    if (N < 0L) {
                        while (Prefix.$star() != 0) {
                            Str.push_back(Prefix.$star());
                            Prefix.$preInc();
                        }
                        String uStr = Unsigned.toUnsignedString((long)N, (int)Radix);
                        Str.append(uStr);
                        return;
                    }
                } else {
                    long I = this.getSExtValue();
                    if (I >= 0L) {
                        N = I;
                    } else {
                        Str.push_back(NativePointer.$((char)'-'));
                        N = -I;
                    }
                }
                while (Prefix.$star() != 0) {
                    Str.push_back(Prefix.$star());
                    Prefix.$preInc();
                }
                while (N != 0L) {
                    ((char.ptr)BufPtr.$preDec()).$set(Digits.$at(N % (long)Radix));
                    N /= (long)Radix;
                }
                Str.append(BufPtr, 65 - BufPtr.$index());
                return;
            }
            Tmp = new APInt<T>(this);
            if (Signed && this.isNegative()) {
                Tmp.flipAllBits();
                Tmp.$preInc();
                Str.push_back(NativePointer.$((char)'-'));
            }
            while (Prefix.$star() != 0) {
                Str.push_back(Prefix.$star());
                Prefix.$preInc();
            }
            int StartDig = Str.size();
            if (Radix == 2 || Radix == 8 || Radix == 16) {
                int ShiftAmt = Radix == 16 ? 4 : (Radix == 8 ? 3 : 1);
                int MaskAmt = Radix - 1;
                while (Tmp.$noteq(0L)) {
                    int Digit = (int)Tmp.getRawData().$at(0) & MaskAmt;
                    Str.push_back(Digits.$at(Digit));
                    Tmp.$assign(Tmp.lshr(ShiftAmt));
                }
            } else {
                APInt<T> divisor = null;
                try {
                    divisor = new APInt<T>(Radix == 10 ? 4 : 8, (long)Radix);
                    while (Tmp.$noteq(0L)) {
                        APInt<T> APdigit = null;
                        APInt<T> tmp2 = null;
                        try {
                            APdigit = new APInt<T>(1, 0L);
                            tmp2 = new APInt<T>(Tmp.getBitWidth(), 0L);
                            APInt.divide(Tmp, Tmp.getNumWords(), divisor, divisor.getNumWords(), tmp2, APdigit);
                            int Digit = (int)APdigit.getZExtValue();
                            assert (Digit < Radix) : "divide failed";
                            Str.push_back(Digits.$at(Digit));
                            Tmp.$assign(tmp2);
                        }
                        finally {
                            if (tmp2 != null) {
                                tmp2.$destroy();
                            }
                            if (APdigit == null) continue;
                            APdigit.$destroy();
                        }
                    }
                }
                finally {
                    if (divisor != null) {
                        divisor.$destroy();
                    }
                }
            }
            std.reverse((Object)Str.begin().$add(StartDig), (Object)Str.end());
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            throw e;
        }
        finally {
            if (Tmp != null) {
                Tmp.$destroy();
            }
        }
    }

    public void toStringUnsigned(SmallString Str) {
        this.toStringUnsigned(Str, 10);
    }

    public void toStringUnsigned(SmallString Str, int Radix) {
        this.__toString(Str, Radix, false, false);
    }

    public void toStringSigned(SmallString Str) {
        this.toStringSigned(Str, 10);
    }

    public void toStringSigned(SmallString Str, int Radix) {
        this.__toString(Str, Radix, true, false);
    }

    public std.string __toString() {
        return this.__toString(10, true);
    }

    public std.string __toString(int Radix) {
        return this.__toString(Radix, true);
    }

    public std.string __toString(int Radix, boolean Signed) {
        assert (Radix >= 0) : "must be non negative " + Radix;
        SmallString S = new SmallString(40);
        this.__toString(S, Radix, Signed, false);
        return S.str().$basic_string();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APInt byteSwap() {
        APInt<T> Result = null;
        try {
            assert (this.BitWidth >= 16 && this.BitWidth % 16 == 0) : "Cannot byteswap!";
            if (this.BitWidth == 16) {
                APInt<T> aPInt = new APInt<T>(this.BitWidth, (long)llvm.ByteSwap_16((char)this.VAL));
                return aPInt;
            }
            if (this.BitWidth == 32) {
                APInt<T> aPInt = new APInt<T>(this.BitWidth, llvm.ByteSwap_32(this.VAL));
                return aPInt;
            }
            if (this.BitWidth == 48) {
                long Tmp1 = this.VAL >> 16;
                Tmp1 = llvm.ByteSwap_32(Tmp1);
                char Tmp2 = (char)this.VAL;
                Tmp2 = llvm.ByteSwap_16(Tmp2);
                APInt<T> aPInt = new APInt<T>(this.BitWidth, (long)Tmp2 << 32 | Tmp1);
                return aPInt;
            }
            if (this.BitWidth == 64) {
                APInt<T> Tmp1 = new APInt<T>(this.BitWidth, llvm.ByteSwap_64(this.VAL));
                return Tmp1;
            }
            Result = new APInt<T>(this.getNumWords() * APINT_BITS_PER_WORD, 0L);
            int N = this.getNumWords();
            for (int I = 0; I != N; ++I) {
                Result.pVal.$set(I, llvm.ByteSwap_64(this.pVal.$at(N - I - 1)));
            }
            if (Result.BitWidth != this.BitWidth) {
                APIntStatics.lshrNear(Result.pVal, Result.pVal, this.getNumWords(), Result.BitWidth - this.BitWidth);
                Result.BitWidth = this.BitWidth;
            }
            APInt<T> aPInt = Result;
            return aPInt;
        }
        finally {
            if (Result != null) {
                Result.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double roundToDouble(boolean isSigned) {
        APInt<T> Tmp = null;
        try {
            long mantissa;
            if (this.isSingleWord() || this.getActiveBits() <= APINT_BITS_PER_WORD) {
                if (isSigned) {
                    long sext = this.getWord(0) << 64 - this.BitWidth >> 64 - this.BitWidth;
                    double d = sext;
                    return d;
                }
                double sext = this.getWord(0);
                return sext;
            }
            boolean isNeg = isSigned ? this.$at(this.BitWidth - 1) : false;
            Tmp = new APInt<T>(isNeg ? this.$minus() : this);
            int n = Tmp.getActiveBits();
            long exp = n;
            if (exp > 1023L) {
                if (!isSigned || !isNeg) {
                    double d = std.numeric_limits_double.infinity();
                    return d;
                }
                double d = -std.numeric_limits_double.infinity();
                return d;
            }
            exp += 1023L;
            int hiWord = APInt.whichWord(n - 1);
            if (hiWord == 0) {
                mantissa = Tmp.pVal.$at(0);
                if (n > 52) {
                    mantissa >>= n - 52;
                }
            } else {
                assert (hiWord > 0) : "huh?";
                long hibits = Tmp.pVal.$at(hiWord) << 52 - n % APINT_BITS_PER_WORD;
                long lobits = Tmp.pVal.$at(hiWord - 1) >> 11 + n % APINT_BITS_PER_WORD;
                mantissa = hibits | lobits;
            }
            long sign = isNeg ? 1L << APINT_BITS_PER_WORD - 1 : 0L;
            class _UnnamedUnion {
                public double D;
                public long I;
            }
            _UnnamedUnion T = new _UnnamedUnion();
            T.I = sign | exp << 52 | mantissa;
            double d = T.D;
            return d;
        }
        finally {
            if (Tmp != null) {
                Tmp.$destroy();
            }
        }
    }

    public double roundToDouble() {
        return this.roundToDouble(false);
    }

    public double signedRoundToDouble() {
        return this.roundToDouble(true);
    }

    public double bitsToDouble() {
        class _UnnamedUnion {
            public long I;
            public double D;
        }
        _UnnamedUnion T = new _UnnamedUnion();
        T.I = this.isSingleWord() ? this.VAL : this.pVal.$at(0);
        return T.D;
    }

    public float bitsToFloat() {
        class _UnnamedUnion {
            public long I;
            public float F;
        }
        _UnnamedUnion T = new _UnnamedUnion();
        T.I = this.isSingleWord() ? this.VAL : this.pVal.$at(0);
        return T.F;
    }

    public static APInt doubleToBits(double V) {
        class _UnnamedUnion {
            public long I;
            public double D;
        }
        _UnnamedUnion T = new _UnnamedUnion();
        T.D = V;
        return new APInt(NativeType.sizeof(_UnnamedUnion.class) * 8, T.I);
    }

    public static APInt floatToBits(float V) {
        class _UnnamedUnion {
            public long I;
            public float F;
        }
        _UnnamedUnion T = new _UnnamedUnion();
        T.F = V;
        return new APInt(NativeType.sizeof(_UnnamedUnion.class) * 8, T.I);
    }

    public int logBase2() {
        int Out = this.BitWidth - 1 - this.countLeadingZeros();
        assert (Out >= -1) : "must be non negative " + Out;
        return Out;
    }

    public int ceilLogBase2() {
        int Out = this.BitWidth - this.$minus(1L).countLeadingZeros();
        assert (Out >= -1) : "must be non negative " + Out;
        return Out;
    }

    public int nearestLogBase2() {
        int lg;
        if (this.BitWidth == 1) {
            return this.VAL > 0L ? 0 : Integer.MAX_VALUE;
        }
        if (!this.getBoolValue()) {
            return Integer.MAX_VALUE;
        }
        int Out = lg + (this.$at((lg = this.logBase2()) - 1) ? 1 : 0);
        assert (Out >= -1) : "must be non negative " + Out;
        return Out;
    }

    public int exactLogBase2() {
        if (!this.isPowerOf2()) {
            return -1;
        }
        return this.logBase2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APInt sqrt() {
        APInt<T> testy = null;
        APInt<T> x_old = null;
        APInt<T> x_new = null;
        APInt<T> two = null;
        APInt<T> square = null;
        APInt<T> nextSquare = null;
        APInt<T> midpoint = null;
        APInt<T> offset = null;
        try {
            int magnitude = this.getActiveBits();
            if (magnitude <= 5) {
                APInt<T> aPInt = new APInt<T>(this.BitWidth, (long)results[(int)(this.isSingleWord() ? this.VAL : this.pVal.$at(0))]);
                return aPInt;
            }
            if (magnitude < 52) {
                APInt<T> aPInt = new APInt<T>(this.BitWidth, (long)(std.sqrt((double)(this.isSingleWord() ? this.VAL : this.pVal.$at(0))) + 0.5));
                return aPInt;
            }
            int nbits = this.BitWidth;
            int i = 4;
            testy = new APInt<T>(this.BitWidth, 16L);
            x_old = new APInt<T>(this.BitWidth, 1L);
            x_new = new APInt<T>(this.BitWidth, 0L);
            two = new APInt<T>(this.BitWidth, 2L);
            while (true) {
                if (i >= nbits || this.ule(testy)) break;
                i += 2;
                testy.$assign(testy.shl(2));
            }
            x_old.$assign(x_old.shl(i / 2));
            while (true) {
                x_new.$assign(this.udiv(x_old).$plus(x_old).udiv(two));
                if (x_old.ule(x_new)) break;
                x_old.$assign(x_new);
            }
            square = new APInt<T>(x_old.$star(x_old));
            nextSquare = new APInt<T>(x_old.$plus(1L).$star(x_old.$plus(1L)));
            if (this.ult(square)) {
                APInt<T> aPInt = x_old;
                return aPInt;
            }
            assert (this.ule(nextSquare)) : "Error in APInt::sqrt computation";
            midpoint = new APInt<T>(nextSquare.$minus(square).udiv(two));
            offset = new APInt<T>(this.$minus(square));
            if (offset.ult(midpoint)) {
                APInt<T> aPInt = x_old;
                return aPInt;
            }
            APInt aPInt = x_old.$plus(1L);
            return aPInt;
        }
        finally {
            if (offset != null) {
                offset.$destroy();
            }
            if (midpoint != null) {
                midpoint.$destroy();
            }
            if (nextSquare != null) {
                nextSquare.$destroy();
            }
            if (square != null) {
                square.$destroy();
            }
            if (two != null) {
                two.$destroy();
            }
            if (x_new != null) {
                x_new.$destroy();
            }
            if (x_old != null) {
                x_old.$destroy();
            }
            if (testy != null) {
                testy.$destroy();
            }
        }
    }

    public APInt abs() {
        if (this.isNegative()) {
            return this.$minus();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APInt multiplicativeInverse(APInt modulo) {
        APInt<T> q = null;
        try {
            assert (this.ult(modulo)) : "This APInt must be smaller than the modulo";
            APInt[] r = new APInt[]{modulo, this};
            APInt[] t = new APInt[]{new APInt<T>(this.BitWidth, 0L), new APInt<T>(this.BitWidth, 1L)};
            q = new APInt<T>(this.BitWidth, 0L);
            int i = 0;
            while (r[i ^ 1].$noteq(0L)) {
                APInt.udivrem(r[i], r[i ^ 1], q, r[i]);
                t[i].$minusassign(t[i ^ 1].$star(q));
                i ^= 1;
            }
            if (r[i].$noteq(1L)) {
                APInt<T> aPInt = new APInt<T>(this.BitWidth, 0L);
                return aPInt;
            }
            APInt aPInt = t[i].isNegative() ? t[i].$plus(modulo) : t[i];
            return aPInt;
        }
        finally {
            if (q != null) {
                q.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ms magic() {
        APInt<T> ad = null;
        APInt<T> anc = null;
        APInt<T> delta = null;
        APInt<T> q1 = null;
        APInt<T> r1 = null;
        APInt<T> q2 = null;
        APInt<T> r2 = null;
        APInt<T> t = null;
        ms mag = null;
        try {
            APInt d = this;
            ad = new APInt<T>();
            anc = new APInt<T>();
            delta = new APInt<T>();
            q1 = new APInt<T>();
            r1 = new APInt<T>();
            q2 = new APInt<T>();
            r2 = new APInt<T>();
            t = new APInt<T>();
            APInt signedMin = APInt.getSignedMinValue(d.getBitWidth());
            mag = new ms();
            ad.$assign(d.abs());
            t.$assign(signedMin.$plus(d.lshr(d.getBitWidth() - 1)));
            anc.$assign(t.$minus(1L).$minus(t.urem(ad)));
            int p = d.getBitWidth() - 1;
            q1.$assign(signedMin.udiv(anc));
            r1.$assign(signedMin.$minus(q1.$star(anc)));
            q2.$assign(signedMin.udiv(ad));
            r2.$assign(signedMin.$minus(q2.$star(ad)));
            do {
                ++p;
                q1.$assign(q1.$out(1));
                r1.$assign(r1.$out(1));
                if (r1.uge(anc)) {
                    q1.$assign(q1.$plus(1L));
                    r1.$assign(r1.$minus(anc));
                }
                q2.$assign(q2.$out(1));
                r2.$assign(r2.$out(1));
                if (r2.uge(ad)) {
                    q2.$assign(q2.$plus(1L));
                    r2.$assign(r2.$minus(ad));
                }
                delta.$assign(ad.$minus(r2));
            } while (q1.ult(delta) || q1.$eq(delta) && r1.$eq(0L));
            mag.m.$assign(q2.$plus(1L));
            if (d.isNegative()) {
                mag.m.$assign(mag.m.$minus());
            }
            mag.s = p - d.getBitWidth();
            ms ms2 = mag;
            return ms2;
        }
        finally {
            if (mag != null) {
                mag.$destroy();
            }
            if (t != null) {
                t.$destroy();
            }
            if (r2 != null) {
                r2.$destroy();
            }
            if (q2 != null) {
                q2.$destroy();
            }
            if (r1 != null) {
                r1.$destroy();
            }
            if (q1 != null) {
                q1.$destroy();
            }
            if (delta != null) {
                delta.$destroy();
            }
            if (anc != null) {
                anc.$destroy();
            }
            if (ad != null) {
                ad.$destroy();
            }
        }
    }

    public mu magicu() {
        return this.magicu(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public mu magicu(int LeadingZeros) {
        assert (LeadingZeros >= 0) : "must be non negative " + LeadingZeros;
        APInt<T> nc = null;
        APInt<T> delta = null;
        APInt<T> q1 = null;
        APInt<T> r1 = null;
        APInt<T> q2 = null;
        APInt<T> r2 = null;
        mu magu = null;
        try {
            APInt d = this;
            nc = new APInt<T>();
            delta = new APInt<T>();
            q1 = new APInt<T>();
            r1 = new APInt<T>();
            q2 = new APInt<T>();
            r2 = new APInt<T>();
            magu = new mu();
            magu.a = false;
            APInt allOnes = APInt.getAllOnesValue(d.getBitWidth()).lshr(LeadingZeros);
            APInt signedMin = APInt.getSignedMinValue(d.getBitWidth());
            APInt signedMax = APInt.getSignedMaxValue(d.getBitWidth());
            nc.$assign(allOnes.$minus(allOnes.$minus(d).urem(d)));
            int p = d.getBitWidth() - 1;
            q1.$assign(signedMin.udiv(nc));
            r1.$assign(signedMin.$minus(q1.$star(nc)));
            q2.$assign(signedMax.udiv(d));
            r2.$assign(signedMax.$minus(q2.$star(d)));
            do {
                ++p;
                if (r1.uge(nc.$minus(r1))) {
                    q1.$assign(q1.$plus(q1).$plus(1L));
                    r1.$assign(r1.$plus(r1).$minus(nc));
                } else {
                    q1.$assign(q1.$plus(q1));
                    r1.$assign(r1.$plus(r1));
                }
                if (r2.$plus(1L).uge(d.$minus(r2))) {
                    if (q2.uge(signedMax)) {
                        magu.a = true;
                    }
                    q2.$assign(q2.$plus(q2).$plus(1L));
                    r2.$assign(r2.$plus(r2).$plus(1L).$minus(d));
                } else {
                    if (q2.uge(signedMin)) {
                        magu.a = true;
                    }
                    q2.$assign(q2.$plus(q2));
                    r2.$assign(r2.$plus(r2).$plus(1L));
                }
                delta.$assign(d.$minus(1L).$minus(r2));
            } while (p < d.getBitWidth() * 2 && (q1.ult(delta) || q1.$eq(delta) && r1.$eq(0L)));
            magu.m.$assign(q2.$plus(1L));
            magu.s = p - d.getBitWidth();
            mu mu2 = magu;
            return mu2;
        }
        finally {
            if (magu != null) {
                magu.$destroy();
            }
            if (r2 != null) {
                r2.$destroy();
            }
            if (q2 != null) {
                q2.$destroy();
            }
            if (r1 != null) {
                r1.$destroy();
            }
            if (q1 != null) {
                q1.$destroy();
            }
            if (delta != null) {
                delta.$destroy();
            }
            if (nc != null) {
                nc.$destroy();
            }
        }
    }

    public static void tcSet(uint.ptr dst, long part, int parts) {
        assert (parts >= 0) : "must be non negative " + parts;
        assert (parts > 0);
        dst.$set(0, part);
        for (int i = 1; i < parts; ++i) {
            dst.$set(i, 0L);
        }
    }

    public static void tcAssign(uint.ptr dst, uint.ptr src, int parts) {
        assert (parts >= 0) : "must be non negative " + parts;
        for (int i = 0; i < parts; ++i) {
            dst.$set(i, src.$at(i));
        }
    }

    public static boolean tcIsZero(uint.ptr src, int parts) {
        assert (parts >= 0) : "must be non negative " + parts;
        for (int i = 0; i < parts; ++i) {
            if (src.$at(i) == 0L) continue;
            return false;
        }
        return true;
    }

    public static int tcExtractBit(uint.ptr parts, int bit) {
        assert (bit >= 0) : "must be non negative " + bit;
        return (parts.$at(bit / llvm.integerPartWidth) & 1L << bit % llvm.integerPartWidth) != 0L ? 1 : 0;
    }

    public static void tcExtract(uint.ptr dst, int dstCount, uint.ptr src, int srcBits, int srcLSB) {
        assert (dstCount >= 0) : "must be non negative " + dstCount;
        assert (srcBits >= 0) : "must be non negative " + srcBits;
        assert (srcLSB >= 0) : "must be non negative " + srcLSB;
        int dstParts = (srcBits + llvm.integerPartWidth - 1) / llvm.integerPartWidth;
        assert (dstParts <= dstCount);
        int firstSrcPart = srcLSB / llvm.integerPartWidth;
        APInt.tcAssign(dst, (uint.ptr)src.$add(firstSrcPart), dstParts);
        int shift = srcLSB % llvm.integerPartWidth;
        APInt.tcShiftRight(dst, dstParts, shift);
        int n = dstParts * llvm.integerPartWidth - shift;
        if (n < srcBits) {
            long mask = APIntStatics.lowBitMask(srcBits - n);
            dst.$set$orassign(dstParts - 1, (src.$at(firstSrcPart + dstParts) & mask) << n % llvm.integerPartWidth);
        } else if (n > srcBits && srcBits % llvm.integerPartWidth != 0) {
            dst.$set$andassign(dstParts - 1, APIntStatics.lowBitMask(srcBits % llvm.integerPartWidth));
        }
        while (dstParts < dstCount) {
            dst.$set(dstParts++, 0L);
        }
    }

    public static void tcSetBit(uint.ptr parts, int bit) {
        assert (bit >= 0) : "must be non negative " + bit;
        parts.$set$orassign(bit / llvm.integerPartWidth, 1L << bit % llvm.integerPartWidth);
    }

    public static void tcClearBit(uint.ptr parts, int bit) {
        assert (bit >= 0) : "must be non negative " + bit;
        parts.$set$andassign(bit / llvm.integerPartWidth, 1L << bit % llvm.integerPartWidth ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int tcLSB(uint.ptr parts, int n) {
        assert (n >= 0) : "must be non negative " + n;
        for (int i = 0; i < n; ++i) {
            if (parts.$at(i) == 0L) continue;
            int lsb = APIntStatics.partLSB(parts.$at(i));
            return lsb + i * llvm.integerPartWidth;
        }
        return -1;
    }

    public static int tcMSB(uint.ptr parts, int n) {
        assert (n >= 0) : "must be non negative " + n;
        do {
            if (parts.$at(--n) == 0L) continue;
            int msb = APIntStatics.partMSB(parts.$at(n));
            return msb + n * llvm.integerPartWidth;
        } while (n != 0);
        return -1;
    }

    public static void tcNegate(uint.ptr dst, int parts) {
        assert (parts >= 0) : "must be non negative " + parts;
        APInt.tcComplement(dst, parts);
        APInt.tcIncrement(dst, parts);
    }

    public static long tcAdd(uint.ptr dst, uint.ptr rhs, long c, int parts) {
        assert (parts >= 0) : "must be non negative " + parts;
        assert (c <= 1L);
        for (int i = 0; i < parts; ++i) {
            long l = dst.$at(i);
            if (c != 0L) {
                dst.$set$addassign(i, rhs.$at(i) + 1L);
                c = dst.$at(i) <= l ? 1L : 0L;
                continue;
            }
            dst.$set$addassign(i, rhs.$at(i));
            c = dst.$at(i) < l ? 1L : 0L;
        }
        return c;
    }

    public static long tcSubtract(uint.ptr dst, uint.ptr rhs, long c, int parts) {
        assert (parts >= 0) : "must be non negative " + parts;
        assert (c <= 1L);
        for (int i = 0; i < parts; ++i) {
            long l = dst.$at(i);
            if (c != 0L) {
                dst.$set$minusassign(i, rhs.$at(i) + 1L);
                c = dst.$at(i) >= l ? 1L : 0L;
                continue;
            }
            dst.$set$minusassign(i, rhs.$at(i));
            c = dst.$at(i) > l ? 1L : 0L;
        }
        return c;
    }

    public static int tcMultiplyPart(uint.ptr dst, uint.ptr src, long multiplier, long carry, int srcParts, int dstParts, boolean add) {
        int i;
        assert (srcParts >= 0) : "must be non negative " + srcParts;
        assert (dstParts >= 0) : "must be non negative " + dstParts;
        assert (dst.$lesseq((Object)src) || dst.$greatereq((Object)src.$add(srcParts)));
        assert (dstParts <= srcParts + 1);
        int n = dstParts < srcParts ? dstParts : srcParts;
        for (i = 0; i < n; ++i) {
            long high;
            long low;
            long srcPart = src.$at(i);
            if (multiplier == 0L || srcPart == 0L) {
                low = carry;
                high = 0L;
            } else {
                low = APIntStatics.lowHalf(srcPart) * APIntStatics.lowHalf(multiplier);
                high = APIntStatics.highHalf(srcPart) * APIntStatics.highHalf(multiplier);
                long mid = APIntStatics.lowHalf(srcPart) * APIntStatics.highHalf(multiplier);
                high += APIntStatics.highHalf(mid);
                if (low + (mid <<= llvm.integerPartWidth / 2) < low) {
                    ++high;
                }
                low += mid;
                mid = APIntStatics.highHalf(srcPart) * APIntStatics.lowHalf(multiplier);
                high += APIntStatics.highHalf(mid);
                if (low + (mid <<= llvm.integerPartWidth / 2) < low) {
                    ++high;
                }
                if ((low += mid) + carry < low) {
                    ++high;
                }
                low += carry;
            }
            if (add) {
                if (low + dst.$at(i) < low) {
                    // empty if block
                }
                dst.$set$addassign(i, low);
            } else {
                dst.$set(i, low);
            }
            carry = ++high;
        }
        if (i < dstParts) {
            assert (i + 1 == dstParts);
            dst.$set(i, carry);
            return 0;
        }
        if (carry != 0L) {
            return 1;
        }
        if (multiplier != 0L) {
            while (i < srcParts) {
                if (src.$at(i) != 0L) {
                    return 1;
                }
                ++i;
            }
        }
        return 0;
    }

    public static int tcMultiply(uint.ptr dst, uint.ptr lhs, uint.ptr rhs, int parts) {
        assert (parts >= 0) : "must be non negative " + parts;
        assert (dst.$noteq((Object)lhs) && dst.$noteq((Object)rhs));
        int overflow = 0;
        APInt.tcSet(dst, 0L, parts);
        for (int i = 0; i < parts; ++i) {
            overflow |= APInt.tcMultiplyPart((uint.ptr)dst.$add(i), lhs, rhs.$at(i), 0L, parts, parts - i, true);
        }
        return overflow;
    }

    public static long tcFullMultiply(uint.ptr dst, uint.ptr lhs, uint.ptr rhs, int lhsParts, int rhsParts) {
        int n;
        assert (lhsParts >= 0) : "must be non negative " + lhsParts;
        assert (rhsParts >= 0) : "must be non negative " + rhsParts;
        if (lhsParts > rhsParts) {
            return APInt.tcFullMultiply(dst, rhs, lhs, rhsParts, lhsParts);
        }
        assert (dst.$noteq((Object)lhs) && dst.$noteq((Object)rhs));
        APInt.tcSet(dst, 0L, rhsParts);
        for (n = 0; n < lhsParts; ++n) {
            APInt.tcMultiplyPart((uint.ptr)dst.$add(n), rhs, lhs.$at(n), 0L, rhsParts, rhsParts + 1, true);
        }
        return n - (dst.$at((n = lhsParts + rhsParts) - 1) == 0L ? 1 : 0);
    }

    public static int tcDivide(uint.ptr lhs, uint.ptr rhs, uint.ptr remainder, uint.ptr srhs, int parts) {
        assert (parts >= 0) : "must be non negative " + parts;
        assert (lhs.$noteq((Object)remainder) && lhs.$noteq((Object)srhs) && remainder.$noteq((Object)srhs));
        int shiftCount = APInt.tcMSB(rhs, parts) + 1;
        if (shiftCount == 0) {
            return 1;
        }
        shiftCount = parts * llvm.integerPartWidth - shiftCount;
        int n = shiftCount / llvm.integerPartWidth;
        long mask = 1L << shiftCount % llvm.integerPartWidth;
        APInt.tcAssign(srhs, rhs, parts);
        APInt.tcShiftLeft(srhs, parts, shiftCount);
        APInt.tcAssign(remainder, lhs, parts);
        APInt.tcSet(lhs, 0L, parts);
        while (true) {
            int compare;
            if ((compare = APInt.tcCompare(remainder, srhs, parts)) >= 0) {
                APInt.tcSubtract(remainder, srhs, 0L, parts);
                lhs.$set$orassign(n, mask);
            }
            if (shiftCount == 0) break;
            --shiftCount;
            APInt.tcShiftRight(srhs, parts, 1);
            if ((mask >>= 1) != 0L) continue;
            mask = 1L << llvm.integerPartWidth - 1;
            --n;
        }
        return 0;
    }

    public static void tcShiftLeft(uint.ptr dst, int parts, int count) {
        assert (parts >= 0) : "must be non negative " + parts;
        assert (count >= 0) : "must be non negative " + count;
        if (count != 0) {
            int jump = count / llvm.integerPartWidth;
            int shift = count % llvm.integerPartWidth;
            while (parts > jump) {
                long part = dst.$at(--parts - jump);
                if (shift != 0) {
                    part <<= shift;
                    if (parts >= jump + 1) {
                        part |= dst.$at(parts - jump - 1) >> llvm.integerPartWidth - shift;
                    }
                }
                dst.$set(parts, part);
            }
            while (parts > 0) {
                dst.$set(--parts, 0L);
            }
        }
    }

    public static void tcShiftRight(uint.ptr dst, int parts, int count) {
        assert (parts >= 0) : "must be non negative " + parts;
        assert (count >= 0) : "must be non negative " + count;
        if (count != 0) {
            int jump = count / llvm.integerPartWidth;
            int shift = count % llvm.integerPartWidth;
            for (int i = 0; i < parts; ++i) {
                long part;
                if (i + jump >= parts) {
                    part = 0L;
                } else {
                    part = dst.$at(i + jump);
                    if (shift != 0) {
                        part >>= shift;
                        if (i + jump + 1 < parts) {
                            part |= dst.$at(i + jump + 1) << llvm.integerPartWidth - shift;
                        }
                    }
                }
                dst.$set(i, part);
            }
        }
    }

    public static void tcAnd(uint.ptr dst, uint.ptr rhs, int parts) {
        assert (parts >= 0) : "must be non negative " + parts;
        for (int i = 0; i < parts; ++i) {
            dst.$set$andassign(i, rhs.$at(i));
        }
    }

    public static void tcOr(uint.ptr dst, uint.ptr rhs, int parts) {
        assert (parts >= 0) : "must be non negative " + parts;
        for (int i = 0; i < parts; ++i) {
            dst.$set$orassign(i, rhs.$at(i));
        }
    }

    public static void tcXor(uint.ptr dst, uint.ptr rhs, int parts) {
        assert (parts >= 0) : "must be non negative " + parts;
        for (int i = 0; i < parts; ++i) {
            dst.$set$xorassign(i, rhs.$at(i));
        }
    }

    public static void tcComplement(uint.ptr dst, int parts) {
        assert (parts >= 0) : "must be non negative " + parts;
        for (int i = 0; i < parts; ++i) {
            dst.$set(i, dst.$at(i) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public static int tcCompare(uint.ptr lhs, uint.ptr rhs, int parts) {
        assert (parts >= 0) : "must be non negative " + parts;
        while (parts != 0) {
            if (lhs.$at(--parts) == rhs.$at(parts)) continue;
            if (lhs.$at(parts) > rhs.$at(parts)) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public static long tcIncrement(uint.ptr dst, int parts) {
        int i;
        assert (parts >= 0) : "must be non negative " + parts;
        for (i = 0; i < parts && dst.$set$preInc(i) == 0L; ++i) {
        }
        return i == parts ? 1L : 0L;
    }

    public static long tcDecrement(uint.ptr dst, int parts) {
        assert (parts >= 0) : "must be non negative " + parts;
        for (int i = 0; i < parts; ++i) {
            if (dst.$set$postDec(i) == 0L) continue;
            return 0L;
        }
        return 1L;
    }

    public static void tcSetLeastSignificantBits(uint.ptr dst, int parts, int bits) {
        assert (parts >= 0) : "must be non negative " + parts;
        assert (bits >= 0) : "must be non negative " + bits;
        int i = 0;
        while (bits > llvm.integerPartWidth) {
            dst.$set(i++, -1L);
            bits -= llvm.integerPartWidth;
        }
        if (bits != 0) {
            dst.$set(i++, -1L >> llvm.integerPartWidth - bits);
        }
        while (i < parts) {
            dst.$set(i++, 0L);
        }
    }

    public void dump() {
        SmallString S = new SmallString(40);
        SmallString U = new SmallString(40);
        this.toStringUnsigned(U);
        this.toStringSigned(S);
        llvm.dbgs().$out("APInt(").$out(this.BitWidth).$out("b, ").$out(U.str()).$out("u ").$out(S.str()).$out("s)");
    }

    public T clone() {
        return (T)new APInt<T>(this);
    }

    public String toString() {
        return "[BitWidth=" + this.BitWidth + "[" + (this.pVal != null ? this.pVal : Long.valueOf(this.VAL)) + "]]";
    }

    public static class mu
    implements Destructors.ClassWithDestructor {
        public APInt m;
        public boolean a;
        public int s;

        public void $destroy() {
        }

        public mu() {
            this.m = new APInt();
        }

        public mu(mu $Prm0) {
            this.m = new APInt($Prm0.m);
            this.a = $Prm0.a;
            this.s = $Prm0.s;
        }
    }

    public static class ms
    implements Destructors.ClassWithDestructor {
        public APInt m;
        public int s;

        public void $destroy() {
        }

        public ms() {
            this.m = new APInt();
        }

        public ms(ms $Prm0) {
            this.m = new APInt($Prm0.m);
            this.s = $Prm0.s;
        }
    }
}

