/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import java.util.concurrent.atomic.AtomicLong;
import org.clank.support.Native;
import org.clank.support.aliases.char;
import org.llvm.support.ValgrindGlobals;
import org.llvm.support.impl.StatisticStatics;
import org.llvm.support.sys.SmartScopedLock;
import org.llvm.support.sys.sys;

public class Statistic {
    public char.ptr Name;
    public char.ptr Desc;
    public AtomicLong Value;
    public boolean Initialized;

    public long getValue() {
        return this.Value.get();
    }

    public char.ptr getName() {
        return this.Name;
    }

    public char.ptr getDesc() {
        return this.Desc;
    }

    public void construct(char.ptr name, char.ptr desc2) {
        this.Name = Native.$tryConstClone((char.ptr)name);
        this.Desc = Native.$tryConstClone((char.ptr)desc2);
        this.Value = new AtomicLong(0L);
        this.Initialized = false;
    }

    public long $long() {
        return this.Value.get();
    }

    public Statistic $assign(long Val) {
        this.Value.set(Val);
        return this.init();
    }

    public Statistic $preInc() {
        sys.AtomicIncrement(this.Value);
        return this.init();
    }

    public long $postInc(int $Prm0) {
        this.init();
        long OldValue = this.Value.get();
        sys.AtomicIncrement(this.Value);
        return OldValue;
    }

    public Statistic $preDec() {
        sys.AtomicDecrement(this.Value);
        return this.init();
    }

    public long $postDec(int $Prm0) {
        this.init();
        long OldValue = this.Value.get();
        sys.AtomicDecrement(this.Value);
        return OldValue;
    }

    public Statistic $addassign(long V) {
        if (V == 0L) {
            return this;
        }
        sys.AtomicAdd(this.Value, V);
        return this.init();
    }

    public Statistic $minusassign(long V) {
        if (V == 0L) {
            return this;
        }
        sys.AtomicAdd(this.Value, -V);
        return this.init();
    }

    public Statistic $starassign(long V) {
        sys.AtomicMul(this.Value, V);
        return this.init();
    }

    public Statistic $slashassign(long V) {
        sys.AtomicDiv(this.Value, V);
        return this.init();
    }

    protected Statistic init() {
        boolean tmp = this.Initialized;
        sys.MemoryFence();
        if (!tmp) {
            this.RegisterStatistic();
        }
        ValgrindGlobals.AnnotateHappensAfter("${LLVM_SRC}/llvm/include/llvm/ADT/Statistic.h", 156, this);
        return this;
    }

    protected void RegisterStatistic() {
        SmartScopedLock Writer = null;
        try {
            Writer = new SmartScopedLock(true, StatisticStatics.StatLock.$star());
            if (!this.Initialized) {
                if (StatisticStatics.Enabled.$boolean()) {
                    StatisticStatics.StatInfo.$arrow().addStatistic(this);
                }
                ValgrindGlobals.AnnotateHappensBefore("${LLVM_SRC}/llvm/lib/Support/Statistic.cpp", 78, this);
                sys.MemoryFence();
                ValgrindGlobals.AnnotateIgnoreWritesBegin("${LLVM_SRC}/llvm/lib/Support/Statistic.cpp", 81);
                this.Initialized = true;
                ValgrindGlobals.AnnotateIgnoreWritesEnd("${LLVM_SRC}/llvm/lib/Support/Statistic.cpp", 83);
            }
        }
        finally {
            if (Writer != null) {
                Writer.$destroy();
            }
        }
    }

    public String toString() {
        return "Statistic{Name=" + this.Name + ", Desc=" + this.Desc + ", Value=" + this.Value + ", Initialized=" + this.Initialized + '}';
    }
}

