/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.llint;
import org.clank.support.aliases.uint;
import org.clank.support.aliases.ullint;
import org.clank.support.char;
import org.llvm.adt.APInt;
import org.llvm.adt.aliases.ArrayRefChar;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.support.impl.StringRefStatics;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class StringRef
implements Native.OpCapable,
Native.NativePOD<StringRef> {
    public static final StringRef EMPTY = new StringRef(NativePointer.EMPTY);
    public static final StringRef SPACE = new StringRef(NativePointer.SPACE);
    public static final StringRef DOT = new StringRef(NativePointer.DOT);
    public static final StringRef PLUS = new StringRef(NativePointer.PLUS);
    public static final StringRef MINUS = new StringRef(NativePointer.MINUS);
    public static final StringRef ZERO = new StringRef(NativePointer.ZERO);
    public static final StringRef ONE = new StringRef(NativePointer.ONE);
    public static final StringRef TWO = new StringRef(NativePointer.TWO);
    public static final StringRef THREE = new StringRef(NativePointer.THREE);
    public static final StringRef SLASH = new StringRef(NativePointer.SLASH);
    public static final StringRef DOT_DOT = new StringRef(NativePointer.DOT_DOT);
    public static final StringRef SCRATCH_SPACE = new StringRef(NativePointer.$SCRATCH_BUFFER);
    public static final StringRef __VA_ARGS__ = new StringRef(NativePointer.$__VA_ARGS__);
    public static final StringRef IMPORT = new StringRef(NativePointer.$IMPORT);
    public static int npos;
    private char.ptr Data;
    private int Length;
    private static long emptyInstances;
    private static long copiedInstances;
    private static long charSeqInstances;
    private static long otherInstances;
    private static long bytesInstances;
    private static final ThreadLocal<int[]> $BadCharSkipArrays;
    private static final boolean CHECK_STRING_REF;

    private static boolean checkBuiltIn(StringRef b, String toCompare) {
        assert (b.$eq(new StringRef(toCompare)));
        assert (b.$equals(toCompare));
        assert (StringRef.builtInConst(b));
        return true;
    }

    private static boolean builtInConst(StringRef $Prm0) {
        if ($Prm0 == EMPTY) {
            return true;
        }
        if ($Prm0 == SPACE) {
            return true;
        }
        if ($Prm0 == DOT) {
            return true;
        }
        if ($Prm0 == PLUS) {
            return true;
        }
        if ($Prm0 == MINUS) {
            return true;
        }
        if ($Prm0 == ZERO) {
            return true;
        }
        if ($Prm0 == ONE) {
            return true;
        }
        if ($Prm0 == TWO) {
            return true;
        }
        if ($Prm0 == THREE) {
            return true;
        }
        if ($Prm0 == SLASH) {
            return true;
        }
        return $Prm0 == DOT_DOT;
    }

    private static long min(long a, long b) {
        return a < b ? a : b;
    }

    private static int min(int a, int b) {
        return a < b ? a : b;
    }

    private static long max(long a, long b) {
        return a > b ? a : b;
    }

    private static int max(int a, int b) {
        return a > b ? a : b;
    }

    private static int compareMemory(char.ptr Lhs, int LhsStartIdx, char.ptr Rhs, int RhsStartIdx, int Length) {
        if (Length == 0) {
            return 0;
        }
        return std.memcmp((char.ptr)Lhs, (int)LhsStartIdx, (char.ptr)Rhs, (int)RhsStartIdx, (int)Length);
    }

    private static int compareMemory(char.ptr Lhs, int LhsStartIdx, byte[] Rhs, int RhsStartIdx, int Length) {
        if (Length == 0) {
            return 0;
        }
        return std.memcmp((char.ptr)Lhs, (int)LhsStartIdx, (byte[])Rhs, (int)RhsStartIdx, (int)Length);
    }

    private static int compareMemory(char.ptr Lhs, int LhsStartIdx, CharSequence Rhs, int RhsIdx, int Length) {
        if (Length == 0) {
            return 0;
        }
        return std.memcmp((char.ptr)Lhs, (int)LhsStartIdx, (CharSequence)Rhs, (int)RhsIdx, (int)Length);
    }

    private static int compareMemory(byte[] Lhs, int LhsStartIdx, CharSequence Rhs, int RhsIdx, int Length) {
        if (Length == 0) {
            return 0;
        }
        return std.memcmp_null_termed((CharSequence)Rhs, (int)RhsIdx, (byte[])Lhs, (int)LhsStartIdx, (int)Length);
    }

    public StringRef() {
        this.Data = null;
        this.Length = 0;
        StringRef.trackEmptyInstance();
    }

    public StringRef(Object obj) {
        this(StringRef.toCharPtr(obj));
    }

    private static char.ptr toCharPtr(Object obj) {
        if (obj instanceof CharSequence) {
            StringRef.trackCharSeqInstance();
            return NativePointer.create_char$ptr((CharSequence)((CharSequence)obj));
        }
        if (obj instanceof char.ptr) {
            StringRef.trackOtherInstance();
            return (char.ptr)obj;
        }
        throw new AssertionError((Object)("Unexpected " + obj));
    }

    public StringRef(char.ptr Str) {
        this.Data = Native.$toConst((char.ptr)Str);
        assert (Str != null) : "StringRef cannot be built from a NULL argument";
        this.Length = std.strlen((char.ptr)Str);
        StringRef.trackOtherInstance();
    }

    public StringRef(char.ptr data, long length) {
        this(data, Unsigned.long2uint((long)length));
    }

    public StringRef(char.ptr data, int length) {
        assert (length >= 0) : "can not be negative " + length;
        this.Data = Native.$toConst((char.ptr)data);
        this.Length = length;
        assert (data != null || length == 0) : "StringRef cannot be built from a NULL argument with non-null length";
        StringRef.trackOtherInstance();
    }

    public StringRef(CharSequence string2, int length) {
        this(NativePointer.create_char$ptr((CharSequence)string2), length);
        StringRef.trackCharSeqInstance();
    }

    public StringRef(std.string Str) {
        this.Data = Native.$toConst((char.ptr)Str.data());
        this.Length = Str.length();
        StringRef.trackOtherInstance();
    }

    public StringRef(CharSequence seq) {
        this.Data = Native.$toConst((char.ptr)NativePointer.create_char$ptr((CharSequence)seq));
        this.Length = seq.length();
        StringRef.trackCharSeqInstance();
    }

    public StringRef(byte[] seq, int Len) {
        assert (Len >= 0) : "can not be negative " + Len;
        this.Data = Native.$toConst((char.ptr)NativePointer.create_const_char$ptr((byte[])seq));
        this.Length = Len;
        StringRef.trackBytesInstance();
    }

    public StringRef(byte[] seq, int startIdx, int Len) {
        assert (Len >= 0) : "can not be negative " + Len;
        this.Data = Native.$toConst((char.ptr)NativePointer.create_const_char$ptr((byte[])seq, (long)startIdx));
        this.Length = Len;
        StringRef.trackBytesInstance();
    }

    public char.ptr begin() {
        return this.Data;
    }

    public char.ptr end() {
        return this.Length == 0 ? this.Data : (char.ptr)this.Data.$add(this.Length);
    }

    public char.ptr data() {
        return this.Data;
    }

    public boolean empty() {
        return this.Length == 0;
    }

    public int size() {
        return this.Length;
    }

    public byte front() {
        assert (!this.empty());
        return this.Data.$at(0);
    }

    public byte back() {
        assert (!this.empty());
        return this.Data.$at(this.Length - 1);
    }

    public boolean equals(StringRef RHS) {
        StringRef.checkStringRef(RHS);
        return RHS == this || this.Length == RHS.Length && StringRef.compareMemory(this.Data, 0, RHS.Data, 0, RHS.Length) == 0;
    }

    public boolean equals(CharSequence RHS) {
        int length = RHS.length();
        return this.Length == length && StringRef.compareMemory(this.Data, 0, RHS, 0, length) == 0;
    }

    public boolean equals(std.string RHS) {
        int length = RHS.length();
        return this.Length == length && StringRef.compareMemory(this.Data, 0, RHS.$array(), 0, length) == 0;
    }

    public boolean equals_lower(StringRef RHS) {
        return this.Length == RHS.Length && this.compare_lower(RHS) == 0;
    }

    public int compare(StringRef RHS) {
        if (RHS == this) {
            return 0;
        }
        int Res = StringRef.compareMemory(this.Data, 0, RHS.Data, 0, StringRef.min(this.Length, RHS.Length));
        if (Res != 0) {
            return Res < 0 ? -1 : 1;
        }
        if (this.Length == RHS.Length) {
            return 0;
        }
        return this.Length < RHS.Length ? -1 : 1;
    }

    public int compare_lower(StringRef RHS) {
        if (RHS == this) {
            return 0;
        }
        int Res = StringRefStatics.ascii_strncasecmp(this.Data, RHS.Data, StringRef.min(this.Length, RHS.Length));
        if (Res != 0) {
            return Res;
        }
        if (this.Length == RHS.Length) {
            return 0;
        }
        return this.Length < RHS.Length ? -1 : 1;
    }

    public int compare_numeric(StringRef RHS) {
        if (RHS == this) {
            return 0;
        }
        int E = StringRef.min(this.Length, RHS.Length);
        for (int I = 0; I != E; ++I) {
            if (StringRefStatics.ascii_isdigit(this.Data.$at(I)) && StringRefStatics.ascii_isdigit(RHS.Data.$at(I))) {
                int Res;
                int J;
                for (J = I + 1; J != E + 1; ++J) {
                    boolean rd;
                    boolean ld = J < this.Length && StringRefStatics.ascii_isdigit(this.Data.$at(J));
                    boolean bl = rd = J < RHS.Length && StringRefStatics.ascii_isdigit(RHS.Data.$at(J));
                    if (ld != rd) {
                        return rd ? -1 : 1;
                    }
                    if (!rd) break;
                }
                if ((Res = StringRef.compareMemory(this.Data, I, RHS.Data, I, J - I)) != 0) {
                    return Res < 0 ? -1 : 1;
                }
                I = J - 1;
                continue;
            }
            if (this.Data.$at(I) == RHS.Data.$at(I)) continue;
            return (short)this.Data.$at(I) < (short)RHS.Data.$at(I) ? -1 : 1;
        }
        if (this.Length == RHS.Length) {
            return 0;
        }
        return this.Length < RHS.Length ? -1 : 1;
    }

    public int edit_distance(StringRef Other) {
        return this.edit_distance(Other, true, 0);
    }

    public int edit_distance(StringRef Other, boolean AllowReplacements) {
        return this.edit_distance(Other, AllowReplacements, 0);
    }

    public int edit_distance(StringRef Other, boolean AllowReplacements, int MaxEditDistance) {
        return llvm.ComputeEditDistance(new ArrayRefChar(this.data(), this.size()), new ArrayRefChar(Other.data(), Other.size()), AllowReplacements, MaxEditDistance);
    }

    public std.string str() {
        if (this.Data == null) {
            return new std.string();
        }
        return new std.string(this.Data, this.Length);
    }

    public byte $at(int Index) {
        assert (Index < this.Length) : "Invalid index!";
        return this.Data.$at(Index);
    }

    public byte $at(long Index) {
        assert (Index < (long)this.Length) : "Invalid index!";
        return this.Data.$at(Unsigned.long2uint((long)Index));
    }

    public std.string $basic_string() {
        return this.str();
    }

    public boolean startswith(StringRef Prefix) {
        StringRef.checkStringRef(Prefix);
        return this.Length >= Prefix.Length && StringRef.compareMemory(this.Data, 0, Prefix.Data, 0, Prefix.Length) == 0;
    }

    public boolean startswith(std.string Prefix) {
        int length = Prefix.length();
        return this.Length >= length && StringRef.compareMemory(this.Data, 0, Prefix.$array(), 0, length) == 0;
    }

    public boolean startswith(CharSequence Prefix) {
        int length = Prefix.length();
        return this.Length >= length && StringRef.compareMemory(this.Data, 0, Prefix, 0, length) == 0;
    }

    public boolean startswith(char.ptr Prefix) {
        int length = std.strlen((char.ptr)Prefix);
        return this.Length >= length && StringRef.compareMemory(this.Data, 0, Prefix, 0, length) == 0;
    }

    public boolean startswith_lower(StringRef Prefix) {
        return this.Length >= Prefix.Length && StringRefStatics.ascii_strncasecmp(this.Data, Prefix.Data, Prefix.Length) == 0;
    }

    public boolean endswith(StringRef Suffix) {
        StringRef.checkStringRef(Suffix);
        return this.Length >= Suffix.Length && StringRef.compareMemory(this.Data, this.Length - Suffix.Length, Suffix.Data, 0, Suffix.Length) == 0;
    }

    public boolean endswith(CharSequence Suffix) {
        int length = Suffix.length();
        return this.Length >= length && StringRef.compareMemory(this.Data, this.Length - length, Suffix, 0, length) == 0;
    }

    public boolean endswith(char.ptr Suffix) {
        int length = std.strlen((char.ptr)Suffix);
        return this.Length >= length && StringRef.compareMemory(this.Data, this.Length - length, Suffix, 0, length) == 0;
    }

    public boolean endswith_lower(StringRef Suffix) {
        return this.Length >= Suffix.Length && StringRefStatics.ascii_strncasecmp(this.Data, this.Length - Suffix.Length, Suffix.Data, 0L, Suffix.Length) == 0;
    }

    public int find(byte C) {
        return this.find(C, 0);
    }

    public int find(byte C, int From) {
        int e = this.Length;
        for (int i = StringRef.min(From, this.Length); i != e; ++i) {
            if (this.Data.$at(i) != C) continue;
            return i;
        }
        return npos;
    }

    public int find(StringRef Str) {
        return this.find(Str, 0);
    }

    public int find(StringRef Str, int From) {
        StringRef.checkStringRef(Str);
        int N = Str.size();
        if (N > this.Length) {
            return npos;
        }
        if (this.Length < 16 || N > 255 || N == 0) {
            int e = this.Length - N + 1;
            for (int i = StringRef.min(From, e); i != e; ++i) {
                if (StringRef.compareMemory(this.Data, i, Str.Data, 0, N) != 0) continue;
                return i;
            }
            return npos;
        }
        if (From >= this.Length) {
            return npos;
        }
        int[] BadCharSkip = StringRef.$BadCharSkip();
        std.memset((int[])BadCharSkip, (int)N, (int)256);
        for (int i = 0; i != N - 1; ++i) {
            BadCharSkip[Casts.$char((byte)Str.$at((int)i))] = N - 1 - i;
        }
        int Len = this.Length - From;
        int Pos = From;
        while (Len >= N) {
            if (StringRef.compareMemory(this.Data, Pos, Str.Data, 0, N) == 0) {
                return Pos;
            }
            int Skip = BadCharSkip[Casts.$char((byte)this.$at(Pos + N - 1))];
            assert (Skip >= 0) : "must be unsigned value";
            Len -= Skip;
            Pos += Skip;
        }
        return npos;
    }

    public int find(std.string Str) {
        return this.find(Str, 0);
    }

    public int find(std.string Str, int From) {
        int N = Str.size();
        if (N > this.Length) {
            return npos;
        }
        if (this.Length < 16 || N > 255 || N == 0) {
            int e = this.Length - N + 1;
            for (int i = StringRef.min(From, e); i != e; ++i) {
                if (StringRef.compareMemory(this.Data, i, Str.$array(), 0, N) != 0) continue;
                return i;
            }
            return npos;
        }
        if (From >= this.Length) {
            return npos;
        }
        int[] BadCharSkip = StringRef.$BadCharSkip();
        std.memset((int[])BadCharSkip, (int)N, (int)256);
        for (int i = 0; i != N - 1; ++i) {
            BadCharSkip[Casts.$char((byte)Str.$at((int)i))] = N - 1 - i;
        }
        int Len = this.Length - From;
        int Pos = From;
        while (Len >= N) {
            if (StringRef.compareMemory(this.Data, Pos, Str.$array(), 0, N) == 0) {
                return Pos;
            }
            int Skip = BadCharSkip[Casts.$char((byte)this.$at(Pos + N - 1))];
            assert (Skip >= 0) : "must be unsigned value";
            Len -= Skip;
            Pos += Skip;
        }
        return npos;
    }

    public int find(CharSequence Str) {
        return this.find(Str, 0);
    }

    public int find(CharSequence Str, int From) {
        int N = Str.length();
        if (N > this.Length) {
            return npos;
        }
        if (this.Length < 16 || N > 255 || N == 0) {
            int e = this.Length - N + 1;
            for (int i = StringRef.min(From, e); i != e; ++i) {
                if (StringRef.compareMemory(this.Data, i, Str, 0, N) != 0) continue;
                return i;
            }
            return npos;
        }
        if (From >= this.Length) {
            return npos;
        }
        int[] BadCharSkip = StringRef.$BadCharSkip();
        std.memset((int[])BadCharSkip, (int)N, (int)256);
        for (int i = 0; i != N - 1; ++i) {
            BadCharSkip[Str.charAt((int)i)] = N - 1 - i;
        }
        int Len = this.Length - From;
        int Pos = From;
        while (Len >= N) {
            if (StringRef.compareMemory(this.Data, Pos, Str, 0, N) == 0) {
                return Pos;
            }
            int Skip = BadCharSkip[Casts.$char((byte)this.$at(Pos + N - 1))];
            assert (Skip >= 0) : "must be unsigned value";
            Len -= Skip;
            Pos += Skip;
        }
        return npos;
    }

    public static int find(CharSequence Str, byte[] Data, int DataIndex, int DataLength) {
        int Length;
        int N = Str.length();
        if (N > (Length = DataLength)) {
            return npos;
        }
        int From = 0;
        if (Length < 16 || N > 255 || N == 0) {
            int e = Length - N + 1;
            for (int i = StringRef.min(From, e); i != e; ++i) {
                if (StringRef.compareMemory(Data, DataIndex + i, Str, 0, N) != 0) continue;
                return DataIndex + i;
            }
            return npos;
        }
        if (From >= Length) {
            return npos;
        }
        int[] BadCharSkip = StringRef.$BadCharSkip();
        std.memset((int[])BadCharSkip, (int)N, (int)256);
        for (int i = 0; i != N - 1; ++i) {
            BadCharSkip[Str.charAt((int)i)] = N - 1 - i;
        }
        int Len = Length - From;
        int Pos = From;
        while (Len >= N) {
            if (StringRef.compareMemory(Data, DataIndex + Pos, Str, 0, N) == 0) {
                return DataIndex + Pos;
            }
            int Skip = BadCharSkip[Casts.$char((byte)Data[Pos + N - 1])];
            assert (Skip >= 0) : "must be unsigned value";
            Len -= Skip;
            Pos += Skip;
        }
        return npos;
    }

    public int rfind(byte C) {
        return this.rfind(C, npos);
    }

    public int rfind(byte C, int From) {
        int i = From = StringRef.min(From, this.Length);
        while (i != 0) {
            if (this.Data.$at(--i) != C) continue;
            return i;
        }
        return npos;
    }

    public int rfind(StringRef Str) {
        int N = Str.size();
        if (N > this.Length) {
            return npos;
        }
        int i = this.Length - N + 1;
        int e = 0;
        while (i != e) {
            if (StringRef.compareMemory(this.Data, --i, Str.Data, 0, N) != 0) continue;
            return i;
        }
        return npos;
    }

    public int find_first_of(byte C) {
        return this.find_first_of(C, 0);
    }

    public int find_first_of(byte C, int From) {
        return this.find(C, From);
    }

    public int find_first_of(StringRef Chars) {
        return this.find_first_of(Chars, 0);
    }

    public int find_first_of(StringRef Chars, int From) {
        int i;
        std.bitset CharBits = new std.bitset(256);
        for (i = 0; i != Chars.size(); ++i) {
            CharBits.set((int)Chars.$at(i));
        }
        int e = this.Length;
        for (i = StringRef.min(From, this.Length); i != e; ++i) {
            if (!CharBits.test((int)this.Data.$at(i))) continue;
            return i;
        }
        return npos;
    }

    public int find_first_of(CharSequence Chars) {
        return this.find_first_of(Chars, 0);
    }

    public int find_first_of(CharSequence Chars, int From) {
        int i;
        std.bitset CharBits = new std.bitset(256);
        for (i = 0; i != Chars.length(); ++i) {
            CharBits.set((int)((short)Chars.charAt(i)));
        }
        int e = this.Length;
        for (i = StringRef.min(From, this.Length); i != e; ++i) {
            if (!CharBits.test((int)this.Data.$at(i))) continue;
            return i;
        }
        return npos;
    }

    public int find_first_not_of(byte C) {
        return this.find_first_not_of(C, 0);
    }

    public int find_first_not_of(byte C, int From) {
        int e = this.Length;
        for (int i = StringRef.min(From, this.Length); i != e; ++i) {
            if (this.Data.$at(i) == C) continue;
            return i;
        }
        return npos;
    }

    public int find_first_not_of(StringRef Chars) {
        return this.find_first_not_of(Chars, 0);
    }

    public int find_first_not_of(StringRef Chars, int From) {
        int i;
        std.bitset CharBits = new std.bitset(256);
        for (i = 0; i != Chars.size(); ++i) {
            CharBits.set((int)Chars.$at(i));
        }
        int e = this.Length;
        for (i = StringRef.min(From, this.Length); i != e; ++i) {
            if (CharBits.test((int)this.Data.$at(i))) continue;
            return i;
        }
        return npos;
    }

    public int find_last_of(byte C) {
        return this.find_last_of(C, npos);
    }

    public int find_last_of(byte C, int From) {
        return this.rfind(C, From);
    }

    public int find_last_of(StringRef Chars) {
        return this.find_last_of(Chars, npos);
    }

    public int find_last_of(StringRef Chars, int From) {
        int i;
        std.bitset CharBits = new std.bitset(256);
        for (i = 0; i != Chars.size(); ++i) {
            CharBits.set((int)Chars.$at(i));
        }
        int e = -1;
        for (i = StringRef.min(From, this.Length) - 1; i != e; --i) {
            if (!CharBits.test((int)this.Data.$at(i))) continue;
            return i;
        }
        return npos;
    }

    public int find_last_not_of(byte C) {
        return this.find_last_not_of(C, npos);
    }

    public int find_last_not_of(byte C, int From) {
        int e = -1;
        for (int i = StringRef.min(From, this.Length) - 1; i != e; --i) {
            if (this.Data.$at(i) == C) continue;
            return i;
        }
        return npos;
    }

    public int find_last_not_of(StringRef Chars) {
        return this.find_last_not_of(Chars, npos);
    }

    public int find_last_not_of(StringRef Chars, int From) {
        int i;
        std.bitset CharBits = new std.bitset(256);
        int e = Chars.size();
        for (i = 0; i != e; ++i) {
            CharBits.set((int)Chars.$at(i));
        }
        e = -1;
        for (i = StringRef.min(From, this.Length) - 1; i != e; --i) {
            if (CharBits.test((int)this.Data.$at(i))) continue;
            return i;
        }
        return npos;
    }

    public int count(byte C) {
        int Count = 0;
        int e = this.Length;
        for (int i = 0; i != e; ++i) {
            if (this.Data.$at(i) != C) continue;
            ++Count;
        }
        return Count;
    }

    public int count(StringRef Str) {
        int Count = 0;
        int N = Str.size();
        if (N > this.Length) {
            return 0;
        }
        int e = this.Length - N + 1;
        for (int i = 0; i != e; ++i) {
            if (StringRef.compareMemory(this.Data, i, Str.Data, 0, N) != 0) continue;
            ++Count;
        }
        return Count;
    }

    public boolean getAsInteger(int Radix, int.ref Result) {
        llint.ref LLVal = NativePointer.create_llint$ref((long)0L);
        if (llvm.getAsSignedInteger(this, Radix, LLVal) || (long)((int)LLVal.$deref()) != LLVal.$deref()) {
            return true;
        }
        Result.$set((int)LLVal.$deref());
        return false;
    }

    public boolean getAsInteger(int Radix, uint.ref Result) {
        ullint.ref ULLVal = NativePointer.create_ullint$ref((long)0L);
        if (llvm.getAsUnsignedInteger(this, Radix, ULLVal) || ULLVal.$deref() != ULLVal.$deref()) {
            return true;
        }
        Result.$set(ULLVal.$deref());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAsInteger(int Radix, APInt Result) {
        APInt RadixAP = null;
        APInt CharAP = null;
        try {
            StringRef Str = new StringRef(this);
            if (Radix == 0) {
                Radix = StringRefStatics.GetAutoSenseRadix(Str);
            }
            assert (Radix > 1) : Radix <= 36;
            if (Str.empty()) {
                boolean bl = true;
                return bl;
            }
            while (!Str.empty() && Str.front() == NativePointer.$0) {
                Str.$assign$substr(1);
            }
            if (Str.empty()) {
                Result.$assign(new APInt(64, 0L));
                boolean bl = false;
                return bl;
            }
            int Log2Radix = 0;
            while (1 << Log2Radix < Radix) {
                ++Log2Radix;
            }
            boolean IsPowerOf2Radix = 1 << Log2Radix == Radix;
            int BitWidth = Log2Radix * Str.size();
            if (BitWidth < Result.getBitWidth()) {
                BitWidth = Unsigned.long2uint((long)Result.getBitWidth());
            } else if (BitWidth > Result.getBitWidth()) {
                Result.$assign(Result.zext(BitWidth));
            }
            RadixAP = new APInt();
            CharAP = new APInt();
            if (!IsPowerOf2Radix) {
                RadixAP.$assign(new APInt(BitWidth, (long)Radix));
                CharAP.$assign(new APInt(BitWidth, 0L));
            }
            Result.$assign(0L);
            while (!Str.empty()) {
                int CharVal;
                if (Str.$at(0) >= NativePointer.$0 && Str.$at(0) <= NativePointer.$9) {
                    CharVal = Str.$at(0) - NativePointer.$0;
                } else if (Str.$at(0) >= NativePointer.$a && Str.$at(0) <= NativePointer.$z) {
                    CharVal = Str.$at(0) - NativePointer.$a + 10;
                } else if (Str.$at(0) >= NativePointer.$A && Str.$at(0) <= NativePointer.$Z) {
                    CharVal = Str.$at(0) - NativePointer.$A + 10;
                } else {
                    boolean bl = true;
                    return bl;
                }
                if (CharVal >= Radix) {
                    boolean bl = true;
                    return bl;
                }
                if (IsPowerOf2Radix) {
                    Result.$lshiftassign(Log2Radix);
                    Result.$orassign(CharVal);
                } else {
                    Result.$starassign(RadixAP);
                    CharAP.$assign(CharVal);
                    Result.$addassign(CharAP);
                }
                Str.$assign$substr(1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (CharAP != null) {
                CharAP.$destroy();
            }
            if (RadixAP != null) {
                RadixAP.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.string lower() {
        std.string Result = null;
        try {
            Result = new std.string(this.size(), 0);
            int e = this.size();
            for (int i = 0; i != e; ++i) {
                Result.$set(i, StringRefStatics.ascii_tolower(this.Data.$at(i)));
            }
            std.string string2 = Result;
            return string2;
        }
        finally {
            if (Result != null) {
                Result.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.string upper() {
        std.string Result = null;
        try {
            Result = new std.string(this.size(), 0);
            int e = this.size();
            for (int i = 0; i != e; ++i) {
                Result.$set(i, StringRefStatics.ascii_toupper(this.Data.$at(i)));
            }
            std.string string2 = Result;
            return string2;
        }
        finally {
            if (Result != null) {
                Result.$destroy();
            }
        }
    }

    public StringRef substr(int Start) {
        return this.substr(Start, npos);
    }

    public StringRef substr(int Start, int N) {
        return new StringRef((long)(Start = StringRef.min(Start, this.Length)) == 0L ? this.Data : (char.ptr)this.Data.$add(Start), StringRef.min(N, this.Length - Start));
    }

    public StringRef $assign$substr(int NewStart) {
        return this.$assign$substr(NewStart, this.Length - NewStart);
    }

    public StringRef $assign$substr(int NewStart, int NewLen) {
        assert (!StringRef.builtInConst(this));
        assert (NewStart <= this.Length) : NewStart + "<=" + this.Length;
        assert (this.Data != null);
        assert (!NativePointer.builtInConst((char.ptr)this.Data));
        this.Data = Native.$incConstIndex((char.ptr)this.Data, (int)NewStart);
        assert (NewLen == npos || NewStart + NewLen <= this.Length) : NewStart + " + " + NewLen + "<=" + this.Length;
        this.Length = StringRef.min(NewLen, this.Length - NewStart);
        return this;
    }

    public StringRef drop_front() {
        return this.drop_front(1);
    }

    public StringRef drop_front(int N) {
        assert (this.size() >= N) : "Dropping more elements than exist";
        return this.substr(N);
    }

    public StringRef drop_back() {
        return this.drop_back(1);
    }

    public StringRef drop_back(int N) {
        assert (this.size() >= N) : "Dropping more elements than exist";
        return this.substr(0, this.size() - N);
    }

    public StringRef $assign$drop_back() {
        return this.$assign$drop_back(1);
    }

    public StringRef $assign$drop_back(int N) {
        assert (this.size() >= N) : "Dropping more elements than exist";
        return this.$assign$substr(0, this.size() - N);
    }

    public StringRef slice(int Start, int End) {
        Start = StringRef.min(Start, this.Length);
        End = StringRef.min(StringRef.max(Start, End), this.Length);
        return new StringRef((long)Start == 0L ? this.Data : (char.ptr)this.Data.$add(Start), End - Start);
    }

    public std.pair<StringRef, StringRef> split(byte Separator) {
        int Idx = this.find(Separator);
        if (Idx == npos) {
            return std.make_pair((Object)new StringRef(this), (Object)new StringRef());
        }
        return std.make_pair((Object)this.slice(0, Idx), (Object)this.slice(Idx + 1, npos));
    }

    public std.pair<StringRef, StringRef> split(char Separator) {
        return this.split(NativePointer.$((char)Separator));
    }

    public std.pair<StringRef, StringRef> split(StringRef Separator) {
        int Idx = this.find(Separator);
        if (Idx == npos) {
            return std.make_pair((Object)new StringRef(this), (Object)new StringRef());
        }
        return std.make_pair((Object)this.slice(0, Idx), (Object)this.slice(Idx + Separator.size(), npos));
    }

    public void split(SmallVectorImpl<StringRef> A, StringRef Separators) {
        this.split(A, Separators, -1, true);
    }

    public void split(SmallVectorImpl<StringRef> A, StringRef Separators, int MaxSplit) {
        this.split(A, Separators, MaxSplit, true);
    }

    public void split(SmallVectorImpl<StringRef> A, StringRef Separators, int MaxSplit, boolean KeepEmpty) {
        StringRef rest = new StringRef(this);
        for (int splits = 0; rest.data() != null && (MaxSplit < 0 || splits < MaxSplit); ++splits) {
            std.pair<StringRef, StringRef> p = rest.split(Separators);
            if (KeepEmpty || ((StringRef)p.first).size() != 0) {
                A.push_back((StringRef)p.first);
            }
            rest.$assign((StringRef)p.second);
        }
        if (rest.data() != null && (rest.size() != 0 || KeepEmpty)) {
            A.push_back(rest);
        }
    }

    public std.pair<StringRef, StringRef> rsplit(byte Separator) {
        int Idx = this.rfind(Separator);
        if (Idx == npos) {
            return std.make_pair((Object)new StringRef(this), (Object)new StringRef());
        }
        return std.make_pair((Object)this.slice(0, Idx), (Object)this.slice(Idx + 1, npos));
    }

    public StringRef ltrim() {
        return this.ltrim(llvm.STRING_REF_DELIMETERS);
    }

    public StringRef ltrim(StringRef Chars) {
        return this.drop_front(std.min((int)this.Length, (int)this.find_first_not_of(Chars)));
    }

    public StringRef rtrim() {
        return this.rtrim(llvm.STRING_REF_DELIMETERS);
    }

    public StringRef rtrim(StringRef Chars) {
        return this.drop_back(this.Length - std.min((int)this.Length, (int)(this.find_last_not_of(Chars) + 1)));
    }

    public StringRef trim() {
        return this.trim(llvm.STRING_REF_DELIMETERS);
    }

    public StringRef trim(StringRef Chars) {
        return this.ltrim(Chars).rtrim(Chars);
    }

    public StringRef(StringRef $Prm0) {
        this.Data = $Prm0.Data;
        this.Length = $Prm0.Length;
        StringRef.trackCopiedInstance();
    }

    public StringRef(JavaDifferentiators.Move _dparam, StringRef $Prm0) {
        this.Data = Native.$toConst((char.ptr)Native.$tryClone((char.ptr)$Prm0.Data));
        this.Length = $Prm0.Length;
    }

    public StringRef $assign(StringRef $Prm0) {
        assert (!StringRef.builtInConst(this)) : "can not modify const " + this + " into " + $Prm0 + "; probably constant was used incorrectly in outer call";
        this.Data = $Prm0.Data;
        this.Length = $Prm0.Length;
        return this;
    }

    public StringRef $assignMove(StringRef $Prm0) {
        this.Data = Native.$toConst((char.ptr)Native.$tryClone((char.ptr)$Prm0.Data));
        this.Length = $Prm0.Length;
        return this;
    }

    public StringRef $assign(char.ptr Str) {
        assert (Str != null) : "StringRef cannot be built from a NULL argument";
        return this.$assign(Str, std.strlen((char.ptr)Str));
    }

    public StringRef $assign(SmallVectorImplChar Str) {
        return this.$assign(Str.data(), Str.size());
    }

    public StringRef $assign(char.ptr Str, int Length) {
        assert (!StringRef.builtInConst(this)) : "can not modify const " + this + " into " + Str + "; probably constant was used incorrectly in outer call";
        this.Data = Native.$toConst((char.ptr)Str);
        assert (Str != null) : "StringRef cannot be built from a NULL argument";
        this.Length = Length;
        return this;
    }

    public boolean $equals(CharSequence other) {
        if (this.Length != other.length()) {
            return false;
        }
        for (int i = 0; i < this.Length; ++i) {
            if (other.charAt(i) == (char)this.Data.$at(i)) continue;
            return false;
        }
        return true;
    }

    public String toJavaString() {
        return Casts.toJavaString((char.ptr)this.Data, (int)this.Length);
    }

    public StringBuilder toJavaString(StringBuilder out) {
        return Casts.toCharSequence((char.ptr)this.Data, (int)this.Length, (StringBuilder)out);
    }

    public String toString() {
        return "StringRef{" + this.toJavaString() + "}";
    }

    public Boolean $op(Native.OpCapable.Op k, Object obj) {
        if (obj instanceof StringRef) {
            if (Native.OpCapable.Op.EQ == k) {
                return this.$eq((StringRef)obj);
            }
        } else if (obj instanceof std.string) {
            if (Native.OpCapable.Op.EQ == k) {
                return this.str().$eq((Object)((std.string)obj));
            }
        } else if (obj instanceof CharSequence && Native.OpCapable.Op.EQ == k) {
            return this.$equals((CharSequence)obj);
        }
        return null;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("StringRef can not be used as key in maps");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringRef other = (StringRef)obj;
        return this.$eq(other);
    }

    public StringRef clone() {
        return new StringRef(this);
    }

    public boolean $noteq(StringRef other) {
        return !this.$eq(other);
    }

    public boolean $eq(StringRef other) {
        return llvm.$eq_StringRef(this, other);
    }

    public void $destroy() {
        this.Data = null;
        this.Length = 0;
    }

    private static void trackCopiedInstance() {
        if (NativeTrace.STATISTICS) {
            ++copiedInstances;
        }
    }

    private static void trackCharSeqInstance() {
        if (NativeTrace.STATISTICS) {
            ++charSeqInstances;
        }
    }

    private static void trackOtherInstance() {
        if (NativeTrace.STATISTICS) {
            ++otherInstances;
        }
    }

    private static void trackEmptyInstance() {
        if (NativeTrace.STATISTICS) {
            ++emptyInstances;
        }
    }

    private static void trackBytesInstance() {
        if (NativeTrace.STATISTICS) {
            ++bytesInstances;
        }
    }

    public static void clearStatistics() {
        copiedInstances = 0L;
        charSeqInstances = 0L;
        otherInstances = 0L;
        emptyInstances = 0L;
        bytesInstances = 0L;
    }

    public static void PrintStats(raw_ostream out) {
        out.$out(String.format("%22s created:\t", StringRef.class.getSimpleName() + " Total")).$out(NativeTrace.formatNumber((long)(bytesInstances + emptyInstances + copiedInstances + charSeqInstances + otherInstances))).$out(".\n");
        out.$out(String.format("%22s created:\t", StringRef.class.getSimpleName() + " empty")).$out(NativeTrace.formatNumber((long)emptyInstances)).$out(".\n");
        out.$out(String.format("%22s created:\t", StringRef.class.getSimpleName() + " copies")).$out(NativeTrace.formatNumber((long)copiedInstances)).$out(".\n");
        out.$out(String.format("%22s created:\t", StringRef.class.getSimpleName() + " char seq")).$out(NativeTrace.formatNumber((long)charSeqInstances)).$out(".\n");
        out.$out(String.format("%22s created:\t", StringRef.class.getSimpleName() + " byte seq")).$out(NativeTrace.formatNumber((long)bytesInstances)).$out(".\n");
        out.$out(String.format("%22s created:\t", StringRef.class.getSimpleName() + " others")).$out(NativeTrace.formatNumber((long)otherInstances)).$out(".\n");
    }

    private static int[] $BadCharSkip() {
        return $BadCharSkipArrays.get();
    }

    private static void checkStringRef(StringRef check) {
        if (CHECK_STRING_REF && check.Data instanceof char.ptr.CharSequence) {
            Exception exception = new Exception("use CharSequence-based method instead for " + check);
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                String methodName = stackTraceElement.getMethodName();
                String className = stackTraceElement.getClassName();
                if (methodName.equals("<clinit>") && className.equals("org.llvm.adt.StringRef")) {
                    return;
                }
                if (className.equals("org.clang.basic.FileManager")) {
                    return;
                }
                if (className.equals("org.clang.basic.target.TargetInfo") && methodName.equals("CreateTargetInfo")) {
                    return;
                }
                if (!className.equals("org.llvm.support.MemoryBuffer") || !methodName.equals("$getMemBufferName")) continue;
                return;
            }
            exception.printStackTrace(System.out);
            System.exit(1);
        }
    }

    static {
        assert (StringRef.checkBuiltIn(EMPTY, ""));
        assert (StringRef.checkBuiltIn(SPACE, " "));
        assert (StringRef.checkBuiltIn(DOT, "."));
        assert (StringRef.checkBuiltIn(PLUS, "+"));
        assert (StringRef.checkBuiltIn(MINUS, "-"));
        assert (StringRef.checkBuiltIn(ZERO, "0"));
        assert (StringRef.checkBuiltIn(ONE, "1"));
        assert (StringRef.checkBuiltIn(TWO, "2"));
        assert (StringRef.checkBuiltIn(THREE, "3"));
        assert (StringRef.checkBuiltIn(SLASH, "/"));
        assert (StringRef.checkBuiltIn(DOT_DOT, ".."));
        npos = std.string.npos;
        emptyInstances = 0L;
        copiedInstances = 0L;
        charSeqInstances = 0L;
        otherInstances = 0L;
        bytesInstances = 0L;
        $BadCharSkipArrays = new ThreadLocal<int[]>(){

            @Override
            protected int[] initialValue() {
                return NativePointer.new$int((int)256);
            }
        };
        CHECK_STRING_REF = Boolean.getBoolean("clank.check.string.ref");
    }
}

