/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.type;
import org.llvm.adt.DenseMapInfo;

public class DenseMapIterator<KeyT, ValueT>
implements type.iterator<DenseMapIterator<KeyT, ValueT>, std.pair<KeyT, ValueT>>,
Cloneable {
    private final DenseMapInfo<KeyT> keyInfoT;
    private final std.pair<KeyT, ValueT>[] Buckets;
    private int Ptr;
    private final int End;
    private static final int INVALID_INDEX = Integer.MAX_VALUE;

    public DenseMapIterator(DenseMapInfo<KeyT> keyInfoT) {
        this.keyInfoT = keyInfoT;
        this.Ptr = Integer.MAX_VALUE;
        this.End = Integer.MAX_VALUE;
        this.Buckets = null;
    }

    public DenseMapIterator(DenseMapInfo<KeyT> keyInfoT, std.pair<KeyT, ValueT>[] Buckets, int Pos, int E) {
        this(keyInfoT, Buckets, Pos, E, false);
    }

    public DenseMapIterator(DenseMapInfo<KeyT> keyInfoT, std.pair<KeyT, ValueT>[] Buckets, int Pos, int E, boolean NoAdvance) {
        this.keyInfoT = keyInfoT;
        this.Ptr = Pos;
        this.End = E;
        this.Buckets = Buckets;
        if (!NoAdvance) {
            this.AdvancePastEmptyBuckets();
        }
    }

    public DenseMapIterator<KeyT, ValueT> $assignMove(DenseMapIterator<KeyT, ValueT> other) {
        assert (this.End == other.End);
        assert (this.Buckets == other.Buckets);
        this.Ptr = other.Ptr;
        return this;
    }

    public DenseMapIterator(DenseMapIterator<KeyT, ValueT> I) {
        this.keyInfoT = I.keyInfoT;
        this.Ptr = I.Ptr;
        this.End = I.End;
        this.Buckets = I.Buckets;
    }

    public std.pair<KeyT, ValueT> $star() {
        return this.Buckets[this.Ptr];
    }

    public type.ref<std.pair<KeyT, ValueT>> star$ref() {
        return new type.ref<std.pair<KeyT, ValueT>>(){
            int localPtr;
            {
                this.localPtr = DenseMapIterator.this.Ptr;
            }

            public std.pair<KeyT, ValueT> $deref() {
                return DenseMapIterator.this.Buckets[this.localPtr];
            }

            public std.pair<KeyT, ValueT> $set(std.pair<KeyT, ValueT> value) {
                std.pair pair2 = value;
                ((DenseMapIterator)DenseMapIterator.this).Buckets[this.localPtr] = pair2;
                return pair2;
            }

            public type.ptr<std.pair<KeyT, ValueT>> deref$ptr() {
                return NativePointer.create_type$ptr((Object[])DenseMapIterator.this.Buckets, (long)this.localPtr);
            }
        };
    }

    public type.ptr<std.pair<KeyT, ValueT>> $arrow() {
        return NativePointer.create_type$ptr((Object[])this.Buckets, (long)this.Ptr);
    }

    public boolean $eq(DenseMapIterator<KeyT, ValueT> RHS) {
        assert (this.Buckets == RHS.Buckets);
        return this.Ptr == RHS.Ptr;
    }

    public boolean $noteq(DenseMapIterator<KeyT, ValueT> RHS) {
        assert (this.Buckets == RHS.Buckets);
        return this.Ptr != RHS.Ptr;
    }

    public DenseMapIterator<KeyT, ValueT> $preInc() {
        ++this.Ptr;
        this.AdvancePastEmptyBuckets();
        return this;
    }

    public DenseMapIterator<KeyT, ValueT> $postInc() {
        DenseMapIterator<KeyT, ValueT> tmp = new DenseMapIterator<KeyT, ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
        ++this.Ptr;
        return tmp;
    }

    private void AdvancePastEmptyBuckets() {
        KeyT Empty = this.keyInfoT.getEmptyKey();
        KeyT Tombstone = this.keyInfoT.getTombstoneKey();
        while (Native.$noteq((int)this.Ptr, (int)this.End) && (this.Buckets[this.Ptr].first == Empty || this.Buckets[this.Ptr].first == Tombstone)) {
            ++this.Ptr;
        }
    }

    public DenseMapIterator<KeyT, ValueT> clone() {
        return new DenseMapIterator<KeyT, ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
    }

    public DenseMapIterator<KeyT, ValueT> const_clone() {
        return new DenseMapIterator<KeyT, ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
    }

    public boolean $eq(Object other) {
        if (other instanceof DenseMapIterator) {
            return Native.$eq((int)this.Ptr, (int)((DenseMapIterator)other).Ptr);
        }
        return false;
    }

    public boolean $noteq(Object other) {
        if (other instanceof DenseMapIterator) {
            return Native.$noteq((int)this.Ptr, (int)((DenseMapIterator)other).Ptr);
        }
        return true;
    }

    public int $sub(DenseMapIterator<KeyT, ValueT> iter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DenseMapIterator<KeyT, ValueT> $preDec() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DenseMapIterator<KeyT, ValueT> $postDec() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DenseMapIterator<KeyT, ValueT> $inc(int amount) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DenseMapIterator<KeyT, ValueT> $inc(long amount) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DenseMapIterator<KeyT, ValueT> $dec(int amount) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DenseMapIterator<KeyT, ValueT> $dec(long amount) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DenseMapIterator<KeyT, ValueT> $add(int amount) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DenseMapIterator<KeyT, ValueT> $add(long amount) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DenseMapIterator<KeyT, ValueT> $sub(int amount) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DenseMapIterator<KeyT, ValueT> $sub(long amount) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

