/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.aliases.char;
import org.clank.support.void;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.support.raw_ostream;

public class raw_svector_ostream
extends raw_ostream
implements Destructors.ClassWithDestructor {
    private SmallString OS;

    @Override
    protected void write_impl(char.ptr Ptr, int PtrIdx, int Size) {
        if (Ptr.$eq((Object)this.OS.end())) {
            long NewSize = this.OS.size() + Size;
            assert (NewSize <= (long)this.OS.capacity()) : "Invalid write_impl() call!";
            this.OS.set_size(NewSize);
        } else {
            assert (this.GetNumBytesInBuffer() == 0);
            this.OS.append(Ptr, Size);
        }
        this.OS.reserve(this.OS.size() + 64);
        this.updateBufferPointer();
    }

    @Override
    protected void write_impl(byte[] Ptr, int PtrIdx, int Size) {
        if (PtrIdx == this.OS.size()) {
            long NewSize = this.OS.size() + Size;
            assert (NewSize <= (long)this.OS.capacity()) : "Invalid write_impl() call!";
            this.OS.set_size(NewSize);
        } else {
            assert (this.GetNumBytesInBuffer() == 0);
            this.OS.append(Ptr, PtrIdx, Size);
        }
        this.OS.reserve(this.OS.size() + 64);
        this.updateBufferPointer();
    }

    @Override
    protected long current_pos() {
        return this.OS.size();
    }

    public raw_svector_ostream(SmallString O) {
        this.OS = O;
        this.OS.reserve(this.OS.size() + 128);
        this.SetBuffer(this.OS.end().toPointer(), this.OS.capacity() - this.OS.size());
    }

    @Override
    public void $destroy() {
        this.flush();
        super.$destroy();
    }

    public void resync() {
        assert (this.GetNumBytesInBuffer() == 0) : "Didn't flush before mutating vector";
        if (this.OS.capacity() - this.OS.size() < 64) {
            this.OS.reserve(this.OS.capacity() * 2);
        }
        this.updateBufferPointer();
    }

    public StringRef str() {
        this.flush();
        return new StringRef(this.OS.begin().toPointer(), this.OS.size());
    }

    private void updateBufferPointer() {
        char.ptr bufferStart = this.getBufferStart();
        if (bufferStart != null && bufferStart.$array() == this.OS.$array()) {
            assert (bufferStart.isComparableTo((void.ptr)this.OS.end().toPointer()));
            Native.$setIndex((char.ptr)bufferStart, (int)this.OS.size());
            assert (bufferStart.$eq((Object)this.OS.end().toPointer()));
        } else {
            bufferStart = this.OS.end().toPointer();
        }
        this.SetBuffer(bufferStart, this.OS.capacity() - this.OS.size());
    }
}

