/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.sys;

import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.support.impl.PathStatics;
import org.llvm.support.llvm;
import org.llvm.support.sys.impl.PathAppendHelper;

public final class path {
    private static final String RFS_PREFIX = "rfs:";

    public static const_iterator begin(StringRef path2) {
        const_iterator i = new const_iterator(path2, PathStatics.find_first_component(path2), 0);
        return i;
    }

    public static const_iterator end(StringRef path2) {
        const_iterator i = new const_iterator(path2, StringRef.EMPTY, path2.size());
        return i;
    }

    public static reverse_iterator rbegin(StringRef Path2) {
        reverse_iterator I = new reverse_iterator(Path2, StringRef.EMPTY, Path2.size());
        return I.$preInc();
    }

    public static reverse_iterator rend(StringRef Path2) {
        reverse_iterator I = new reverse_iterator(Path2, Path2.substr(0, 0), 0);
        return I;
    }

    public static void remove_filename(SmallString path2) {
        int end_pos = PathStatics.parent_path_end(path2.$StringRef());
        if (end_pos != StringRef.npos) {
            path2.set_size(end_pos);
        }
    }

    public static void replace_extension(SmallString path2, Twine extension) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, Twine a) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            if (!a.isTriviallyEmpty()) {
                SmallString a_storage = helper.$a_storage();
                components.push_back(a.toStringRef(a_storage));
            }
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, StringRef a) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            components.push_back(a);
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, char.ptr a) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            components.push_back(helper.$a_StringRef().$assign(a));
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, std.string a) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            components.push_back(helper.$a_StringRef().$assign(a.data(), a.length()));
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, SmallVectorImplChar a) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            components.push_back(helper.$a_StringRef().$assign(a.data(), a.size()));
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, Twine a, Twine b) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            if (!a.isTriviallyEmpty()) {
                SmallString a_storage = helper.$a_storage();
                components.push_back(a.toStringRef(a_storage));
            }
            if (!b.isTriviallyEmpty()) {
                SmallString b_storage = helper.$b_storage();
                components.push_back(b.toStringRef(b_storage));
            }
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, StringRef a, StringRef b) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            components.push_back(a);
            components.push_back(b);
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, Twine a, Twine b, Twine c) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            if (!a.isTriviallyEmpty()) {
                SmallString a_storage = helper.$a_storage();
                components.push_back(a.toStringRef(a_storage));
            }
            if (!b.isTriviallyEmpty()) {
                SmallString b_storage = helper.$b_storage();
                components.push_back(b.toStringRef(b_storage));
            }
            if (!c.isTriviallyEmpty()) {
                SmallString c_storage = helper.$c_storage();
                components.push_back(c.toStringRef(c_storage));
            }
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, StringRef a, StringRef b, StringRef c) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            components.push_back(a);
            components.push_back(b);
            components.push_back(c);
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, char.ptr a, char.ptr b, char.ptr c) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            components.push_back(helper.$a_StringRef().$assign(a));
            components.push_back(helper.$b_StringRef().$assign(b));
            components.push_back(helper.$c_StringRef().$assign(c));
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, Twine a, Twine b, Twine c, Twine d) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            if (!a.isTriviallyEmpty()) {
                SmallString a_storage = helper.$a_storage();
                components.push_back(a.toStringRef(a_storage));
            }
            if (!b.isTriviallyEmpty()) {
                SmallString b_storage = helper.$b_storage();
                components.push_back(b.toStringRef(b_storage));
            }
            if (!c.isTriviallyEmpty()) {
                SmallString c_storage = helper.$c_storage();
                components.push_back(c.toStringRef(c_storage));
            }
            if (!d.isTriviallyEmpty()) {
                SmallString d_storage = helper.$d_storage();
                components.push_back(d.toStringRef(d_storage));
            }
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(SmallString path2, StringRef a, StringRef b, StringRef c, StringRef d) {
        PathAppendHelper helper = PathAppendHelper.$get();
        try {
            SmallVector<StringRef> components = helper.$components();
            components.push_back(a);
            components.push_back(b);
            components.push_back(c);
            components.push_back(d);
            path.appendImpl(components, path2);
        }
        finally {
            PathAppendHelper.$release(helper);
        }
    }

    private static void appendImpl(SmallVector<StringRef> components, SmallString path2) {
        T[] $array = components.$array();
        int e = components.size();
        for (int i = 0; i != e; ++i) {
            StringRef i$star = (StringRef)$array[i];
            boolean path_has_sep = !path2.empty() && path.is_separator(path2.$at(path2.size() - 1));
            boolean component_has_sep = !i$star.empty() && path.is_separator(i$star.$at(0));
            boolean is_root_name = path.has_root_name(i$star);
            if (path_has_sep) {
                int loc = i$star.find_first_not_of(PathStatics.separators);
                StringRef c_ = i$star.substr(loc);
                path2.append(c_, 0, c_.size());
                continue;
            }
            if (!(component_has_sep || path2.empty() || is_root_name)) {
                path2.push_back(PathStatics.prefered_separator);
            }
            path2.append(i$star, 0, i$star.size());
        }
    }

    public static void append(SmallString path2, const_iterator begin, const_iterator end) {
        begin = (const_iterator)Native.$tryClone((NativeCloneable)begin);
        while (begin.$noteq((Object)end)) {
            path.append(path2, begin.$star());
            begin.$preInc();
        }
    }

    public static void __native(Twine path2, SmallString result) {
        assert (!path2.isSingleStringRef() || path2.getSingleStringRef().data() != result.data()) : "path and result are not allowed to overlap!";
        result.clear();
        path2.toVector(result);
        path.__native(result);
    }

    public static void __native(SmallString path2) {
        if (!llvm.LLVM_ON_WIN32) {
            // empty if block
        }
        std.replace((char.iterator)path2.begin(), (char.iterator)path2.end(), (char)'/', (char)'\\');
    }

    public static StringRef root_name(StringRef path2) {
        StringRef First = PathStatics.find_first_component(path2);
        int size = First.size();
        if (size > 0) {
            int pathOffsetInURL = path.get_path_offset_in_url(path2);
            byte first_at_zero = First.$at(pathOffsetInURL);
            boolean has_net = pathOffsetInURL == 0 && size > 2 && path.is_separator(first_at_zero) && First.$at(1) == first_at_zero;
            boolean has_drive = false;
            if (!llvm.LLVM_ON_WIN32) {
                // empty if block
            }
            has_drive = First.endswith(":");
            if (has_net || has_drive) {
                return First;
            }
        }
        return StringRef.EMPTY;
    }

    public static StringRef root_directory(StringRef path2) {
        StringRef First = PathStatics.find_first_component(path2);
        int size = First.size();
        if (size > 0) {
            int pathOffsetInURL = path.get_path_offset_in_url(path2);
            byte first_at_zero = First.$at(pathOffsetInURL);
            boolean first_at_zero_is_separator = path.is_separator(first_at_zero);
            boolean has_net = pathOffsetInURL == 0 && size > 2 && first_at_zero_is_separator && First.$at(1) == first_at_zero;
            boolean has_drive = false;
            has_drive = First.endswith(":");
            if (has_net || has_drive) {
                const_iterator pos = new const_iterator(path2, First, 0);
                int EndPosition = path2.size();
                pos.$preInc();
                if (pos.Position != EndPosition && path.is_separator(pos.$star().$at(0))) {
                    return pos.$star();
                }
            }
            if (!has_net && first_at_zero_is_separator) {
                return First;
            }
        }
        return StringRef.EMPTY;
    }

    public static StringRef root_path(StringRef path2) {
        StringRef First = PathStatics.find_first_component(path2);
        int size = First.size();
        if (size > 0) {
            int pathOffsetInURL = path.get_path_offset_in_url(path2);
            byte first_at_zero = First.$at(pathOffsetInURL);
            boolean first_at_zero_is_separator = path.is_separator(first_at_zero);
            boolean has_net = pathOffsetInURL == 0 && size > 2 && first_at_zero_is_separator && First.$at(1) == first_at_zero;
            boolean has_drive = false;
            if (llvm.LLVM_ON_WIN32 || NativeTrace.UNIT_TEST_MODE) {
                has_drive = First.endswith(":");
            }
            if (has_net || has_drive) {
                const_iterator pos = new const_iterator(path2, First, 0);
                int EndPosition = path2.size();
                pos.$preInc();
                if (pos.Position != EndPosition && path.is_separator(pos.$star().$at(0))) {
                    return path2.substr(0, First.size() + pos.$arrow().size());
                }
                return First;
            }
            if (first_at_zero_is_separator) {
                return First;
            }
        }
        return StringRef.EMPTY;
    }

    public static StringRef relative_path(StringRef path2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static StringRef parent_path(StringRef path2) {
        int end_pos = PathStatics.parent_path_end(path2);
        if (end_pos == StringRef.npos) {
            return StringRef.EMPTY;
        }
        return path2.substr(0, end_pos);
    }

    public static StringRef filename(StringRef path2) {
        return path.rbegin(path2).$star();
    }

    public static StringRef stem(StringRef path2) {
        StringRef fname = path.filename(path2);
        int pos = fname.find_last_of(NativePointer.$((char)'.'));
        if (pos == StringRef.npos) {
            return fname;
        }
        if (fname.size() == 1 && llvm.$eq_StringRef(fname, (CharSequence)".") || fname.size() == 2 && llvm.$eq_StringRef(fname, (CharSequence)"..")) {
            return fname;
        }
        return fname.substr(0, pos);
    }

    public static StringRef extension(StringRef path2) {
        StringRef fname = path.filename(path2);
        int pos = fname.find_last_of(NativePointer.$((char)'.'));
        if (pos == StringRef.npos) {
            return StringRef.EMPTY;
        }
        if (fname.size() == 1 && llvm.$eq_StringRef(fname, (CharSequence)".") || fname.size() == 2 && llvm.$eq_StringRef(fname, (CharSequence)"..")) {
            return StringRef.EMPTY;
        }
        return fname.substr(pos);
    }

    public static boolean is_separator(byte value) {
        switch (value) {
            case 47: 
            case 92: {
                return true;
            }
        }
        return false;
    }

    public static void system_temp_directory(boolean erasedOnReboot, SmallString result) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean has_root_name(Twine path2) {
        SmallString path_storage = new SmallString(128);
        StringRef p = path2.toStringRef(path_storage);
        return path.has_root_name(p);
    }

    public static boolean has_root_name(StringRef p) {
        return !path.root_name(p).empty();
    }

    public static boolean has_root_directory(Twine path2) {
        SmallString path_storage = new SmallString(128);
        StringRef p = path2.toStringRef(path_storage);
        return path.has_root_directory(p);
    }

    public static boolean has_root_directory(StringRef p) {
        return !path.root_directory(p).empty();
    }

    public static boolean has_root_path(Twine path2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean has_relative_path(Twine path2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean has_parent_path(Twine path2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean has_filename(Twine path2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean has_stem(Twine path2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean has_extension(Twine path2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean is_absolute(Twine path2) {
        if (path2.isSingleStringRef()) {
            return path.is_absolute(path2.getSingleStringRef());
        }
        SmallString path_storage = new SmallString(128);
        path2.toVector(path_storage);
        return path.is_absolute(path_storage.$StringRef());
    }

    public static boolean is_absolute(char.ptr path2) {
        return path.is_absolute(new StringRef(path2));
    }

    public static boolean is_absolute(std.string path2) {
        return path.is_absolute(new StringRef(path2));
    }

    public static boolean is_absolute(StringRef p) {
        int pathOffsetInURL = path.get_path_offset_in_url(p);
        if (pathOffsetInURL > 0) {
            return true;
        }
        boolean rootDir = path.has_root_directory(p);
        boolean rootName = true;
        rootName = llvm.LLVM_ON_WIN32 ? path.has_root_name(p) : true;
        return rootDir && rootName;
    }

    public static boolean is_relative(Twine path2) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static boolean is_empty(StringRef path2) {
        int pathOffsetInURL = path.get_path_offset_in_url(path2);
        if (pathOffsetInURL > 0) {
            return path2.size() <= pathOffsetInURL;
        }
        return path2.empty();
    }

    public static int get_path_offset_in_url(StringRef path2) {
        String prefix;
        if (path2 != null && path2.startswith(prefix = RFS_PREFIX)) {
            int colonPos = path2.find_first_of((byte)58, prefix.length());
            if (colonPos != StringRef.npos) {
                int pos;
                for (pos = colonPos + 1; pos < path2.size() && std.isdigit((int)path2.$at(pos)) != 0; ++pos) {
                }
                return pos;
            }
            ((Throwable)((Object)new AssertionError((Object)("The path " + path2 + " starts with " + prefix + " but does not contain a colon after it")))).printStackTrace(System.err);
            return prefix.length();
        }
        return 0;
    }

    public static class reverse_iterator
    extends std.iterator<std.input_iterator_tag, StringRef>
    implements type.iterator<reverse_iterator, StringRef> {
        private final StringRef Path;
        private StringRef Component;
        private int Position;

        public StringRef $star() {
            return this.Component;
        }

        public StringRef $arrow() {
            return this.Component;
        }

        public reverse_iterator $preInc() {
            int end_pos;
            int root_dir_pos = PathStatics.root_dir_start(this.Path);
            if (this.Position == this.Path.size() && Unsigned.compare((int)this.Path.size(), (int)(root_dir_pos + 1)) > 0 && path.is_separator(this.Path.$at(this.Position - 1))) {
                --this.Position;
                this.Component = StringRef.DOT;
                return this;
            }
            for (end_pos = this.Position; end_pos > 0 && end_pos - 1 != root_dir_pos && path.is_separator(this.Path.$at(end_pos - 1)); --end_pos) {
            }
            int start_pos = PathStatics.filename_pos(this.Path.substr(0, end_pos));
            this.Component = this.Path.slice(start_pos, end_pos);
            this.Position = start_pos;
            return this;
        }

        public reverse_iterator $postInc() {
            throw new UnsupportedOperationException("Not implemented yet.");
        }

        public boolean $eq(Object _RHS) {
            reverse_iterator RHS = (reverse_iterator)((Object)_RHS);
            return this.Path.begin() == RHS.Path.begin() && llvm.$eq_StringRef(this.Component, RHS.Component) && this.Position == RHS.Position;
        }

        public boolean $noteq(Object RHS) {
            return !this.$eq(RHS);
        }

        public reverse_iterator(StringRef Path2, StringRef Component, int Position) {
            this.Path = Path2;
            this.Component = Component;
            this.Position = Position;
        }

        public reverse_iterator(reverse_iterator $Prm0) {
            super((std.iterator)$Prm0);
            this.Path = $Prm0.Path;
            this.Component = $Prm0.Component;
            this.Position = $Prm0.Position;
        }

        public type.ref<StringRef> star$ref() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int $sub(reverse_iterator iter) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public reverse_iterator $preDec() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public reverse_iterator $postDec() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public reverse_iterator $inc(int amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public reverse_iterator $inc(long amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public reverse_iterator $dec(int amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public reverse_iterator $dec(long amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public reverse_iterator $add(int amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public reverse_iterator $add(long amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public reverse_iterator $sub(int amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public reverse_iterator $sub(long amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public reverse_iterator clone() {
            return new reverse_iterator(this);
        }

        public reverse_iterator const_clone() {
            return this.clone();
        }

        public String toString() {
            return "Path=" + this.Path + ", Component=" + this.Component + ", Position=" + this.Position + super.toString();
        }
    }

    public static class const_iterator
    extends std.iterator<std.input_iterator_tag, StringRef>
    implements type.iterator<const_iterator, StringRef> {
        private final StringRef Path;
        private StringRef Component;
        private int Position;

        public const_iterator(StringRef Path2, StringRef Component, int Position) {
            this.Path = Path2;
            this.Component = Component;
            this.Position = Position;
        }

        public StringRef $star() {
            return this.Component;
        }

        public StringRef $arrow() {
            return this.Component;
        }

        public const_iterator $preInc() {
            boolean was_net;
            assert (this.Position < this.Path.size()) : "Tried to increment past end!";
            this.Position += this.Component.size();
            if (this.Position == this.Path.size()) {
                this.Component = StringRef.EMPTY;
                return this;
            }
            boolean bl = was_net = this.Component.size() > 2 && path.is_separator(this.Component.$at(0)) && this.Component.$at(1) == this.Component.$at(0) && !path.is_separator(this.Component.$at(2));
            if (path.is_separator(this.Path.$at(this.Position))) {
                if (was_net || (llvm.LLVM_ON_WIN32 || NativeTrace.UNIT_TEST_MODE) && this.Component.endswith(":")) {
                    this.Component = this.Path.substr(this.Position, 1);
                    return this;
                }
                while (this.Position != this.Path.size() && path.is_separator(this.Path.$at(this.Position))) {
                    ++this.Position;
                }
                if (this.Position == this.Path.size()) {
                    --this.Position;
                    this.Component = StringRef.DOT;
                    return this;
                }
            }
            int end_pos = this.Path.find_first_of(PathStatics.separators, this.Position);
            this.Component = this.Path.slice(this.Position, end_pos);
            return this;
        }

        public const_iterator $postInc() {
            throw new UnsupportedOperationException("EmptyBody");
        }

        public boolean $eq(Object RHS) {
            return Native.$eq((char.ptr)this.Path.begin(), (char.ptr)((const_iterator)((Object)RHS)).Path.begin()) && Native.$eq((int)this.Position, (int)((const_iterator)((Object)RHS)).Position);
        }

        public boolean $noteq(Object RHS) {
            return !this.$eq(RHS);
        }

        public int $sub(const_iterator RHS) {
            return this.Position - RHS.Position;
        }

        public const_iterator() {
            this.Path = StringRef.EMPTY;
            this.Component = StringRef.EMPTY;
        }

        public const_iterator(const_iterator $Prm0) {
            super((std.iterator)$Prm0);
            this.Path = $Prm0.Path;
            this.Component = $Prm0.Component;
            this.Position = $Prm0.Position;
        }

        public type.ref<StringRef> star$ref() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public const_iterator $preDec() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public const_iterator $postDec() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public const_iterator $inc(int amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public const_iterator $inc(long amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public const_iterator $dec(int amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public const_iterator $dec(long amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public const_iterator $add(int amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public const_iterator $add(long amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public const_iterator $sub(int amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public const_iterator $sub(long amount) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public const_iterator clone() {
            return new const_iterator(this);
        }

        public const_iterator const_clone() {
            return this.clone();
        }

        public String toString() {
            return "Path=" + this.Path + ", Component=" + this.Component + ", Position=" + this.Position + super.toString();
        }
    }
}

