/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.markup;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.ContentState;
import org.eclipse.mylyn.wikitext.core.parser.markup.DefaultIdGenerationStrategy;
import org.eclipse.mylyn.wikitext.core.parser.markup.IdGenerationStrategy;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguageConfiguration;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.ImpliedHyperlinkReplacementToken;
import org.eclipse.mylyn.wikitext.core.util.LocationTrackingReader;

public abstract class MarkupLanguage
implements Cloneable {
    private static final DefaultIdGenerationStrategy DEFAULT_ID_GENERATION_STRATEGY = new DefaultIdGenerationStrategy();
    private String name;
    private String extendsLanguage;
    private boolean filterGenerativeBlocks;
    private boolean blocksOnly;
    protected String internalLinkPattern = "{0}";
    private boolean syntaxInitialized = false;
    protected MarkupLanguageConfiguration configuration;
    private boolean enableMacros = true;

    public MarkupLanguage clone() {
        MarkupLanguage markupLanguage;
        try {
            markupLanguage = (MarkupLanguage)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        markupLanguage.setName(this.name);
        markupLanguage.internalLinkPattern = this.internalLinkPattern;
        markupLanguage.enableMacros = this.enableMacros;
        markupLanguage.configuration = this.configuration == null ? null : this.configuration.clone();
        return markupLanguage;
    }

    protected ContentState createState() {
        ContentState contentState = new ContentState();
        contentState.getIdGenerator().setGenerationStrategy(this.getIdGenerationStrategy());
        return contentState;
    }

    public IdGenerationStrategy getIdGenerationStrategy() {
        return DEFAULT_ID_GENERATION_STRATEGY;
    }

    public void processContent(MarkupParser parser, String markupContent, boolean asDocument) {
        this.initializeSyntax(false);
        this.initProcessors();
        ContentState state = this.createState();
        state.setMarkupContent(markupContent);
        LocationTrackingReader reader = new LocationTrackingReader(new StringReader(markupContent));
        DocumentBuilder builder = parser.getBuilder();
        builder.setLocator(state);
        try {
            if (asDocument) {
                builder.beginDocument();
            }
            Stack<Block> nestedBlocks = null;
            Stack<LineState> lineStates = null;
            Block currentBlock = null;
            try {
                String line = reader.readLine();
                int lineOffset = 0;
                while (line != null) {
                    block25: {
                        state.setLineNumber(reader.getLineNumber() + 1);
                        state.setLineOffset(reader.getLineOffset());
                        state.setLineCharacterOffset(lineOffset);
                        state.setLineSegmentEndOffset(0);
                        state.setLineLength(line.length());
                        do {
                            Block nestedParent;
                            int closeOffset;
                            if (nestedBlocks != null && !nestedBlocks.isEmpty() && (closeOffset = (nestedParent = (Block)nestedBlocks.peek()).findCloseOffset(line, lineOffset)) != -1) {
                                if (closeOffset > lineOffset) {
                                    String truncatedLine = line.substring(0, closeOffset);
                                    if (lineStates == null) {
                                        lineStates = new Stack<LineState>();
                                    }
                                    lineStates.push(new LineState(line, closeOffset));
                                    line = truncatedLine;
                                } else {
                                    if (currentBlock != null) {
                                        currentBlock.setClosed(true);
                                        currentBlock = null;
                                    }
                                    currentBlock = (Block)nestedBlocks.pop();
                                    lineOffset = closeOffset;
                                    state.setLineCharacterOffset(lineOffset);
                                }
                            }
                            if (currentBlock == null) {
                                if (nestedBlocks != null && !nestedBlocks.isEmpty() && (nestedParent = (Block)nestedBlocks.peek()).canResume(line, lineOffset)) {
                                    currentBlock = nestedParent;
                                }
                                if (currentBlock == null) {
                                    currentBlock = this.startBlock(line, lineOffset);
                                    if (currentBlock == null) break block25;
                                    currentBlock.setMarkupLanguage(this);
                                    currentBlock.setState(state);
                                    currentBlock.setParser(parser);
                                }
                            }
                            lineOffset = currentBlock.processLineContent(line, lineOffset);
                            if (currentBlock.isClosed()) {
                                currentBlock = null;
                            } else if (currentBlock.beginNesting()) {
                                if (nestedBlocks == null) {
                                    nestedBlocks = new Stack<Block>();
                                }
                                nestedBlocks.push(currentBlock);
                                currentBlock = null;
                            }
                            if (lineOffset >= line.length() || lineOffset < 0) break block25;
                        } while (currentBlock == null);
                        throw new IllegalStateException(String.format("if a block does not fully process a line then it must be closed, at or near line %s lineOffset %s, block %s", reader.getLineNumber(), lineOffset, currentBlock.getClass().getName()));
                    }
                    if (lineStates != null && !lineStates.isEmpty()) {
                        LineState lineState = (LineState)lineStates.pop();
                        line = lineState.line;
                        lineOffset = lineState.lineOffset;
                        continue;
                    }
                    lineOffset = 0;
                    line = reader.readLine();
                }
                state.setLineNumber(reader.getLineNumber() + 1);
                state.setLineOffset(reader.getLineOffset());
                state.setLineCharacterOffset(0);
                state.setLineLength(0);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            if (currentBlock != null && !currentBlock.isClosed()) {
                currentBlock.setClosed(true);
            }
            if (nestedBlocks != null) {
                while (!nestedBlocks.isEmpty()) {
                    Block block = (Block)nestedBlocks.pop();
                    if (block.isClosed()) continue;
                    block.setClosed(true);
                }
                nestedBlocks = null;
            }
            if (asDocument) {
                builder.endDocument();
            }
        }
        finally {
            builder.setLocator(null);
        }
    }

    private void initProcessors() {
        for (Block block : this.getBlocks()) {
            if (block.getMarkupLanguage() != null) {
                return;
            }
            block.setMarkupLanguage(this);
        }
    }

    public Block startBlock(String line, int lineOffset) {
        if (this.isEmptyLine(line)) {
            return null;
        }
        for (Block block : this.getBlocks()) {
            if (!block.canStart(line, lineOffset)) continue;
            return block.clone();
        }
        return null;
    }

    public abstract List<Block> getBlocks();

    public void configure(MarkupLanguageConfiguration configuration) throws UnsupportedOperationException {
        this.configuration = configuration;
        this.initializeSyntax(true);
    }

    private void initializeSyntax(boolean force) {
        if (force || !this.syntaxInitialized) {
            this.syntaxInitialized = true;
            this.initializeSyntax();
        }
    }

    protected abstract void initializeSyntax();

    public void emitMarkupLine(MarkupParser parser, ContentState state, int textLineOffset, String line, int offset) {
        int previousShift;
        block4: {
            PatternBasedElementProcessor phraseModifier;
            if (offset == line.length()) {
                return;
            }
            if (this.blocksOnly) {
                this.emitMarkupText(parser, state, line.substring(offset));
                return;
            }
            previousShift = state.getShift();
            state.setShift(previousShift + textLineOffset);
            while ((phraseModifier = this.getPhraseModifierSyntax().findPatternBasedElement(line, offset)) != null) {
                int newOffset = phraseModifier.getLineStartOffset();
                if (offset < newOffset) {
                    state.setLineCharacterOffset(state.getShift() + offset);
                    state.setLineSegmentEndOffset(state.getShift() + newOffset);
                    String text = line.substring(offset, newOffset);
                    this.emitMarkupText(parser, state, text);
                }
                phraseModifier.setMarkupLanguage(this);
                phraseModifier.setParser(parser);
                phraseModifier.setState(state);
                state.setLineCharacterOffset(state.getShift() + phraseModifier.getLineStartOffset());
                state.setLineSegmentEndOffset(state.getShift() + phraseModifier.getLineEndOffset());
                phraseModifier.emit();
                offset = phraseModifier.getLineEndOffset();
                if (offset < line.length()) continue;
                break block4;
            }
            state.setLineCharacterOffset(state.getShift() + offset);
            state.setLineSegmentEndOffset(state.getShift() + line.length());
            this.emitMarkupText(parser, state, line.substring(offset));
        }
        state.setShift(previousShift);
    }

    public void emitMarkupLine(MarkupParser parser, ContentState state, String line, int offset) {
        this.emitMarkupLine(parser, state, 0, line, offset);
    }

    public void emitMarkupText(MarkupParser parser, ContentState state, String text) {
        block3: {
            PatternBasedElementProcessor tokenReplacement;
            if (this.blocksOnly) {
                parser.getBuilder().characters(text);
                return;
            }
            int offset = 0;
            while ((tokenReplacement = this.getReplacementTokenSyntax().findPatternBasedElement(text, offset)) != null) {
                int newOffset = tokenReplacement.getLineStartOffset();
                if (offset < newOffset) {
                    String text2 = text.substring(offset, newOffset);
                    this.emitMarkupText(parser, state, text2);
                }
                tokenReplacement.setMarkupLanguage(this);
                tokenReplacement.setParser(parser);
                tokenReplacement.setState(state);
                state.setLineCharacterOffset(state.getShift() + tokenReplacement.getLineStartOffset());
                state.setLineSegmentEndOffset(state.getShift() + tokenReplacement.getLineEndOffset());
                tokenReplacement.emit();
                offset = tokenReplacement.getLineEndOffset();
                if (offset < text.length()) continue;
                break block3;
            }
            parser.getBuilder().characters(offset > 0 ? text.substring(offset) : text);
        }
    }

    protected abstract PatternBasedSyntax getPhraseModifierSyntax();

    protected abstract PatternBasedSyntax getReplacementTokenSyntax();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExtendsLanguage() {
        return this.extendsLanguage;
    }

    public void setExtendsLanguage(String extendsLanguage) {
        this.extendsLanguage = extendsLanguage;
    }

    public boolean isFilterGenerativeContents() {
        return this.filterGenerativeBlocks;
    }

    public void setFilterGenerativeContents(boolean filterGenerativeBlocks) {
        this.filterGenerativeBlocks = filterGenerativeBlocks;
    }

    public boolean isBlocksOnly() {
        return this.blocksOnly;
    }

    public void setBlocksOnly(boolean blocksOnly) {
        this.blocksOnly = blocksOnly;
    }

    public boolean isEmptyLine(String line) {
        if (line.length() == 0) {
            return true;
        }
        int x = 0;
        while (x < line.length()) {
            if (!Character.isWhitespace(line.charAt(x))) {
                return false;
            }
            ++x;
        }
        return true;
    }

    public String getInternalLinkPattern() {
        return this.internalLinkPattern;
    }

    public void setInternalLinkPattern(String internalLinkPattern) {
        this.internalLinkPattern = internalLinkPattern;
    }

    public boolean isDetectingRawHyperlinks() {
        this.initializeSyntax(false);
        PatternBasedSyntax replacementTokenSyntax = this.getReplacementTokenSyntax();
        if (replacementTokenSyntax != null) {
            for (PatternBasedElement element : replacementTokenSyntax.getElements()) {
                if (!(element instanceof ImpliedHyperlinkReplacementToken)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEnableMacros() {
        return this.enableMacros;
    }

    public void setEnableMacros(boolean enableMacros) {
        this.enableMacros = enableMacros;
    }

    public DocumentBuilder createDocumentBuilder(Writer out) {
        throw new UnsupportedOperationException();
    }

    private static class Group {
        int count;

        private Group() {
        }
    }

    private static class LineState {
        int lineOffset;
        String line;

        public LineState(String line, int offset) {
            this.line = line;
            this.lineOffset = offset;
        }
    }

    public static final class PatternBasedSyntax {
        protected List<PatternBasedElement> elements = new ArrayList<PatternBasedElement>();
        protected Pattern elementPattern;
        protected List<Integer> elementGroup = new ArrayList<Integer>();
        private final StringBuilder patternBuffer = new StringBuilder();
        private int patternGroup = 0;
        private final Stack<Group> groups = new Stack();

        public PatternBasedSyntax() {
            this.groups.push(new Group());
        }

        public void add(PatternBasedElement element) {
            this.elementPattern = null;
            this.elements.add(element);
            if (this.groups.peek().count++ > 0) {
                this.patternBuffer.append('|');
            }
            ++this.patternGroup;
            this.patternBuffer.append('(');
            this.patternBuffer.append(element.getPattern(this.patternGroup));
            this.patternBuffer.append(')');
            this.elementGroup.add(this.patternGroup);
            this.patternGroup += element.getPatternGroupCount();
        }

        protected List<PatternBasedElement> getElements() {
            return Collections.unmodifiableList(this.elements);
        }

        public void beginGroup(String regexFragment, int size) {
            this.add(regexFragment, size, true);
        }

        public void endGroup(String regexFragment, int size) {
            this.add(regexFragment, size, false);
        }

        private void add(String regexFragment, int size, boolean beginGroup) {
            this.elementPattern = null;
            if (beginGroup) {
                if (this.groups.peek().count++ > 0) {
                    this.patternBuffer.append('|');
                }
                this.groups.push(new Group());
                this.patternBuffer.append("(?:");
            } else {
                this.groups.pop();
            }
            this.patternBuffer.append(regexFragment);
            if (!beginGroup) {
                this.patternBuffer.append(")");
            }
            this.patternGroup += size;
        }

        public PatternBasedElementProcessor findPatternBasedElement(String lineText, int offset) {
            Matcher matcher = this.getPattern().matcher(lineText);
            if (offset > 0) {
                matcher.region(offset, lineText.length());
            }
            if (matcher.find()) {
                int size = this.elementGroup.size();
                int x = 0;
                while (x < size) {
                    int group = this.elementGroup.get(x);
                    String value = matcher.group(group);
                    if (value != null) {
                        PatternBasedElement element = this.elements.get(x);
                        PatternBasedElementProcessor processor = element.newProcessor();
                        processor.setLineStartOffset(matcher.start());
                        processor.setLineEndOffset(matcher.end());
                        processor.setGroup(0, matcher.group(0), matcher.start(0), matcher.end(0));
                        int y = 0;
                        while (y < element.getPatternGroupCount()) {
                            int groupIndex = group + y + 1;
                            processor.setGroup(y + 1, matcher.group(groupIndex), matcher.start(groupIndex), matcher.end(groupIndex));
                            ++y;
                        }
                        return processor;
                    }
                    ++x;
                }
                throw new IllegalStateException();
            }
            return null;
        }

        public Pattern getPattern() {
            if (this.elementPattern == null) {
                if (this.patternBuffer.length() > 0) {
                    this.elementPattern = Pattern.compile(this.patternBuffer.toString());
                } else {
                    return null;
                }
            }
            return this.elementPattern;
        }

        public void clear() {
            this.elements.clear();
            this.elementPattern = null;
            this.elementGroup.clear();
            this.patternBuffer.delete(0, this.patternBuffer.length());
            this.patternGroup = 0;
            this.groups.clear();
            this.groups.push(new Group());
        }
    }
}

