/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DebuggerOption;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class EvalAnnotation
extends Annotation {
    private final RequestProcessor RP = new RequestProcessor("Debugger tooltip evaluation", 2);
    private static EvalAnnotation lastAnnotation = null;

    public String getAnnotationType() {
        return null;
    }

    public String getShortDescription() {
        final Line.Part lp = (Line.Part)this.getAttachedAnnotatable();
        if (lp == null) {
            return null;
        }
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                EvalAnnotation.this.evalExpression(lp);
            }
        });
        return null;
    }

    private void evalExpression(Line.Part lp) {
        try {
            NativeDebugger debugger;
            Line line = lp.getLine();
            Lookup lineLookup = line.getLookup();
            DataObject dobj = (DataObject)lineLookup.lookup(DataObject.class);
            EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            final StyledDocument doc = ec.openDocument();
            JEditorPane ep = EditorContextDispatcher.getDefault().getCurrentEditor();
            if (ep == null) {
                return;
            }
            int pos = lp.getColumn();
            final int offset = NbDocument.findLineOffset((StyledDocument)doc, (int)line.getLineNumber()) + pos;
            String expr = EvalAnnotation.getSelectedExpr(ep, offset);
            if (expr == null && DebuggerOption.BALLOON_EVAL.isEnabled(NativeDebuggerManager.get().globalOptions())) {
                Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line.getLineNumber());
                if (lineElem == null) {
                    return;
                }
                int lineStartOffset = lineElem.getStartOffset();
                int lineLen = lineElem.getEndOffset() - lineStartOffset;
                expr = doc.getText(lineStartOffset, lineLen);
                final AtomicBoolean skip = new AtomicBoolean(false);
                doc.render(new Runnable(){

                    @Override
                    public void run() {
                        String category;
                        TokenItem token = CndTokenUtilities.getToken((Document)doc, (int)offset, (boolean)true);
                        if (token != null && !"identifier".equals(category = token.id().primaryCategory())) {
                            skip.set(true);
                        }
                    }
                });
                if (skip.get()) {
                    return;
                }
            } else {
                pos = -1;
            }
            if ((debugger = NativeDebuggerManager.get().currentNativeDebugger()) != null) {
                lastAnnotation = this;
                debugger.balloonEvaluate(pos, expr);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    private static String getSelectedExpr(JEditorPane ep, int offset) {
        if (ep.getCaret() != null && ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
            return ep.getSelectedText();
        }
        return null;
    }

    public static String extractExpr(int pos, String text) {
        int bp = pos;
        int ep = pos;
        int len = text.length();
        if (pos >= len) {
            return null;
        }
        char[] str = new char[len + 1];
        text.getChars(0, len, str, 0);
        str[len] = '\u0000';
        int bbalance = 0;
        int pbalance = 0;
        boolean foundEnd = false;
        while (!foundEnd && str[ep] != '\u0000') {
            if (!Character.isLetterOrDigit(str[ep]) && str[ep] != '_') {
                switch (str[ep]) {
                    case '[': {
                        ++bbalance;
                        break;
                    }
                    case ']': {
                        if (str[ep] != ']' || --bbalance >= 0) break;
                        foundEnd = true;
                        break;
                    }
                    case '*': {
                        break;
                    }
                    case ':': {
                        if (str[ep + 1] != ':') {
                            foundEnd = true;
                            break;
                        }
                        ++ep;
                        break;
                    }
                    default: {
                        foundEnd = true;
                    }
                }
                if (foundEnd) break;
            }
            ++ep;
        }
        bbalance = 0;
        pbalance = 0;
        foundEnd = false;
        while (!foundEnd && bp >= 0) {
            if (!Character.isLetterOrDigit(str[bp]) && str[bp] != '_') {
                switch (str[bp]) {
                    case ')': {
                        if (bp < ep && (Character.isLetterOrDigit(str[bp + 1]) || str[bp + 1] == '_')) {
                            pbalance = 0;
                            while (bp >= pos) {
                                if (str[bp] == ')') {
                                    ++pbalance;
                                } else if (str[bp] == '(' && --pbalance == 0) {
                                    --bp;
                                    break;
                                }
                                --bp;
                            }
                            foundEnd = true;
                            break;
                        }
                        ++pbalance;
                        break;
                    }
                    case ']': {
                        ++bbalance;
                        break;
                    }
                    case '(': {
                        if (--pbalance >= 0) break;
                        foundEnd = true;
                        break;
                    }
                    case '[': {
                        if (--bbalance >= 0) break;
                        foundEnd = true;
                        break;
                    }
                    case '>': {
                        if (bp == pos || str[bp - 1] != '-') {
                            foundEnd = true;
                            break;
                        }
                        --bp;
                        break;
                    }
                    case '\u0000': 
                    case '.': 
                    case ':': {
                        break;
                    }
                    case '&': 
                    case '*': {
                        foundEnd = true;
                        break;
                    }
                    default: {
                        foundEnd = true;
                    }
                }
                if (foundEnd) break;
            }
            --bp;
        }
        String result = "";
        if (++bp >= ep) {
            return null;
        }
        while (bp < ep) {
            result = result + str[bp++];
        }
        return result;
    }

    public static void postResult(int rt1, int rt2, int flags, String lhs, String rhs, String rhs2, String rhs3) {
        if (lhs == null) {
            EvalAnnotation.postResult(rhs);
        } else if (rhs2 == null && rhs3 == null) {
            EvalAnnotation.postResult(lhs + " = " + rhs);
        } else {
            StringBuffer sb = new StringBuffer(200);
            sb.append(lhs);
            sb.append(' ');
            sb.append('=');
            sb.append(' ');
            sb.append(rhs);
            if (rhs2 != null) {
                sb.append("\n");
                sb.append("type: ");
                sb.append(rhs2);
            }
            EvalAnnotation.postResult(sb.toString());
        }
    }

    public static void postResult(String tipText) {
        if (lastAnnotation != null) {
            lastAnnotation.firePropertyChange("shortDescription", null, tipText);
        }
    }
}

