/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.Catalog;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.spi.debugger.ui.Controller;

public class EditMaxObjectPanel
extends JPanel {
    private JLabel maxObjectLabel = null;
    private JTextField maxObjectText = null;
    private String max_object_size;
    private NativeDebugger debugger;
    private final MaxObjectController controller = new MaxObjectController();

    public EditMaxObjectPanel(NativeDebugger debugger, String initialMaxObject) {
        if (initialMaxObject != null) {
            this.max_object_size = initialMaxObject;
        }
        this.debugger = debugger;
        this.initComponents();
        this.maxObjectText.setText(this.max_object_size);
    }

    public Controller getController() {
        return this.controller;
    }

    public void refocus() {
        if (this.maxObjectText != null) {
            this.maxObjectText.requestFocusInWindow();
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(11, 12, 1, 11));
        this.maxObjectLabel = new JLabel(Catalog.get("LBL_max_object_size"));
        this.maxObjectLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_MaxObjectSize"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 5, 10);
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)this.maxObjectLabel, gbc);
        this.maxObjectText = new JTextField();
        Catalog.setAccessibleDescription(this.maxObjectText, "ACSD_MaxObjectSize");
        this.maxObjectText.setBorder(new CompoundBorder(this.maxObjectText.getBorder(), new EmptyBorder(2, 0, 2, 0)));
        this.maxObjectText.setColumns(25);
        this.maxObjectText.selectAll();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 0;
        this.add((Component)this.maxObjectText, gbc);
        this.maxObjectLabel.setLabelFor(this.maxObjectText);
        this.maxObjectText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                EditMaxObjectPanel.this.controller.validChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditMaxObjectPanel.this.controller.validChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditMaxObjectPanel.this.controller.validChanged();
            }
        });
        this.refocus();
    }

    public boolean validateFields() {
        String expr = this.maxObjectText.getText();
        return !IpeUtils.isEmpty(expr);
    }

    protected void post() {
        this.debugger.setOption("DBX_output_max_object_size", this.maxObjectText.getText());
    }

    private class MaxObjectController
    implements Controller {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        private MaxObjectController() {
        }

        public boolean ok() {
            if (!EditMaxObjectPanel.this.validateFields()) {
                return false;
            }
            EditMaxObjectPanel.this.post();
            return true;
        }

        public boolean cancel() {
            return true;
        }

        public boolean isValid() {
            if (IpeUtils.isEmpty(EditMaxObjectPanel.this.maxObjectText.getText())) {
                return false;
            }
            try {
                int i = Integer.parseInt(EditMaxObjectPanel.this.maxObjectText.getText());
                if (i < 1) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        public final void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public final void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        void validChanged() {
            this.pcs.firePropertyChange("valid", null, null);
        }
    }
}

