/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.assembly;

import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerAnnotation;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.Location;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.DisInfoPanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Disassembly;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.Exceptions;

public class DisassemblyUtils {
    private DisassemblyUtils() {
    }

    private static int getAddressLine(String address) {
        Disassembly dis = Disassembly.getCurrent();
        if (dis == null) {
            return -1;
        }
        return dis.getAddressLine(address);
    }

    public static String getLineAddress(int lineNo) {
        Disassembly dis = Disassembly.getCurrent();
        if (dis == null) {
            return null;
        }
        return dis.getLineAddress(lineNo);
    }

    public static boolean showLine(int line) {
        if (line != -1) {
            FileObject fo = Disassembly.getFileObject();
            if (fo != null) {
                try {
                    Line disLine = Disassembly.getLine(line);
                    EditorBridge.showInEditor(disLine);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        } else {
            Disassembly.open();
        }
        return false;
    }

    public static boolean showAddress(String address) {
        return DisassemblyUtils.showLine(DisassemblyUtils.getAddressLine(address));
    }

    public static void annotatePC(Location location, DebuggerAnnotation pcMarker, boolean andShow) {
        Disassembly dis = Disassembly.getCurrent();
        if (dis == null) {
            return;
        }
        int line = dis.getAddressLine(location.pc());
        if (line != -1) {
            FileObject fo = Disassembly.getFileObject();
            if (fo != null) {
                try {
                    Line disLine = Disassembly.getLine(line);
                    if (andShow) {
                        EditorBridge.showInEditor(disLine);
                    }
                    pcMarker.setLine(disLine, true);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                DisInfoPanel.setLocation(location);
            }
        } else {
            pcMarker.setLine(null, true);
        }
    }
}

