/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints;

import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.debugger.common2.DbgGuiModule;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerAnnotation;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeSession;
import org.netbeans.modules.cnd.debugger.common2.debugger.RoutingToken;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointBag;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Context;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Gen;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Handler;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpointType;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.props.ActionProperty;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.props.ContextProperty;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.props.CountLimitProperty;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.InstructionBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.InstructionBreakpointType;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.LineBreakpointType;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.StackHistory;
import org.netbeans.modules.cnd.debugger.common2.utils.props.BooleanProperty;
import org.netbeans.modules.cnd.debugger.common2.utils.props.EnumProperty;
import org.netbeans.modules.cnd.debugger.common2.utils.props.IntegerProperty;
import org.netbeans.modules.cnd.debugger.common2.utils.props.Property;
import org.netbeans.modules.cnd.debugger.common2.utils.props.PropertyOwner;
import org.netbeans.modules.cnd.debugger.common2.utils.props.PropertyOwnerSupport;
import org.netbeans.modules.cnd.debugger.common2.utils.props.StringProperty;
import org.netbeans.modules.cnd.debugger.common2.values.Action;
import org.netbeans.modules.cnd.debugger.common2.values.CountLimit;
import org.netbeans.modules.cnd.debugger.common2.values.EditUndo;
import org.netbeans.modules.cnd.debugger.common2.values.EditUndoable;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.spi.debugger.ContextAwareSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.BreakpointType;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.text.Line;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;

public abstract class NativeBreakpoint
extends Breakpoint
implements PropertyOwner,
EditUndoable {
    static boolean enableDifferentiates = true;
    private static boolean skipSingleParent = true;
    private static boolean sessionOnly = true;
    private static boolean ghostBuster;
    private static int nextSerialNo;
    private int serialNo = nextSerialNo++;
    private final NativeBreakpointType breakpointType;
    private ModelListener updater;
    private boolean disposed = false;
    private boolean isConditional = false;
    private NativeBreakpoint original;
    private boolean updateTimestamp = false;
    private boolean srcOutOfSync = false;
    private Date timestamp = new Date(0L);
    private ArrayList<DebuggerAnnotation> annotations = new ArrayList();
    private int visitedAnnotationId = 0;
    private final int flags;
    static final int RESTORED = 1;
    public static final int TOPLEVEL = 2;
    public static final int SUBBREAKPOINT = 4;
    public static final int MIDBREAKPOINT = 8;
    private NativeDebugger debugger;
    private Handler handler;
    private final CopyOnWriteArrayList<NativeBreakpoint> children;
    private NativeBreakpoint parent;
    private StackHistory stackHistory = new StackHistory();
    private boolean deletingChildren = false;
    protected PropertyOwnerSupport pos = new PropertyOwnerSupport(){

        @Override
        protected void propagateDirty() {
        }
    };
    private Action actionType = Action.STOP;
    protected final ContextProperty context = new ContextProperty(this.pos, "context", "PROP_BREAKPOINT_CONTEXT", true, null);
    protected final StringProperty whileIn = new StringProperty(this.pos, "whileIn", "PROP_BREAKPOINT_WHILEIN", false, null);
    protected final StringProperty qwhileIn = new StringProperty(this.pos, "qwhileIn", null, false, null);
    protected final StringProperty condition = new StringProperty(this.pos, "condition", "PROP_BREAKPOINT_CONDITION", false, null);
    protected final StringProperty qcondition = new StringProperty(this.pos, "qcondition", null, false, null);
    protected final StringProperty lwp = new StringProperty(this.pos, "lwp", "PROP_BREAKPOINT_LWP", false, null);
    protected final StringProperty thread = new StringProperty(this.pos, "thread", "PROP_BREAKPOINT_THREAD", false, null);
    protected final IntegerProperty id = new IntegerProperty(this.pos, "id", "PROP_BREAKPOINT_ID", true, 0){

        @Override
        public Object getAsObject() {
            if (this.get() == 0) {
                return "";
            }
            return super.getAsObject();
        }

        @Override
        protected void setFromStringImpl(String s) {
            if (IpeUtils.isEmpty(s)) {
                super.setFromStringImpl("0");
            } else {
                super.setFromStringImpl(s);
            }
        }

        @Override
        protected void setFromObjectImpl(Object o) {
            if (o instanceof String) {
                this.setFromStringImpl((String)o);
            } else {
                super.setFromObjectImpl(o);
            }
        }
    };
    protected final IntegerProperty count = new IntegerProperty(this.pos, "count", "PROP_BREAKPOINT_COUNT", true, 0);
    protected final BooleanProperty temp = new BooleanProperty(this.pos, "temp", "PROP_BREAKPOINT_TEMP", false, false);
    protected final BooleanProperty adjusted = new BooleanProperty(this.pos, "adjusted", null, false, false);
    protected final CountLimitProperty countLimit = new CountLimitProperty(this.pos, "countLimit", "PROP_BREAKPOINT_COUNTLIMIT", false, null);
    protected final ActionProperty action = new ActionProperty(this.pos, "action", null, false, Action.STOP);
    protected final StringProperty script = new StringProperty(this.pos, "script", null, false, null);
    protected final BooleanProperty java = new BooleanProperty(this.pos, "java", "PROP_BREAKPOINT_JAVA", false, false);
    private final BooleanProperty enabled = new BooleanProperty(this.pos, "enabled", "PROP_BREAKPOINT_ENABLE", false, true);
    private boolean expanded = false;
    private String originalEventspec;
    private static final String debugger_icon_dir = "org/netbeans/modules/debugger/resources/breakpointsView";
    private static final String icon_dir = "org/netbeans/modules/cnd/debugger/common2/icons";
    private int routingToken = 0;

    static boolean getSkipSingleParent() {
        return skipSingleParent;
    }

    static void toggleSkipSingleParent() {
        skipSingleParent = !skipSingleParent;
        NativeBreakpoint.breakpointBag().breakpointUpdater().modelChanged((ModelEvent)new ModelEvent.TreeChanged(new Object()));
    }

    static boolean getSessionOnly() {
        return sessionOnly;
    }

    static void toggleSessionOnly() {
        sessionOnly = !sessionOnly;
        NativeBreakpoint.breakpointBag().breakpointUpdater().modelChanged((ModelEvent)new ModelEvent.TreeChanged(new Object()));
    }

    static boolean getGhostBuster() {
        return ghostBuster;
    }

    static void toggleGhostBuster() {
        ghostBuster = !ghostBuster;
    }

    private boolean isRestored() {
        return (this.flags & 1) == 1;
    }

    public final boolean isToplevel() {
        return (this.flags & 2) == 2;
    }

    public final boolean isMidlevel() {
        return (this.flags & 8) == 8;
    }

    public final boolean isSubBreakpoint() {
        return (this.flags & 4) == 4;
    }

    protected NativeBreakpoint(NativeBreakpointType breakpointType, int flags) {
        this.breakpointType = breakpointType;
        this.flags = flags;
        assert (this.isSubBreakpoint() ^ this.isMidlevel() ^ this.isToplevel());
        this.children = new CopyOnWriteArrayList();
        if (!this.isRestored()) {
            this.updateTimestamp();
        }
        this.temp.setDifferentiating(false);
        this.adjusted.setDifferentiating(false);
        this.id.setDifferentiating(false);
    }

    private static NativeDebuggerManager manager() {
        return NativeDebuggerManager.get();
    }

    protected static NativeDebugger currentDebugger() {
        return NativeBreakpoint.manager().currentNativeDebugger();
    }

    final boolean isCurrent() {
        return this.debugger != null && this.debugger == NativeBreakpoint.currentDebugger();
    }

    private static BreakpointBag breakpointBag() {
        return NativeBreakpoint.manager().breakpointBag();
    }

    private void setDebugger(NativeDebugger debugger) {
        assert (!this.isToplevel()) : "Cannot setDebugger() on toplevel bpt";
        this.debugger = debugger;
    }

    public NativeDebugger getDebugger() {
        if (this.isToplevel()) {
            return null;
        }
        return this.debugger;
    }

    private NativeBreakpoint findCurrent() {
        if (this.isToplevel()) {
            for (NativeBreakpoint c : this.children) {
                if (c.getDebugger() != NativeBreakpoint.currentDebugger()) continue;
                return c;
            }
            return null;
        }
        if (this.isMidlevel()) {
            if (this.getDebugger() == NativeBreakpoint.currentDebugger()) {
                return this;
            }
            return null;
        }
        return this.getParent().findCurrent();
    }

    public void enable() {
        if (NativeDebuggerManager.isPerTargetBpts()) {
            NativeBreakpoint current = this.findCurrent();
            if (current != null) {
                current.setPropEnabled(true);
            }
        } else {
            this.setPropEnabled(true);
        }
    }

    public void disable() {
        if (NativeDebuggerManager.isPerTargetBpts()) {
            NativeBreakpoint current = this.findCurrent();
            if (current != null) {
                current.setPropEnabled(false);
            }
        } else {
            this.setPropEnabled(false);
        }
    }

    void setDisposed(boolean disposed) {
        this.disposed = disposed;
    }

    public void dispose() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NativeBreakpoint.this.dispose();
                }
            });
            return;
        }
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.postDelete(false, Gen.primary(this));
    }

    public final NativeBreakpointType getBreakpointType() {
        return this.breakpointType;
    }

    final boolean isOfType(BreakpointType type) {
        String t1 = this.breakpointType.getTypeDisplayName();
        String t2 = type.getTypeDisplayName();
        return IpeUtils.sameString(t1, t2);
    }

    private boolean sameTypeAs(NativeBreakpoint that) {
        return this.isOfType(that.getBreakpointType());
    }

    boolean isOnlyChild() {
        assert (!this.isToplevel()) : "NB.isOnlyChild(): Cannot apply to toplevel bpt";
        return this.parent.nChildren() == 1;
    }

    public final boolean isEditable() {
        return this.original != null;
    }

    public NativeBreakpoint original() {
        return this.original;
    }

    public final void setHandler(Handler handler) {
        assert (this.isSubBreakpoint()) : "Setting a Handler for a Toplevel bpt";
        this.handler = handler;
        if (handler == null) {
            this.setId(0);
        } else {
            this.setId(handler.getId());
            this.update();
        }
    }

    public final Handler getHandler() {
        assert (this.isSubBreakpoint()) : "Can only get Handlers for sub-bpts";
        assert (!this.isEditable()) : "NB.getHandler(): disallowed for editable bpts";
        return this.handler;
    }

    private void echoUpdater(String who) {
    }

    private void setParent(NativeBreakpoint parent) {
        assert (parent != null) : "Can't set bpt parent to null";
        assert (!this.isToplevel());
        if (this.isMidlevel() ? !$assertionsDisabled && !parent.isToplevel() : !$assertionsDisabled && !parent.isMidlevel()) {
            throw new AssertionError();
        }
        this.parent = parent;
        this.updater = parent.updater;
        this.echoUpdater("setParent");
    }

    public NativeBreakpoint getParent() {
        return this.parent;
    }

    public NativeBreakpoint getMidlevelFor(NativeDebugger debugger) {
        assert (this.isToplevel());
        assert (!this.isEditable()) : "NB.setMidlevelFor(): disallowed for editable bpts";
        if (this.original != null) {
            return this.original.getMidlevelFor(debugger);
        }
        if (debugger == null) {
            return null;
        }
        for (NativeBreakpoint candidate : this.children) {
            if (candidate.debugger != debugger) continue;
            return candidate;
        }
        return null;
    }

    private int findByBreakpoint(NativeBreakpoint subBpt) {
        int bx = 0;
        for (NativeBreakpoint candidate : this.children) {
            if (candidate == subBpt) {
                return bx;
            }
            ++bx;
        }
        return -1;
    }

    private void removeChild(NativeBreakpoint child, NativeDebugger debugger) {
        assert (this.isToplevel() || this.isMidlevel());
        assert (child != null) : "removeChild(): null child";
        if (this.isToplevel()) {
            assert (child.isMidlevel());
            assert (child.getDebugger() == debugger) : "removeChild(): child not associated with debugger or removed twice";
        } else assert (child.isSubBreakpoint());
        int bx = this.findByBreakpoint(child);
        NativeBreakpoint removed = this.children.remove(bx);
        assert (removed != null) : "removeChild(): No bpt under this debugger " + debugger + "\n" + "last removal: " + this.stackHistory.toString();
        assert (removed == child) : "removeChild(): bpt under debugger different from one being removed.\nlast removal: " + this.stackHistory.toString();
        if (this.isToplevel()) {
            child.setDebugger(null);
        }
        child.removeAnnotations();
        this.updateAndParent();
    }

    public void removeOnlyChild() {
        assert (this.isToplevel()) : "NB.removeOnlyChild(): not a top-level bpt";
        assert (this.nChildren() == 1) : "NB.removeOnlyChild(): has " + this.nChildren() + " children instead of 1";
        NativeBreakpoint removed = this.children.remove(0);
        removed.setDebugger(null);
        removed.removeAnnotations();
    }

    public final void unbind() {
        assert (this.isMidlevel());
        for (NativeBreakpoint c : this.children) {
            c.setDebugger(null);
            c.setHandler(null);
            c.update();
        }
        this.setDebugger(null);
        this.update();
    }

    public void bindTo(NativeDebugger debugger) {
        assert (this.isSubBreakpoint() || this.isMidlevel());
        assert (this.getDebugger() == null || this.getDebugger() == debugger) : "NativeBreakpoint.bindTo(): already have a debugger";
        String executable = debugger.session().getTarget();
        String hostname = debugger.session().getSessionHost();
        this.setContext(new Context(executable, hostname));
        this.setDebugger(debugger);
        this.updateAndParent();
    }

    public final void addSubBreakpoint(NativeBreakpoint subBreakpoint) {
        assert (this.isMidlevel());
        assert (!this.isEditable()) : "addSubBreakpoint(): cannot add to editable bpt";
        assert (subBreakpoint != null) : "addSubBreakpoint(): null subBreakpoint";
        assert (subBreakpoint.isSubBreakpoint());
        this.deletingChildren = false;
        subBreakpoint.setContext(this.getContext());
        subBreakpoint.setParent(this);
        subBreakpoint.setDebugger(this.debugger);
        this.children.add(subBreakpoint);
        this.setEnabled(this.recalculateIsEnabled());
        subBreakpoint.updateAndParent();
    }

    public final void setMidBreakpointFor(NativeBreakpoint midBreakpoint, NativeDebugger debugger) {
        assert (this.isToplevel());
        assert (!this.isEditable()) : "setMidBreakpointFor(): cannot add to editable bpt";
        assert (midBreakpoint != null) : "setMidBreakpointFor(): null midBreakpoint";
        assert (debugger != null) : "setMidBreakpointFor(): null debugger key";
        assert (midBreakpoint.isMidlevel());
        assert (midBreakpoint.debugger == null) : "setMidBreakpointFor(): mid-bpt already associated with " + midBreakpoint.debugger;
        this.deletingChildren = false;
        String executable = debugger.session().getTarget();
        String hostname = debugger.session().getSessionHost();
        midBreakpoint.setContext(new Context(executable, hostname));
        midBreakpoint.setParent(this);
        midBreakpoint.setDebugger(debugger);
        this.children.add(midBreakpoint);
        this.setEnabled(this.recalculateIsEnabled());
        midBreakpoint.updateAndParent();
    }

    public final int nChildren() {
        return this.children.size();
    }

    public final int nBoundChildren() {
        int nBound = 0;
        for (NativeBreakpoint b : this.children) {
            if (!b.isBound()) continue;
            ++nBound;
        }
        return nBound;
    }

    public final NativeBreakpoint[] getChildren() {
        return this.children.toArray(new NativeBreakpoint[0]);
    }

    public List<NativeBreakpoint> findByContext(Context context) {
        assert (this.isToplevel());
        ArrayList<NativeBreakpoint> matches = new ArrayList<NativeBreakpoint>();
        for (NativeBreakpoint candidate : this.getChildren()) {
            if (!candidate.matches(context) || this.contains(matches, candidate)) continue;
            matches.add(candidate);
        }
        return matches;
    }

    private boolean matches(Context context) {
        assert (this.isMidlevel());
        Context thisContext = (Context)this.context.getAsObject();
        return thisContext.matches(context);
    }

    private boolean contains(List<NativeBreakpoint> list, NativeBreakpoint b) {
        for (NativeBreakpoint c : list) {
            if (!b.matchesSibling(c)) continue;
            return true;
        }
        return false;
    }

    public boolean isUnique() {
        if (Log.Bpt.ghostbuster) {
            System.out.printf("\nConsidering if %s is unique\n", this);
        }
        assert (this.isMidlevel());
        NativeBreakpoint top = this.getParent();
        if (this.isAdjusted()) {
            if (Log.Bpt.ghostbuster) {
                System.out.printf("\tIt required intervention. Keep\n", new Object[0]);
            }
            return true;
        }
        if (ghostBuster && this.matchesTemplate(top)) {
            if (Log.Bpt.ghostbuster) {
                System.out.printf("\tIt matches the template. Bust it!\n", new Object[0]);
            }
            return false;
        }
        for (NativeBreakpoint sibling : top.children) {
            if (sibling == this || !this.matchesSibling(sibling)) continue;
            if (Log.Bpt.ghostbuster) {
                System.out.printf("\tIt different from the template but matches a sibling. Bust it!\n", new Object[0]);
            }
            return false;
        }
        if (Log.Bpt.ghostbuster) {
            System.out.printf("\tIt's different from the template and siblings. Keep\n", new Object[0]);
        }
        return true;
    }

    boolean isUniqueLite() {
        if (Log.Bpt.ghostbuster) {
            System.out.printf("\nConsidering (lite) if %s is unique\n", this);
        }
        assert (this.isMidlevel());
        NativeBreakpoint top = this.getParent();
        if (this.isAdjusted()) {
            if (Log.Bpt.ghostbuster) {
                System.out.printf("\tIt required intervention. Keep\n", new Object[0]);
            }
            return true;
        }
        if (this.matchesTemplate(top)) {
            if (Log.Bpt.ghostbuster) {
                System.out.printf("\tIt matches the template. Bust it!\n", new Object[0]);
            }
            return false;
        }
        if (Log.Bpt.ghostbuster) {
            System.out.printf("\tIt's different from the template. Keep\n", new Object[0]);
        }
        return true;
    }

    private boolean matchesSibling(NativeBreakpoint that) {
        assert (this.sameTypeAs(that)) : "mismatched types: \n\tthis: " + (Object)((Object)this.getBreakpointType()) + "\n" + "\tthat: " + (Object)((Object)that.getBreakpointType());
        if (this.isMidlevel()) {
            assert (that.isMidlevel());
            assert (this.getParent() == that.getParent());
            Iterator<NativeBreakpoint> thisIter = this.children.iterator();
            Iterator<NativeBreakpoint> thatIter = that.children.iterator();
            while (thisIter.hasNext() && thatIter.hasNext()) {
                NativeBreakpoint thatNB;
                NativeBreakpoint thisNB = thisIter.next();
                if (thisNB.matchesSibling(thatNB = thatIter.next())) continue;
                return false;
            }
            if (thisIter.hasNext() || thatIter.hasNext()) {
                DbgGuiModule.logger.log(Level.WARNING, String.format("matchesSibling(): mismatched children\n\tthis: %s\n\tthat: %s\n", this, that));
                return false;
            }
            return true;
        }
        assert (that.isSubBreakpoint());
        assert (this.getParent().getParent() == that.getParent().getParent());
        return this.equals(that, new PropertyOwner.Comparator(){

            @Override
            public boolean equals(Property thisP, Property thatP) {
                if (!enableDifferentiates || thisP != NativeBreakpoint.this.enabled) {
                    if (ghostBuster && thisP == NativeBreakpoint.this.context) {
                        return true;
                    }
                    if (!thisP.isDifferentiating()) {
                        return true;
                    }
                }
                if (!thisP.matches(thatP)) {
                    if (Log.Bpt.hierarchy) {
                        System.out.println("mismatched properties against sibling: ");
                        System.out.println("\tthis " + thisP.name() + ": " + thisP);
                        System.out.println("\tthat " + thatP.name() + ": " + thatP);
                    }
                    return false;
                }
                return true;
            }
        });
    }

    private boolean isQualified(Property p) {
        return p.name().startsWith("q");
    }

    private boolean isDefining(Property p) {
        if (p == this.context) {
            return false;
        }
        if (p == this.whileIn) {
            return false;
        }
        if (p == this.qwhileIn) {
            return false;
        }
        if (p == this.condition) {
            return false;
        }
        if (p == this.qcondition) {
            return false;
        }
        if (p == this.lwp) {
            return false;
        }
        if (p == this.thread) {
            return false;
        }
        if (p == this.count) {
            return false;
        }
        if (p == this.temp) {
            return false;
        }
        if (p == this.countLimit) {
            return false;
        }
        if (p == this.action) {
            return false;
        }
        if (p == this.script) {
            return false;
        }
        if (p == this.java) {
            return false;
        }
        if (p == this.enabled) {
            return false;
        }
        return p != this.id;
    }

    public boolean isChangeInDefiningProperty() {
        assert (this.isEditable()) : "isChangeInDefiningProperty() applied to non edited bpt";
        for (Property p : this.pos) {
            if (!p.isDirty() || !this.isDefining(p)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesTemplate(NativeBreakpoint that) {
        assert (that.isToplevel());
        if (this.isMidlevel() ? !$assertionsDisabled && this.getParent() != that : !$assertionsDisabled && this.getParent().getParent() != that) {
            throw new AssertionError();
        }
        if (this.isMidlevel()) {
            for (NativeBreakpoint c : this.children) {
                if (c.matchesTemplate(that)) continue;
                return false;
            }
            return true;
        }
        assert (this.sameTypeAs(that)) : "mismatched types: \n\tthis: " + (Object)((Object)this.getBreakpointType()) + "\n" + "\tthat: " + (Object)((Object)that.getBreakpointType());
        return this.equals(that, new PropertyOwner.Comparator(){

            @Override
            public boolean equals(Property thisP, Property thatP) {
                if (!enableDifferentiates || thisP != NativeBreakpoint.this.enabled) {
                    if (thisP == NativeBreakpoint.this.context) {
                        return true;
                    }
                    if (NativeBreakpoint.this.isQualified(thisP)) {
                        return true;
                    }
                    if (NativeBreakpoint.this.isDefining(thisP)) {
                        return true;
                    }
                    if (!thisP.isDifferentiating()) {
                        return true;
                    }
                }
                if (!thisP.matches(thatP)) {
                    if (Log.Bpt.hierarchy) {
                        System.out.println("mismatched properties against template: ");
                        System.out.println("\tthis " + thisP.name() + ": " + thisP);
                        System.out.println("\tthat " + thatP.name() + ": " + thatP);
                    }
                    return false;
                }
                return true;
            }
        });
    }

    public final boolean hasHandler() {
        assert (!this.isEditable()) : "NB.hasHandler(): disallowed for editable bpts";
        if (this.original != null) {
            return this.original.hasHandler();
        }
        assert (this.isSubBreakpoint()) : "Can only ask hasHandler() of subbpts";
        if (this.getHandler() == null) {
            return false;
        }
        return this.getHandler().getId() != 0;
    }

    void discardUnused(Set<Context> contexts) {
        assert (this.isToplevel());
        if (this.nChildren() == 0) {
            this.primDelete(false, Gen.primary(null));
            return;
        }
        for (NativeBreakpoint c : this.getChildren()) {
            if (Log.Bpt.pertarget) {
                System.out.printf("\tIs '%s'/'%s' in set?\n", c, c.getContext());
            }
            if (contexts != null && contexts.contains(c.getContext())) continue;
            if (c.isBound()) {
                if (!Log.Bpt.pertarget) continue;
                System.out.printf("\tno -- but it's bound\n", new Object[0]);
                continue;
            }
            if (Log.Bpt.pertarget) {
                System.out.printf("\tno -- deleting\n", new Object[0]);
            }
            boolean keepParent = false;
            NativeBreakpoint origin = null;
            c.primDelete(keepParent, Gen.primary(origin));
        }
    }

    public boolean isBound() {
        return this.getDebugger() != null;
    }

    public String getError() {
        if (this.srcOutOfSync) {
            return "File newer than breakpoint (modified outside of IDE?)";
        }
        if (this.isToplevel()) {
            return null;
        }
        if (this.isMidlevel()) {
            return null;
        }
        if (this.getHandler() != null) {
            return this.getHandler().getError();
        }
        return null;
    }

    public boolean isBroken() {
        if (this.isToplevel()) {
            for (NativeBreakpoint child : this.getChildren()) {
                if (child.getDebugger() == null || !child.isCurrent() || !child.isBroken()) continue;
                return true;
            }
            return false;
        }
        if (this.isMidlevel()) {
            for (NativeBreakpoint child : this.getChildren()) {
                if (!child.isBroken()) continue;
                return true;
            }
            return false;
        }
        return this.getError() != null;
    }

    private boolean isFired() {
        if (this.isToplevel()) {
            for (NativeBreakpoint child : this.getChildren()) {
                if (child.getDebugger() == null || !child.isFired() || !child.isCurrent()) continue;
                return true;
            }
            return false;
        }
        if (this.isMidlevel()) {
            for (NativeBreakpoint child : this.getChildren()) {
                if (!child.isFired()) continue;
                return true;
            }
            return false;
        }
        if (this.getHandler() != null) {
            return this.getHandler().isFired();
        }
        return false;
    }

    public void setUpdater(ModelListener updater) {
        this.updater = updater;
        this.echoUpdater("setUpdater");
    }

    public Date timestamp() {
        return this.timestamp;
    }

    void restoreTimestamp(Date newDate) {
        this.timestamp = (Date)newDate.clone();
    }

    private void updateTimestamp() {
        if (!this.srcOutOfSync) {
            this.updateTimestamp = true;
        }
    }

    void prepareForSaving() {
        if (this.updateTimestamp) {
            Date now;
            this.timestamp = now = new Date();
        }
    }

    void restoredChild() {
        this.checkOutofDate(this.timestamp());
        this.updateAnnotations();
    }

    void restoringChild(NativeBreakpoint child) {
        assert (this.isRestored());
        assert (child.isRestored());
        assert (this.isToplevel() || this.isMidlevel());
        if (this.isToplevel()) {
            assert (child.isMidlevel());
            child.setDebugger(null);
        } else {
            assert (child.isSubBreakpoint());
            child.setDebugger(null);
        }
        child.setParent(this);
        this.children.add(child);
    }

    public void changeOne(NativeBreakpoint edited, Gen gen) {
        if (!edited.isChangeInDefiningProperty()) {
            NativeBreakpoint template = this.makeEditableCopy();
            template.original = edited;
            template.pos.assign(edited.pos);
            edited.copyFrom(template);
        }
        if (this.isToplevel()) {
            this.copyFrom(edited);
            this.update();
            NativeDebuggerManager.get().bringDownDialog();
        } else if (this.isMidlevel()) {
            this.copyFrom(edited);
            this.updateAndParent();
            NativeDebuggerManager.get().bringDownDialog();
        } else if (this.isBound()) {
            Handler.postChange(this.getDebugger(), this, edited, gen);
        } else {
            this.copyFrom(edited);
            this.updateAndParent();
            NativeDebuggerManager.get().bringDownDialog();
        }
    }

    public void spreadChange(NativeBreakpoint validated, NativeBreakpoint edited, Gen gen) {
        if (Log.Bpt.pathway) {
            System.out.printf("spread(%s)\n\tthis    %s\n\tvalid   %s\n\tedited  %s\n", gen, this, validated, edited);
        }
        assert (this.isMidlevel()) : "spread() can only be applied to midlevel bpts";
        assert (validated.isSubBreakpoint()) : "spread(): validated is not a subbpt";
        assert (validated.parent == this) : "spread():  this is not the parent of validated";
        Spread spread = edited.original.isSubBreakpoint() ? (edited.isChangeInDefiningProperty() ? Spread.ALL : Spread.SELF) : (edited.original.isMidlevel() ? (edited.isChangeInDefiningProperty() ? Spread.ALL : Spread.OVERLOAD) : Spread.ALL);
        switch (spread) {
            case SELF: {
                if (this.nChildren() != 1) break;
                this.changeOne(edited, gen);
                if (!this.isOnlyChild()) break;
                this.parent.changeOne(edited, gen);
                break;
            }
            case OVERLOAD: {
                if (gen.isTertiary()) {
                    return;
                }
                this.changeOne(edited, gen);
                if (this.isOnlyChild()) {
                    this.parent.changeOne(edited, gen);
                }
                this.changeAllButTo(validated, edited, gen);
                break;
            }
            case ALL: {
                if (edited.isChangeInDefiningProperty()) {
                    this.clearOldOverloaded(gen);
                }
                if (gen.isTertiary()) {
                    return;
                }
                this.changeOne(edited, gen);
                if (!edited.isChangeInDefiningProperty()) {
                    this.changeAllButTo(validated, edited, gen);
                }
                if (gen.isSecondary()) {
                    return;
                }
                this.parent.changeOne(edited, gen);
                this.parent.changeAllButTo(this, edited, gen);
            }
        }
    }

    final void postChange(NativeBreakpoint edited, Gen gen) {
        assert (edited.isEditable()) : "NB.postChange(): passed in bpt isn't editable";
        assert (edited.isDirty()) : "NativeBreakpoint.postChange(): passed in bpt isn't dirty!";
        if (Log.Bpt.pathway) {
            System.out.printf("postChange(%s):\n\tthis   %s\n\tedited %s\n", gen, this, edited);
        }
        if (this.isToplevel()) {
            if (this.nChildren() == 0) {
                this.changeOne(edited, gen);
                return;
            }
            NativeBreakpoint rep = this.getMidlevelFor(NativeBreakpoint.currentDebugger());
            if (rep == null) {
                rep = this.children.get(0);
            }
            rep.postChange(edited, gen);
        } else if (this.isMidlevel()) {
            NativeBreakpoint b = this.children.get(0);
            b.changeOne(edited, gen);
            if (!this.isBound()) {
                this.spreadChange(b, edited, gen);
            }
        } else {
            assert (edited.original.isSubBreakpoint()) : "postChange called recursively on subbpt";
            this.changeOne(edited, gen);
            if (!this.isBound()) {
                this.parent.spreadChange(this, edited, gen);
            }
        }
    }

    private void changeAllButTo(NativeBreakpoint exclude, NativeBreakpoint edited, Gen gen) {
        if (Log.Bpt.pathway) {
            System.out.printf("changeAllButTo(%s)\n\tthis    %s\n\texclude %s\n\tedited  %s\n", gen, this, exclude, edited);
        }
        if (this.isToplevel()) {
            for (NativeBreakpoint child : this.children) {
                if (child == exclude) continue;
                child.postChange(edited, gen.second());
            }
        } else if (this.isMidlevel()) {
            for (NativeBreakpoint child : this.children) {
                if (child == exclude) continue;
                child.changeOne(edited, gen.third());
            }
        } else assert (false) : "Cannot apply changeAllButTo to subbpt";
    }

    private void clearOldOverloaded(Gen gen) {
        if (Log.Bpt.pathway) {
            System.out.printf("clearOldOverloaded():\n\tthis %s\n", this);
        }
        assert (this.isMidlevel());
        NativeBreakpoint[] sbs = this.getChildren();
        for (int bx = 1; bx < sbs.length; ++bx) {
            NativeBreakpoint b = sbs[bx];
            b.postDelete(false, gen.third());
        }
    }

    public final void postCreate() {
        Handler.postNewHandler(NativeBreakpoint.currentDebugger(), this, this.getRoutingToken());
    }

    @Override
    public void undo(String property) {
        this.update();
    }

    public void update() {
        if (this.isEditable()) {
            return;
        }
        this.updateAnnotations();
        if (this.updater == null) {
            return;
        }
        this.updater.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)this));
        for (Property p : this.pos) {
            if (p == this.enabled || p == this.java || p == this.lwp || p == this.temp || p.key() == null) continue;
            ModelEvent.TableValueChanged e = new ModelEvent.TableValueChanged((Object)this, (Object)this, p.key());
            this.updater.modelChanged((ModelEvent)e);
        }
    }

    void updateAndParent() {
        if (this.isEditable()) {
            return;
        }
        this.update();
        if (this.getParent() != null) {
            this.getParent().updateAndParent();
        } else {
            if (this.updater == null) {
                return;
            }
            this.updater.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    public void postDelete(boolean keepParent, Gen gen) {
        if (Log.Bpt.pathway) {
            System.out.printf("postDelete(%s, %s):\n\tthis %s\n", keepParent, gen, this);
        }
        if (this.isToplevel()) {
            assert (!keepParent) : "NB.postDelete(): keepParent doesn't make sense for toplevel";
            if (this.nChildren() == 0) {
                assert (!this.deletingChildren);
                this.primDelete(keepParent, gen);
            } else {
                if (this.deletingChildren) {
                    if (Log.Bpt.pathway) {
                        System.out.printf("postDelete(top): deletingChildren = true\n", new Object[0]);
                    }
                    return;
                }
                this.deletingChildren = true;
                for (NativeBreakpoint c : this.getChildren()) {
                    c.postDelete(false, gen);
                }
            }
        } else if (this.isMidlevel()) {
            if (this.nChildren() == 0) {
                assert (!this.deletingChildren);
                this.primDelete(keepParent, gen);
            } else {
                if (this.deletingChildren) {
                    if (Log.Bpt.pathway) {
                        System.out.printf("postDelete(mid): deletingChildren = true\n", new Object[0]);
                    }
                    return;
                }
                this.deletingChildren = true;
                for (NativeBreakpoint c : this.getChildren()) {
                    c.postDelete(false, gen);
                }
            }
        } else if (this.isBound()) {
            this.getDebugger().bm().postDeleteHandler(this, gen);
        } else {
            this.primDelete(keepParent, gen);
        }
    }

    public void primDelete(boolean keepParent, Gen gen) {
        this.cleanup();
        if (this.isSubBreakpoint()) {
            if (this.parent.nChildren() > 1) {
                this.parent.setAdjusted(true);
            }
            this.parent.removeChild(this, this.getDebugger());
            if (!keepParent && this.parent.nChildren() == 0) {
                this.parent.primDelete(keepParent, gen);
            }
        } else if (this.isMidlevel()) {
            this.removeAnnotations();
            boolean isOnlyChild = this.isOnlyChild();
            boolean isBound = this.isBound();
            this.parent.removeChild(this, this.getDebugger());
            if (isOnlyChild && !isBound && (gen.origin() == this || gen.origin() != null && gen.origin().getParent() == this)) {
                return;
            }
            if (!isOnlyChild && NativeDebuggerManager.isPerTargetBpts()) {
                return;
            }
            if (!keepParent) {
                if (this.parent.nChildren() == 0) {
                    this.parent.primDelete(keepParent, gen);
                } else if (gen.isPrimary() && isBound) {
                    this.parent.postDelete(false, gen.second());
                }
            }
        } else if (this.isToplevel()) {
            this.removeAnnotations();
            NativeBreakpoint.breakpointBag().remove(this);
        }
    }

    public void cleanup() {
    }

    public DebuggerAnnotation[] annotations() {
        return this.annotations.toArray(new DebuggerAnnotation[this.annotations.size()]);
    }

    public void addAnnotation(final String filename, final int line, final long addr) {
        NativeDebuggerManager.getRequestProcessor().submit(new Runnable(){

            @Override
            public void run() {
                final Line l = NativeBreakpoint.this.getLine(filename, line);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NativeBreakpoint.this.addAnnotation(l, addr);
                    }
                });
            }
        });
    }

    protected Line getLine(String filename, int line) {
        if (line != 0) {
            return EditorBridge.getLine(filename, line, NativeBreakpoint.currentDebugger());
        }
        return null;
    }

    public void addAnnotation(Line l, long addr) {
        assert (!this.isMidlevel()) : "cannot add annotations to midlevel bpts";
        DebuggerAnnotation.Listener listener = new DebuggerAnnotation.Listener(){

            @Override
            public void annotationMoved() {
                NativeBreakpoint.this.update();
                NativeBreakpoint.this.updateTimestamp();
            }
        };
        DebuggerAnnotation a = new DebuggerAnnotation(listener, this.getAnnotationType(), l, addr, true, this);
        if (addr != 0L || l != null) {
            this.annotations.add(a);
            if (addr != 0L) {
                a.addInstBpt(this);
            }
        }
        if (NativeBreakpoint.currentDebugger() == null) {
            if (this.isToplevel()) {
                if (!NativeDebuggerManager.isPerTargetBpts()) {
                    this.showAnnotation(a, true);
                }
            } else {
                this.showAnnotation(a, false);
            }
        } else if (this.isToplevel()) {
            if (!NativeDebuggerManager.isPerTargetBpts()) {
                this.showAnnotation(a, false);
            }
        } else {
            this.showAnnotation(a, NativeBreakpoint.currentDebugger() == this.debugger);
        }
        if (this instanceof LineBreakpoint) assert (this.annotations.size() <= 1) : this.annotations.size() + " > 1 annotations for LineBreakpoint";
    }

    public void removeAnnotations() {
        if (this.isMidlevel()) {
            for (NativeBreakpoint c : this.children) {
                c.removeAnnotations();
            }
        } else {
            for (DebuggerAnnotation a : this.annotations) {
                a.setLine(null, true);
                a.removeInstBpt(this);
            }
            this.annotations = new ArrayList();
        }
    }

    public void seedToplevelAnnotations() {
        assert (this.isToplevel());
    }

    private void showAnnotationsHelp(boolean show) {
        assert (!this.isMidlevel()) : "cannot show annotations of midlevel bpts";
        for (DebuggerAnnotation a : this.annotations) {
            this.showAnnotation(a, show);
        }
    }

    public void showAnnotations(boolean show) {
        this.showAnnotationsHelp(show);
    }

    private void showAnnotation(DebuggerAnnotation a, boolean show) {
        if (show) {
            a.attach(true);
        } else {
            a.detach();
        }
    }

    public void showAnnotationsFor(boolean show, NativeDebugger debugger) {
        assert (this.isToplevel());
        if (!NativeDebuggerManager.isPerTargetBpts()) {
            if (show) {
                this.showAnnotationsHelp(false);
            } else if (this.nBoundChildren() == 0) {
                this.showAnnotationsHelp(true);
            }
        }
        for (NativeBreakpoint mid : this.getChildren()) {
            for (NativeBreakpoint sub : mid.getChildren()) {
                if (sub.debugger == debugger) {
                    sub.showAnnotationsHelp(show);
                }
                if (sub.hasHandler()) continue;
                sub.showAnnotationsHelp(false);
            }
        }
    }

    public void visitNextAnnotation() {
        Line line;
        DebuggerAnnotation annotation = this.getNextAnnotation();
        if (annotation != null && (line = annotation.getLine()) != null) {
            line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
        }
    }

    public boolean isVisitable() {
        if (this.annotations == null) {
            return false;
        }
        return !this.annotations.isEmpty();
    }

    private DebuggerAnnotation getNextAnnotation() {
        if (!this.isVisitable()) {
            return null;
        }
        DebuggerAnnotation r = this.annotations.get(this.visitedAnnotationId);
        ++this.visitedAnnotationId;
        if (this.visitedAnnotationId == this.annotations.size()) {
            this.visitedAnnotationId = 0;
        }
        return r;
    }

    public boolean matchesLine(String src, int line) {
        for (DebuggerAnnotation a : this.annotations) {
            if (!a.matchesLine(src, line)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesLineIn(String src, int line, NativeDebugger debugger) {
        return this.getDebugger() == debugger && this.matchesLine(src, line);
    }

    public PropertyOwnerSupport getPos() {
        return this.pos;
    }

    @Override
    public final void register(Property p) {
        this.pos.register(p);
    }

    @Override
    public Property propertyByName(String name) {
        return this.pos.propertyByName(name);
    }

    @Override
    public Property propertyByKey(String key) {
        return this.pos.propertyByKey(key);
    }

    @Override
    public int size() {
        return this.pos.size();
    }

    @Override
    public Iterator<Property> iterator() {
        return this.pos.iterator();
    }

    @Override
    public boolean isDirty() {
        return this.pos.isDirty();
    }

    @Override
    public void clearDirty() {
        this.pos.clearDirty();
    }

    @Override
    public boolean equals(PropertyOwner that, PropertyOwner.Comparator comparator) {
        return this.pos.equals(((NativeBreakpoint)that).pos, comparator);
    }

    public String getAnnotationType() {
        StringBuilder type = new StringBuilder();
        if (!this.isEnabled()) {
            type.append("Disabled");
        }
        if (this.isConditional) {
            type.append("Cond");
        }
        type.append("Breakpoint");
        if (this.isBroken() && this.isEnabled()) {
            type.append("_broken");
        }
        return type.toString();
    }

    public void updateAnnotations() {
        this.isConditional = false;
        if (this.getAction() != Action.STOP && this.getAction() != Action.STOPINSTR) {
            this.isConditional = true;
        } else if (this.getCondition() != null) {
            this.isConditional = true;
        }
        String type = this.getAnnotationType();
        for (DebuggerAnnotation a : this.annotations) {
            a.setAnnotationType(type);
            a.setShortDescription(this.getError());
            long addr = a.getAddr();
            if (addr == 0L) continue;
            a.enableInstBpt(this);
        }
    }

    final boolean isExpanded() {
        return this.expanded;
    }

    final void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public final boolean isEnabled() {
        boolean isEnabled = this.enabled.get();
        if (Log.Bpt.enabling) {
            if (this.isToplevel()) {
                System.out.println("?T  isEnabled() ->" + isEnabled);
            } else if (this.isMidlevel()) {
                System.out.println("? M isEnabled() ->" + isEnabled);
            } else {
                System.out.println("?  SisEnabled() ->" + isEnabled);
            }
        }
        return isEnabled;
    }

    public final boolean isPropEnabled() {
        if (Log.Bpt.enabling) {
            System.out.println("?  isPropEnabled() ->" + this.enabled.get());
        }
        return this.enabled.get();
    }

    final void setEnabled(boolean enabled) {
        this.enabled.set(enabled);
        if (this.isToplevel()) {
            if (Log.Bpt.enabling) {
                System.out.println("<T  setEnabled" + enabled + ")");
            }
            this.update();
        } else if (this.isMidlevel()) {
            if (Log.Bpt.enabling) {
                System.out.println("< M setEnabled(" + enabled + ")");
            }
            this.update();
            NativeBreakpoint parent = this.getParent();
            if (parent != null) {
                parent.setEnabled(parent.recalculateIsEnabled());
            }
        } else {
            if (Log.Bpt.enabling) {
                System.out.println("<  SsetEnabled(" + enabled + ")");
            }
            this.update();
            NativeBreakpoint parent = this.getParent();
            if (parent != null) {
                parent.setEnabled(parent.recalculateIsEnabled());
            }
        }
    }

    private boolean recalculateIsEnabled() {
        if (this.isSubBreakpoint()) {
            return this.isEnabled();
        }
        if (this.nChildren() == 0) {
            return this.isEnabled();
        }
        boolean isEnabled = false;
        for (NativeBreakpoint c : this.getChildren()) {
            isEnabled |= c.recalculateIsEnabled();
        }
        return isEnabled;
    }

    public void setPropEnabled(boolean b) {
        if (this.isToplevel()) {
            if (Log.Bpt.enabling) {
                System.out.println(">T  setPropEnabled(" + b + ")");
            }
            if (this.nChildren() == 0) {
                this.setEnabled(b);
            } else {
                for (NativeBreakpoint c : this.getChildren()) {
                    c.setPropEnabled(b);
                }
            }
        } else if (this.isMidlevel()) {
            if (Log.Bpt.enabling) {
                System.out.println("> M setPropEnabled(" + b + ")");
            }
            if (this.nChildren() == 0) {
                this.setEnabled(b);
            } else {
                for (NativeBreakpoint c : this.getChildren()) {
                    c.setPropEnabled(b);
                }
            }
        } else {
            if (Log.Bpt.enabling) {
                System.out.println(">  SsetPropEnabled(" + b + ")");
            }
            if (this.hasHandler()) {
                this.getHandler().postEnable(b, this.getRoutingToken());
            } else {
                this.setEnabled(b);
            }
        }
    }

    public final int getId() {
        return this.id.get();
    }

    public final String getWhileIn() {
        return this.whileIn.get();
    }

    public final String getQwhileIn() {
        return this.qwhileIn.get();
    }

    public final void setQwhileIn(String whileIn) {
        this.qwhileIn.setFromString(whileIn);
    }

    public final void setWhileIn(String whileIn) {
        this.whileIn.setFromString(whileIn);
    }

    public final void setPropWhileIn(String whileIn) {
        if (!IpeUtils.sameString(whileIn, this.getWhileIn())) {
            new EditUndo(this, "PROP_BREAKPOINT_WHILEIN");
            NativeBreakpoint editable = this.makeEditableCopy();
            if (IpeUtils.isEmpty(whileIn)) {
                whileIn = null;
            }
            editable.setWhileIn(whileIn);
            editable.setQwhileIn(null);
            this.postChange(editable, Gen.primary(null));
        }
    }

    public final String getCondition() {
        return this.condition.get();
    }

    public final void setCondition(String newCond) {
        this.condition.setFromString(newCond);
        this.update();
    }

    public final String getQcondition() {
        return this.qcondition.get();
    }

    public final void setQcondition(String newCond) {
        this.qcondition.setFromString(newCond);
        this.update();
    }

    public final void setPropCondition(String condition) {
        new EditUndo(this, "PROP_BREAKPOINT_CONDITION");
        NativeBreakpoint editable = this.makeEditableCopy();
        if (IpeUtils.isEmpty(condition)) {
            condition = null;
        }
        editable.setCondition(condition);
        editable.setQcondition(null);
        this.postChange(editable, Gen.primary(null));
    }

    public final String getLwp() {
        return this.lwp.get();
    }

    public final void setLwp(String newLwp) {
        this.lwp.setFromString(newLwp);
    }

    public final void setPropLwp(String lwp) {
        new EditUndo(this, "PROP_BREAKPOINT_LWP");
        NativeBreakpoint editable = this.makeEditableCopy();
        editable.setLwp(lwp);
        this.postChange(editable, Gen.primary(null));
    }

    public final String getThread() {
        return this.thread.get();
    }

    public final void setThread(String newThread) {
        this.thread.setFromString(newThread);
    }

    public final void setPropThread(String thread) {
        new EditUndo(this, "PROP_BREAKPOINT_THREAD");
        NativeBreakpoint editable = this.makeEditableCopy();
        editable.setThread(thread);
        this.postChange(editable, Gen.primary(null));
    }

    public final Context getContext() {
        return this.context.get();
    }

    public final void setContext(Context newContext) {
        this.context.set(newContext);
        if (this.isMidlevel()) {
            for (NativeBreakpoint c : this.getChildren()) {
                c.context.set(newContext);
            }
        }
    }

    private long getPid() {
        NativeSession session;
        NativeDebugger debugger = this.getDebugger();
        if (debugger == null) {
            return -1L;
        }
        if (Log.Bpt.embellish) {
            System.out.printf("\thave debugger\n", new Object[0]);
        }
        if ((session = debugger.session()) == null) {
            return -1L;
        }
        long pid = session.getPid();
        if (Log.Bpt.embellish) {
            System.out.printf("\thave session\n", new Object[0]);
            System.out.printf("\tpid -> %d\n", pid);
        }
        return pid;
    }

    public String embellishedContext(String contextPropertyValue) {
        if (contextPropertyValue == null) {
            return null;
        }
        if (Log.Bpt.embellish) {
            System.out.printf("embellishedContext(%s)\n", contextPropertyValue);
        }
        String basename = CndPathUtilities.getBaseName((String)contextPropertyValue);
        long pid = this.getPid();
        if (pid != -1L) {
            return "[" + pid + "] " + basename;
        }
        return basename;
    }

    public void updateFor(NativeDebugger debugger) {
        assert (this.isToplevel());
        for (NativeBreakpoint c : this.getChildren()) {
            if (c.debugger != debugger) continue;
            c.update();
        }
    }

    public final void setId(int newId) {
        this.id.set(newId);
    }

    public final void setCount(int newCount) {
        this.count.set(newCount);
        if (this.getParent() != null && this.isOnlyChild()) {
            this.getParent().setCount(newCount);
        }
    }

    public final int getCount() {
        return this.count.get();
    }

    public final long getCountLimit() {
        if (this.countLimit.get() != null) {
            return this.countLimit.get().count();
        }
        return 0L;
    }

    public final boolean hasCountLimit() {
        return this.countLimit.get() != null;
    }

    public final void setCountLimit(long newCountLimit, boolean hasLimit) {
        if (hasLimit) {
            this.countLimit.set(new CountLimit(newCountLimit));
        } else {
            this.countLimit.set(null);
            this.setCount(0);
        }
    }

    public final void setPropCountLimit(Object o) {
        CountLimit cl = (CountLimit)o;
        cl = cl.possiblySetToCurrentCount(this.getCount());
        new EditUndo(this, "PROP_BREAKPOINT_COUNTLIMIT");
        NativeBreakpoint editable = this.makeEditableCopy();
        editable.setCountLimit(cl.count(), cl.isEnabled());
        this.postChange(editable, Gen.primary(null));
    }

    public final boolean isAdjusted() {
        return this.adjusted.get();
    }

    public final void setAdjusted(boolean adjusted) {
        this.adjusted.set(adjusted);
    }

    public final boolean getTemp() {
        return this.temp.get();
    }

    public final void setTemp(boolean newTemp) {
        this.temp.set(newTemp);
    }

    public final void setPropTemp(boolean temp) {
        new EditUndo(this, "PROP_BREAKPOINT_TEMP");
        NativeBreakpoint editable = this.makeEditableCopy();
        editable.setTemp(temp);
        this.postChange(editable, Gen.primary(null));
    }

    public final void setPropScript(String script) {
        NativeBreakpoint editable = this.makeEditableCopy();
        editable.setScript(script);
        this.postChange(editable, Gen.primary(null));
    }

    public final void setScript(String newScript) {
        if (this.action.get() == Action.WHEN || this.action.get() == Action.WHENINSTR) {
            this.script.setFromString(newScript);
        } else {
            this.script.setFromString(null);
        }
    }

    public final String getScript() {
        return this.script.get();
    }

    public final void setJava(boolean java) {
        this.java.set(java);
    }

    public final boolean getJava() {
        return this.java.get();
    }

    public final void setPropJava(boolean java) {
        new EditUndo(this, "PROP_BREAKPOINT_JAVA");
        NativeBreakpoint editable = this.makeEditableCopy();
        editable.setJava(java);
        this.postChange(editable, Gen.primary(null));
    }

    public final Action getAction() {
        return this.action.get();
    }

    public final void setAction(Action newAction) {
        this.action.set(newAction);
        this.update();
    }

    public final void setPropAction(Object o) {
        Action a = (Action)o;
        NativeBreakpoint editable = this.makeEditableCopy();
        editable.setAction(a);
        this.postChange(editable, Gen.primary(null));
    }

    public final void setOriginalEventspec(String originalEventspec) {
        this.originalEventspec = originalEventspec;
    }

    public final String getOriginalEventspec() {
        return this.originalEventspec;
    }

    protected abstract void processOriginalEventspec(String var1);

    private void copyFromHelp(NativeBreakpoint that) {
        this.timestamp = that.timestamp;
        this.updateTimestamp = that.updateTimestamp;
        this.srcOutOfSync = that.srcOutOfSync;
        if (that instanceof LineBreakpoint) {
            LineBreakpoint olb = (LineBreakpoint)that;
            LineBreakpoint nlb = (LineBreakpoint)this;
            nlb.setLineNumberInitial(olb.getLineNumber());
        }
        for (Property thatProp : that.pos) {
            String thatName = thatProp.name();
            Object thatObject = thatProp.getAsObject();
            for (Property thisProp : this.getPos()) {
                String thisName = thisProp.name();
                if (thisName == null || !thisName.equals(thatName)) continue;
                thisProp.setFromObjectInitial(thatObject);
            }
        }
        this.adjusted.setFromObjectInitial(false);
    }

    public void copyFrom(NativeBreakpoint that) {
        assert (this.sameTypeAs(that)) : "NB.copyFrom(): can only copy from compatible type";
        assert (that.isEditable()) : "NB.copyFrom(): can only copy from toplevel bpts";
        if (this.isToplevel() || that.isToplevel()) {
            Object originalContext = this.context.getAsObject();
            this.copyFromHelp(that);
            this.context.setFromObject(originalContext);
        } else {
            this.copyFromHelp(that);
        }
    }

    public NativeBreakpoint makeEditableCopy() {
        NativeBreakpoint editable = this.breakpointType.newInstance(this.flags);
        editable.debugger = this.debugger;
        editable.original = this;
        editable.parent = this.parent;
        editable.updater = null;
        editable.echoUpdater("makeEditableCopy");
        editable.copyFromHelp(this);
        return editable;
    }

    public NativeBreakpoint makeToplevelCopy(boolean useOeventspec) {
        assert (this.isSubBreakpoint());
        int flags = 2;
        NativeBreakpoint toplevel = this.breakpointType.newInstance(2);
        toplevel.original = null;
        toplevel.updater = null;
        toplevel.echoUpdater("makeToplevelCopy");
        toplevel.copyFromHelp(this);
        if (useOeventspec) {
            toplevel.processOriginalEventspec(this.getOriginalEventspec());
        }
        return toplevel;
    }

    public NativeBreakpoint makeSubBreakpointCopy() {
        assert (this.isToplevel());
        int flags = 4;
        NativeBreakpoint subbpt = this.breakpointType.newInstance(4);
        subbpt.original = null;
        subbpt.updater = null;
        subbpt.echoUpdater("makeSubBreakpointCopy");
        subbpt.copyFromHelp(this);
        return subbpt;
    }

    public NativeBreakpoint makeMidlevelCopy() {
        assert (this.isToplevel() || this.isMidlevel()) : "Can makeMidBreakpointCopy() only of Toplevel or Midlevel bpt";
        int flags = 8;
        NativeBreakpoint midbpt = this.breakpointType.newInstance(8);
        midbpt.original = null;
        midbpt.updater = null;
        midbpt.echoUpdater("makeMidBreakpointCopy");
        midbpt.copyFromHelp(this);
        return midbpt;
    }

    public String toString() {
        String level = this.isToplevel() ? ".--" : (this.isMidlevel() ? " .-" : "  .");
        return "(" + level + (this.isEditable() ? "*" : " ") + this.getDisplayNameHelp() + " [" + this.nChildren() + "] " + (this.isBound() ? "  bound" : "unbound") + ")";
    }

    protected abstract String getSummary();

    protected abstract String getDisplayNameHelp();

    private static String quote(String s) {
        try {
            s = XMLUtil.toAttributeValue((String)s);
        }
        catch (CharConversionException charConversionException) {
            // empty catch block
        }
        return s;
    }

    public String getDisplayName() {
        String newSummary;
        if (this.isSubBreakpoint() && this.getHandler() != null && this.getHandler().isInProgress()) {
            return Catalog.get("AddingBreakpoint");
        }
        String summary = this.getDisplayNameHelp();
        Rendition rendition = this.isSubBreakpoint() ? (this.isCurrent() && !this.parent.isOnlyChild() ? Rendition.CURRENT : (!this.isBound() ? Rendition.GHOST : Rendition.PLAIN)) : (this.isMidlevel() ? (this.isCurrent() && !this.isOnlyChild() ? Rendition.CURRENT : (!this.isBound() ? Rendition.GHOST : Rendition.PLAIN)) : Rendition.PLAIN);
        switch (rendition) {
            case CURRENT: {
                if (sessionOnly) {
                    newSummary = summary;
                    break;
                }
                newSummary = "<html><b>";
                newSummary = newSummary + NativeBreakpoint.quote(summary);
                newSummary = newSummary + "</b></html>";
                break;
            }
            case GHOST: {
                newSummary = "<html>";
                newSummary = newSummary + "<font color=\"#C0C0C0\"/>";
                newSummary = newSummary + NativeBreakpoint.quote(summary);
                newSummary = newSummary + "</html>";
                break;
            }
            case PLAIN: {
                newSummary = summary;
                break;
            }
            default: {
                newSummary = summary;
            }
        }
        return newSummary;
    }

    public String getIconBase() {
        if (this.debugger != null && !this.debugger.areBreakpointsActivated()) {
            if (this.isEnabled()) {
                return "org/netbeans/modules/debugger/resources/breakpointsView/DeactivatedBreakpoint";
            }
            return "org/netbeans/modules/debugger/resources/breakpointsView/DeactivatedDisabledBreakpoint";
        }
        StringBuilder name = new StringBuilder();
        if (!this.isEnabled()) {
            name.append("Disabled");
        }
        if (this.isConditional) {
            name.append("Conditional");
        }
        name.append("Breakpoint");
        if (this.isBroken() && this.isEnabled()) {
            name.append("_broken");
        } else if (this.isFired()) {
            name.append("Hit");
        }
        return "org/netbeans/modules/debugger/resources/breakpointsView/" + name.toString();
    }

    public int getRoutingToken() {
        if (this.routingToken == 0) {
            this.routingToken = RoutingToken.BREAKPOINTS.getUniqueRoutingTokenInt();
        }
        return this.routingToken;
    }

    public void setAttrs(Attributes genericAttributes) {
        for (Property p : this.pos) {
            String pname = p.name();
            String value = genericAttributes.getValue(pname);
            if (value == null) continue;
            if (p instanceof EnumProperty) {
                EnumProperty ep = (EnumProperty)p;
                ep.setFromName(value);
                continue;
            }
            p.setFromString(value);
        }
    }

    private void checkOutofDate(Date time) {
        for (DebuggerAnnotation a : this.annotations) {
            if (!a.fileIsNewerThan(time)) continue;
            this.srcOutOfSync = true;
            break;
        }
    }

    private static NativeBreakpoint newBreakpointOfType(Class<? extends NativeBreakpointType> cls) {
        NativeBreakpointType instance = (NativeBreakpointType)((Object)ContextAwareSupport.createInstance((String)cls.getCanonicalName(), (ContextProvider)DebuggerManager.getDebuggerManager()));
        if (instance != null) {
            return instance.newInstance(2);
        }
        List breakpointTypes = DebuggerManager.getDebuggerManager().lookup(null, BreakpointType.class);
        if (breakpointTypes == null) {
            return null;
        }
        NativeBreakpointType nbt = null;
        for (int btx = 0; btx < breakpointTypes.size(); ++btx) {
            BreakpointType bt = (BreakpointType)breakpointTypes.get(btx);
            if (!cls.isInstance(bt)) continue;
            nbt = (NativeBreakpointType)bt;
            break;
        }
        if (nbt == null) {
            return null;
        }
        NativeBreakpoint bpt = nbt.newInstance(2);
        return bpt;
    }

    public static NativeBreakpoint newInstructionBreakpoint(String address) {
        NativeBreakpoint bpt = NativeBreakpoint.newBreakpointOfType(InstructionBreakpointType.class);
        if (bpt == null) {
            return null;
        }
        InstructionBreakpoint ib = (InstructionBreakpoint)bpt;
        ib.setAddress(address);
        return ib;
    }

    public static NativeBreakpoint newLineBreakpoint(String fileName, int lineNo, FileSystem fs) {
        NativeBreakpoint bpt = NativeBreakpoint.newBreakpointOfType(LineBreakpointType.class);
        if (bpt == null) {
            return null;
        }
        LineBreakpoint lb = (LineBreakpoint)bpt;
        lb.setFileAndLine(fileName, lineNo, fs);
        return lb;
    }

    public static Set<Property> diff(NativeBreakpoint oldBpt, NativeBreakpoint newBpt) {
        assert (oldBpt.getClass() == newBpt.getClass()) : "Only compares similar breakpoints";
        HashSet<Property> res = new HashSet<Property>();
        for (Property pOld : oldBpt.pos) {
            Property pNew;
            if (pOld.matches(pNew = newBpt.pos.propertyByName(pOld.name()))) continue;
            res.add(pNew);
        }
        return res;
    }

    public Breakpoint.GroupProperties getGroupProperties() {
        return new NativeGroupProperties();
    }

    static {
        NativeBreakpoint.manager();
        ghostBuster = !NativeDebuggerManager.isPerTargetBpts();
        nextSerialNo = 0;
    }

    protected class NativeGroupProperties
    extends Breakpoint.GroupProperties {
        protected NativeGroupProperties() {
        }

        public String getType() {
            return NativeBreakpoint.this.getBreakpointType().getTypeDisplayName();
        }

        public String getLanguage() {
            return "C/C++";
        }

        public FileObject[] getFiles() {
            return null;
        }

        public Project[] getProjects() {
            return null;
        }

        public DebuggerEngine[] getEngines() {
            return null;
        }

        public boolean isHidden() {
            return false;
        }
    }

    private static enum Rendition {
        PLAIN,
        CURRENT,
        GHOST;

    }

    private static enum Spread {
        SELF,
        OVERLOAD,
        ALL;

    }
}

