/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.values;

import java.math.BigInteger;
import org.netbeans.modules.cnd.debugger.common2.values.Catalog;

public class AId {
    private String id;
    public String errorMessage = null;

    private static boolean isDecimalNumber(String s) {
        long n = 0L;
        try {
            n = Long.parseLong(s);
        }
        catch (NumberFormatException x) {
            return false;
        }
        return n >= 0L;
    }

    private static boolean isLongDecimalNumber(String s) {
        try {
            if (s.startsWith("-")) {
                return false;
            }
            BigInteger bi = new BigInteger(s);
            if (bi.bitLength() > 64) {
                return false;
            }
        }
        catch (NumberFormatException x) {
            return false;
        }
        return true;
    }

    public AId(String text, boolean isLwp, boolean isJava) {
        if (text == null) {
            this.id = null;
            return;
        }
        if ((text = text.trim()).length() == 0) {
            this.id = null;
            return;
        }
        String numberPart = null;
        if (isLwp) {
            if (text.startsWith("l@") || text.startsWith("L@")) {
                try {
                    numberPart = text.substring(2);
                }
                catch (IndexOutOfBoundsException x) {}
            } else {
                numberPart = text;
            }
            if (!AId.isDecimalNumber(numberPart)) {
                this.errorMessage = Catalog.get("MSG_AId_MalformedLwp");
                return;
            }
            this.id = "l@" + Integer.parseInt(numberPart);
        } else if (!isJava) {
            if (text.startsWith("t@") || text.startsWith("T@")) {
                try {
                    numberPart = text.substring(2);
                }
                catch (IndexOutOfBoundsException x) {}
            } else {
                numberPart = text;
            }
            if (!AId.isLongDecimalNumber(numberPart)) {
                this.errorMessage = Catalog.get("MSG_AId_MalformedThread");
                return;
            }
            BigInteger big = new BigInteger(numberPart);
            long lid = big.longValue();
            if (lid < 0L) {
                BigInteger max = BigInteger.ONE.shiftLeft(64);
                BigInteger bi = BigInteger.valueOf(lid);
                this.id = "t@" + bi.add(max).toString();
            } else {
                this.id = "t@" + Long.toString(lid);
            }
        } else {
            this.id = text;
        }
    }

    public String toString() {
        return this.id;
    }
}

