/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.logging;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.netbeans.core.startup.logging.NbFormatter;
import org.openide.util.RequestProcessor;

final class DispatchingHandler
extends Handler
implements Runnable {
    private static final int LIMIT = 1024;
    private static RequestProcessor RP = new RequestProcessor("Logging Flush", 1, false, false);
    private static ThreadLocal<Boolean> FLUSHING = new ThreadLocal();
    private final Handler delegate;
    private final BlockingQueue<LogRecord> queue = new LinkedBlockingQueue<LogRecord>(1024);
    private RequestProcessor.Task flush;
    private int delay;

    DispatchingHandler(Handler h, int delay) {
        this.delegate = h;
        this.flush = RP.create((Runnable)this, true);
        this.flush.setPriority(1);
        this.delay = delay;
    }

    @Override
    public void setFormatter(Formatter newFormatter) throws SecurityException {
        this.delegate.setFormatter(newFormatter);
    }

    @Override
    public void publish(LogRecord record) {
        Throwable t;
        if (RP.isRequestProcessorThread()) {
            return;
        }
        boolean empty = this.queue.isEmpty();
        if (!this.queue.offer(record)) {
            while (true) {
                try {
                    if (!this.schedule(true)) {
                        return;
                    }
                    this.queue.put(record);
                    Thread.yield();
                }
                catch (InterruptedException ex) {
                    continue;
                }
                break;
            }
        }
        if ((t = record.getThrown()) != null) {
            StackTraceElement[] tStack = t.getStackTrace();
            StackTraceElement[] hereStack = new Throwable().getStackTrace();
            for (int i = 1; i <= Math.min(tStack.length, hereStack.length); ++i) {
                if (tStack[tStack.length - i].equals(hereStack[hereStack.length - i])) continue;
                NbFormatter.registerCatchIndex(t, tStack.length - i);
                break;
            }
        }
        if (empty) {
            this.schedule(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean schedule(boolean now) {
        if (!Boolean.TRUE.equals(FLUSHING.get())) {
            try {
                int d;
                FLUSHING.set(true);
                if (now) {
                    d = 0;
                } else {
                    int emptySpace = 1024 - this.queue.size();
                    d = this.delay * emptySpace / 1024;
                    assert (d <= this.delay) : "d: " + d + " delay: " + this.delay;
                    assert (d >= 0) : "d: " + d;
                }
                this.flush.schedule(d);
            }
            finally {
                FLUSHING.set(false);
            }
            return true;
        }
        return false;
    }

    @Override
    public void flush() {
        this.flush.cancel();
        this.flush.waitFinished();
        this.run();
    }

    @Override
    public void close() throws SecurityException {
        this.flush();
        this.delegate.flush();
    }

    final void doClose() throws SecurityException {
        this.flush();
        this.delegate.close();
    }

    @Override
    public Formatter getFormatter() {
        return this.delegate.getFormatter();
    }

    static Handler getInternal(Handler h) {
        if (h instanceof DispatchingHandler) {
            return ((DispatchingHandler)h).delegate;
        }
        return h;
    }

    @Override
    public void run() {
        if (this.queue.isEmpty()) {
            return;
        }
        while (true) {
            LogRecord r;
            if ((r = (LogRecord)this.queue.poll()) == null) break;
            this.delegate.publish(r);
        }
        this.schedule(false);
        this.delegate.flush();
    }
}

