/*
 * Decompiled with CFR 0.152.
 */
package info.dmtree;

import info.dmtree.DmtIllegalStateException;
import java.util.Arrays;
import java.util.Hashtable;

public final class DmtData {
    public static final int FORMAT_INTEGER = 1;
    public static final int FORMAT_FLOAT = 2;
    public static final int FORMAT_STRING = 4;
    public static final int FORMAT_BOOLEAN = 8;
    public static final int FORMAT_DATE = 16;
    public static final int FORMAT_TIME = 32;
    public static final int FORMAT_BINARY = 64;
    public static final int FORMAT_BASE64 = 128;
    public static final int FORMAT_XML = 256;
    public static final int FORMAT_NULL = 512;
    public static final int FORMAT_NODE = 1024;
    public static final int FORMAT_RAW_STRING = 2048;
    public static final int FORMAT_RAW_BINARY = 4096;
    private static final Hashtable FORMAT_NAMES = new Hashtable();
    public static final DmtData NULL_VALUE;
    private final String str;
    private final int integer;
    private final float flt;
    private final boolean bool;
    private final byte[] bytes;
    private final int format;
    private final String formatName;
    private final Object complex;
    private static char[] hex;

    private DmtData() {
        this.format = 512;
        this.formatName = DmtData.getFormatName(this.format);
        this.str = null;
        this.integer = 0;
        this.flt = 0.0f;
        this.bool = false;
        this.bytes = null;
        this.complex = null;
    }

    public DmtData(String str) {
        this.format = 4;
        this.formatName = DmtData.getFormatName(this.format);
        this.str = str;
        this.integer = 0;
        this.flt = 0.0f;
        this.bool = false;
        this.bytes = null;
        this.complex = null;
    }

    public DmtData(Object complex) {
        if (complex == null) {
            throw new NullPointerException("Complex data argument is null.");
        }
        this.format = 1024;
        this.formatName = DmtData.getFormatName(this.format);
        this.complex = complex;
        this.str = null;
        this.integer = 0;
        this.flt = 0.0f;
        this.bool = false;
        this.bytes = null;
    }

    public DmtData(String value, int format) {
        switch (format) {
            case 16: {
                DmtData.checkDateFormat(value);
                break;
            }
            case 32: {
                DmtData.checkTimeFormat(value);
                break;
            }
            case 4: 
            case 256: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid format in string constructor: " + format);
            }
        }
        this.format = format;
        this.formatName = DmtData.getFormatName(format);
        this.str = value;
        this.integer = 0;
        this.flt = 0.0f;
        this.bool = false;
        this.bytes = null;
        this.complex = null;
    }

    public DmtData(int integer) {
        this.format = 1;
        this.formatName = DmtData.getFormatName(this.format);
        this.integer = integer;
        this.str = null;
        this.flt = 0.0f;
        this.bool = false;
        this.bytes = null;
        this.complex = null;
    }

    public DmtData(float flt) {
        this.format = 2;
        this.formatName = DmtData.getFormatName(this.format);
        this.flt = flt;
        this.str = null;
        this.integer = 0;
        this.bool = false;
        this.bytes = null;
        this.complex = null;
    }

    public DmtData(boolean bool) {
        this.format = 8;
        this.formatName = DmtData.getFormatName(this.format);
        this.bool = bool;
        this.str = null;
        this.integer = 0;
        this.flt = 0.0f;
        this.bytes = null;
        this.complex = null;
    }

    public DmtData(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("Binary data argument is null.");
        }
        this.format = 64;
        this.formatName = DmtData.getFormatName(this.format);
        this.bytes = bytes;
        this.str = null;
        this.integer = 0;
        this.flt = 0.0f;
        this.bool = false;
        this.complex = null;
    }

    public DmtData(byte[] bytes, boolean base64) {
        if (bytes == null) {
            throw new NullPointerException("Binary data argument is null.");
        }
        this.format = base64 ? 128 : 64;
        this.formatName = DmtData.getFormatName(this.format);
        this.bytes = bytes;
        this.str = null;
        this.integer = 0;
        this.flt = 0.0f;
        this.bool = false;
        this.complex = null;
    }

    public DmtData(String formatName, String data) {
        if (formatName == null) {
            throw new NullPointerException("Format name argument is null.");
        }
        if (data == null) {
            throw new NullPointerException("Data argument is null.");
        }
        this.format = 2048;
        this.formatName = formatName;
        this.str = data;
        this.bytes = null;
        this.integer = 0;
        this.flt = 0.0f;
        this.bool = false;
        this.complex = null;
    }

    public DmtData(String formatName, byte[] data) {
        if (formatName == null) {
            throw new NullPointerException("Format name argument is null.");
        }
        if (data == null) {
            throw new NullPointerException("Data argument is null.");
        }
        this.format = 4096;
        this.formatName = formatName;
        this.bytes = (byte[])data.clone();
        this.str = null;
        this.integer = 0;
        this.flt = 0.0f;
        this.bool = false;
        this.complex = null;
    }

    public String getString() {
        if (this.format == 4) {
            return this.str;
        }
        throw new DmtIllegalStateException("DmtData value is not string.");
    }

    public String getDate() {
        if (this.format == 16) {
            return this.str;
        }
        throw new DmtIllegalStateException("DmtData value is not date.");
    }

    public String getTime() {
        if (this.format == 32) {
            return this.str;
        }
        throw new DmtIllegalStateException("DmtData value is not time.");
    }

    public String getXml() {
        if (this.format == 256) {
            return this.str;
        }
        throw new DmtIllegalStateException("DmtData value is not XML.");
    }

    public int getInt() {
        if (this.format == 1) {
            return this.integer;
        }
        throw new DmtIllegalStateException("DmtData value is not integer.");
    }

    public float getFloat() {
        if (this.format == 2) {
            return this.flt;
        }
        throw new DmtIllegalStateException("DmtData value is not float.");
    }

    public boolean getBoolean() {
        if (this.format == 8) {
            return this.bool;
        }
        throw new DmtIllegalStateException("DmtData value is not boolean.");
    }

    public byte[] getBinary() {
        if (this.format == 64) {
            byte[] bytesCopy = new byte[this.bytes.length];
            for (int i = 0; i < this.bytes.length; ++i) {
                bytesCopy[i] = this.bytes[i];
            }
            return bytesCopy;
        }
        throw new DmtIllegalStateException("DmtData value is not a byte array.");
    }

    public byte[] getRawBinary() {
        if (this.format == 4096) {
            return (byte[])this.bytes.clone();
        }
        throw new DmtIllegalStateException("DmtData value is not in raw binary format.");
    }

    public String getRawString() {
        if (this.format == 2048) {
            return this.str;
        }
        throw new DmtIllegalStateException("DmtData value is not in raw string format.");
    }

    public byte[] getBase64() {
        if (this.format == 128) {
            byte[] bytesCopy = new byte[this.bytes.length];
            for (int i = 0; i < this.bytes.length; ++i) {
                bytesCopy[i] = this.bytes[i];
            }
            return bytesCopy;
        }
        throw new DmtIllegalStateException("DmtData value is not in base 64 format.");
    }

    public Object getNode() {
        if (this.format == 1024) {
            return this.complex;
        }
        throw new DmtIllegalStateException("DmtData does not contain interior node data.");
    }

    public int getFormat() {
        return this.format;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public int getSize() {
        switch (this.format) {
            case 4: 
            case 16: 
            case 32: 
            case 256: 
            case 2048: {
                return this.str == null ? 0 : this.str.length();
            }
            case 64: 
            case 128: 
            case 4096: {
                return this.bytes.length;
            }
            case 1: 
            case 2: {
                return 4;
            }
            case 8: {
                return 1;
            }
            case 1024: {
                return -1;
            }
            case 512: {
                return 0;
            }
        }
        return 0;
    }

    public String toString() {
        switch (this.format) {
            case 4: 
            case 16: 
            case 32: 
            case 256: 
            case 2048: {
                return this.str == null ? "" : this.str;
            }
            case 1: {
                return String.valueOf(this.integer);
            }
            case 2: {
                return String.valueOf(this.flt);
            }
            case 8: {
                return String.valueOf(this.bool);
            }
            case 64: 
            case 128: 
            case 4096: {
                return DmtData.getHexDump(this.bytes);
            }
            case 1024: {
                return this.complex.toString();
            }
            case 512: {
                return "null";
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DmtData)) {
            return false;
        }
        DmtData other = (DmtData)obj;
        if (this.format != other.format) {
            return false;
        }
        switch (this.format) {
            case 4: 
            case 16: 
            case 32: 
            case 256: {
                return this.str == null ? other.str == null : this.str.equals(other.str);
            }
            case 1: {
                return this.integer == other.integer;
            }
            case 2: {
                return this.flt == other.flt;
            }
            case 8: {
                return this.bool == other.bool;
            }
            case 64: 
            case 128: {
                return Arrays.equals(this.bytes, other.bytes);
            }
            case 1024: {
                return this.complex.equals(other.complex);
            }
            case 512: {
                return true;
            }
            case 4096: {
                return this.formatName.equals(other.formatName) && Arrays.equals(this.bytes, other.bytes);
            }
            case 2048: {
                return this.formatName.equals(other.formatName) && this.str.equals(other.str);
            }
        }
        return false;
    }

    public int hashCode() {
        switch (this.format) {
            case 4: 
            case 16: 
            case 32: 
            case 256: 
            case 2048: {
                return this.str == null ? 0 : this.str.hashCode();
            }
            case 1: {
                return ((Object)new Integer(this.integer)).hashCode();
            }
            case 2: {
                return ((Object)new Float(this.flt)).hashCode();
            }
            case 8: {
                return ((Object)new Boolean(this.bool)).hashCode();
            }
            case 64: 
            case 128: 
            case 4096: {
                return new String(this.bytes).hashCode();
            }
            case 1024: {
                return this.complex.hashCode();
            }
            case 512: {
                return 0;
            }
        }
        return 0;
    }

    private static void checkDateFormat(String value) {
        if (value.length() != 8) {
            throw new IllegalArgumentException("Date string '" + value + "' does not follow the format 'CCYYMMDD'.");
        }
        int year = DmtData.checkNumber(value, "Date", 0, 4, 0, 9999);
        int month = DmtData.checkNumber(value, "Date", 4, 2, 1, 12);
        int day = DmtData.checkNumber(value, "Date", 6, 2, 1, 31);
        if ((month == 4 || month == 6 || month == 9 || month == 11) && day == 31) {
            throw new IllegalArgumentException("Date string '" + value + "' contains an invalid date.");
        }
        if (month == 2 && day > 28 && (day != 29 || year % 4 != 0 || year % 100 == 0 && year % 400 != 0)) {
            throw new IllegalArgumentException("Date string '" + value + "' contains an invalid date.");
        }
    }

    private static void checkTimeFormat(String value) {
        if (value.length() > 0 && value.charAt(value.length() - 1) == 'Z') {
            value = value.substring(0, value.length() - 1);
        }
        if (value.length() != 6) {
            throw new IllegalArgumentException("Time string '" + value + "' does not follow the format 'hhmmss' or 'hhmmssZ'.");
        }
        DmtData.checkNumber(value, "Time", 0, 2, 0, 24);
        DmtData.checkNumber(value, "Time", 2, 2, 0, 59);
        DmtData.checkNumber(value, "Time", 4, 2, 0, 59);
        if (value.startsWith("24") && !value.startsWith("240000")) {
            throw new IllegalArgumentException("Time string is out of range.");
        }
    }

    private static int checkNumber(String value, String name, int from, int length, int min, int max) {
        int number;
        String part = value.substring(from, from + length);
        try {
            number = Integer.parseInt(part);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(name + " string '" + value + "' contains a non-numeric part.");
        }
        if (number < min || number > max) {
            throw new IllegalArgumentException("A segment of the " + name + " string '" + value + "' is out of range.");
        }
        return number;
    }

    private static String getHexDump(byte[] bytes) {
        if (bytes.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        DmtData.appendHexByte(buf, bytes[0]);
        for (int i = 1; i < bytes.length; ++i) {
            DmtData.appendHexByte(buf.append(' '), bytes[i]);
        }
        return ((Object)buf).toString();
    }

    private static void appendHexByte(StringBuffer buf, byte b) {
        buf.append(hex[(b & 0xF0) >> 4]).append(hex[b & 0xF]);
    }

    private static String getFormatName(int format) {
        return (String)FORMAT_NAMES.get(new Integer(format));
    }

    static {
        FORMAT_NAMES.put(new Integer(128), "b64");
        FORMAT_NAMES.put(new Integer(64), "bin");
        FORMAT_NAMES.put(new Integer(8), "bool");
        FORMAT_NAMES.put(new Integer(16), "date");
        FORMAT_NAMES.put(new Integer(2), "float");
        FORMAT_NAMES.put(new Integer(1), "int");
        FORMAT_NAMES.put(new Integer(1024), "node");
        FORMAT_NAMES.put(new Integer(512), "null");
        FORMAT_NAMES.put(new Integer(4), "chr");
        FORMAT_NAMES.put(new Integer(32), "time");
        FORMAT_NAMES.put(new Integer(256), "xml");
        NULL_VALUE = new DmtData();
        hex = "0123456789ABCDEF".toCharArray();
    }
}

