/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.awt.Dialog;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.RegisterDerby;
import org.netbeans.modules.derby.Util;
import org.netbeans.modules.derby.ui.CreateDatabasePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class CreateDatabaseAction
extends CallableSystemAction {
    public CreateDatabaseAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void performAction() {
        if (!Util.checkInstallLocation()) {
            return;
        }
        if (!Util.ensureSystemHome()) {
            return;
        }
        String derbySystemHome = DerbyOptions.getDefault().getSystemHome();
        CreateDatabasePanel panel = new CreateDatabasePanel(derbySystemHome);
        DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(CreateDatabaseAction.class, (String)"LBL_CreateDatabaseTitle"), true, null);
        desc.createNotificationLineSupport();
        panel.setDialogDescriptor(desc);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(desc);
        panel.setIntroduction();
        String acsd = NbBundle.getMessage(CreateDatabaseAction.class, (String)"ACSD_CreateDatabaseAction");
        dialog.getAccessibleContext().setAccessibleDescription(acsd);
        dialog.setVisible(true);
        dialog.dispose();
        if (!DialogDescriptor.OK_OPTION.equals(desc.getValue())) {
            return;
        }
        String databaseName = panel.getDatabaseName();
        String user = panel.getUser();
        String password = panel.getPassword();
        if (user == null || password == null) {
            user = null;
            password = null;
        }
        try {
            this.makeDatabase(databaseName, user, password);
        }
        catch (Exception e) {
            Logger.getLogger("global").log(Level.WARNING, null, e);
        }
    }

    void makeDatabase(String dbname, String user, String password) throws Exception {
        RegisterDerby.getDefault().postCreateNewDatabase(dbname, user, password);
    }

    protected boolean asynchronous() {
        return false;
    }

    public boolean isEnabled() {
        return Util.hasInstallLocation();
    }

    public String getName() {
        return NbBundle.getBundle(CreateDatabaseAction.class).getString("LBL_CreateDBAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CreateDatabaseAction.class);
    }
}

