/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.settings;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class HighlightingSettings {
    private static final String NODE_NAME = "highlighting";
    private static final String KEY_MODE = "mode";
    private static final String KEY_TYPE = "type";
    private static final HighlightingSettings INSTANCE = new HighlightingSettings();

    private HighlightingSettings() {
    }

    @NonNull
    public Mode getMode() {
        return Mode.forSystemName(this.getNode().get(KEY_MODE, null));
    }

    void setMode(@NonNull Mode mode) {
        assert (mode != null);
        this.getNode().put(KEY_MODE, mode.getSystemName());
    }

    @NonNull
    public Type getType() {
        return Type.forSystemName(this.getNode().get(KEY_TYPE, null));
    }

    void setType(@NonNull Type type) {
        assert (type != null);
        this.getNode().put(KEY_TYPE, type.getSystemName());
    }

    @NonNull
    private Preferences getNode() {
        Preferences prefs = NbPreferences.forModule(HighlightingSettings.class);
        return prefs.node(NODE_NAME);
    }

    @NonNull
    public static HighlightingSettings getDefault() {
        return INSTANCE;
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type BOLD = new Type("bold", NbBundle.getMessage(HighlightingSettings.class, (String)"NAME_BOLD"));
        public static final /* enum */ Type BACKGROUND = new Type("background", NbBundle.getMessage(HighlightingSettings.class, (String)"NAME_BACKGROUND"));
        private static final Map<String, Type> typesBySystemName;
        private final String systemName;
        private final String displayName;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(String systemName, String displayName) {
            assert (systemName != null);
            assert (displayName != null);
            this.systemName = systemName;
            this.displayName = displayName;
        }

        @NonNull
        public String getDisplayName() {
            return this.displayName;
        }

        @NonNull
        String getSystemName() {
            return this.systemName;
        }

        public String toString() {
            return this.getDisplayName();
        }

        @NonNull
        static Type forSystemName(@NullAllowed String systemName) {
            Type type = typesBySystemName.get(systemName);
            if (type == null) {
                type = Type.getDefault();
            }
            return type;
        }

        @NonNull
        private static Type getDefault() {
            return BACKGROUND;
        }

        static {
            $VALUES = new Type[]{BOLD, BACKGROUND};
            HashMap<String, Type> map = new HashMap<String, Type>();
            for (Type t : Type.values()) {
                map.put(t.getSystemName(), t);
            }
            typesBySystemName = Collections.unmodifiableMap(map);
        }
    }

    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode NONE = new Mode("none", NbBundle.getMessage(HighlightingSettings.class, (String)"NAME_NONE"));
        public static final /* enum */ Mode ACTIVE = new Mode("active", NbBundle.getMessage(HighlightingSettings.class, (String)"NAME_ACTIVE"));
        public static final /* enum */ Mode ALL = new Mode("all", NbBundle.getMessage(HighlightingSettings.class, (String)"NAME_ALL"));
        private static final Map<String, Mode> modesBySystemName;
        private final String systemName;
        private final String displayName;
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String name) {
            return Enum.valueOf(Mode.class, name);
        }

        private Mode(String systemName, String displayName) {
            assert (systemName != null);
            assert (displayName != null);
            this.systemName = systemName;
            this.displayName = displayName;
        }

        @NonNull
        public String getDisplayName() {
            return this.displayName;
        }

        @NonNull
        String getSystemName() {
            return this.systemName;
        }

        public String toString() {
            return this.getDisplayName();
        }

        @NonNull
        static Mode forSystemName(@NullAllowed String sysName) {
            Mode m = modesBySystemName.get(sysName);
            if (m == null) {
                m = Mode.getDefault();
            }
            return m;
        }

        @NonNull
        private static Mode getDefault() {
            return ACTIVE;
        }

        static {
            $VALUES = new Mode[]{NONE, ACTIVE, ALL};
            HashMap<String, Mode> map = new HashMap<String, Mode>();
            for (Mode m : Mode.values()) {
                map.put(m.getSystemName(), m);
            }
            modesBySystemName = Collections.unmodifiableMap(map);
        }
    }
}

