/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.history;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.netbeans.modules.db.sql.execute.ui.SQLHistoryPanel;
import org.netbeans.modules.db.sql.history.SQLHistory;
import org.netbeans.modules.db.sql.history.SQLHistoryEntry;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class SQLHistoryManager {
    JAXBContext context;
    private static final String SQL_HISTORY_DIRECTORY = "Databases/SQLHISTORY";
    private static final String SQL_HISTORY_FILE = "sql_history.xml";
    public static final String OPT_SQL_STATEMENTS_SAVED_FOR_HISTORY = "SQL_STATEMENTS_SAVED_FOR_HISTORY";
    public static final int DEFAULT_SQL_STATEMENTS_SAVED_FOR_HISTORY = 100;
    public static final int MAX_SQL_STATEMENTS_SAVED_FOR_HISTORY = 10000;
    private static SQLHistoryManager _instance = null;
    private static final Logger LOGGER = Logger.getLogger(SQLHistoryEntry.class.getName());
    private SQLHistory sqlHistory;
    private static final RequestProcessor RP = new RequestProcessor(SQLHistoryManager.class.getName(), 1, false, false);
    private final RequestProcessor.Task SAVER = RP.create((Runnable)new Saver());
    private final PropertyChangeSupport PROPERTY_CHANGE_SUPPORT = new PropertyChangeSupport(this);
    private static final int SAVE_DELAY = 5000;
    static final String PROP_SAVED = "saved";

    protected SQLHistoryManager() {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SQLHistoryManager.class.getClassLoader());
        try {
            this.context = JAXBContext.newInstance((String)"org.netbeans.modules.db.sql.history", (ClassLoader)SQLHistoryManager.class.getClassLoader());
            this.loadHistory();
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (SQLHistoryManager.this.SAVER.getDelay() > 0) {
                    SQLHistoryManager.this.SAVER.schedule(0);
                    SQLHistoryManager.this.SAVER.waitFinished();
                }
            }
        });
    }

    public static synchronized SQLHistoryManager getInstance() {
        if (_instance == null) {
            _instance = new SQLHistoryManager();
        }
        return _instance;
    }

    public int getListSize() {
        return NbPreferences.forModule(SQLHistoryPanel.class).getInt("OPT_SQL_STATEMENTS_SAVED_FOR_HISTORY", 100);
    }

    protected FileObject getHistoryRoot(boolean create) throws IOException {
        FileObject result = null;
        FileObject historyRootDir = this.getConfigRoot().getFileObject(this.getRelativeHistoryPath());
        if (historyRootDir != null || create) {
            FileObject historyRoot;
            if (historyRootDir == null) {
                historyRootDir = FileUtil.createFolder((FileObject)this.getConfigRoot(), (String)this.getRelativeHistoryPath());
            }
            if ((historyRoot = historyRootDir.getFileObject(this.getHistoryFilename())) != null || create) {
                if (historyRoot == null) {
                    historyRoot = historyRootDir.createData(this.getHistoryFilename());
                }
                result = historyRoot;
            }
        }
        return result;
    }

    protected FileObject getConfigRoot() {
        return FileUtil.getConfigRoot();
    }

    protected String getRelativeHistoryPath() {
        return SQL_HISTORY_DIRECTORY;
    }

    protected String getHistoryFilename() {
        return SQL_HISTORY_FILE;
    }

    public void setListSize(int listSize) {
        NbPreferences.forModule(SQLHistoryPanel.class).putInt("OPT_SQL_STATEMENTS_SAVED_FOR_HISTORY", listSize);
        this.sqlHistory.setHistoryLimit(listSize);
    }

    public void saveSQL(SQLHistoryEntry sqlStored) {
        this.sqlHistory.add(sqlStored);
    }

    private void loadHistory() {
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            InputStream is = this.getHistoryRoot(false).getInputStream();
            this.sqlHistory = (SQLHistory)unmarshaller.unmarshal(is);
            this.sqlHistory.setHistoryLimit(this.getListSize());
            is.close();
        }
        catch (Exception ex) {
            this.sqlHistory = new SQLHistory();
            this.sqlHistory.setHistoryLimit(this.getListSize());
            LOGGER.log(Level.INFO, ex.getMessage());
        }
    }

    public void save() {
        if (this.SAVER.getDelay() == 0) {
            this.SAVER.schedule(5000);
        }
    }

    public SQLHistory getSQLHistory() {
        return this.sqlHistory;
    }

    void addPropertyChangeListener(PropertyChangeListener listener) {
        this.PROPERTY_CHANGE_SUPPORT.addPropertyChangeListener(listener);
    }

    void removePropertyChangeListener(PropertyChangeListener listener) {
        this.PROPERTY_CHANGE_SUPPORT.removePropertyChangeListener(listener);
    }

    private class Saver
    implements Runnable {
        private Saver() {
        }

        @Override
        public void run() {
            try {
                final FileObject targetFile = SQLHistoryManager.this.getHistoryRoot(true);
                targetFile.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() throws IOException {
                        OutputStream os = null;
                        try {
                            Marshaller marshaller = SQLHistoryManager.this.context.createMarshaller();
                            os = targetFile.getOutputStream();
                            marshaller.marshal((Object)SQLHistoryManager.this.sqlHistory, os);
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.INFO, ex.getMessage(), ex);
                        }
                        finally {
                            try {
                                if (os != null) {
                                    os.close();
                                }
                                SQLHistoryManager.this.PROPERTY_CHANGE_SUPPORT.firePropertyChange(SQLHistoryManager.PROP_SAVED, null, null);
                            }
                            catch (IOException ex) {
                                LOGGER.log(Level.INFO, null, ex);
                            }
                        }
                    }
                });
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, ex.getMessage());
            }
        }
    }
}

