/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator.support;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.terminalemulator.LineDiscipline;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.lib.terminalemulator.support.Catalog;
import org.netbeans.lib.terminalemulator.support.ColorComboBox;
import org.netbeans.lib.terminalemulator.support.ColorValue;
import org.netbeans.lib.terminalemulator.support.FontPanel;
import org.netbeans.lib.terminalemulator.support.TermOptions;

public final class TermOptionsPanel
extends JPanel {
    private TermOptions termOptions;
    private final Term term;
    static final String LBL_Options = Catalog.get("LBL_Options");
    static final String CTL_Restore = Catalog.get("CTL_Restore");
    static final String LBL_Font = Catalog.get("LBL_Font");
    static final String CTL_Ellipsis = Catalog.get("CTL_Ellipsis");
    static final String LBL_FontSize = Catalog.get("LBL_FontSize");
    static final String LBL_ForegroundColor = Catalog.get("LBL_ForegroundColor");
    static final String LBL_BackgroundColor = Catalog.get("LBL_BackgroundColor");
    static final String LBL_SelectionBackgroundColor = Catalog.get("LBL_SelectionBackgroundColor");
    static final String LBL_HistorySize = Catalog.get("LBL_HistorySize");
    static final String LBL_TabSize = Catalog.get("LBL_TabSize");
    static final String CTL_ClickToType = Catalog.get("CTL_ClickToType");
    static final String CTL_ScrollOnInput = Catalog.get("CTL_ScrollOnInput");
    static final String CTL_ScrollOnOutput = Catalog.get("CTL_ScrollOnOutput");
    static final String LBL_WrapLines = Catalog.get("LBL_WrapLines");
    static final String LBL_Preview = Catalog.get("LBL_Preview");
    static final String LBL_IgnoreKeymap = Catalog.get("LBL_IgnoreKeymap");
    private static final int MNM_Restore = Catalog.mnemonic("MNM_Restore");
    private static final int MNM_Font = Catalog.mnemonic("MNM_Font");
    private static final int MNM_FontSize = Catalog.mnemonic("MNM_FontSize");
    private static final int MNM_ForegroundColor = Catalog.mnemonic("MNM_ForegroundColor");
    private static final int MNM_BackgroundColor = Catalog.mnemonic("MNM_BackgroundColor");
    private static final int MNM_SelectionBackgroundColor = Catalog.mnemonic("MNM_SelectionBackgroundColor");
    private static final int MNM_HistorySize = Catalog.mnemonic("MNM_HistorySize");
    private static final int MNM_TabSize = Catalog.mnemonic("MNM_TabSize");
    private static final int MNM_ClickToType = Catalog.mnemonic("MNM_ClickToType");
    private static final int MNM_ScrollOnInput = Catalog.mnemonic("MNM_ScrollOnInput");
    private static final int MNM_ScrollOnOutput = Catalog.mnemonic("MNM_ScrollOnOutput");
    private static final int MNM_WrapLines = Catalog.mnemonic("MNM_WrapLines");
    private static final int MNM_IgnoreKeymap = Catalog.mnemonic("MNM_IgnoreKeymap");
    private static final int MNM_Preview = Catalog.mnemonic("MNM_Preview");
    private boolean inApplyingModel;
    private final PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            TermOptionsPanel.this.refreshView();
        }
    };
    private JComboBox<ColorValue> backgroundComboBox;
    private JLabel backgroundLabel;
    private JCheckBox clickToTypeCheckBox;
    private JLabel descriptionLabel;
    private JButton fontButton;
    private JLabel fontLabel;
    private JLabel fontSizeLabel;
    private JSpinner fontSizeSpinner;
    private JTextField fontText;
    private JComboBox<ColorValue> foregroundComboBox;
    private JLabel foregroundLabel;
    private JLabel historySizeLabel;
    private JSpinner historySizeSpinner;
    private JCheckBox ignoreKeymapCheckBox;
    private JCheckBox lineWrapCheckBox;
    private JLabel previewLabel;
    private JPanel previewPanel;
    private JButton restoreButton;
    private JCheckBox scrollOnInputCheckBox;
    private JCheckBox scrollOnOutputCheckBox;
    private JComboBox<ColorValue> selectionComboBox;
    private JLabel selectionLabel;
    private JLabel tabSizeLabel;
    private JSpinner tabSizeSpinner;

    public TermOptionsPanel() {
        this.initComponents();
        ColorComboBox.init(this.foregroundComboBox);
        ColorComboBox.init(this.backgroundComboBox);
        ColorComboBox.init(this.selectionComboBox);
        this.term = new Term();
        String line1String = Catalog.get("MSG_Hello") + "\r\n";
        char[] line1 = line1String.toCharArray();
        this.term.putChars(line1, 0, line1.length);
        Border termBorder = BorderFactory.createLoweredBevelBorder();
        this.term.setBorder(termBorder);
        this.term.pushStream(new LineDiscipline());
        this.term.setRowsColumns(7, 60);
        this.term.setClickToType(true);
        this.previewPanel.add((Component)this.term, "Center");
    }

    public void setTermOptions(TermOptions termOptions) {
        if (this.termOptions != null) {
            this.termOptions.removePropertyChangeListener(this.propertyListener);
        }
        this.termOptions = termOptions;
        if (this.termOptions != null) {
            this.termOptions.addPropertyChangeListener(this.propertyListener);
        }
        this.refreshView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshView() {
        if (this.termOptions != null) {
            this.termOptions.removePropertyChangeListener(this.propertyListener);
        }
        try {
            this.applyTermOptions();
        }
        finally {
            if (this.termOptions != null) {
                this.termOptions.addPropertyChangeListener(this.propertyListener);
            }
        }
        this.previewTermOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyTermOptions() {
        this.inApplyingModel = true;
        try {
            this.fontSizeSpinner.setValue(this.termOptions.getFontSize());
            this.fontText.setText(this.termOptions.getFont().getFamily() + " " + this.termOptions.getFont().getSize());
            ColorComboBox.setColor(this.foregroundComboBox, this.termOptions.getForeground());
            ColorComboBox.setColor(this.backgroundComboBox, this.termOptions.getBackground());
            ColorComboBox.setColor(this.selectionComboBox, this.termOptions.getSelectionBackground());
            this.historySizeSpinner.setValue(this.termOptions.getHistorySize());
            this.tabSizeSpinner.setValue(this.termOptions.getTabSize());
            this.clickToTypeCheckBox.setSelected(this.termOptions.getClickToType());
            this.scrollOnInputCheckBox.setSelected(this.termOptions.getScrollOnInput());
            this.scrollOnOutputCheckBox.setSelected(this.termOptions.getScrollOnOutput());
            this.lineWrapCheckBox.setSelected(this.termOptions.getLineWrap());
            this.ignoreKeymapCheckBox.setSelected(this.termOptions.getIgnoreKeymap());
        }
        finally {
            this.inApplyingModel = false;
        }
    }

    private void patchSizes() {
        this.term.invalidate();
        this.previewPanel.validate();
        this.previewPanel.invalidate();
        this.validate();
        this.invalidate();
    }

    private void previewTermOptions() {
        if (this.term == null) {
            return;
        }
        this.term.setFixedFont(true);
        this.term.setFont(this.termOptions.getFont());
        this.term.setBackground(this.termOptions.getBackground());
        this.term.setForeground(this.termOptions.getForeground());
        this.term.setHighlightColor(this.termOptions.getSelectionBackground());
        this.term.setHistorySize(this.termOptions.getHistorySize());
        this.term.setTabSize(this.termOptions.getTabSize());
        this.term.setClickToType(this.termOptions.getClickToType());
        this.term.setScrollOnInput(this.termOptions.getScrollOnInput());
        this.term.setScrollOnOutput(this.termOptions.getScrollOnOutput());
        this.term.setHorizontallyScrollable(!this.termOptions.getLineWrap());
        this.term.setRowsColumns(7, 60);
        this.patchSizes();
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.restoreButton = new JButton();
        this.fontLabel = new JLabel();
        this.fontText = new JTextField();
        this.fontButton = new JButton();
        this.fontSizeLabel = new JLabel();
        this.fontSizeSpinner = new JSpinner();
        this.foregroundLabel = new JLabel();
        this.foregroundComboBox = new JComboBox();
        this.backgroundLabel = new JLabel();
        this.backgroundComboBox = new JComboBox();
        this.selectionLabel = new JLabel();
        this.selectionComboBox = new JComboBox();
        this.historySizeLabel = new JLabel();
        this.historySizeSpinner = new JSpinner();
        this.tabSizeLabel = new JLabel();
        this.tabSizeSpinner = new JSpinner();
        this.clickToTypeCheckBox = new JCheckBox();
        this.scrollOnInputCheckBox = new JCheckBox();
        this.scrollOnOutputCheckBox = new JCheckBox();
        this.lineWrapCheckBox = new JCheckBox();
        this.ignoreKeymapCheckBox = new JCheckBox();
        this.previewLabel = new JLabel();
        this.previewPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.descriptionLabel.setText(LBL_Options);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.add((Component)this.descriptionLabel, gridBagConstraints);
        this.restoreButton.setMnemonic(MNM_Restore);
        this.restoreButton.setText(CTL_Restore);
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.restoreActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.restoreButton, gridBagConstraints);
        this.fontLabel.setDisplayedMnemonic(MNM_Font);
        this.fontLabel.setText(LBL_Font);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.fontLabel, gridBagConstraints);
        this.fontText.setColumns(20);
        this.fontText.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.fontText, gridBagConstraints);
        this.fontButton.setText(CTL_Ellipsis);
        this.fontButton.setMaximumSize(new Dimension(20, 20));
        this.fontButton.setMinimumSize(new Dimension(20, 20));
        this.fontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.chooseFont(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.fontButton, gridBagConstraints);
        this.fontSizeLabel.setDisplayedMnemonic(MNM_FontSize);
        this.fontSizeLabel.setLabelFor(this.fontSizeSpinner);
        this.fontSizeLabel.setText(LBL_FontSize);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.fontSizeLabel, gridBagConstraints);
        this.fontSizeSpinner.setModel(new SpinnerNumberModel(12, 8, 48, 1));
        this.fontSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TermOptionsPanel.this.fontSizeSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.fontSizeSpinner, gridBagConstraints);
        this.foregroundLabel.setDisplayedMnemonic(MNM_ForegroundColor);
        this.foregroundLabel.setLabelFor(this.foregroundComboBox);
        this.foregroundLabel.setText(LBL_ForegroundColor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.foregroundLabel, gridBagConstraints);
        this.foregroundComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.foregroundComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add(this.foregroundComboBox, gridBagConstraints);
        this.backgroundLabel.setDisplayedMnemonic(MNM_BackgroundColor);
        this.backgroundLabel.setLabelFor(this.backgroundComboBox);
        this.backgroundLabel.setText(LBL_BackgroundColor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.backgroundLabel, gridBagConstraints);
        this.backgroundComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.backgroundComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add(this.backgroundComboBox, gridBagConstraints);
        this.selectionLabel.setDisplayedMnemonic(MNM_SelectionBackgroundColor);
        this.selectionLabel.setLabelFor(this.selectionComboBox);
        this.selectionLabel.setText(LBL_SelectionBackgroundColor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.selectionLabel, gridBagConstraints);
        this.selectionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.selectionComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add(this.selectionComboBox, gridBagConstraints);
        this.historySizeLabel.setDisplayedMnemonic(MNM_HistorySize);
        this.historySizeLabel.setLabelFor(this.historySizeSpinner);
        this.historySizeLabel.setText(LBL_HistorySize);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.historySizeLabel, gridBagConstraints);
        this.historySizeSpinner.setModel(new SpinnerNumberModel(4000, 0, 50000, 10));
        this.historySizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TermOptionsPanel.this.historySizeSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.historySizeSpinner, gridBagConstraints);
        this.tabSizeLabel.setDisplayedMnemonic(MNM_TabSize);
        this.tabSizeLabel.setLabelFor(this.tabSizeSpinner);
        this.tabSizeLabel.setText(LBL_TabSize);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.tabSizeLabel, gridBagConstraints);
        this.tabSizeSpinner.setModel(new SpinnerNumberModel(5, 1, 16, 1));
        this.tabSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TermOptionsPanel.this.tabSizeSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.tabSizeSpinner, gridBagConstraints);
        this.clickToTypeCheckBox.setMnemonic(MNM_ClickToType);
        this.clickToTypeCheckBox.setText(CTL_ClickToType);
        this.clickToTypeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.clickToTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.clickToTypeCheckBox, gridBagConstraints);
        this.scrollOnInputCheckBox.setMnemonic(MNM_ScrollOnInput);
        this.scrollOnInputCheckBox.setText(CTL_ScrollOnInput);
        this.scrollOnInputCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.scrollOnInputActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.scrollOnInputCheckBox, gridBagConstraints);
        this.scrollOnOutputCheckBox.setMnemonic(MNM_ScrollOnOutput);
        this.scrollOnOutputCheckBox.setText(CTL_ScrollOnOutput);
        this.scrollOnOutputCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.scrollOnOutputActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.scrollOnOutputCheckBox, gridBagConstraints);
        this.lineWrapCheckBox.setMnemonic(MNM_WrapLines);
        this.lineWrapCheckBox.setText(LBL_WrapLines);
        this.lineWrapCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.lineWrapActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.lineWrapCheckBox, gridBagConstraints);
        this.ignoreKeymapCheckBox.setMnemonic(MNM_IgnoreKeymap);
        this.ignoreKeymapCheckBox.setText(LBL_IgnoreKeymap);
        this.ignoreKeymapCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.ignoreKeymapCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.ignoreKeymapCheckBox, gridBagConstraints);
        this.previewLabel.setDisplayedMnemonic(MNM_Preview);
        this.previewLabel.setLabelFor(this.previewPanel);
        this.previewLabel.setText(LBL_Preview);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.previewLabel, gridBagConstraints);
        this.previewPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.previewPanel.setPreferredSize(new Dimension(400, 50));
        this.previewPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        this.add((Component)this.previewPanel, gridBagConstraints);
    }

    private void restoreActionPerformed(ActionEvent evt) {
        this.termOptions.resetToDefault();
    }

    private void fontSizeSpinnerStateChanged(ChangeEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        Object fontSizeObj = this.fontSizeSpinner.getValue();
        if (fontSizeObj instanceof Integer) {
            int fontSize = (Integer)fontSizeObj;
            this.termOptions.setFontSize(fontSize);
        }
    }

    private void historySizeSpinnerStateChanged(ChangeEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        Object historySizeObj = this.historySizeSpinner.getValue();
        if (historySizeObj instanceof Integer) {
            int historySize = (Integer)historySizeObj;
            this.termOptions.setHistorySize(historySize);
        }
    }

    private void tabSizeSpinnerStateChanged(ChangeEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        Object tabSizeObj = this.tabSizeSpinner.getValue();
        if (tabSizeObj instanceof Integer) {
            int tabSize = (Integer)tabSizeObj;
            this.termOptions.setTabSize(tabSize);
        }
    }

    private void clickToTypeActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        this.termOptions.setClickToType(this.clickToTypeCheckBox.isSelected());
    }

    private void scrollOnInputActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        this.termOptions.setScrollOnInput(this.scrollOnInputCheckBox.isSelected());
    }

    private void scrollOnOutputActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        this.termOptions.setScrollOnOutput(this.scrollOnOutputCheckBox.isSelected());
    }

    private void lineWrapActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        this.termOptions.setLineWrap(this.lineWrapCheckBox.isSelected());
    }

    String getStyleName(int i) {
        if ((i & 1) > 0) {
            if ((i & 2) > 0) {
                return "CTL_BoldItalic";
            }
            return "CTL_Bold";
        }
        if ((i & 2) > 0) {
            return "CTL_Italic";
        }
        return "CTL_Plain";
    }

    private void chooseFont(ActionEvent evt) {
        FontPanel panel = new FontPanel(this.termOptions.getFont(), this);
        int choice = JOptionPane.showOptionDialog(this.previewPanel, panel, Catalog.get("LBL_Title"), 2, -1, null, null, null);
        if (choice == 0) {
            this.termOptions.setFont(panel.font());
            this.applyTermOptions();
        }
    }

    private void ignoreKeymapCheckBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        this.termOptions.setIgnoreKeymap(this.ignoreKeymapCheckBox.isSelected());
    }

    private void foregroundComboBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        Color c = ColorComboBox.getColor(this.foregroundComboBox);
        if (c != null) {
            this.termOptions.setForeground(c);
        }
    }

    private void backgroundComboBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        Color c = ColorComboBox.getColor(this.backgroundComboBox);
        if (c != null) {
            this.termOptions.setBackground(c);
        }
    }

    private void selectionComboBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        Color c = ColorComboBox.getColor(this.selectionComboBox);
        if (c != null) {
            this.termOptions.setSelectionBackground(c);
        }
    }
}

