/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.checkout;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.modules.git.ui.checkout.Bundle;
import org.netbeans.modules.git.ui.checkout.CheckoutRevisionPanel;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.repository.RevisionDialogController;
import org.netbeans.modules.git.utils.GitUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public abstract class AbstractCheckoutRevision
implements DocumentListener,
ActionListener,
PropertyChangeListener {
    protected final CheckoutRevisionPanel panel;
    private final RevisionDialogController revisionPicker;
    private JButton okButton;
    private DialogDescriptor dd;
    private boolean revisionValid = false;
    private String msgInvalidName;
    private boolean branchNameRecommended = true;
    private String branchName;
    private final Map<String, GitBranch> branches;
    private final Icon ICON_ERROR = new ImageIcon(this.getClass().getResource("/org/netbeans/modules/git/resources/icons/info.png"));

    protected AbstractCheckoutRevision(RepositoryInfo info, RevisionDialogController revisionPicker) {
        this.revisionPicker = revisionPicker;
        this.panel = new CheckoutRevisionPanel(revisionPicker.getPanel());
        info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)info));
        this.branches = info.getBranches();
    }

    String getRevision() {
        return this.revisionPicker.getRevision().getRevision();
    }

    String getBranchName() {
        return this.panel.branchNameField.getText();
    }

    boolean isCreateBranchSelected() {
        return this.panel.cbCheckoutAsNewBranch.isSelected();
    }

    protected abstract String getOkButtonLabel();

    protected abstract String getDialogTitle();

    boolean show(HelpCtx helpCtx) {
        this.okButton = new JButton(this.getOkButtonLabel());
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)this.okButton.getText());
        this.dd = new DialogDescriptor((Object)this.panel, this.getDialogTitle(), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, helpCtx, null);
        this.validateBranchCB();
        this.revisionPicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "RevisionDialogController.valid") {
                    AbstractCheckoutRevision.this.setRevisionValid(Boolean.TRUE.equals(evt.getNewValue()));
                } else if (evt.getPropertyName() == "RevisionDialogController.revisionAccepted" && AbstractCheckoutRevision.this.dd.isValid()) {
                    AbstractCheckoutRevision.this.okButton.doClick();
                }
            }
        });
        this.panel.branchNameField.getDocument().addDocumentListener(this);
        this.panel.cbCheckoutAsNewBranch.addActionListener(this);
        Dialog d = DialogDisplayer.getDefault().createDialog(this.dd);
        d.setVisible(true);
        return this.okButton == this.dd.getValue();
    }

    private void setRevisionValid(boolean flag) {
        this.revisionValid = flag;
        if (flag) {
            this.validateBranchCB();
        } else {
            this.setErrorMessage(NbBundle.getMessage(AbstractCheckoutRevision.class, (String)"MSG_CheckoutRevision.errorRevision"));
            this.validate();
        }
    }

    private void validate() {
        boolean flag = this.revisionValid;
        boolean messageSet = false;
        if (flag) {
            if (this.panel.cbCheckoutAsNewBranch.isSelected() && this.msgInvalidName != null) {
                this.setErrorMessage(this.msgInvalidName);
                flag = false;
                messageSet = true;
            } else if (!this.panel.cbCheckoutAsNewBranch.isSelected() && this.branchNameRecommended) {
                this.setErrorMessage(NbBundle.getMessage(AbstractCheckoutRevision.class, (String)"MSG_CheckoutRevision.warningDetachedHead"));
                messageSet = true;
            }
        }
        if (!messageSet) {
            this.setErrorMessage(null);
        }
        this.okButton.setEnabled(flag);
        this.dd.setValid(flag);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateName();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateName();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.cbCheckoutAsNewBranch) {
            this.panel.branchNameField.setEnabled(this.panel.cbCheckoutAsNewBranch.isSelected());
            this.validateBranchCB();
            this.validate();
        }
    }

    private void validateName() {
        this.msgInvalidName = null;
        this.branchName = this.panel.branchNameField.getText();
        if (this.branchName.isEmpty()) {
            this.msgInvalidName = Bundle.MSG_CheckoutRevision_errorBranchNameEmpty();
        } else if (!GitUtils.isValidBranchName(this.branchName)) {
            this.msgInvalidName = Bundle.MSG_CheckoutRevision_errorInvalidBranchName();
        } else if (this.branches.containsKey(this.branchName)) {
            this.msgInvalidName = Bundle.MSG_CheckoutRevision_errorBranchExists();
        } else {
            for (String branch : this.branches.keySet()) {
                if (!this.branchName.startsWith(branch + "/") && !branch.startsWith(this.branchName + "/")) continue;
                this.msgInvalidName = Bundle.MSG_CheckoutRevision_errorParentExists(branch);
                break;
            }
        }
        this.validate();
    }

    private void validateBranchCB() {
        String localBranch;
        boolean localBranchExists;
        String rev = this.revisionPicker.getRevision().getRevision();
        if (rev.startsWith("refs/heads/")) {
            rev = rev.substring("refs/heads/".length());
        } else if (rev.startsWith("refs/remotes/")) {
            rev = rev.substring("refs/remotes/".length());
        } else if (rev.startsWith("remotes/")) {
            rev = rev.substring(8);
        }
        GitBranch b = this.branches.get(rev);
        this.branchNameRecommended = b == null || b.isRemote();
        if (b != null && b.isRemote() && this.panel.cbCheckoutAsNewBranch.isSelected() && !(localBranchExists = this.branches.containsKey(localBranch = rev.substring(rev.indexOf("/") + 1)))) {
            this.panel.branchNameField.setText(localBranch);
        }
        this.validate();
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        if ("prop.branches".equals(evt.getPropertyName())) {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    AbstractCheckoutRevision.this.branches.clear();
                    AbstractCheckoutRevision.this.branches.putAll((Map)evt.getNewValue());
                    AbstractCheckoutRevision.this.validateName();
                    AbstractCheckoutRevision.this.validateBranchCB();
                }
            });
        }
    }

    private void setErrorMessage(String message) {
        this.panel.lblError.setText(message);
        if (message == null || message.isEmpty()) {
            this.panel.lblError.setIcon(null);
        } else {
            this.panel.lblError.setIcon(this.ICON_ERROR);
        }
    }
}

