/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.fetch;

import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.modules.git.ui.fetch.PullBranchesStep;
import org.netbeans.modules.git.ui.repository.remote.SelectUriStep;
import org.netbeans.modules.git.ui.wizards.AbstractWizardPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

class PullWizard
implements ChangeListener {
    private final Map<String, GitRemoteConfig> remotes;
    private PanelsIterator wizardIterator;
    private WizardDescriptor wizardDescriptor;
    private final File repository;

    public PullWizard(File repository, Map<String, GitRemoteConfig> remotes) {
        this.repository = repository;
        this.remotes = remotes;
    }

    boolean show() {
        boolean finnished;
        this.wizardIterator = new PanelsIterator();
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this.wizardIterator);
        this.wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        this.wizardDescriptor.setTitle(NbBundle.getMessage(PullWizard.class, (String)"LBL_PullWizard.title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        this.setErrorMessage(this.wizardIterator.selectUriStep.getErrorMessage());
        dialog.setVisible(true);
        dialog.toFront();
        Object value = this.wizardDescriptor.getValue();
        boolean bl = finnished = value == WizardDescriptor.FINISH_OPTION;
        if (!(finnished || value != WizardDescriptor.CLOSED_OPTION && value != WizardDescriptor.CANCEL_OPTION)) {
            this.wizardIterator.selectUriStep.cancelBackgroundTasks();
        }
        return finnished;
    }

    String getRemoteToPersist() {
        return this.wizardIterator.selectUriStep.getRemoteName();
    }

    private void setErrorMessage(AbstractWizardPanel.Message msg) {
        if (this.wizardDescriptor != null) {
            if (msg == null) {
                this.wizardDescriptor.putProperty("WizardPanel_infoMessage", null);
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
            } else if (msg.isInfo()) {
                this.wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)msg.getMessage());
            } else {
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)msg.getMessage());
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        AbstractWizardPanel step = (AbstractWizardPanel)e.getSource();
        this.setErrorMessage(step.getErrorMessage());
    }

    String getFetchUri() {
        return this.wizardIterator.selectUriStep.getSelectedUri();
    }

    List<String> getFetchRefSpecs() {
        return this.wizardIterator.pullBranchesStep.getSelectedRefSpecs();
    }

    String getBranchToMerge() {
        return this.wizardIterator.pullBranchesStep.getBranchToMerge();
    }

    private class PanelsIterator
    extends WizardDescriptor.ArrayIterator<WizardDescriptor> {
        private SelectUriStep selectUriStep;
        private PullBranchesStep pullBranchesStep;

        private PanelsIterator() {
        }

        protected WizardDescriptor.Panel<WizardDescriptor>[] initializePanels() {
            this.selectUriStep = new SelectUriStep(PullWizard.this.repository, PullWizard.this.remotes, SelectUriStep.Mode.PULL);
            this.selectUriStep.addChangeListener(PullWizard.this);
            this.pullBranchesStep = new PullBranchesStep(PullWizard.this.repository);
            this.pullBranchesStep.addChangeListener(PullWizard.this);
            WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{this.selectUriStep, this.pullBranchesStep};
            String[] steps = new String[panels.length];
            for (int i = 0; i < panels.length; ++i) {
                Component c = panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
            return panels;
        }

        public synchronized void nextPanel() {
            if (this.current() == this.selectUriStep) {
                GitRemoteConfig remote = this.selectUriStep.getSelectedRemote();
                Map<String, GitBranch> remoteBranches = this.selectUriStep.getRemoteBranches();
                this.pullBranchesStep.setRemote(remote);
                if (remoteBranches != null) {
                    this.pullBranchesStep.fillRemoteBranches(remoteBranches);
                }
                this.selectUriStep.storeURI();
            }
            super.nextPanel();
        }
    }
}

