/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.ui.history.Bundle;
import org.netbeans.modules.git.ui.history.SearchExecutor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class SearchCriteriaPanel
extends JPanel {
    private static final DateFormat[] dateFormats = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd HH:mm"), new SimpleDateFormat("yyyy-MM-dd")};
    private SearchExecutor.Mode mode = SearchExecutor.Mode.LOCAL;
    private JLabel branchLabel;
    final JButton btnSelectBranch = new JButton();
    private JLabel commitMessageLabel;
    private JLabel fromInfoLabel;
    private JLabel fromLabel;
    private JLabel limitLabel;
    private JCheckBox showMergesChkBox;
    final JTextField tfBranch = new JTextField();
    private JTextField tfCommitMessage;
    final JTextField tfFrom = new JTextField();
    final JTextField tfLimit = new JTextField();
    final JTextField tfTo = new JTextField();
    private JTextField tfUsername;
    private JLabel toInfoLabel;
    private JLabel toLabel;
    private JLabel usernameLabel;

    public SearchCriteriaPanel() {
        this.initComponents();
        this.showMergesChkBox.setSelected(GitModuleConfig.getDefault().getShowHistoryMerges());
        this.tfLimit.setText(Integer.toString(10));
    }

    public Date getFrom() {
        if (this.mode != SearchExecutor.Mode.LOCAL) {
            return null;
        }
        String s = this.tfFrom.getText().trim();
        if (s.isEmpty()) {
            return null;
        }
        return SearchCriteriaPanel.parseDate(s);
    }

    public Date getTo() {
        if (this.mode != SearchExecutor.Mode.LOCAL) {
            return null;
        }
        String s = this.tfTo.getText().trim();
        if (s.isEmpty()) {
            return null;
        }
        return SearchCriteriaPanel.parseDate(s);
    }

    String getBranch() {
        String s = this.tfBranch.getText().trim();
        if (s.isEmpty()) {
            return null;
        }
        return s;
    }

    public void setBranch(String branch) {
        this.tfBranch.setText(branch);
    }

    public int getLimit() {
        String s = this.tfLimit.getText().trim();
        Integer retval = -1;
        try {
            retval = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            retval = -1;
        }
        if (retval <= 0) {
            retval = -1;
        }
        return retval;
    }

    public void setLimit(int limit) {
        if (limit > 0) {
            this.tfLimit.setText(Integer.toString(limit));
        } else {
            this.tfLimit.setText("");
        }
    }

    public String getCommitMessage() {
        String s = this.tfCommitMessage.getText().trim();
        return s.isEmpty() ? null : s;
    }

    public String getUsername() {
        String s = this.tfUsername.getText().trim();
        return s.isEmpty() ? null : s;
    }

    boolean isIncludeMerges() {
        return this.showMergesChkBox.isSelected();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchCriteriaPanel.this.tfCommitMessage.requestFocusInWindow();
            }
        });
    }

    void setupRemoteSearch(SearchExecutor.Mode mode) {
        this.mode = mode;
        this.branchLabel.setEnabled(false);
        this.tfBranch.setEnabled(false);
        this.btnSelectBranch.setEnabled(false);
        this.fromLabel.setVisible(false);
        this.tfFrom.setVisible(false);
        this.fromInfoLabel.setVisible(false);
        this.toLabel.setVisible(false);
        this.tfTo.setVisible(false);
        this.toInfoLabel.setVisible(false);
    }

    String getToRevision() {
        String toRevision;
        String branch = this.getBranch();
        switch (this.mode) {
            case REMOTE_IN: {
                return null;
            }
            case REMOTE_OUT: {
                return branch;
            }
        }
        if (branch == null) {
            toRevision = this.getTo() == null ? this.tfTo.getText().trim() : null;
        } else {
            toRevision = branch;
            if (this.getTo() == null && !this.tfTo.getText().trim().isEmpty()) {
                throw new IllegalArgumentException(Bundle.MSG_IllegalSearchArgument_bothBranchAndTo());
            }
        }
        return toRevision != null && toRevision.isEmpty() ? null : toRevision;
    }

    String getFromRevision() {
        String branch = this.getBranch();
        switch (this.mode) {
            case REMOTE_IN: {
                return branch;
            }
            case REMOTE_OUT: {
                return null;
            }
        }
        String fromRevision = this.getFrom() == null ? this.tfFrom.getText().trim() : null;
        return fromRevision != null && fromRevision.isEmpty() ? null : fromRevision;
    }

    SearchExecutor.Mode getMode() {
        return this.mode;
    }

    private static Date parseDate(String strDate) {
        Date date = null;
        if (strDate != null) {
            for (DateFormat fd : dateFormats) {
                try {
                    date = fd.parse(strDate);
                }
                catch (ParseException ex) {
                    // empty catch block
                }
            }
        }
        return date;
    }

    boolean validateUserInput() {
        return true;
    }

    private void initComponents() {
        this.commitMessageLabel = new JLabel();
        this.tfCommitMessage = new JTextField();
        this.usernameLabel = new JLabel();
        this.tfUsername = new JTextField();
        this.fromLabel = new JLabel();
        this.fromInfoLabel = new JLabel();
        this.toLabel = new JLabel();
        this.toInfoLabel = new JLabel();
        this.limitLabel = new JLabel();
        this.showMergesChkBox = new JCheckBox();
        this.branchLabel = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(8, 12, 0, 11));
        this.commitMessageLabel.setLabelFor(this.tfCommitMessage);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/git/ui/history/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.commitMessageLabel, (String)bundle.getString("CTL_UseCommitMessage"));
        this.commitMessageLabel.setToolTipText(bundle.getString("TT_CommitMessage"));
        this.tfCommitMessage.setColumns(20);
        this.usernameLabel.setLabelFor(this.tfUsername);
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)bundle.getString("CTL_UseUsername"));
        this.usernameLabel.setToolTipText(bundle.getString("TT_Username"));
        this.tfUsername.setColumns(20);
        this.fromLabel.setLabelFor(this.tfFrom);
        Mnemonics.setLocalizedText((JLabel)this.fromLabel, (String)bundle.getString("CTL_UseFrom"));
        this.fromLabel.setToolTipText(bundle.getString("TT_From"));
        this.tfFrom.setColumns(20);
        Mnemonics.setLocalizedText((JLabel)this.fromInfoLabel, (String)bundle.getString("CTL_FromHint"));
        this.toLabel.setLabelFor(this.tfTo);
        Mnemonics.setLocalizedText((JLabel)this.toLabel, (String)bundle.getString("CTL_UseTo"));
        this.toLabel.setToolTipText(bundle.getString("TT_To"));
        this.tfTo.setColumns(20);
        Mnemonics.setLocalizedText((JLabel)this.toInfoLabel, (String)bundle.getString("CTL_ToHint"));
        this.limitLabel.setLabelFor(this.tfLimit);
        Mnemonics.setLocalizedText((JLabel)this.limitLabel, (String)bundle.getString("CTL_UseLimit"));
        this.limitLabel.setToolTipText(bundle.getString("TT_Limit"));
        this.tfLimit.setColumns(10);
        this.showMergesChkBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.showMergesChkBox, (String)NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_ShowMerge"));
        this.showMergesChkBox.setToolTipText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"TT_ShowMerges"));
        this.showMergesChkBox.setHorizontalTextPosition(4);
        this.tfBranch.setColumns(20);
        this.branchLabel.setLabelFor(this.tfBranch);
        Mnemonics.setLocalizedText((JLabel)this.branchLabel, (String)bundle.getString("CTL_UseBranch"));
        this.branchLabel.setToolTipText(bundle.getString("TT_Branch"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectBranch, (String)NbBundle.getMessage(SearchCriteriaPanel.class, (String)"SearchCriteriaPanel.btnSelectBranch.text"));
        this.btnSelectBranch.setToolTipText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"SearchCriteriaPanel.btnSelectBranch.TTtext"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.limitLabel).addComponent(this.commitMessageLabel))).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.usernameLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfUsername, -1, 242, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.tfLimit, -2, 1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.showMergesChkBox)).addComponent(this.tfCommitMessage)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.branchLabel).addComponent(this.toLabel).addComponent(this.fromLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfFrom, -1, 227, Short.MAX_VALUE).addComponent(this.tfTo).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toInfoLabel).addComponent(this.fromInfoLabel)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.tfBranch, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSelectBranch))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.commitMessageLabel).addComponent(this.tfCommitMessage, -2, -1, -2).addComponent(this.branchLabel).addComponent(this.tfBranch, -2, -1, -2).addComponent(this.btnSelectBranch)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tfFrom, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fromInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfTo, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.fromLabel).addGap(30, 30, 30).addComponent(this.toLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toInfoLabel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfUsername, -2, -1, -2).addComponent(this.usernameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.limitLabel).addComponent(this.tfLimit, -2, -1, -2).addComponent(this.showMergesChkBox)))).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

