/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.push;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitPushResult;
import org.netbeans.libs.git.GitRefUpdateResult;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitSubmoduleStatus;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.ActionProgress;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.branch.SetTrackingAction;
import org.netbeans.modules.git.ui.fetch.PullFromUpstreamAction;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.netbeans.modules.git.ui.push.Bundle;
import org.netbeans.modules.git.ui.push.PushMapping;
import org.netbeans.modules.git.ui.push.PushWizard;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.git.utils.LogUtils;
import org.netbeans.modules.versioning.hooks.GitHook;
import org.netbeans.modules.versioning.hooks.GitHookContext;
import org.netbeans.modules.versioning.hooks.VCSHooks;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class PushAction
extends SingleRepositoryAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/resources/icons/push-setting.png";
    private static final Set<GitRefUpdateResult> UPDATED_STATUSES = new HashSet<GitRefUpdateResult>(Arrays.asList(GitRefUpdateResult.FAST_FORWARD, GitRefUpdateResult.FORCED, GitRefUpdateResult.NEW, GitRefUpdateResult.OK, GitRefUpdateResult.RENAMED));
    private static final Logger LOG = Logger.getLogger(PushAction.class.getName());

    public PushAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        this.push(repository);
    }

    public void push(File repository, GitRemoteConfig remote, Collection<PushMapping> pushMappins) {
        List uris = remote.getPushUris();
        if (uris.isEmpty()) {
            uris = remote.getUris();
        }
        if (uris.size() != 1) {
            this.push(repository);
        } else {
            this.push(repository, (String)uris.get(0), pushMappins, remote.getFetchRefSpecs(), null);
        }
    }

    public void push(final File repository) {
        if (EventQueue.isDispatchThread()) {
            Utils.post((Runnable)new Runnable(){

                @Override
                public void run() {
                    PushAction.this.push(repository);
                }
            });
            return;
        }
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        try {
            info.refreshRemotes();
        }
        catch (GitException ex) {
            GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
        }
        final Map<String, GitRemoteConfig> remotes = info.getRemotes();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PushWizard wiz = new PushWizard(repository, remotes);
                if (wiz.show()) {
                    Utils.logVCSExternalRepository((String)"GIT", (String)wiz.getPushUri());
                    PushAction.this.push(repository, wiz.getPushUri(), wiz.getPushMappings(), wiz.getFetchRefSpecs(), wiz.getRemoteName());
                }
            }
        });
    }

    public RequestProcessor.Task push(File repository, String target, Collection<PushMapping> pushMappins, List<String> fetchRefSpecs, String remoteNameToUpdate) {
        return this.push(repository, target, pushMappins, fetchRefSpecs, remoteNameToUpdate, Collections.singleton(repository), false);
    }

    RequestProcessor.Task push(final File repository, final String target, final Collection<PushMapping> pushMappins, final List<String> fetchRefSpecs, final String remoteNameToUpdate, final Set<File> toPushRepositories, final boolean allowSync) {
        GitProgressSupport supp = new GitProgressSupport(){

            @Override
            protected void perform() {
                LinkedList<String> pushRefSpecs = new LinkedList<String>();
                HashSet<String> newBranches = new HashSet<String>();
                for (PushMapping b : pushMappins) {
                    pushRefSpecs.add(b.getRefSpec());
                    if (!b.isCreateBranchMapping()) continue;
                    newBranches.add(b.getRemoteName());
                }
                HashSet<String> toDelete = new HashSet<String>();
                ListIterator it = fetchRefSpecs.listIterator();
                while (it.hasNext()) {
                    String refSpec = (String)it.next();
                    if (!refSpec.startsWith(":refs/remotes/")) continue;
                    it.remove();
                    toDelete.add(refSpec.substring(":refs/remotes/".length()));
                }
                LOG.log(Level.FINE, "Pushing {0}/{1} to {2}", new Object[]{pushRefSpecs, fetchRefSpecs, target});
                try {
                    GitClient client = this.getClient();
                    Map<String, GitBranch> localBranches = client.getBranches(false, this.getProgressMonitor());
                    Collection hooks = VCSHooks.getInstance().getHooks(GitHook.class);
                    this.beforePush(hooks, pushMappins);
                    if (this.isCanceled()) {
                        return;
                    }
                    for (String branch : toDelete) {
                        client.deleteBranch(branch, true, this.getProgressMonitor());
                        this.getLogger().outputLine(Bundle.MSG_PushAction_branchDeleted(branch));
                    }
                    if (remoteNameToUpdate != null) {
                        GitRemoteConfig config = client.getRemote(remoteNameToUpdate, this.getProgressMonitor());
                        if (this.isCanceled()) {
                            return;
                        }
                        List<String> refsToAdd = fetchRefSpecs;
                        if (config == null) {
                            refsToAdd = Arrays.asList(GitUtils.getGlobalRefSpec(remoteNameToUpdate));
                        }
                        config = GitUtils.prepareConfig(config, remoteNameToUpdate, target, refsToAdd);
                        client.setRemote(config, this.getProgressMonitor());
                        if (this.isCanceled()) {
                            return;
                        }
                    }
                    this.pushSubmodules(toPushRepositories);
                    if (this.isCanceled()) {
                        return;
                    }
                    boolean cont = true;
                    while (cont && !this.isCanceled()) {
                        this.setDisplayName(Bundle.MSG_PushAction_pushing());
                        GitPushResult result = client.push(target, pushRefSpecs, fetchRefSpecs, this.getProgressMonitor());
                        this.getLogger().outputLine("");
                        this.logUpdates(this.getRepositoryRoot(), result.getRemoteRepositoryUpdates(), "MSG_PushAction.updates.remoteUpdates", true);
                        this.getLogger().outputLine("");
                        this.logUpdates(this.getRepositoryRoot(), result.getLocalRepositoryUpdates(), "MSG_PushAction.updates.localUpdates", false);
                        cont = this.reportRemoteConflicts(result.getRemoteRepositoryUpdates());
                        if (cont) continue;
                        if (remoteNameToUpdate != null && !newBranches.isEmpty()) {
                            for (Map.Entry e : result.getLocalRepositoryUpdates().entrySet()) {
                                if (((GitTransportUpdate)e.getValue()).getResult() != GitRefUpdateResult.NEW) continue;
                                String localRefName = ((GitTransportUpdate)e.getValue()).getLocalName();
                                for (String localBranchName : newBranches) {
                                    GitBranch localBranch;
                                    if (!localRefName.equals(remoteNameToUpdate + "/" + localBranchName) || (localBranch = localBranches.get(localBranchName)) == null || localBranch.getTrackedBranch() != null) continue;
                                    LOG.log(Level.FINE, "Update tracking for {0} <-> {1}", new Object[]{localRefName, localBranchName});
                                    GitBranch b = client.updateTracking(localBranchName, localRefName, this.getProgressMonitor());
                                    this.logTrackingUpdate(b);
                                }
                            }
                        }
                        if (this.isCanceled()) {
                            return;
                        }
                        this.setDisplayName(NbBundle.getMessage(PushAction.class, (String)"MSG_PushAction.finalizing"));
                        this.afterPush(hooks, result.getRemoteRepositoryUpdates());
                    }
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
            }

            protected void logUpdates(File repository2, Map<String, GitTransportUpdate> updates, String titleBundleName, boolean remote) {
                OutputLogger logger = this.getLogger();
                logger.outputLine(NbBundle.getMessage(PushAction.class, (String)titleBundleName));
                if (updates.isEmpty()) {
                    logger.outputLine(NbBundle.getMessage(PushAction.class, (String)"MSG_PushAction.updates.noChange"));
                } else {
                    GitBranch currBranch = RepositoryInfo.getInstance(repository2).getActiveBranch();
                    for (Map.Entry<String, GitTransportUpdate> e : updates.entrySet()) {
                        GitTransportUpdate update = e.getValue();
                        if (update.getResult() == GitRefUpdateResult.NOT_ATTEMPTED) continue;
                        if (update.getType() == GitTransportUpdate.Type.BRANCH) {
                            if (update.getNewObjectId() == null && update.getOldObjectId() != null) {
                                logger.outputLine(Bundle.MSG_PushAction_updates_deleteBranch(update.getRemoteName(), update.getOldObjectId(), update.getResult()));
                                continue;
                            }
                            if (update.getNewObjectId() != null && update.getOldObjectId() == null) {
                                int pos;
                                logger.outputLine(Bundle.MSG_PushAction_updates_addBranch(update.getLocalName(), update.getNewObjectId(), update.getResult()));
                                if (remote || update.getNewObjectId() == null || (pos = update.getLocalName().indexOf(47)) < 0 || !update.getLocalName().substring(pos + 1).equals(currBranch.getName()) || !PushAction.shallSetupTracking(currBranch, update.getLocalName())) continue;
                                ((SetTrackingAction)SystemAction.get(SetTrackingAction.class)).setupTrackedBranchImmediately(repository2, currBranch.getName(), update.getLocalName());
                                continue;
                            }
                            logger.outputLine(Bundle.MSG_PushAction_updates_updateBranch(update.getRemoteName(), update.getOldObjectId(), update.getNewObjectId(), update.getResult()));
                            if (!UPDATED_STATUSES.contains(update.getResult())) continue;
                            if (remote) {
                                LogUtils.logBranchUpdateReview(repository2, update.getRemoteName(), update.getOldObjectId(), update.getNewObjectId(), logger);
                                continue;
                            }
                            LogUtils.logBranchUpdateReview(repository2, update.getLocalName(), update.getOldObjectId(), update.getNewObjectId(), logger);
                            continue;
                        }
                        logger.outputLine(NbBundle.getMessage(PushAction.class, (String)"MSG_PushAction.updates.updateTag", (Object[])new Object[]{update.getLocalName(), update.getResult()}));
                    }
                }
            }

            private void logTrackingUpdate(GitBranch b) {
                if (b != null && b.getTrackedBranch() != null) {
                    OutputLogger logger = this.getLogger();
                    logger.outputLine(Bundle.MSG_PushAction_trackingUpdated(b.getName(), b.getTrackedBranch().getName()));
                    logger.outputLine("");
                }
            }

            private void beforePush(Collection<GitHook> hooks, Collection<PushMapping> pushMapping) throws GitException {
                if (hooks.size() > 0) {
                    List<GitRevisionInfo> messages = this.getOutgoingRevisions(pushMapping);
                    if (!this.isCanceled() && !messages.isEmpty()) {
                        GitHookContext context = this.initializeHookContext(messages);
                        for (GitHook gitHook : hooks) {
                            try {
                                gitHook.beforePush(context);
                            }
                            catch (IOException ex) {}
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private List<GitRevisionInfo> getOutgoingRevisions(Collection<PushMapping> pushMappings) throws GitException {
                LinkedList<GitRevisionInfo> revisionList = new LinkedList<GitRevisionInfo>();
                HashSet<String> visitedRevisions = new HashSet<String>();
                GitClient client = Git.getInstance().getClient(this.getRepositoryRoot());
                try {
                    for (PushMapping mapping : pushMappings) {
                        if (mapping instanceof PushMapping.PushBranchMapping) {
                            PushMapping.PushBranchMapping branchMapping = (PushMapping.PushBranchMapping)mapping;
                            String remoteRevisionId = branchMapping.getRemoteRepositoryBranchHeadId();
                            String localRevisionId = branchMapping.getLocalRepositoryBranchHeadId();
                            revisionList.addAll(this.addRevisions(client, visitedRevisions, remoteRevisionId, localRevisionId));
                        }
                        if (!this.isCanceled()) continue;
                        break;
                    }
                }
                finally {
                    if (client != null) {
                        client.release();
                    }
                }
                return revisionList;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private List<GitRevisionInfo> getPushedRevisions(Map<String, GitTransportUpdate> remoteRepositoryUpdates) throws GitException {
                LinkedList<GitRevisionInfo> revisionList = new LinkedList<GitRevisionInfo>();
                HashSet<String> visitedRevisions = new HashSet<String>();
                GitClient client = Git.getInstance().getClient(this.getRepositoryRoot());
                try {
                    for (Map.Entry<String, GitTransportUpdate> update : remoteRepositoryUpdates.entrySet()) {
                        String remoteRevisionId = update.getValue().getOldObjectId();
                        String localRevisionId = update.getValue().getNewObjectId();
                        revisionList.addAll(this.addRevisions(client, visitedRevisions, remoteRevisionId, localRevisionId));
                        if (!this.isCanceled()) continue;
                        break;
                    }
                }
                finally {
                    if (client != null) {
                        client.release();
                    }
                }
                return revisionList;
            }

            private void afterPush(Collection<GitHook> hooks, Map<String, GitTransportUpdate> remoteRepositoryUpdates) throws GitException {
                if (hooks.size() > 0) {
                    List<GitRevisionInfo> messages = this.getPushedRevisions(remoteRepositoryUpdates);
                    if (!this.isCanceled() && !messages.isEmpty()) {
                        GitHookContext context = this.initializeHookContext(messages);
                        for (GitHook gitHook : hooks) {
                            gitHook.afterPush(context);
                        }
                    }
                }
            }

            private GitHookContext initializeHookContext(List<GitRevisionInfo> messages) {
                LinkedList<GitHookContext.LogEntry> entries = new LinkedList<GitHookContext.LogEntry>();
                for (GitRevisionInfo message : messages) {
                    entries.add(new GitHookContext.LogEntry(message.getFullMessage(), message.getAuthor().toString(), message.getRevision(), new Date(message.getCommitTime())));
                }
                GitHookContext context = new GitHookContext(new File[]{this.getRepositoryRoot()}, null, entries.toArray(new GitHookContext.LogEntry[entries.size()]));
                return context;
            }

            private List<GitRevisionInfo> addRevisions(GitClient client, Set<String> visitedRevisions, String remoteRevisionId, String localRevisionId) throws GitException {
                LinkedList<GitRevisionInfo> list;
                block7: {
                    list = new LinkedList<GitRevisionInfo>();
                    SearchCriteria crit = null;
                    if (localRevisionId != null) {
                        if (remoteRevisionId == null) {
                            crit = new SearchCriteria();
                            crit.setRevisionTo(localRevisionId);
                        } else {
                            crit = new SearchCriteria();
                            crit.setRevisionFrom(remoteRevisionId);
                            crit.setRevisionTo(localRevisionId);
                        }
                    }
                    if (crit != null) {
                        final 3 supp = this;
                        try {
                            GitRevisionInfo[] revisions;
                            for (GitRevisionInfo rev : revisions = client.log(crit, false, new ProgressMonitor(){

                                public boolean isCanceled() {
                                    return supp.isCanceled();
                                }

                                public void started(String command) {
                                }

                                public void finished() {
                                }

                                public void preparationsFailed(String message) {
                                }

                                public void notifyError(String message) {
                                }

                                public void notifyWarning(String message) {
                                }
                            })) {
                                boolean firstTime = visitedRevisions.add(rev.getRevision());
                                if (!firstTime) continue;
                                list.add(rev);
                            }
                        }
                        catch (GitException.MissingObjectException ex) {
                            if (remoteRevisionId != null && remoteRevisionId.equals(ex.getObjectName())) break block7;
                            throw ex;
                        }
                    }
                }
                return list;
            }

            private boolean reportRemoteConflicts(Map<String, GitTransportUpdate> updates) {
                boolean retry = false;
                LinkedList<GitTransportUpdate> errors = new LinkedList<GitTransportUpdate>();
                LinkedList<GitTransportUpdate> conflicts = new LinkedList<GitTransportUpdate>();
                block4: for (Map.Entry<String, GitTransportUpdate> e : updates.entrySet()) {
                    GitTransportUpdate update = e.getValue();
                    switch (update.getResult()) {
                        case OK: 
                        case UP_TO_DATE: {
                            continue block4;
                        }
                        case REJECTED_NONFASTFORWARD: {
                            conflicts.add(update);
                            continue block4;
                        }
                    }
                    errors.add(update);
                }
                String message = null;
                if (!errors.isEmpty()) {
                    message = Bundle.MSG_PushAction_report_errors();
                } else if (!conflicts.isEmpty()) {
                    String string = message = allowSync ? Bundle.MSG_PushAction_report_conflicts_allowPull() : Bundle.MSG_PushAction_report_conflicts();
                }
                if (message != null) {
                    Object[] objectArray;
                    JButton outputBtn = new JButton();
                    Mnemonics.setLocalizedText((AbstractButton)outputBtn, (String)Bundle.CTL_PushAction_report_outputButton_text());
                    outputBtn.getAccessibleContext().setAccessibleDescription(Bundle.CTL_PushAction_report_outputButton_desc());
                    JButton pullBtn = new JButton();
                    Mnemonics.setLocalizedText((AbstractButton)pullBtn, (String)Bundle.CTL_PushAction_report_pullButton_text());
                    pullBtn.getAccessibleContext().setAccessibleDescription(Bundle.CTL_PushAction_report_pullButton_desc());
                    DialogDisplayer dialogDisplayer = DialogDisplayer.getDefault();
                    String string = Bundle.LBL_PushAction_report_error_title();
                    if (allowSync && !conflicts.isEmpty()) {
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = pullBtn;
                        objectArray2[1] = outputBtn;
                        objectArray = objectArray2;
                        objectArray2[2] = NotifyDescriptor.CANCEL_OPTION;
                    } else {
                        Object[] objectArray3 = new Object[2];
                        objectArray3[0] = outputBtn;
                        objectArray = objectArray3;
                        objectArray3[1] = NotifyDescriptor.CANCEL_OPTION;
                    }
                    Object o = dialogDisplayer.notify(new NotifyDescriptor((Object)message, string, 2, 0, objectArray, (Object)(allowSync && !conflicts.isEmpty() ? pullBtn : outputBtn)));
                    if (o == outputBtn) {
                        this.getLogger().getOpenOutputAction().actionPerformed(new ActionEvent((Object)PushAction.this, 1001, null));
                    } else if (o == pullBtn) {
                        this.setDisplayName(Bundle.MSG_PushAction_pullingChanges());
                        ActionProgress result = ((PullFromUpstreamAction)SystemAction.get(PullFromUpstreamAction.class)).pull(repository);
                        if (result != null) {
                            result.getActionTask().waitFinished();
                            if (result.isFinishedSuccess()) {
                                retry = NotifyDescriptor.YES_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.MSG_PushAction_pullingChanges_finished(), Bundle.LBL_PushAction_pullingChanges_finished(), 0, 3));
                            }
                        }
                    }
                }
                return retry;
            }

            private void pushSubmodules(Set<File> toPushRepositories2) throws GitException {
                Map<File, GitSubmoduleStatus> submoduleStatuses = this.getClient().getSubmoduleStatus(new File[0], this.getProgressMonitor());
                ArrayList<File> submodulesToPush = new ArrayList<File>(submoduleStatuses.size());
                for (Map.Entry<File, GitSubmoduleStatus> e : submoduleStatuses.entrySet()) {
                    String referencedCommit;
                    File submodule = e.getKey();
                    if (toPushRepositories2.contains(submodule) || !this.isLocalCommit(submodule, referencedCommit = e.getValue().getReferencedCommitId())) continue;
                    submodulesToPush.add(submodule);
                }
                if (submodulesToPush.isEmpty() || this.askToPushSubmodules(submodulesToPush)) {
                    // empty if block
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isLocalCommit(File repo, String commit) {
                if (commit == null) {
                    return false;
                }
                boolean localCommit = false;
                GitClient client = null;
                try {
                    client = Git.getInstance().getClient(repo);
                    for (Map.Entry<String, GitBranch> e : client.getBranches(true, this.getProgressMonitor()).entrySet()) {
                        if (this.isCanceled()) {
                            boolean bl = false;
                            return bl;
                        }
                        if (!e.getValue().isRemote()) continue;
                        localCommit = true;
                        GitRevisionInfo anc = client.getCommonAncestor(new String[]{commit, e.getKey()}, this.getProgressMonitor());
                        if (anc != null && commit.equals(anc.getRevision())) {
                            localCommit = false;
                            LOG.log(Level.FINE, "Commit {0} found in submodule's {1} branch {2}", new Object[]{commit, repo, e.getKey()});
                            break;
                        }
                        LOG.log(Level.FINE, "Commit {0} not in submodule's {1} branch {2}", new Object[]{commit, repo, e.getKey()});
                    }
                }
                catch (GitException ex) {
                    LOG.log(Level.INFO, null, ex);
                }
                finally {
                    if (client != null) {
                        client.release();
                    }
                }
                return localCommit;
            }

            private boolean askToPushSubmodules(List<File> submodulesToPush) {
                NotifyDescriptor desc = new NotifyDescriptor((Object)Bundle.MSG_PushAction_push_submodules_text(this.getRepositoryRoot().getName()), Bundle.LBL_PushAction_push_submodules_title(), 0, 2, new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION}, NotifyDescriptor.YES_OPTION);
                Object retval = DialogDisplayer.getDefault().notify(desc);
                if (retval == NotifyDescriptor.NO_OPTION) {
                    this.cancel();
                }
                return false;
            }
        };
        return supp.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.LBL_PushAction_progressName(repository.getName()));
    }

    private static boolean shallSetupTracking(GitBranch branch, String remoteBranchName) {
        return NotifyDescriptor.YES_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.MSG_Push_setupTracking(remoteBranchName, branch.getName()), Bundle.LBL_Push_setupTracking(), 0, 3));
    }
}

