/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.status;

import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.GitStatusNode;
import org.netbeans.modules.git.ui.status.VersioningPanelController;
import org.netbeans.modules.versioning.util.common.FileTreeView;
import org.netbeans.modules.versioning.util.status.VCSStatusNode;
import org.netbeans.swing.outline.RenderDataProvider;
import org.openide.awt.MouseUtils;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;

class FileTreeViewImpl
extends FileTreeView<VersioningPanelController.GitStatusNodeImpl> {
    private final VersioningPanelController.ModeKeeper modeKeeper;
    private final VersioningPanelController master;

    public FileTreeViewImpl(VersioningPanelController master, VersioningPanelController.ModeKeeper modeKeeper) {
        this.modeKeeper = modeKeeper;
        this.master = master;
        this.setupColumns();
    }

    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && MouseUtils.isDoubleClick((MouseEvent)e) && !this.getSelectedNodes().isEmpty()) {
            this.modeKeeper.storeMode();
        }
        super.mouseClicked(e);
    }

    private void setupColumns() {
        Node.Property[] properties = new Node.Property[]{new ColumnDescriptor<String>("gitstatus", String.class, GitStatusNode.GitStatusProperty.DISPLAY_NAME, GitStatusNode.GitStatusProperty.DESCRIPTION), new ColumnDescriptor<String>("path", String.class, VCSStatusNode.PathProperty.DISPLAY_NAME, VCSStatusNode.PathProperty.DESCRIPTION)};
        this.view.setProperties(properties);
        this.view.getOutline().setRenderDataProvider(this.createRenderProvider());
    }

    private RenderDataProvider createRenderProvider() {
        return new FileTreeView.AbstractRenderDataProvider(){

            protected String annotateName(VersioningPanelController.GitStatusNodeImpl node, String originalLabel) {
                if (GitModuleConfig.getDefault().isExcludedFromCommit(node.getFile().getAbsolutePath())) {
                    originalLabel = "<s>" + (originalLabel == null ? node.getName() : originalLabel) + "</s>";
                }
                return originalLabel;
            }
        };
    }

    protected void nodeSelected(VersioningPanelController.GitStatusNodeImpl node) {
    }

    protected JPopupMenu getPopup() {
        List nodes = this.getSelectedNodes();
        return this.master.getPopupFor(nodes.toArray(new Node[nodes.size()]));
    }

    protected void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int width = FileTreeViewImpl.this.view.getWidth();
                FileTreeViewImpl.this.view.getOutline().getColumnModel().getColumn(0).setPreferredWidth(width * 40 / 100);
                FileTreeViewImpl.this.view.getOutline().getColumnModel().getColumn(1).setPreferredWidth(width * 20 / 100);
                FileTreeViewImpl.this.view.getOutline().getColumnModel().getColumn(2).setPreferredWidth(width * 40 / 100);
            }
        });
    }

    private static class ColumnDescriptor<T>
    extends PropertySupport.ReadOnly<T> {
        public ColumnDescriptor(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public T getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

