/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.utils;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitUser;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.utils.GitUtils;
import org.openide.filesystems.FileUtil;

public class JGitUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepositoryInfo.PushMode getPushMode(File root) {
        Repository repository = JGitUtils.getRepository(root);
        if (repository != null) {
            try {
                String val = repository.getConfig().getString("push", null, "default");
                if ("upstream".equals(val)) {
                    RepositoryInfo.PushMode pushMode = RepositoryInfo.PushMode.UPSTREAM;
                    return pushMode;
                }
            }
            finally {
                repository.close();
            }
        }
        return RepositoryInfo.PushMode.ASK;
    }

    public static boolean isValidRefName(String refName) {
        return Repository.isValidRefName((String)refName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUserSetup(File root) {
        Repository repository = JGitUtils.getRepository(root);
        boolean userExists = true;
        if (repository != null) {
            try {
                StoredConfig config = repository.getConfig();
                String name = config.getString("user", null, "name");
                String email = config.getString("user", null, "email");
                if (name == null || name.isEmpty() || email == null || email.isEmpty()) {
                    userExists = false;
                }
            }
            finally {
                repository.close();
            }
        }
        return userExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persistUser(File root, GitUser author) throws GitException {
        Repository repository = JGitUtils.getRepository(root);
        if (repository != null) {
            try {
                StoredConfig config = repository.getConfig();
                config.setString("user", null, "name", author.getName());
                config.setString("user", null, "email", author.getEmailAddress());
                try {
                    config.save();
                    FileUtil.refreshFor((File[])new File[]{new File(GitUtils.getGitFolderForRoot(root), "config")});
                }
                catch (IOException ex) {
                    throw new GitException((Throwable)ex);
                }
            }
            finally {
                repository.close();
            }
        }
    }

    private static Repository getRepository(File root) {
        try {
            return ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(root)).setup()).build();
        }
        catch (IOException ex) {
            return null;
        }
    }

    private JGitUtils() {
    }
}

