/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.cnd.makefile.utils.IpeFileSystemView;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizard;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizardPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.ui.CndUIUtilities;

public abstract class FileChooserPanel
extends MakefileWizardPanel
implements FocusListener {
    static final long serialVersionUID = -3638230469770222549L;
    private JLabel label;
    private JTextField text;
    private JTextArea helpText;
    protected JFileChooser fc;
    private int pathType;
    public static final int PATH_NONE = 0;
    public static final int ABSOLUTE_PATH = 1;
    public static final int RELATIVE_PATH = 2;
    public static final int NAME_ONLY = 3;

    public FileChooserPanel(MakefileWizard wd) {
        super(wd);
        this.init();
    }

    public FileChooserPanel(MakefileWizard wd, JFileChooser fc) {
        super(wd);
        this.fc = fc;
        this.init();
    }

    protected void init() {
        this.pathType = 0;
    }

    public void setPathType(int pathType) {
        if (pathType == 1 || pathType == 2 || pathType == 3) {
            this.pathType = pathType;
        }
    }

    public void create(String labelString) {
        this.create(labelString, this.pathType, null);
    }

    public void create(String labelString, int pathType) {
        this.create(labelString, pathType, null);
    }

    public void create(String labelString, String help) {
        this.create(labelString, this.pathType, help);
    }

    public void create(String labelString, final int pathType, String help) {
        int gridy = 0;
        this.setLayout(new GridBagLayout());
        GridBagConstraints grid = new GridBagConstraints();
        this.pathType = pathType;
        this.label = new JLabel(labelString);
        grid.anchor = 18;
        grid.gridx = 0;
        grid.gridy = gridy++;
        grid.gridwidth = 0;
        this.add((Component)this.label, grid);
        this.text = new JTextField();
        this.text.addFocusListener(this);
        grid.gridy = gridy++;
        grid.weightx = 1.0;
        grid.gridwidth = -1;
        grid.fill = 2;
        grid.anchor = 17;
        this.add((Component)this.text, grid);
        JButton chooser = new JButton(this.getString("BTN_Chooser"));
        chooser.setMnemonic(this.getString("MNEM_Chooser").charAt(0));
        grid.gridx = 2;
        grid.weightx = 0.0;
        grid.gridwidth = 0;
        grid.fill = 0;
        grid.insets = new Insets(0, 5, 0, 0);
        this.add((Component)chooser, grid);
        chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File file;
                String cur;
                if (FileChooserPanel.this.fc == null) {
                    FileChooserPanel.this.fc = new JFileChooser();
                    FileChooserPanel.this.fc.setApproveButtonText(FileChooserPanel.this.getString("BTN_Approve"));
                    FileChooserPanel.this.fc.setFileSystemView(new IpeFileSystemView(FileChooserPanel.this.fc.getFileSystemView()));
                    FileChooserPanel.this.fc.setDialogTitle(FileChooserPanel.this.getString("DLG_FILE_CHOOSER_TITLE"));
                }
                File cwd = (cur = CndPathUtilities.expandPath((String)FileChooserPanel.this.text.getText())).length() > 0 && (file = new File(cur)).isDirectory() ? (cur.charAt(0) == '.' ? new File(FileChooserPanel.this.getMakefileData().getBaseDirectory() + File.separator + cur) : file) : new File(FileChooserPanel.this.getMakefileData().getBaseDirectory());
                FileChooserPanel.this.fc.setCurrentDirectory(cwd);
                int returnVal = FileChooserPanel.this.fc.showDialog(FileChooserPanel.this, null);
                if (returnVal == 0) {
                    file = FileChooserPanel.this.fc.getSelectedFile();
                    if (pathType == 1) {
                        try {
                            FileChooserPanel.this.text.setText(file.getCanonicalPath());
                        }
                        catch (IOException ex) {
                            FileChooserPanel.this.text.setText(file.getAbsolutePath());
                        }
                    } else if (pathType == 3) {
                        FileChooserPanel.this.text.setText(file.getName());
                    } else if (pathType == 2) {
                        String path = null;
                        try {
                            path = file.getAbsolutePath();
                            String cwdpath = cwd.getCanonicalPath();
                            if (path.equals(cwdpath)) {
                                FileChooserPanel.this.text.setText(".");
                            } else if (path.startsWith(cwdpath)) {
                                FileChooserPanel.this.text.setText(path.substring(cwdpath.length() + 1));
                            } else {
                                FileChooserPanel.this.text.setText(path);
                            }
                        }
                        catch (IOException ex) {
                            if (path == null) {
                                FileChooserPanel.this.text.setText(file.getAbsolutePath());
                            }
                            FileChooserPanel.this.text.setText(path);
                        }
                    }
                    FileChooserPanel.this.onOk();
                }
            }
        });
        if (help != null) {
            grid.anchor = 18;
            grid.gridx = 0;
            grid.gridy = gridy++;
            grid.weighty = 1.0;
            grid.gridheight = 0;
            grid.fill = 1;
            grid.insets = new Insets(11, 0, 0, 0);
            this.helpText = new JTextArea(help);
            this.helpText.getAccessibleContext().setAccessibleName("ACSN_DirHelp");
            this.helpText.addFocusListener(this);
            this.helpText.setEditable(false);
            this.helpText.setFocusable(false);
            this.helpText.setLineWrap(true);
            this.helpText.setWrapStyleWord(true);
            this.helpText.setBackground(this.label.getBackground());
            this.add((Component)this.helpText, grid);
        } else {
            grid.gridx = 0;
            grid.gridy = gridy++;
            grid.gridwidth = 0;
            grid.gridheight = 0;
            grid.weightx = 1.0;
            grid.weighty = 1.0;
            this.add((Component)new JLabel(""), grid);
        }
    }

    protected void onOk() {
    }

    protected JLabel getLabel() {
        return this.label;
    }

    protected JTextField getText() {
        return this.text;
    }

    @Override
    public void focusGained(FocusEvent evt) {
        Component comp = evt.getComponent();
        if (comp == this.helpText || comp == this.text) {
            ((JTextComponent)comp).selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
        ((JTextComponent)evt.getComponent()).setSelectionEnd(0);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        CndUIUtilities.requestFocus((Component)this.text);
    }

    @Override
    public void removeNotify() {
        Container o;
        super.removeNotify();
        if (this.fc != null && this.fc.isShowing() && (o = this.fc.getTopLevelAncestor()) != null && o instanceof JDialog) {
            ((JDialog)o).dispose();
        }
    }
}

