/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.util.impl;

import com.mchange.util.MessageLogger;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;

public class SimpleLogFile
implements MessageLogger {
    PrintWriter logWriter;
    DateFormat df = DateFormat.getDateTimeInstance(3, 3);

    public SimpleLogFile(File file, String enc) throws UnsupportedEncodingException, IOException {
        this.logWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsolutePath(), true), enc)), true);
    }

    public SimpleLogFile(File file) throws IOException {
        this.logWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file.getAbsolutePath(), true)), true);
    }

    public synchronized void log(String message) throws IOException {
        this.logMessage(message);
        this.flush();
    }

    public synchronized void log(Throwable t, String message) throws IOException {
        this.logMessage(message);
        t.printStackTrace(this.logWriter);
        this.flush();
    }

    private void logMessage(String message) {
        this.logWriter.println(this.df.format(new Date()) + " -- " + message);
    }

    private void flush() {
        this.logWriter.flush();
    }

    public synchronized void close() {
        this.logWriter.close();
    }

    public void finalize() {
        this.close();
    }
}

