/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelWorldClassLoader
extends ClassLoader {
    private final String prefix;

    public ParallelWorldClassLoader(ClassLoader parent, String prefix) {
        super(parent);
        this.prefix = prefix;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        StringBuffer sb = new StringBuffer(name.length() + this.prefix.length() + 6);
        sb.append(this.prefix).append(name.replace('.', '/')).append(".class");
        InputStream is = this.getParent().getResourceAsStream(sb.toString());
        if (is == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            String pkgname;
            Package pkg;
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) >= 0) {
                baos.write(buf, 0, len);
            }
            buf = baos.toByteArray();
            int packIndex = name.lastIndexOf(46);
            if (packIndex != -1 && (pkg = this.getPackage(pkgname = name.substring(0, packIndex))) == null) {
                this.definePackage(pkgname, null, null, null, null, null, null, null);
            }
            return this.defineClass(name, buf, 0, buf.length);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    @Override
    protected URL findResource(String name) {
        return this.getParent().getResource(this.prefix + name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.getParent().getResources(this.prefix + name);
    }

    public static URL toJarUrl(URL res) throws ClassNotFoundException, MalformedURLException {
        String url = res.toExternalForm();
        if (!url.startsWith("jar:")) {
            throw new ClassNotFoundException("Loaded outside a jar " + url);
        }
        url = url.substring(4);
        url = url.substring(0, url.lastIndexOf(33));
        return new URL(url);
    }
}

