/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.owsm;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import java.awt.FlowLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javaee.specs.support.api.JaxWsPoliciesSupport;
import org.netbeans.modules.websvc.api.wseditor.InvalidDataException;
import org.netbeans.modules.websvc.api.wseditor.WSEditor;
import org.netbeans.modules.websvc.owsm.PoliciesVisualPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class OWSMPoliciesEditor
implements WSEditor {
    private static final String ORACLE = "oracle/";
    private JaxWsPoliciesSupport mySupport;
    private FileObject myFileObject;
    private PoliciesVisualPanel myPanel;
    private List<String> myPolicyIds;

    OWSMPoliciesEditor(JaxWsPoliciesSupport support, Lookup lookup, List<String> policyIds) {
        this.mySupport = support;
        this.myFileObject = (FileObject)lookup.lookup(FileObject.class);
        this.myPolicyIds = policyIds;
    }

    public JComponent createWSEditorComponent(Node node) throws InvalidDataException {
        if (this.mySupport == null || this.myFileObject == null) {
            JPanel component = new JPanel();
            component.setLayout(new FlowLayout());
            component.add(new JLabel(NbBundle.getMessage(OWSMPoliciesEditor.class, (String)"ERR_NoPoliciesSupport")));
            return component;
        }
        this.myPanel = new PoliciesVisualPanel(this.myPolicyIds, this.myFileObject);
        return this.myPanel;
    }

    public String getTitle() {
        return NbBundle.getMessage(OWSMPoliciesEditor.class, (String)"TXT_OWSMEditorTitle");
    }

    public void save(Node node) {
        if (node == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            PoliciesVisualPanel.JAVA_PROCESSOR.post(new Runnable(){

                @Override
                public void run() {
                    OWSMPoliciesEditor.this.doSave();
                }
            });
        } else {
            this.doSave();
        }
    }

    public void cancel(Node node) {
    }

    public String getDescription() {
        return NbBundle.getMessage(OWSMPoliciesEditor.class, (String)"TXT_PanelDescription");
    }

    private void doSave() {
        if (this.myPanel == null) {
            return;
        }
        if (this.myPanel.getWsFqn() == null) {
            return;
        }
        final JavaSource javaSource = JavaSource.forFileObject((FileObject)this.myFileObject);
        if (javaSource == null) {
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)NbBundle.getMessage(OWSMPoliciesEditor.class, (String)"ERR_NoJava"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            return;
        }
        final List<String> policyIds = this.myPanel.getPolicyIds();
        ArrayList<String> fqns = new ArrayList<String>(2);
        fqns.add("weblogic.wsee.jws.jaxws.owsm.SecurityPolicy");
        if (policyIds.size() > 1) {
            fqns.add("weblogic.wsee.jws.jaxws.owsm.SecurityPolicies");
        }
        Project project = FileOwnerQuery.getOwner((FileObject)this.myFileObject);
        this.mySupport.extendsProjectClasspath(project, fqns);
        Task<WorkingCopy> task = new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                String wsFqn = OWSMPoliciesEditor.this.myPanel.getWsFqn();
                CompilationUnitTree cu = workingCopy.getCompilationUnit();
                ClassTree wsClassTree = null;
                if (cu != null) {
                    List<? extends Tree> decls = cu.getTypeDecls();
                    for (Tree tree : decls) {
                        Name className;
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) continue;
                        ClassTree classTree = (ClassTree)tree;
                        Element element = workingCopy.getTrees().getElement(workingCopy.getTrees().getPath(cu, classTree));
                        if (!(element instanceof TypeElement) || !(className = ((TypeElement)element).getQualifiedName()).contentEquals(wsFqn)) continue;
                        wsClassTree = classTree;
                    }
                }
                if (wsClassTree == null) {
                    return;
                }
                OWSMPoliciesEditor.this.rewriteAnnotations(policyIds, workingCopy, wsClassTree);
            }
        };
        final Runnable runnable = new Runnable((Task)task){
            final /* synthetic */ Task val$task;
            {
                this.val$task = task;
            }

            @Override
            public void run() {
                try {
                    javaSource.runModificationTask(this.val$task).commit();
                }
                catch (IOException e) {
                    Logger.getLogger(OWSMPoliciesEditor.class.getName()).log(Level.INFO, null, e);
                }
            }
        };
        final String title = NbBundle.getMessage(OWSMPoliciesEditor.class, (String)"LBL_ModifyPolicies");
        if (SwingUtilities.isEventDispatchThread()) {
            ScanDialog.runWhenScanFinished((Runnable)runnable, (String)title);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScanDialog.runWhenScanFinished((Runnable)runnable, (String)title);
                }
            });
        }
    }

    private void rewriteAnnotations(List<String> policyIds, WorkingCopy workingCopy, ClassTree wsClassTree) {
        TreeMaker maker = workingCopy.getTreeMaker();
        ModifiersTree modifiers = wsClassTree.getModifiers();
        List<? extends AnnotationTree> annotations = modifiers.getAnnotations();
        ArrayList<AnnotationTree> clearedTrees = new ArrayList<AnnotationTree>(annotations.size());
        for (AnnotationTree annotationTree : annotations) {
            Tree annotationType = annotationTree.getAnnotationType();
            Element element = workingCopy.getTrees().getElement(workingCopy.getTrees().getPath(workingCopy.getCompilationUnit(), annotationType));
            if (element.equals(workingCopy.getElements().getTypeElement("weblogic.wsee.jws.jaxws.owsm.SecurityPolicies")) || element.equals(workingCopy.getElements().getTypeElement("weblogic.wsee.jws.jaxws.owsm.SecurityPolicy"))) continue;
            clearedTrees.add(annotationTree);
        }
        modifiers = maker.Modifiers(modifiers, clearedTrees);
        AnnotationTree newAnnotation = null;
        if (policyIds.size() > 1) {
            ArrayList<AnnotationTree> arrayList = new ArrayList<AnnotationTree>(policyIds.size());
            for (String id : policyIds) {
                AnnotationTree annotationTree = this.createPolicyAnnotation(maker, id);
                arrayList.add(annotationTree);
            }
            NewArrayTree newArray = maker.NewArray((Tree)workingCopy.getTrees().getTree(workingCopy.getElements().getTypeElement("weblogic.wsee.jws.jaxws.owsm.SecurityPolicy")), Collections.emptyList(), arrayList);
            newAnnotation = maker.Annotation((Tree)maker.QualIdent("weblogic.wsee.jws.jaxws.owsm.SecurityPolicies"), Collections.singletonList(maker.Assignment((ExpressionTree)maker.Identifier((CharSequence)"value"), (ExpressionTree)newArray)));
        } else if (policyIds.size() == 1) {
            newAnnotation = this.createPolicyAnnotation(maker, policyIds.get(0));
        }
        if (newAnnotation != null) {
            modifiers = maker.addModifiersAnnotation(modifiers, newAnnotation);
        }
        workingCopy.rewrite((Tree)wsClassTree.getModifiers(), (Tree)modifiers);
    }

    private AnnotationTree createPolicyAnnotation(TreeMaker maker, String id) {
        AssignmentTree idTree = maker.Assignment((ExpressionTree)maker.Identifier((CharSequence)"uri"), (ExpressionTree)maker.Literal((Object)id));
        return maker.Annotation((Tree)maker.QualIdent("weblogic.wsee.jws.jaxws.owsm.SecurityPolicy"), Collections.singletonList(idTree));
    }
}

