/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.editor;

import com.sun.source.tree.MethodTree;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.websvc.rest.editor.AsyncConverter;
import org.netbeans.modules.websvc.rest.editor.RestScanTask;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class AsyncConverterTask
extends AsyncConverter
implements CancellableTask<CompilationInfo> {
    private final AtomicReference<AsyncHintsTask> runTask = new AtomicReference();

    public void run(CompilationInfo compilationInfo) throws Exception {
        FileObject fileObject = compilationInfo.getFileObject();
        if (!this.isApplicable(fileObject)) {
            return;
        }
        AsyncHintsTask task = new AsyncHintsTask(compilationInfo);
        this.runTask.set(task);
        task.run();
        this.runTask.compareAndSet(task, null);
        HintsController.setErrors((FileObject)fileObject, (String)"REST Async Converter", task.getDescriptions());
    }

    @Override
    protected Logger getLogger() {
        return Logger.getLogger(AsyncConverterTask.class.getName());
    }

    public void cancel() {
        AsyncHintsTask scanTask = this.runTask.getAndSet(null);
        if (scanTask != null) {
            scanTask.stop();
        }
    }

    private class AsyncHint
    implements Fix {
        private final FileObject myFileObject;
        private final ElementHandle<Element> myHandle;

        AsyncHint(FileObject fileObject, ElementHandle<Element> handle) {
            this.myFileObject = fileObject;
            this.myHandle = handle;
        }

        public ChangeInfo implement() throws Exception {
            AsyncConverterTask.this.convertMethod(this.myHandle, this.myFileObject);
            return null;
        }

        public String getText() {
            return NbBundle.getMessage(AsyncConverterTask.class, (String)"TXT_ConvertMethod");
        }
    }

    private class AsyncHintsTask {
        private final Collection<ErrorDescription> descriptions;
        private volatile boolean stop;
        private final CompilationInfo myInfo;

        private AsyncHintsTask(CompilationInfo info) {
            this.myInfo = info;
            this.descriptions = new LinkedList<ErrorDescription>();
        }

        void run() {
            List classes = this.myInfo.getTopLevelElements();
            for (TypeElement clazz : classes) {
                if (this.stop) {
                    return;
                }
                String fqn = clazz.getQualifiedName().toString();
                List<ExecutableElement> methods = ElementFilter.methodsIn(clazz.getEnclosedElements());
                for (ExecutableElement method : methods) {
                    MethodTree tree;
                    if (this.stop) {
                        return;
                    }
                    if (!AsyncConverterTask.this.isApplicable(method) || !AsyncConverterTask.this.checkRestMethod(fqn, method, this.myInfo.getFileObject()) || AsyncConverterTask.this.isAsync(method) || (tree = this.myInfo.getTrees().getTree(method)) == null) continue;
                    List<Integer> position = RestScanTask.getElementPosition(this.myInfo, tree);
                    AsyncHint fix = new AsyncHint(this.myInfo.getFileObject(), (ElementHandle<Element>)ElementHandle.create((Element)method));
                    List<AsyncHint> fixes = Collections.singletonList(fix);
                    ErrorDescription description = ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)NbBundle.getMessage(AsyncConverterTask.class, (String)"TXT_ConvertMethod"), fixes, (FileObject)this.myInfo.getFileObject(), (int)position.get(0), (int)position.get(1));
                    this.getDescriptions().add(description);
                }
            }
        }

        Collection<ErrorDescription> getDescriptions() {
            return this.descriptions;
        }

        void stop() {
            this.stop = true;
        }
    }
}

