/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class InterceptorPanelVisual
extends JPanel {
    private JCheckBox reader;
    private JLabel type;
    private JPanel typesPanel;
    private JCheckBox writer;
    private List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();

    public InterceptorPanelVisual(WizardDescriptor myDescriptor) {
        this.initComponents();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                InterceptorPanelVisual.this.fireChangeEvent();
            }
        };
        this.reader.addActionListener(listener);
        this.writer.addActionListener(listener);
    }

    void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    String getError() {
        if (!this.reader.isSelected() && !this.writer.isSelected()) {
            return NbBundle.getMessage(InterceptorPanelVisual.class, (String)"ERR_NoInterceptorType");
        }
        return null;
    }

    void readSettings(WizardDescriptor descriptor) {
    }

    void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    void storeSettings(WizardDescriptor descriptor) {
        descriptor.putProperty("reader.interceptor", (Object)this.reader.isSelected());
        descriptor.putProperty("writer.interceptor", (Object)this.writer.isSelected());
    }

    private void fireChangeEvent() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    private void initComponents() {
        this.type = new JLabel();
        this.typesPanel = new JPanel();
        this.reader = new JCheckBox();
        this.writer = new JCheckBox();
        this.type.setLabelFor(this.typesPanel);
        Mnemonics.setLocalizedText((JLabel)this.type, (String)NbBundle.getMessage(InterceptorPanelVisual.class, (String)"LBL_InterceptorType"));
        this.typesPanel.setBorder(BorderFactory.createEtchedBorder());
        Mnemonics.setLocalizedText((AbstractButton)this.reader, (String)NbBundle.getMessage(InterceptorPanelVisual.class, (String)"LBL_ReaderInterceptor"));
        Mnemonics.setLocalizedText((AbstractButton)this.writer, (String)NbBundle.getMessage(InterceptorPanelVisual.class, (String)"LBL_WriterInterceptor"));
        GroupLayout typesPanelLayout = new GroupLayout(this.typesPanel);
        this.typesPanel.setLayout(typesPanelLayout);
        typesPanelLayout.setHorizontalGroup(typesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(typesPanelLayout.createSequentialGroup().addContainerGap().addGroup(typesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.reader).addComponent(this.writer)).addContainerGap(213, Short.MAX_VALUE)));
        typesPanelLayout.setVerticalGroup(typesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(typesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.reader).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.writer).addContainerGap(-1, Short.MAX_VALUE)));
        this.reader.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InterceptorPanelVisual.class, (String)"ACSN_ReaderInterceptor"));
        this.reader.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InterceptorPanelVisual.class, (String)"ACSD_ReaderInterceptor"));
        this.writer.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InterceptorPanelVisual.class, (String)"ACSN_WriterInterceptor"));
        this.writer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InterceptorPanelVisual.class, (String)"ACSD_WriterInterceptor"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.type).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.typesPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.type).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typesPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.type.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InterceptorPanelVisual.class, (String)"ACSN_Interceptors"));
        this.type.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InterceptorPanelVisual.class, (String)"ACSD_Interceptors"));
    }
}

